/* -*- Mode: C; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2; -*- */
/*  Copyright © 2008 Xan Lopez <xan@gnome.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __EPIPHANY_H__
#define __EPIPHANY_H__

#define __EPHY_EPIPHANY_H_INSIDE__

/* From GTK_CHECK_VERSION */
#define EPHY_MAJOR_VERSION (3)
#define EPHY_MINOR_VERSION (6)
#define EPHY_MICRO_VERSION (0)

#define EPHY_CHECK_VERSION(major, minor, micro)\
  (EPHY_MAJOR_VERSION > (major) || \
   (EPHY_MAJOR_VERSION == (major) && EPHY_MINOR_VERSION > (minor)) ||  \
    (EPHY_MAJOR_VERSION == (major) && EPHY_MINOR_VERSION == (minor) && \
     EPHY_MICRO_VERSION >= (micro)))

#include <epiphany/ephy-adblock.h>
#include <epiphany/ephy-adblock-manager.h>
#include <epiphany/ephy-bookmarks.h>
#include <epiphany/ephy-bookmarks-type-builtins.h>
#include <epiphany/ephy-dialog.h>
#include <epiphany/ephy-download.h>
#include <epiphany/ephy-embed-container.h>
#include <epiphany/ephy-embed-event.h>
#include <epiphany/ephy-embed.h>
#include <epiphany/ephy-embed-prefs.h>
#include <epiphany/ephy-embed-shell.h>
#include <epiphany/ephy-embed-single.h>
#include <epiphany/ephy-embed-type-builtins.h>
#include <epiphany/ephy-embed-utils.h>
#include <epiphany/ephy-extension.h>
#include <epiphany/ephy-extensions-manager.h>
#include <epiphany/ephy-lib-type-builtins.h>
#include <epiphany/ephy-link.h>
#include <epiphany/ephy-loader.h>
#include <epiphany/ephy-node-db.h>
#include <epiphany/ephy-node.h>
#include <epiphany/ephy-notebook.h>
#include <epiphany/ephy-permission-manager.h>
#include <epiphany/ephy-session.h>
#include <epiphany/ephy-shell.h>
#include <epiphany/ephy-state.h>
#include <epiphany/ephy-type-builtins.h>
#include <epiphany/ephy-window.h>

#undef __EPHY_EPIPHANY_H_INSIDE__

#endif /* !__EPIPHANY_H__ */
