/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8; show-trailing-whitespace: t -*- */
/*
 * ActiveSync core protocol library
 *
 * Copyright © 2011 Intel Corporation.
 *
 * Authors: Mobica Ltd. <www.mobica.com>
 *
 * This file is provided under a dual Apache/LGPLv2.1 licence.  When
 * using or redistributing this file, you may do so under either
 * licence.
 *
 *
 * LGPLv2.1 LICENCE SUMMARY
 *
 *   Copyright © Intel Corporation, dates as above.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later
 *   version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *   Boston, MA 02110-1301 USA
 *
 *
 * APACHE LICENCE SUMMARY
 *
 *   Copyright © Intel Corporation, dates as above.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

#include "eas-connection-errors.h"

#define ERRVAL(num, name) { num, #num, name }

static const GEnumValue err_values[] = {
	/* Ick. These need to be autogenerated */
	ERRVAL (EAS_CONNECTION_ERROR_FAILED, "Error.Failed"),
	ERRVAL (EAS_CONNECTION_ERROR_FILEERROR, "Error.FileError"),
	ERRVAL (EAS_CONNECTION_ERROR_NOTENOUGHMEMORY, "Error.NotEnoughMemory"),
	ERRVAL (EAS_CONNECTION_ERROR_BADARG, "Error.BadArg"),
	ERRVAL (EAS_CONNECTION_ERROR_WBXMLERROR, "Error.WBXMLError"),
	ERRVAL (EAS_CONNECTION_ERROR_SOUPERROR, "Error.SoupError"),
	ERRVAL (EAS_CONNECTION_ERROR_XMLELEMENTNOTFOUND, "Error.XMLElementNotFound"),
	ERRVAL (EAS_CONNECTION_ERROR_STATUSUNRECOGNIZED, "Error.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_ERROR_ACCOUNTNOTFOUND, "Error.AccountNotFound"),
	ERRVAL (EAS_CONNECTION_ERROR_BADREQUESTSTATE, "Error.BadRequestState"),
	ERRVAL (EAS_CONNECTION_ERROR_XMLTOOLARGETODOM, "Error.XMLTooLargeToDOM"),
	ERRVAL (EAS_CONNECTION_ERROR_NOTSUPPORTED, "Error.NotSupported"),
	ERRVAL (EAS_CONNECTION_ERROR_CANCELLED, "Error.Cancelled"),
	ERRVAL (EAS_CONNECTION_ERROR_REPROVISION, "Error.Reprovision"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_PROTOCOLERROR, "ProvisionError.ProtocolError"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_GENERALSERVERERROR, "ProvisionError.GeneralServerError"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_DEVICE_EXTERNALLY_MANAGED, "ProvisionError.DeviceExternallyManaged"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_NOCLIENTPOLICYEXISTS, "ProvisionError.NoClientPolicyExists"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_UNKNOWNPOLICYTYPE, "ProvisionError.UnknownPolicyType"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_CORRUPTSERVERPOLICYDATA, "ProvisionError.CorruptServerPolicyData"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_ACKINGWRONGPOLICYKEY, "ProvisionError.AckingWrongPolicyKey"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_STATUSUNRECOGNIZED, "ProvisionError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_INVALIDSYNCKEY, "SyncError.InvalidSyncKey"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_PROTOCOLERROR, "SyncError.ProtocolError"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_SERVERERROR, "SyncError.ServerError"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_CONVERSIONERROR, "SyncError.ConversionError"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_CONFLICTERROR, "SyncError.ConflictError"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_OBJECTNOTFOUND, "SyncError.ObjectNotFound"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_MAILBOXFULL, "SyncError.MailboxFull"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_FOLDERHIERARCHYCHANGED, "SyncError.FolderHierarchyChanged"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_REQUESTINCOMPLETE, "SyncError.RequestIncomplete"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_INVALIDWAITORHEARTBEAT, "SyncError.InvalidWaitOrHeartbeat"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_INVALIDSYNCCOMMAND, "SyncError.InvalidSyncCommand"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_RETRY, "SyncError.Retry"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_STATUSUNRECOGNIZED, "SyncError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_INVALIDSTATE, "SyncError.InvalidState"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_INVALIDTYPE, "SyncError.InvalidType"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_STATUSUNRECOGNIZED, "FolderSyncError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_SERVERERROR, "FolderSyncError.ServerError"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_TIMEOUT, "FolderSyncError.Timeout"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_INVALIDSYNCKEY, "FolderSyncError.InvalidSyncKey"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_BADLYFORMATTEDREQUEST, "FolderSyncError.BadlyFormattedRequest"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_UNKNOWNERROR, "FolderSyncError.UnknownError"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_CODEUNKNOWN, "FolderSyncError.CodeUnknown"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_PROTOCOLERROR, "ItemOperationsError.ProtocolError"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_SERVERERROR, "ItemOperationsError.ServerError"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_BADURI, "ItemOperationsError.BadURI"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_DOCLIBACCESSDENIED, "ItemOperationsError.DocLibAccessDenied"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_OBJECTNOTFOUND, "ItemOperationsError.ObjectNotFound"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_FAILEDTOCONNECT, "ItemOperationsError.FailedToConnect"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_INVALIDBYTERANGE, "ItemOperationsError.InvalidByteRange"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_UNKNOWNSTORE, "ItemOperationsError.UnknownStore"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_FILEEMPTY, "ItemOperationsError.FileEmpty"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_TOOLARGE, "ItemOperationsError.TooLarge"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_IOFAILURE, "ItemOperationsError.IOFailure"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_CONVERSIONFAILED, "ItemOperationsError.ConversionFailed"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_INVALIDATTACHMENT, "ItemOperationsError.InvalidAttachment"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_RESOURCEACCESSDENIED, "ItemOperationsError.ResourceAccessDenied"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_PARTIALCOMPLETE, "ItemOperationsError.PartialComplete"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_CREDENTIALSREQUIRED, "ItemOperationsError.CredentialsRequired"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_STATUSUNRECOGNIZED, "ItemOperationsError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_STATUSUNRECOGNIZED, "PingError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_FOLDERS_UPDATED, "PingError.FoldersUpdated"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_PARAMETER, "PingError.Parameter"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_PROTOCOL, "PingError.Protocol"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_HEARTBEAT_INTERVAL, "PingError.HeartbeatInterval"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_FOLDER, "PingError.Folder"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_FOLDER_SYNC, "PingError.FolderSync"),
	ERRVAL (EAS_CONNECTION_MOVEITEMS_ERROR_INVALID_SRC_ID, "MoveItemsError.InvalidSrcId"),
	ERRVAL (EAS_CONNECTION_MOVEITEMS_ERROR_INVALID_DST_ID, "MoveItemsError.InvalidDstId"),
	ERRVAL (EAS_CONNECTION_MOVEITEMS_ERROR_SRC_AND_DST_SAME, "MoveItemsError.SrcAndDstSame"),
	ERRVAL (EAS_CONNECTION_MOVEITEMS_ERROR_MULTIPLE_DST, "MoveItemsError.MultipleDst"),
	ERRVAL (EAS_CONNECTION_MOVEITEMS_ERROR_SRC_OR_DST_LOCKED, "MoveItemsError.SrcOrDstLocked"),
	ERRVAL (EAS_CONNECTION_MOVEITEMS_ERROR_STATUSUNRECOGNIZED, "MoveItemsError.StatusUnrecocnized"),
	ERRVAL (EAS_CONNECTION_GETITEMESTIMATE_ERROR_STATUSUNRECOGNIZED, "GetItemEstimateError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_GETITEMESTIMATE_ERROR_INVALID_COLLECTION, "GetItemEstimateError.InvalidCollection"),
	ERRVAL (EAS_CONNECTION_GETITEMESTIMATE_ERROR_BAD_SYNC_STATE, "GetItemEstimateError.BadSyncState"),
	ERRVAL (EAS_CONNECTION_GETITEMESTIMATE_ERROR_INVALID_SYNC_KEY, "GetItemEstimateError.InvalidSyncKey"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_STATUSUNRECOGNIZED, "CommonError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDCONTENT, "CommonError.InvalidContent"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDWBXML, "CommonError.InvalidWBXML"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDXML, "CommonError.InvalidXML"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDDATETIME, "CommonError.InvalidDateTime"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDCOMBINATIONOFIDS, "CommonError.InvalidCombinationOfIds"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDIDS, "CommonError.InvalidIds"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDMIME, "CommonError.InvalidMIME"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_DEVICEIDMISSINGORINVALID, "CommonError.DeviceIdMissingOrInvalid"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_DEVICETYPEMISSINGORINVALID, "CommonError.DeviceTypeMissingOrInvalid"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SERVERERROR, "CommonError.ServerError"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SERVERERRORRETRYLATER, "CommonError.ServerErrorRetryLater"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ACTIVEDIRECTORYACCESSDENIED, "CommonError.ActiveDirectoryAccessDenied"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MAILBOXQUOTAEXCEEDED, "CommonError.MailboxQuotaExceeded"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MAILBOXSERVEROFFLINE, "CommonError.MailboxServerOffline"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SENDQUOTAEXCEEDED, "CommonError.SendQuotaExceeded"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MESSAGERECIPIENTUNRESOLVED, "CommonError.MessageRecipientUnresolved"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MESSAGEREPLYNOTALLOWED, "CommonError.MessageReplyNotAllowed"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MESSAGEPREVIOUSLYSENT, "CommonError.MessagePreviouslySend"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MESSAGEHASNORECIPIENT, "CommonError.MessageHasNoRecipient"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MAILSUBMISSIONFAILED, "CommonError.MailSubmissionFailed"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MESSAGEREPLYFAILED, "CommonError.MessageReplyFailed"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ATTACHMENTISTOOLARGE, "CommonError.AttachmentIsTooLarge"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_USERHASNOMAILBOX, "CommonError.UserHasNoMailbox"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_USERCANNOTBEANONYMOUS, "CommonError.UserCannotBeAnonymous"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_USERPRINCIPALCOULDNOTBEFOUND, "CommonError.UserPrincipalCouldNotBeFound"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_USERDISABLEDFORSYNC, "CommonError.UserDisabledForSync"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_USERONNEWMAILBOXCANNOTSYNC, "CommonError.UserOnNewMailboxCannotSync"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_USERONLEGACYMAILBOXCANNOTSYNC, "CommonError.UserOnLegacyMailboxCannotSync"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_DEVICEISBLOCKEDFORTHISUSER, "CommonError.DeviceIsBlockedForThisUser"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ACCESSDENIED, "CommonError.AccessDenied"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ACCOUNTDISABLED, "CommonError.AccountDisabled"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SYNCSTATENOTFOUND, "CommonError.SyncStateNotFound"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SYNCSTATELOCKED, "CommonError.SyncStateLocked"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SYNCSTATECORRUPT, "CommonError.SyncStateCorrupt"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SYNCSTATEALREADYEXISTS, "CommonError.SyncStateAlreadyExists"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SYNCSTATEVERSIONINVALID, "CommonError.SyncStateVersionInvalid"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_COMMANDNOTSUPPORTED, "CommonError.CommandNotSupported"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_VERSIONNOTSUPPORTED, "CommonError.VersionNotSupported"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_DEVICENOTFULLYPROVISIONABLE, "CommonError.DeviceNotFullyProvisionable"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_REMOTEWIPEREQUESTED, "CommonError.RemoteWipeRequested"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_LEGACYDEVICEONSTRICTPOLICY, "CommonError.LegacyDeviceOnStrictPolicy"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_DEVICENOTPROVISIONED, "CommonError.DeviceNotProvisioned"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_POLICYREFRESH, "CommonError.PolicyRefresh"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDPOLICYKEY, "CommonError.InvalidPolicyKey"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_EXTERNALLYMANAGEDDEVICESNOTALLOWED, "CommonError.ExternallyManagedDevicesNotAllowed"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_NORECURRENCEINCALENDAR, "CommonError.NoRecurrenceInCalendar"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_UNEXPECTEDITEMCLASS, "CommonError.UnexpectedItemClass"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_REMOTESERVERHASNOSSL, "CommonError.RemoteServerHasNoSSL"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDSTOREDREQUEST, "CommonError.InvalidStoredRequest"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ITEMNOTFOUND, "CommonError.ItemNotFound"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_TOOMANYFOLDERS, "CommonError.TooManyFolders"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_NOFOLDERSFOUND, "CommonError.NoFoldersFound"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ITEMSLOSTAFTERMOVE, "CommonError.ItemsLostAfterMove"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_FAILUREINMOVEOPERATION, "CommonError.FailureInMoveOperation"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MOVECOMMANDDISALLOWEDFORNONPERSISTENTMOVEACTION, "CommonError.MoveCommandDisallowedForNonpersistentMoveAction"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MOVECOMMANDINVALIDDESTINATIONFOLDER, "CommonError.MoveCommandInvalidDestinationFolder"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_AVAILABILITYTOOMANYRECIPIENTS, "CommonError.AvailabilityTooManyRecipients"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_AVAILABILITYDLLIMITREACHED, "CommonError.AvailabilityDLLimitReached"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_AVAILABILITYTRANSIENTFAILURE, "CommonError.AvailabilityTransientFailure"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_AVAILABILITYFAILURE, "CommonError.AvailabilityFailure"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_BODYPARTPREFERENCETYPENOTSUPPORTED, "CommonError.BodyPartPreferenceTypeNotSupported"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_DEVICEINFORMATIONREQUIRED, "CommonError.DeviceInformationRequired"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDACCOUNTID, "CommonError.InvalidAccountId"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ACCOUNTSENDDISABLED, "CommonError.AccountSendDisabled"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_IRM_FEATUREDISABLED, "CommonError.IRMFeatureDisabled"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_IRM_TRANSIENTERROR, "CommonError.IRMTransientError"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_IRM_PERMANENTERROR, "CommonError.IRMPermanentError"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_IRM_INVALIDTEMPLATEID, "CommonError.IRMInvalidTemplateId"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_IRM_OPERATIONNOTPERMITTED, "CommonError.IRMOperationNotPermitted"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_NOPICTURE, "CommonError.NoPicture"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_PICTURETOOLARGE, "CommonError.PictureTooLarge"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_PICTURELIMITREACHED, "CommonError.PictureLimitReached"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_BODYPART_CONVERSATIONTOOLARGE, "CommonError.BodyPartConversationTooLarge"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MAXIMUMDEVICESREACHED, "CommonError.MaximumDevicesReached"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_EXCEEDSSTATUSLIMIT, "CommonError.ExceedsStatusLimit"),

	{ }
};

#define compile_time_assert(cond, msg)  \
	char msg[(cond)?1:-1] __attribute__((unused))

GType eas_connection_error_get_type (void)
{
	static GType etype = 0;
	compile_time_assert (sizeof (err_values) / sizeof (err_values[0]) == EAS_CONNECTION_ERROR_LAST + 1, ASSERT_Error_Mapping_Out_Of_Date);

	if (!etype)
		etype = g_enum_register_static ("EasConnectionError", err_values);

	return etype;
}

EasError common_status_error_map[] = {
	{EAS_CONNECTION_COMMON_ERROR_STATUSUNRECOGNIZED, "Unrecognised status"},  //100
	{EAS_CONNECTION_COMMON_ERROR_INVALIDCONTENT, "The body of the HTTP request sent by the client is invalid"},
	{EAS_CONNECTION_COMMON_ERROR_INVALIDWBXML, "The request contains WBXML but it could not be decoded into XML"},
	{EAS_CONNECTION_COMMON_ERROR_INVALIDXML, "The XML provided in the request does not follow the protocol requirements"},
	{EAS_CONNECTION_COMMON_ERROR_INVALIDDATETIME, "The request contains a timestamp that could not be parsed into a valid date and time."},
	{EAS_CONNECTION_COMMON_ERROR_INVALIDCOMBINATIONOFIDS, "The request contains a combination of parameters that is invalid."},
	{EAS_CONNECTION_COMMON_ERROR_INVALIDIDS, "The request contains one or more IDs that could not be parsed into valid values"},
	{EAS_CONNECTION_COMMON_ERROR_INVALIDMIME, "The request contains MIME that could not be parsed"},
	{EAS_CONNECTION_COMMON_ERROR_DEVICEIDMISSINGORINVALID, "The device ID is either missing or has an invalid format."},
	{EAS_CONNECTION_COMMON_ERROR_DEVICETYPEMISSINGORINVALID, "The device type is either missing or has an invalid format"},
	{EAS_CONNECTION_COMMON_ERROR_SERVERERROR, "The server encountered an unknown error, the device SHOULD NOT retry later"},
	{EAS_CONNECTION_COMMON_ERROR_SERVERERRORRETRYLATER, "The server encountered an unknown error, the device SHOULD retry later"},
	{EAS_CONNECTION_COMMON_ERROR_ACTIVEDIRECTORYACCESSDENIED, "The server does not have access to read/write to an object in the directory service"},
	{EAS_CONNECTION_COMMON_ERROR_MAILBOXQUOTAEXCEEDED, "The mailbox has reached its size quota"},
	{EAS_CONNECTION_COMMON_ERROR_MAILBOXSERVEROFFLINE, "The mailbox server is offline"},
	{EAS_CONNECTION_COMMON_ERROR_SENDQUOTAEXCEEDED, "The request would exceed the send quota."},
	{EAS_CONNECTION_COMMON_ERROR_MESSAGERECIPIENTUNRESOLVED, "One of the recipients could not be resolved to an e-mail address"},
	{EAS_CONNECTION_COMMON_ERROR_MESSAGEREPLYNOTALLOWED, "The mailbox server will not allow a reply of this message"},
	{EAS_CONNECTION_COMMON_ERROR_MESSAGEPREVIOUSLYSENT, "The message was already sent in a previous request"},
	{EAS_CONNECTION_COMMON_ERROR_MESSAGEHASNORECIPIENT, "The message being sent contains no recipient."},
	{EAS_CONNECTION_COMMON_ERROR_MAILSUBMISSIONFAILED, "The server failed to submit the message for delivery."},
	{EAS_CONNECTION_COMMON_ERROR_MESSAGEREPLYFAILED, "The server failed to create a reply message."},
	{EAS_CONNECTION_COMMON_ERROR_ATTACHMENTISTOOLARGE, "The attachment is too large to be processed by this request."},
	{EAS_CONNECTION_COMMON_ERROR_USERHASNOMAILBOX, "A mailbox could not be found for the user"},
	{EAS_CONNECTION_COMMON_ERROR_USERCANNOTBEANONYMOUS, "The request was sent without credentials. Anonymous requests are not allowed"},
	{EAS_CONNECTION_COMMON_ERROR_USERPRINCIPALCOULDNOTBEFOUND, "The user was not found in the directory service."},
	{EAS_CONNECTION_COMMON_ERROR_USERDISABLEDFORSYNC, "The user object in the directory service indicates that this user is not allowed to use ActiveSyn"},
	{EAS_CONNECTION_COMMON_ERROR_USERONNEWMAILBOXCANNOTSYNC, "The server is configured to prevent users from syncing"},
	{EAS_CONNECTION_COMMON_ERROR_USERONLEGACYMAILBOXCANNOTSYNC, "The server is configured to prevent users on legacy servers from syncing."},
	{EAS_CONNECTION_COMMON_ERROR_DEVICEISBLOCKEDFORTHISUSER, "The user is configured to allow only some devices to sync. This device is not the allowed device."},
	{EAS_CONNECTION_COMMON_ERROR_ACCESSDENIED, "The user is not allowed to perform that request."},
	{EAS_CONNECTION_COMMON_ERROR_ACCOUNTDISABLED, "The user's account is disabled."},
	{EAS_CONNECTION_COMMON_ERROR_SYNCSTATENOTFOUND, "The server’s data file that contains the state of the client was unexpectedly missing. The next request will likely answer a sync key error and the device will be forced to do full sync"},
	{EAS_CONNECTION_COMMON_ERROR_SYNCSTATELOCKED, "The server’s data file that contains the state of the client is locked, possibly because the mailbox is being moved or was recently moved"},
	{EAS_CONNECTION_COMMON_ERROR_SYNCSTATECORRUPT, "The server’s data file that contains the state of the client appears to be corrupt."},
	{EAS_CONNECTION_COMMON_ERROR_SYNCSTATEALREADYEXISTS, "The server’s data file that contains the state of the client already exists. This can happen with two initial syncs are executed concurrently"},
	{EAS_CONNECTION_COMMON_ERROR_SYNCSTATEVERSIONINVALID, "The version of the server’s data file that contains the state of the client is invalid."},
	{EAS_CONNECTION_COMMON_ERROR_COMMANDNOTSUPPORTED, "The command is not supported by this server."},
	{EAS_CONNECTION_COMMON_ERROR_VERSIONNOTSUPPORTED, "The command is not supported in the protocol version specified."},
	{EAS_CONNECTION_COMMON_ERROR_DEVICENOTFULLYPROVISIONABLE, "The device uses a protocol version that cannot send all the policy settings the admin enabled."},
	{EAS_CONNECTION_COMMON_ERROR_REMOTEWIPEREQUESTED, "A remote wipe was requested. The device SHOULD provision to get the request and then do another provision to acknowledge it"},
	{EAS_CONNECTION_COMMON_ERROR_LEGACYDEVICEONSTRICTPOLICY, "A policy is in place but the device is not provisionable."},
	{EAS_CONNECTION_COMMON_ERROR_DEVICENOTPROVISIONED, "There is a policy in place; the device needs to provision."},
	{EAS_CONNECTION_COMMON_ERROR_POLICYREFRESH, "The policy is configured to be refreshed every few hours. The device needs to re-provision."},
	{EAS_CONNECTION_COMMON_ERROR_INVALIDPOLICYKEY, "The device's policy key is invalid. The policy has probably changed on the server. The device needs to re-provision"},
	{EAS_CONNECTION_COMMON_ERROR_EXTERNALLYMANAGEDDEVICESNOTALLOWED, "The device claimed to be externally managed, but the server doesn't allow externally managed devices to sync"},
	{EAS_CONNECTION_COMMON_ERROR_NORECURRENCEINCALENDAR, "The request tried to forward an occurrence of a meeting that has no recurrence."},
	{EAS_CONNECTION_COMMON_ERROR_UNEXPECTEDITEMCLASS, "The request tried to operate on a type of items unknown to the server."},
	{EAS_CONNECTION_COMMON_ERROR_REMOTESERVERHASNOSSL, "The request needs to be proxied to another server but that server doesn't have SSL enabled. This server is configured to only proxy requests to servers with SSL enabled"},
	{EAS_CONNECTION_COMMON_ERROR_INVALIDSTOREDREQUEST, "The server had stored the previous request from that device. The device needs to send the full request again"},
	{EAS_CONNECTION_COMMON_ERROR_ITEMNOTFOUND, "The ItemId value specified in the SmartReply command or SmartForward command request could not be found in the mailbox"},
	{EAS_CONNECTION_COMMON_ERROR_TOOMANYFOLDERS, "The mailbox contains too many folders. By default, the mailbox cannot contain more than 1000 folders"},
	{EAS_CONNECTION_COMMON_ERROR_NOFOLDERSFOUND, "The mailbox contains no folders."},
	{EAS_CONNECTION_COMMON_ERROR_ITEMSLOSTAFTERMOVE, "After moving items to the destination folder, some of those items could not be found"},
	{EAS_CONNECTION_COMMON_ERROR_FAILUREINMOVEOPERATION, "The mailbox server returned an unknown error while moving items"},
	{EAS_CONNECTION_COMMON_ERROR_MOVECOMMANDDISALLOWEDFORNONPERSISTENTMOVEACTION, "An ItemOperations command request to move a conversation is missing the MoveAlways element"},
	{EAS_CONNECTION_COMMON_ERROR_MOVECOMMANDINVALIDDESTINATIONFOLDER, "The destination folder for the move is invalid"},
	{EAS_CONNECTION_COMMON_ERROR_STATUSUNRECOGNIZED, "Unrecognised status"},  //157
	{EAS_CONNECTION_COMMON_ERROR_STATUSUNRECOGNIZED, "Unrecognised status"},  //158
	{EAS_CONNECTION_COMMON_ERROR_STATUSUNRECOGNIZED, "Unrecognised status"},  //159
	{EAS_CONNECTION_COMMON_ERROR_AVAILABILITYTOOMANYRECIPIENTS, "The command has reached the maximum number of recipients that it can request availability for."},
	{EAS_CONNECTION_COMMON_ERROR_AVAILABILITYDLLIMITREACHED, "The size of the distribution list is larger than the availability service is configured to process."},
	{EAS_CONNECTION_COMMON_ERROR_AVAILABILITYTRANSIENTFAILURE, "Availability service request failed with a transient error."},
	{EAS_CONNECTION_COMMON_ERROR_AVAILABILITYFAILURE, "Availability service request failed with an error."},
	{EAS_CONNECTION_COMMON_ERROR_BODYPARTPREFERENCETYPENOTSUPPORTED, "The BodyPartPreference node has an unsupported Type element"},
	{EAS_CONNECTION_COMMON_ERROR_DEVICEINFORMATIONREQUIRED, "The required DeviceInformation element is missing in the Provision request"},
	{EAS_CONNECTION_COMMON_ERROR_INVALIDACCOUNTID, "The AccountId value is not valid"},
	{EAS_CONNECTION_COMMON_ERROR_ACCOUNTSENDDISABLED, "The AccountId value specified in the request does not support sending e-mail."},
	{EAS_CONNECTION_COMMON_ERROR_IRM_FEATUREDISABLED, "The Information Rights Management feature is disabled."},
	{EAS_CONNECTION_COMMON_ERROR_IRM_TRANSIENTERROR, "Information Rights Management encountered an error"},
	{EAS_CONNECTION_COMMON_ERROR_IRM_PERMANENTERROR, "Information Rights Management encountered an error.  "},
	{EAS_CONNECTION_COMMON_ERROR_IRM_INVALIDTEMPLATEID, "The Template ID value is not valid."},
	{EAS_CONNECTION_COMMON_ERROR_IRM_OPERATIONNOTPERMITTED, "Information Rights Management does not support the specified operation"},
	{EAS_CONNECTION_COMMON_ERROR_NOPICTURE, "The user does not have a contact photo"},
	{EAS_CONNECTION_COMMON_ERROR_PICTURETOOLARGE, "The contact photo exceeds the size limit set by the MaxSize element"},
	{EAS_CONNECTION_COMMON_ERROR_PICTURELIMITREACHED, "The number of contact photos returned exceeds the size limit set by the MaxPictures element "},
	{EAS_CONNECTION_COMMON_ERROR_BODYPART_CONVERSATIONTOOLARGE, "The conversation is too large to compute the body parts. Try requesting the body of the item again, without body parts"},
	{EAS_CONNECTION_COMMON_ERROR_MAXIMUMDEVICESREACHED, "The user's account has too many device partnerships. Delete partnerships on the server before proceeding."},
};


EasError sync_status_error_map[] = {
	{EAS_CONNECTION_SYNC_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //0
	{0, ""},  //1, not an error case
	{EAS_CONNECTION_SYNC_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //2
	{EAS_CONNECTION_SYNC_ERROR_INVALIDSYNCKEY, "Sync error: Invalid synchronization key"},
	{EAS_CONNECTION_SYNC_ERROR_PROTOCOLERROR, "Sync error: Request that does not comply with the specification requirements"},
	{EAS_CONNECTION_SYNC_ERROR_SERVERERROR, "Sync error: Server misconfiguration, temporary system issue, or bad item"},
	{EAS_CONNECTION_SYNC_ERROR_CONVERSIONERROR, "Sync error: malformed or invalid item sent"},
	{EAS_CONNECTION_SYNC_ERROR_CONFLICTERROR, "Sync error: client tried to change an item for which server changes take precedence"},
	{EAS_CONNECTION_SYNC_ERROR_OBJECTNOTFOUND, "Sync error: Fetch or Change operation that has an id no longer valid on the server"},
	{EAS_CONNECTION_SYNC_ERROR_MAILBOXFULL, "Sync error: User account could be out of disk space"},
	{EAS_CONNECTION_SYNC_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //10
	{EAS_CONNECTION_SYNC_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  // 11
	{EAS_CONNECTION_SYNC_ERROR_FOLDERHIERARCHYCHANGED, "Sync error: Mailbox folders are not synchronized, need FolderSync first"},
	{EAS_CONNECTION_SYNC_ERROR_REQUESTINCOMPLETE, "Sync error: sync request not complete, cached set of notify-able collections missing, resend a full Sync request"},
	{EAS_CONNECTION_SYNC_ERROR_INVALIDWAITORHEARTBEAT, "Sync error: Invalid Wait or HeartbeatInterval value, update the Wait element value according to the Limit and resend the request"},
	{EAS_CONNECTION_SYNC_ERROR_INVALIDSYNCCOMMAND, "Sync error: Too many collections are included in the Sync request, sync fewer folders"},
	{EAS_CONNECTION_SYNC_ERROR_RETRY, "Sync error: Something on the server caused a retriable error."},
	{EAS_CONNECTION_SYNC_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"}  //17
};

EasError folder_sync_status_error_map[] = {
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //0
	{0, ""},  //1, not an error case
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //2
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //3
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //4
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //5
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_SERVERERROR, "SyncFolder error: Server misconfiguration, temporary system issue, or bad item"}, //6
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //7
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_TIMEOUT, "SyncFolder error: The server took too long to respond to the request, retry"}, //8
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_INVALIDSYNCKEY, "SyncFolder error: Invalid synchronization key"}, //9
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_BADLYFORMATTEDREQUEST, "SyncFolder error: the FolderSync request contains a semantic or syntactic error."}, //10
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_UNKNOWNERROR, "SyncFolder error: Server misconfiguration, temporary system issue, or bad item. Retry or return to sync key zero"}, //11
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_CODEUNKNOWN, "SyncFolder error: Unusual back-end issue"}, //12
	{EAS_CONNECTION_FOLDER_SYNC_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"}  //13
};



EasError itemoperations_status_error_map[] = {
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //0
	{0, ""},  //1, success
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_PROTOCOLERROR, "Protocol error - protocol violation/XML validation error."},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_SERVERERROR, "Server error"},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_BADURI, "Document library access - The specified Uniform Resource Identifier (URI) is bad."},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_DOCLIBACCESSDENIED, "Document library - Access denied."},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_OBJECTNOTFOUND, "Document library - The object was not found or access denied."},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_FAILEDTOCONNECT, "Document library - Failed to connect to the server."},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_INVALIDBYTERANGE, "The byte-range is invalid or too large"},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_UNKNOWNSTORE, "The store is unknown or unsupported."},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_FILEEMPTY, "The file is empty"},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_TOOLARGE, "The requested data size is too large"},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_IOFAILURE, "Failed to download file because of input/output (I/O) failure."},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"}, // 13
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_CONVERSIONFAILED, "Mailbox fetch provider - The item failed conversion."},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_INVALIDATTACHMENT, "Attachment fetch provider - Attachment or attachment ID is invalid."},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_RESOURCEACCESSDENIED, "Access to the resource is denied."},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_PARTIALCOMPLETE, "Partial success; the command completed partially."},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_CREDENTIALSREQUIRED, "Credentials required."},
	{EAS_CONNECTION_ITEMOPERATIONS_ERROR_STATUSUNRECOGNIZED, "Unrecognised itemoperations status"}  //19
};


EasError ping_status_error_map[] = {
	{EAS_CONNECTION_PING_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //0
	{0, ""},  //1
	{EAS_CONNECTION_PING_ERROR_FOLDERS_UPDATED, ""},
	{EAS_CONNECTION_PING_ERROR_PARAMETER, "Parameter Error - one or more parameters missing from request"},
	{EAS_CONNECTION_PING_ERROR_PROTOCOL, "Protocol error - protocol violation/XML validation error."},
	{EAS_CONNECTION_PING_ERROR_HEARTBEAT_INTERVAL, "Heartbeat Interval outside of allowed parameters - modify and retry"},
	{EAS_CONNECTION_PING_ERROR_FOLDER, "Too Many Folders Selected."},
	{EAS_CONNECTION_PING_ERROR_FOLDER_SYNC, "Folder hierarchy is wrong - resync."}
};
EasError moveitems_status_error_map[] = {
	{EAS_CONNECTION_MOVEITEMS_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //0
	{EAS_CONNECTION_MOVEITEMS_ERROR_INVALID_SRC_ID, "Invalid source collection ID or invalid source Item ID. Issue a FolderSync then a Sync command for the SrcFldId and reissue the MoveItems command request if the items are still present in this folder"},
	{EAS_CONNECTION_MOVEITEMS_ERROR_INVALID_DST_ID, "Destination folder ID not recognised by server (may have been deleted). Issue a FolderSync then use a valid folder id"},
	{0, ""},  // 3, success
	{EAS_CONNECTION_MOVEITEMS_ERROR_SRC_AND_DST_SAME, "Source and destination folder IDs are the same"},
	{EAS_CONNECTION_MOVEITEMS_ERROR_MULTIPLE_DST, "More than one Destination folder id was included in the request or an item with that name already exists"},
	{EAS_CONNECTION_MOVEITEMS_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //6
	{EAS_CONNECTION_MOVEITEMS_ERROR_SRC_OR_DST_LOCKED, "Source or destination item was locked. Transient server condition, retry"},
	{EAS_CONNECTION_MOVEITEMS_ERROR_STATUSUNRECOGNIZED, "Unrecognised moveitems status"}  //8
};

EasError get_item_estimate_status_error_map[] = {
	{EAS_CONNECTION_GETITEMESTIMATE_ERROR_STATUSUNRECOGNIZED, "Unrecognised sync status"},  //0
	{0, ""},  //1
	{EAS_CONNECTION_GETITEMESTIMATE_ERROR_INVALID_COLLECTION, "Invalid Collection; specified folder does not exist or incorrect folder requested"},
	{EAS_CONNECTION_GETITEMESTIMATE_ERROR_BAD_SYNC_STATE, "Sync state not primed (Sync with a sync key of zero has never been issued"},
	{EAS_CONNECTION_GETITEMESTIMATE_ERROR_INVALID_SYNC_KEY, "Invalid sync key"},
};


