/*
 * ActiveSync client library for email access
 *
 * Copyright © 2011 Intel Corporation.
 *
 * Authors: Mobica Ltd. <www.mobica.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 */

#include <gio/gio.h>

#include "eas-errors.h"

#define ERRVAL(x,y) {x, "org.meego.activesyncd." y}

static const GDBusErrorEntry eas_connection_error_entries[] =
{
	/* Ick. These need to be autogenerated */
	ERRVAL (EAS_CONNECTION_ERROR_FAILED, "Error.Failed"),
	ERRVAL (EAS_CONNECTION_ERROR_FILEERROR, "Error.FileError"),
	ERRVAL (EAS_CONNECTION_ERROR_NOTENOUGHMEMORY, "Error.NotEnoughMemory"),
	ERRVAL (EAS_CONNECTION_ERROR_BADARG, "Error.BadArg"),
	ERRVAL (EAS_CONNECTION_ERROR_WBXMLERROR, "Error.WBXMLError"),
	ERRVAL (EAS_CONNECTION_ERROR_SOUPERROR, "Error.SoupError"),
	ERRVAL (EAS_CONNECTION_ERROR_XMLELEMENTNOTFOUND, "Error.XMLElementNotFound"),
	ERRVAL (EAS_CONNECTION_ERROR_STATUSUNRECOGNIZED, "Error.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_ERROR_ACCOUNTNOTFOUND, "Error.AccountNotFound"),
	ERRVAL (EAS_CONNECTION_ERROR_BADREQUESTSTATE, "Error.BadRequestState"),
	ERRVAL (EAS_CONNECTION_ERROR_XMLTOOLARGETODOM, "Error.XMLTooLargeToDOM"),
	ERRVAL (EAS_CONNECTION_ERROR_NOTSUPPORTED, "Error.NotSupported"),
	ERRVAL (EAS_CONNECTION_ERROR_CANCELLED, "Error.Cancelled"),
	ERRVAL (EAS_CONNECTION_ERROR_REPROVISION, "Error.Reprovision"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_PROTOCOLERROR, "ProvisionError.ProtocolError"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_GENERALSERVERERROR, "ProvisionError.GeneralServerError"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_DEVICE_EXTERNALLY_MANAGED, "ProvisionError.DeviceExternallyManaged"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_NOCLIENTPOLICYEXISTS, "ProvisionError.NoClientPolicyExists"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_UNKNOWNPOLICYTYPE, "ProvisionError.UnknownPolicyType"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_CORRUPTSERVERPOLICYDATA, "ProvisionError.CorruptServerPolicyData"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_ACKINGWRONGPOLICYKEY, "ProvisionError.AckingWrongPolicyKey"),
	ERRVAL (EAS_CONNECTION_PROVISION_ERROR_STATUSUNRECOGNIZED, "ProvisionError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_INVALIDSYNCKEY, "SyncError.InvalidSyncKey"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_PROTOCOLERROR, "SyncError.ProtocolError"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_SERVERERROR, "SyncError.ServerError"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_CONVERSIONERROR, "SyncError.ConversionError"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_CONFLICTERROR, "SyncError.ConflictError"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_OBJECTNOTFOUND, "SyncError.ObjectNotFound"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_MAILBOXFULL, "SyncError.MailboxFull"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_FOLDERHIERARCHYCHANGED, "SyncError.FolderHierarchyChanged"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_REQUESTINCOMPLETE, "SyncError.RequestIncomplete"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_INVALIDWAITORHEARTBEAT, "SyncError.InvalidWaitOrHeartbeat"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_INVALIDSYNCCOMMAND, "SyncError.InvalidSyncCommand"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_RETRY, "SyncError.Retry"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_STATUSUNRECOGNIZED, "SyncError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_INVALIDSTATE, "SyncError.InvalidState"),
	ERRVAL (EAS_CONNECTION_SYNC_ERROR_INVALIDTYPE, "SyncError.InvalidType"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_STATUSUNRECOGNIZED, "FolderSyncError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_SERVERERROR, "FolderSyncError.ServerError"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_TIMEOUT, "FolderSyncError.Timeout"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_INVALIDSYNCKEY, "FolderSyncError.InvalidSyncKey"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_BADLYFORMATTEDREQUEST, "FolderSyncError.BadlyFormattedRequest"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_UNKNOWNERROR, "FolderSyncError.UnknownError"),
	ERRVAL (EAS_CONNECTION_FOLDER_SYNC_ERROR_CODEUNKNOWN, "FolderSyncError.CodeUnknown"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_PROTOCOLERROR, "ItemOperationsError.ProtocolError"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_SERVERERROR, "ItemOperationsError.ServerError"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_BADURI, "ItemOperationsError.BadURI"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_DOCLIBACCESSDENIED, "ItemOperationsError.DocLibAccessDenied"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_OBJECTNOTFOUND, "ItemOperationsError.ObjectNotFound"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_FAILEDTOCONNECT, "ItemOperationsError.FailedToConnect"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_INVALIDBYTERANGE, "ItemOperationsError.InvalidByteRange"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_UNKNOWNSTORE, "ItemOperationsError.UnknownStore"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_FILEEMPTY, "ItemOperationsError.FileEmpty"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_TOOLARGE, "ItemOperationsError.TooLarge"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_IOFAILURE, "ItemOperationsError.IOFailure"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_CONVERSIONFAILED, "ItemOperationsError.ConversionFailed"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_INVALIDATTACHMENT, "ItemOperationsError.InvalidAttachment"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_RESOURCEACCESSDENIED, "ItemOperationsError.ResourceAccessDenied"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_PARTIALCOMPLETE, "ItemOperationsError.PartialComplete"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_CREDENTIALSREQUIRED, "ItemOperationsError.CredentialsRequired"),
	ERRVAL (EAS_CONNECTION_ITEMOPERATIONS_ERROR_STATUSUNRECOGNIZED, "ItemOperationsError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_STATUSUNRECOGNIZED, "PingError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_FOLDERS_UPDATED, "PingError.FoldersUpdated"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_PARAMETER, "PingError.Parameter"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_PROTOCOL, "PingError.Protocol"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_HEARTBEAT_INTERVAL, "PingError.HeartbeatInterval"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_FOLDER, "PingError.Folder"),
	ERRVAL (EAS_CONNECTION_PING_ERROR_FOLDER_SYNC, "PingError.FolderSync"),
	ERRVAL (EAS_CONNECTION_MOVEITEMS_ERROR_INVALID_SRC_ID, "MoveItemsError.InvalidSrcId"),
	ERRVAL (EAS_CONNECTION_MOVEITEMS_ERROR_INVALID_DST_ID, "MoveItemsError.InvalidDstId"),
	ERRVAL (EAS_CONNECTION_MOVEITEMS_ERROR_SRC_AND_DST_SAME, "MoveItemsError.SrcAndDstSame"),
	ERRVAL (EAS_CONNECTION_MOVEITEMS_ERROR_MULTIPLE_DST, "MoveItemsError.MultipleDst"),
	ERRVAL (EAS_CONNECTION_MOVEITEMS_ERROR_SRC_OR_DST_LOCKED, "MoveItemsError.SrcOrDstLocked"),
	ERRVAL (EAS_CONNECTION_MOVEITEMS_ERROR_STATUSUNRECOGNIZED, "MoveItemsError.StatusUnrecocnized"),
	ERRVAL (EAS_CONNECTION_GETITEMESTIMATE_ERROR_STATUSUNRECOGNIZED, "GetItemEstimateError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_GETITEMESTIMATE_ERROR_INVALID_COLLECTION, "GetItemEstimateError.InvalidCollection"),
	ERRVAL (EAS_CONNECTION_GETITEMESTIMATE_ERROR_BAD_SYNC_STATE, "GetItemEstimateError.BadSyncState"),
	ERRVAL (EAS_CONNECTION_GETITEMESTIMATE_ERROR_INVALID_SYNC_KEY, "GetItemEstimateError.InvalidSyncKey"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_STATUSUNRECOGNIZED, "CommonError.StatusUnrecognized"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDCONTENT, "CommonError.InvalidContent"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDWBXML, "CommonError.InvalidWBXML"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDXML, "CommonError.InvalidXML"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDDATETIME, "CommonError.InvalidDateTime"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDCOMBINATIONOFIDS, "CommonError.InvalidCombinationOfIds"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDIDS, "CommonError.InvalidIds"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDMIME, "CommonError.InvalidMIME"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_DEVICEIDMISSINGORINVALID, "CommonError.DeviceIdMissingOrInvalid"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_DEVICETYPEMISSINGORINVALID, "CommonError.DeviceTypeMissingOrInvalid"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SERVERERROR, "CommonError.ServerError"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SERVERERRORRETRYLATER, "CommonError.ServerErrorRetryLater"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ACTIVEDIRECTORYACCESSDENIED, "CommonError.ActiveDirectoryAccessDenied"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MAILBOXQUOTAEXCEEDED, "CommonError.MailboxQuotaExceeded"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MAILBOXSERVEROFFLINE, "CommonError.MailboxServerOffline"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SENDQUOTAEXCEEDED, "CommonError.SendQuotaExceeded"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MESSAGERECIPIENTUNRESOLVED, "CommonError.MessageRecipientUnresolved"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MESSAGEREPLYNOTALLOWED, "CommonError.MessageReplyNotAllowed"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MESSAGEPREVIOUSLYSENT, "CommonError.MessagePreviouslySend"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MESSAGEHASNORECIPIENT, "CommonError.MessageHasNoRecipient"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MAILSUBMISSIONFAILED, "CommonError.MailSubmissionFailed"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MESSAGEREPLYFAILED, "CommonError.MessageReplyFailed"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ATTACHMENTISTOOLARGE, "CommonError.AttachmentIsTooLarge"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_USERHASNOMAILBOX, "CommonError.UserHasNoMailbox"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_USERCANNOTBEANONYMOUS, "CommonError.UserCannotBeAnonymous"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_USERPRINCIPALCOULDNOTBEFOUND, "CommonError.UserPrincipalCouldNotBeFound"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_USERDISABLEDFORSYNC, "CommonError.UserDisabledForSync"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_USERONNEWMAILBOXCANNOTSYNC, "CommonError.UserOnNewMailboxCannotSync"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_USERONLEGACYMAILBOXCANNOTSYNC, "CommonError.UserOnLegacyMailboxCannotSync"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_DEVICEISBLOCKEDFORTHISUSER, "CommonError.DeviceIsBlockedForThisUser"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ACCESSDENIED, "CommonError.AccessDenied"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ACCOUNTDISABLED, "CommonError.AccountDisabled"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SYNCSTATENOTFOUND, "CommonError.SyncStateNotFound"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SYNCSTATELOCKED, "CommonError.SyncStateLocked"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SYNCSTATECORRUPT, "CommonError.SyncStateCorrupt"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SYNCSTATEALREADYEXISTS, "CommonError.SyncStateAlreadyExists"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_SYNCSTATEVERSIONINVALID, "CommonError.SyncStateVersionInvalid"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_COMMANDNOTSUPPORTED, "CommonError.CommandNotSupported"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_VERSIONNOTSUPPORTED, "CommonError.VersionNotSupported"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_DEVICENOTFULLYPROVISIONABLE, "CommonError.DeviceNotFullyProvisionable"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_REMOTEWIPEREQUESTED, "CommonError.RemoteWipeRequested"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_LEGACYDEVICEONSTRICTPOLICY, "CommonError.LegacyDeviceOnStrictPolicy"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_DEVICENOTPROVISIONED, "CommonError.DeviceNotProvisioned"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_POLICYREFRESH, "CommonError.PolicyRefresh"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDPOLICYKEY, "CommonError.InvalidPolicyKey"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_EXTERNALLYMANAGEDDEVICESNOTALLOWED, "CommonError.ExternallyManagedDevicesNotAllowed"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_NORECURRENCEINCALENDAR, "CommonError.NoRecurrenceInCalendar"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_UNEXPECTEDITEMCLASS, "CommonError.UnexpectedItemClass"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_REMOTESERVERHASNOSSL, "CommonError.RemoteServerHasNoSSL"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDSTOREDREQUEST, "CommonError.InvalidStoredRequest"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ITEMNOTFOUND, "CommonError.ItemNotFound"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_TOOMANYFOLDERS, "CommonError.TooManyFolders"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_NOFOLDERSFOUND, "CommonError.NoFoldersFound"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ITEMSLOSTAFTERMOVE, "CommonError.ItemsLostAfterMove"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_FAILUREINMOVEOPERATION, "CommonError.FailureInMoveOperation"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MOVECOMMANDDISALLOWEDFORNONPERSISTENTMOVEACTION, "CommonError.MoveCommandDisallowedForNonpersistentMoveAction"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MOVECOMMANDINVALIDDESTINATIONFOLDER, "CommonError.MoveCommandInvalidDestinationFolder"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_AVAILABILITYTOOMANYRECIPIENTS, "CommonError.AvailabilityTooManyRecipients"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_AVAILABILITYDLLIMITREACHED, "CommonError.AvailabilityDLLimitReached"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_AVAILABILITYTRANSIENTFAILURE, "CommonError.AvailabilityTransientFailure"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_AVAILABILITYFAILURE, "CommonError.AvailabilityFailure"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_BODYPARTPREFERENCETYPENOTSUPPORTED, "CommonError.BodyPartPreferenceTypeNotSupported"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_DEVICEINFORMATIONREQUIRED, "CommonError.DeviceInformationRequired"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_INVALIDACCOUNTID, "CommonError.InvalidAccountId"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_ACCOUNTSENDDISABLED, "CommonError.AccountSendDisabled"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_IRM_FEATUREDISABLED, "CommonError.IRMFeatureDisabled"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_IRM_TRANSIENTERROR, "CommonError.IRMTransientError"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_IRM_PERMANENTERROR, "CommonError.IRMPermanentError"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_IRM_INVALIDTEMPLATEID, "CommonError.IRMInvalidTemplateId"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_IRM_OPERATIONNOTPERMITTED, "CommonError.IRMOperationNotPermitted"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_NOPICTURE, "CommonError.NoPicture"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_PICTURETOOLARGE, "CommonError.PictureTooLarge"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_PICTURELIMITREACHED, "CommonError.PictureLimitReached"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_BODYPART_CONVERSATIONTOOLARGE, "CommonError.BodyPartConversationTooLarge"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_MAXIMUMDEVICESREACHED, "CommonError.MaximumDevicesReached"),
	ERRVAL (EAS_CONNECTION_COMMON_ERROR_EXCEEDSSTATUSLIMIT, "CommonError.ExceedsStatusLimit"),
};

GQuark eas_connection_error_quark (void)
{
	static volatile gsize quark_volatile = 0;

	g_dbus_error_register_error_domain ("eas-connection-error-quark",
					    &quark_volatile,
					    eas_connection_error_entries,
					    G_N_ELEMENTS (eas_connection_error_entries));
	return (GQuark) quark_volatile;
}
