/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * evolution-kolab
 * Copyright (C) 2010 Christian Hilberg <hilberg@kernelconcepts.de>
 *           and 2011 Silvan Marco Fin <silvan@kernelconcepts.de>
 * 
 * evolution-kolab is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * evolution-kolab is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _E_BOOK_BACKEND_KOLAB_H_
#define _E_BOOK_BACKEND_KOLAB_H_

#include <glib-object.h>
#include <libedata-book/e-book-backend.h>
#include <libedata-book/e-book-backend-sync.h>

G_BEGIN_DECLS

/**
 * SECTION:e-book-backend-kolab
 * @title: EBookBackendKolab
 * @short_description: Evolution addressbook backend API implementation for Evolution-Kolab plugin.
 */

#define E_TYPE_BOOK_BACKEND_KOLAB             (e_book_backend_kolab_get_type ())
#define E_BOOK_BACKEND_KOLAB(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), E_TYPE_BOOK_BACKEND_KOLAB, EBookBackendKolab))
#define E_BOOK_BACKEND_KOLAB_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), E_TYPE_BOOK_BACKEND_KOLAB, EBookBackendKolabClass))
#define E_IS_BOOK_BACKEND_KOLAB(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E_TYPE_BOOK_BACKEND_KOLAB))
#define E_IS_BOOK_BACKEND_KOLAB_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), E_TYPE_BOOK_BACKEND_KOLAB))
#define E_BOOK_BACKEND_KOLAB_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), E_TYPE_BOOK_BACKEND_KOLAB, EBookBackendKolabClass))

typedef struct _EBookBackendKolabClass EBookBackendKolabClass;
typedef struct _EBookBackendKolab EBookBackendKolab;

struct _EBookBackendKolabClass
{
	EBookBackendSyncClass parent_class;
};

struct _EBookBackendKolab
{
	EBookBackendSync parent_instance;
};

EBookBackend* e_book_backend_kolab_new (void);
GType e_book_backend_kolab_get_type (void) G_GNUC_CONST;

void e_book_backend_kolab_set_koma_table (EBookBackendKolab *kolab, GHashTable *koma_objects);

G_END_DECLS

#endif /* _E_BOOK_BACKEND_KOLAB_H_ */
