/***************************************************************************
 *            camel-kolab-imapx-folder.c
 *
 *  Tue Sep 14 11:04:17 2010
 *  Copyright  2010  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
/*----------------------------------------------------------------------------*/

#include <camel/providers/imapx/camel-imapx-folder.h>

#include "camel-kolab-imapx-folder.h"

/*----------------------------------------------------------------------------*/

guint64
camel_kolab_imapx_folder_get_uidvalidity (CamelFolder *folder,
                                          GError **err)
{
	guint64 uidvalidity;
	GError *tmp_err = NULL;
	
	g_assert (CAMEL_IS_FOLDER (folder));
	g_return_val_if_fail (err == NULL || *err == NULL, 0);

	uidvalidity = __KOLAB_camel_imapx_folder_get_uidvalidity (folder,
	                                                          &tmp_err);
	if (tmp_err != NULL) {
		g_propagate_error (err, tmp_err);
		return 0;
	}

	return uidvalidity;
}

/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
