/***************************************************************************
 *            camel-kolab-imapx-metadata.h
 *
 *  Tue Oct 19 18:58:03 2010
 *  Copyright  2010  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
/*----------------------------------------------------------------------------*/
/* ANNOTATEMORE / METADATA (RFC 5464) (Kolab specifics) */

#ifndef _CAMEL_KOLAB_IMAPX_METADATA_H_
#define _CAMEL_KOLAB_IMAPX_METADATA_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>

#include <camel/camel.h>

#include <libekolabutil/kolab-util-folder.h>

#include "camel-kolab-imapx-metadata-db.h"

/*----------------------------------------------------------------------------*/

typedef struct _CamelKolabFolderMetaData {
	/* folder name kept as key in CamelKolabIMAPXMetaData kolab_metadata  */
	KolabFolderTypeID folder_type;
} CamelKolabFolderMetaData;

typedef struct _CamelKolabIMAPXMetaData {
	CamelKolabIMAPXMetaDataDB  *mdb;	/* persistent DB */
	GHashTable *kolab_metadata;		/* for CamelKolabFolderMetaData */
} CamelKolabIMAPXMetaData;

/*----------------------------------------------------------------------------*/

CamelKolabFolderMetaData *kolab_folder_meta_data_new (void);
gboolean kolab_folder_meta_data_free (CamelKolabFolderMetaData*);

CamelKolabIMAPXMetaData *kolab_imapx_meta_data_new (void);
gboolean kolab_imapx_meta_data_free (CamelKolabIMAPXMetaData*);
gboolean kolab_imapx_meta_data_init (CamelKolabIMAPXMetaData*, CamelService*, CamelSession*, GError**);
gboolean kolab_imapx_meta_data_uninit (CamelKolabIMAPXMetaData*, GError**);

gboolean kolab_imapx_meta_data_query_all_folder_types (CamelService*, GError**);
KolabFolderTypeID kolab_imapx_meta_data_get_foldertype (CamelKolabIMAPXMetaData*, CamelService*, const gchar*, gboolean, GError**);
gboolean kolab_imapx_meta_data_set_foldertype (CamelKolabIMAPXMetaData*, CamelService*, const gchar*, KolabFolderTypeID, GError**);
gboolean kolab_imapx_meta_data_remove (CamelKolabIMAPXMetaData*, const gchar*, GError**);

/*----------------------------------------------------------------------------*/

#endif /* _CAMEL_KOLAB_IMAPX_METADATA_H_ */

/*----------------------------------------------------------------------------*/
