/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* camel-imap-store.h : class for an imap store */

/*
 * Authors: Michael Zucchi <notzed@ximian.com>
 *
 * Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file has been borrowed from the original IMAPX implementation
 * of libcamel1.2-14, which is part of the Evolution Data Server.
 * Since the IMAPX API is not a public libcamel one, yet we need to
 * derive from (and extend) it, a local copy is kept here. The verbatim
 * copies are kept in a separate branch. 
 * This version of the file might have been extended by the
 * evolution-kolab project. Diff against the version in the verbatim branch
 * to see the changeset.
 *
 * changed by: Christian Hilberg <hilberg@kernelconcepts.de>
 * Changes (c) 2010 kernel concepts
 */

#ifndef CAMEL_IMAPX_STORE_H
#define CAMEL_IMAPX_STORE_H 1

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus }*/

#include <camel/camel-types.h>
#include <camel/camel-store.h>
#include <camel/camel-offline-store.h>
#include "camel-imapx-store-summary.h"

#define CAMEL_IMAPX_STORE_TYPE     (__KOLAB_camel_imapx_store_get_type ())
#define CAMEL_IMAPX_STORE(obj)     (CAMEL_CHECK_CAST((obj), CAMEL_IMAPX_STORE_TYPE, CamelIMAPXStore))
#define CAMEL_IMAPX_STORE_CLASS(k) (CAMEL_CHECK_CLASS_CAST ((k), CAMEL_IMAPX_STORE_TYPE, CamelIMAPXStoreClass))
#define CAMEL_IS_IMAPX_STORE(o)    (CAMEL_CHECK_TYPE((o), CAMEL_IMAPX_STORE_TYPE))
	
#define IMAPX_OVERRIDE_NAMESPACE	(1 << 0)
#define IMAPX_CHECK_ALL			(1 << 1)
#define IMAPX_FILTER_INBOX		(1 << 2)
#define IMAPX_FILTER_JUNK		(1 << 3)
#define IMAPX_FILTER_JUNK_INBOX		(1 << 4)
#define IMAPX_SUBSCRIPTIONS		(1 << 5)
#define IMAPX_CHECK_LSUB		(1 << 6)
#define IMAPX_USE_IDLE			(1 << 7)
#define IMAPX_USE_QRESYNC		(1 << 8)

typedef struct {
	CamelOfflineStore parent_object;

	struct _CamelIMAPXServer *server;

	CamelIMAPXStoreSummary *summary; /* in-memory list of folders */
	gchar *namespace, dir_sep, *base_url, *storage_path;

	guint32 rec_options;

	/* Used for syncronizing get_folder_info. Check for re-use of any other lock. At the
	   moment, could not find anything suitable for this */
	GMutex *get_finfo_lock;
	time_t last_refresh_time;

	/* hash table of UIDs to ignore as recent when updating folder */
	GHashTable *ignore_recent;

	/* if we had a login error, what to show to user */
	gchar *login_error;

	GPtrArray *pending_list;
} CamelIMAPXStore;

typedef struct {
	CamelOfflineStoreClass parent_class;

} CamelIMAPXStoreClass;

/* Standard Camel function */
CamelType __KOLAB_camel_imapx_store_get_type (void);
struct _CamelIMAPXServer *__KOLAB_camel_imapx_store_get_server (CamelIMAPXStore *store, CamelException *ex);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* CAMEL_IMAPX_STORE_H */

