/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 *  Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 *
 *  Authors:
 *    Michael Zucchi <notzed@ximian.com>
 *    Dan Winship <danw@ximian.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file has been borrowed from the original IMAPX implementation
 * of libcamel1.2-14, which is part of the Evolution Data Server.
 * Since the IMAPX API is not a public libcamel one, yet we need to
 * derive from (and extend) it, a local copy is kept here. The verbatim
 * copies are kept in a separate branch. 
 * This version of the file might have been extended by the
 * evolution-kolab project. Diff against the version in the verbatim branch
 * to see the changeset.
 *
 * changed by: Christian Hilberg <hilberg@kernelconcepts.de>
 * Changes (c) 2010 kernel concepts
 */

#ifndef _CAMEL_IMAPX_SUMMARY_H
#define _CAMEL_IMAPX_SUMMARY_H

//#include "camel-imap-types.h"
#include <camel/camel-folder-summary.h>
#include <camel/camel-exception.h>

#define CAMEL_IMAPX_SUMMARY(obj)         CAMEL_CHECK_CAST (obj, __KOLAB_camel_imapx_summary_get_type (), CamelIMAPXSummary)
#define CAMEL_IMAPX_SUMMARY_CLASS(klass) CAMEL_CHECK_CLASS_CAST (klass, __KOLAB_camel_imapx_summary_get_type (), CamelIMAPXSummaryClass)
#define CAMEL_IS_IMAPX_SUMMARY(obj)      CAMEL_CHECK_TYPE (obj, __KOLAB_camel_imapx_summary_get_type ())

#define CAMEL_IMAPX_SERVER_FLAGS (CAMEL_MESSAGE_ANSWERED | \
				 CAMEL_MESSAGE_DELETED | \
				 CAMEL_MESSAGE_DRAFT | \
				 CAMEL_MESSAGE_FLAGGED | \
				 CAMEL_MESSAGE_JUNK | \
				 CAMEL_MESSAGE_NOTJUNK | \
				 CAMEL_MESSAGE_SEEN)

G_BEGIN_DECLS

typedef struct _CamelIMAPXSummaryClass CamelIMAPXSummaryClass;
typedef struct _CamelIMAPXSummary CamelIMAPXSummary;

typedef struct _CamelIMAPXMessageContentInfo {
	CamelMessageContentInfo info;

} CamelIMAPXMessageContentInfo;

typedef struct _CamelIMAPXMessageInfo {
	CamelMessageInfoBase info;

	guint32 server_flags;
	struct _CamelFlag *server_user_flags;
} CamelIMAPXMessageInfo;

struct _CamelIMAPXSummary {
	CamelFolderSummary parent;

	guint32 version;
	guint32 uidnext;
	guint64 validity;
	guint64 modseq;
};

struct _CamelIMAPXSummaryClass {
	CamelFolderSummaryClass parent_class;

};

CamelType               __KOLAB_camel_imapx_summary_get_type     (void);
CamelFolderSummary *__KOLAB_camel_imapx_summary_new          (struct _CamelFolder *folder, const gchar *filename);

void __KOLAB_camel_imapx_summary_add_offline (CamelFolderSummary *summary, const gchar *uid, CamelMimeMessage *message, const CamelMessageInfo *info);

void __KOLAB_camel_imapx_summary_add_offline_uncached (CamelFolderSummary *summary, const gchar *uid, const CamelMessageInfo *info);

G_END_DECLS

#endif /* _CAMEL_IMAPX_SUMMARY_H */
