/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            e-book-backend-factory-kolab.c
 *
 *  Thu Jun 10 17:21:15 2010
 *  Copyright  2010  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 * and Silvan Marco Fin <silvan@kernelconcepts.de> in 2011
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#include "e-book-backend-kolab.h"

#include <libekolabutil/kolab-util-camel.h>

#include <libebackend/e-data-server-module.h>
#include <libedata-book/e-book-backend-factory.h>

typedef struct {
	EBookBackendFactory      parent_object;
} EBookBackendKolab2Factory;

typedef struct {
	EBookBackendFactoryClass parent_class;
} EBookBackendKolab2FactoryClass;

static GHashTable *koma_objects = NULL;

static void
_kolab2_factory_instance_init (EBookBackendKolab2Factory *factory)
{
	(void) factory;
}

static const gchar *
_kolab2_get_protocol (EBookBackendFactory *factory)
{
	(void) factory;
	return KOLAB_CAMEL_PROVIDER_PROTOCOL;
}

static EBookBackend*
_kolab2_new_backend (EBookBackendFactory *factory)
{
	EBookBackend *new_backend = NULL;

	(void) factory;

	new_backend = e_book_backend_kolab_new ();
	if (koma_objects == NULL)
		koma_objects = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	e_book_backend_kolab_set_koma_table (E_BOOK_BACKEND_KOLAB (new_backend), koma_objects);
	return new_backend;
}

static void
_kolab2_factory_class_init (EBookBackendKolab2FactoryClass *klass)
{
	E_BOOK_BACKEND_FACTORY_CLASS (klass)->get_protocol = _kolab2_get_protocol;
	E_BOOK_BACKEND_FACTORY_CLASS (klass)->new_backend = _kolab2_new_backend;
}

static GType
_kolab2_factory_get_type (GTypeModule *module)
{
	GType type;
	
	const GTypeInfo info = {
		sizeof (EBookBackendKolab2FactoryClass),
		NULL, /* base_class_init */
		NULL, /* base_class_finalize */
		(GClassInitFunc)  _kolab2_factory_class_init,
		NULL, /* class_finalize */
		NULL, /* class_data */
		sizeof (EBookBackendKolab2Factory),
		0,    /* n_preallocs */
		(GInstanceInitFunc) _kolab2_factory_instance_init,
		NULL /* GTypeValueTable */
	};

	type = g_type_module_register_type (module,
					    E_TYPE_BOOK_BACKEND_FACTORY,
					    "EBookBackendKolab2Factory",
					    &info, 0);

	return type;
}

static GType kolab_type;

void
eds_module_initialize (GTypeModule *module)
{
	g_debug ("%s() called.", __func__);
	kolab_type = _kolab2_factory_get_type (module);
}

void
eds_module_shutdown (void)
{
	g_debug ("%s() from the EBookBackendKolabFactory called.", __func__);
}

void
eds_module_list_types (const GType **types, gint *num_types)
{
	g_debug ("%s() called.", __func__);
	*types = &kolab_type;
	*num_types = 1;
}
