/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * evolution-kolab
 * Copyright (C) Silvan Marco Fin 2011 <silvan@kernelconcepts.de>
 * 
 * evolution-kolab is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * evolution-kolab is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _KOLAB_UTIL_CALENDAR_CACHE_H_
#define _KOLAB_UTIL_CALENDAR_CACHE_H_

#include <libekolab/kolab-mail-access.h>
#include <libecal/e-cal.h>
#include <libedata-cal/e-cal-backend-cache.h>

#include <glib-object.h>

G_BEGIN_DECLS

/**
 * SECTION:kolab-util-calendar-cache
 * @short_description: Utility methods for Evolution-Kolab calendar backend implementation with ECalBackendCache side effects.
 * @title: KolabUtilCalendarCache
 * 
 * The methods in KolabUtilCalendarCache are supposed to update the 
 * ECalBackendCache as a side effect to their primary task or retrieve data
 * from the cache to fulfill its task.
 */


#define KOLAB_TYPE_UTIL_CALENDAR_CACHE             (kolab_util_calendar_cache_get_type ())
#define KOLAB_UTIL_CALENDAR_CACHE(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), KOLAB_TYPE_UTIL_CALENDAR_CACHE, KolabUtilCalendarCache))
#define KOLAB_UTIL_CALENDAR_CACHE_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), KOLAB_TYPE_UTIL_CALENDAR_CACHE, KolabUtilCalendarCacheClass))
#define KOLAB_IS_UTIL_CALENDAR_CACHE(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KOLAB_TYPE_UTIL_CALENDAR_CACHE))
#define KOLAB_IS_UTIL_CALENDAR_CACHE_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), KOLAB_TYPE_UTIL_CALENDAR_CACHE))
#define KOLAB_UTIL_CALENDAR_CACHE_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), KOLAB_TYPE_UTIL_CALENDAR_CACHE, KolabUtilCalendarCacheClass))

typedef struct _KolabUtilCalendarCacheClass KolabUtilCalendarCacheClass;
typedef struct _KolabUtilCalendarCache KolabUtilCalendarCache;

struct _KolabUtilCalendarCacheClass
{
	GObjectClass parent_class;
};

struct _KolabUtilCalendarCache
{
	GObject parent_instance;
};

GType kolab_util_calendar_cache_get_type (void) G_GNUC_CONST;

/* library functions */

ECalComponent *kolab_util_calendar_cache_get_tz (ECalBackendCache *cache, ECalComponent *comp);
ECalComponent *kolab_util_calendar_cache_get_object (ECalBackendCache *cal_cache,
                                                     KolabMailAccess *koma,
                                                     const gchar *uri,
                                                     const gchar *uid,
                                                     gboolean bulk,
                                                     GError **error);
ECalComponent *kolab_util_calendar_cache_remove_instance (ECalBackendCache *cal_cache,
                                                          CalObjModType mod,
                                                          ECalComponent *ecalcomp,
                                                          const gchar *uid, 
                                                          const gchar *rid);
gboolean kolab_util_calendar_cache_assure_uid_on_ecalcomponent (ECalBackendCache *cache, 
                                                                KolabMailAccess *koma,
                                                                const gchar *uri,
                                                                ECalComponent *ecalcomp,
                                                                gboolean bulk,
                                                                GError **error);
void kolab_util_calendar_cache_update_on_query (ECalBackendCache *cache,
                                                KolabMailAccess *koma,
                                                const gchar *query,
                                                const gchar *uri);
void kolab_util_calendar_cache_update_object (ECalBackendCache *cache,
                                              KolabMailAccess *koma,
                                              const gchar *uri,
                                              const gchar *uid,
                                              gboolean bulk,
                                              GError **error);

/* object methods */

G_END_DECLS

#endif /* _KOLAB_UTIL_CALENDAR_CACHE_H_ */
