/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-kolab-imapx-provider.c
 *
 *  Thu Jun 10 19:27:45 2010
 *  Copyright  2010  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
/*----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>

#include <libekolabutil/kolab-util-camel.h>

#include <camel/camel-sasl.h>
#include <camel/camel-provider.h>
#include <camel/camel-exception.h>
#include <camel/camel-i18n.h>

/* IMAPX specifics 
 *
 *      The following header files are not installed,
 *      their API is not public to Camel users, so we
 *      need to keep our own local IMAPX around.
 */
#include <camel/providers/imapx/camel-imapx-exception.h>
#include <camel/providers/imapx/camel-imapx-utils.h>

#include "camel-kolab-imapx-provider.h"
#include "camel-kolab-imapx-store.h"
#include "camel-kolab-imapx-transport.h"

/*----------------------------------------------------------------------------*/

/* TODO customize for kolab2 */
CamelProviderConfEntry kolab_imapx_conf_entries[] = {
	{ CAMEL_PROVIDER_CONF_SECTION_START, "mailcheck", NULL,
	  N_("Checking for New Mail") },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "use_idle", NULL,
	  N_("Use I_dle if the server supports it"), "1" },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "check_all", NULL,
	  N_("C_heck for new messages in all folders"), "1" },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "check_lsub", NULL,
	  N_("Ch_eck for new messages in subscribed folders"), "0" },
	{ CAMEL_PROVIDER_CONF_SECTION_END },
	{ CAMEL_PROVIDER_CONF_SECTION_START, "folders", NULL,
	  N_("Folders") },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "use_lsub", NULL,
	  N_("_Show only subscribed folders"), "1" },
	{ CAMEL_PROVIDER_CONF_SECTION_END },
	{ CAMEL_PROVIDER_CONF_SECTION_START, "general", NULL, N_("Options") },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "filter", NULL,
	  N_("_Apply filters to new messages in INBOX on this server"), "0" },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "filter_junk", NULL,
	  N_("Check new messages for Jun_k contents"), "0" },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "filter_junk_inbox", "filter_junk",
	  N_("Only check for Junk messages in the IN_BOX folder"), "0" },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "sync_offline", NULL,
	  N_("Automatically synchroni_ze remote mail locally"), "0" },
	{ CAMEL_PROVIDER_CONF_SECTION_END },
	{ CAMEL_PROVIDER_CONF_END }
};

static CamelProvider kolab_imapx_provider = {	/* http://www.go-evolution.org/Camel.Provider */
	KOLAB_CAMEL_PROVIDER_PROTOCOL,

	N_(KOLAB_CAMEL_PROVIDER_NAME),
	 
	N_("For accessing Kolab2 servers."),
	"mail",

	/* TODO customize for kolab2 */
	CAMEL_PROVIDER_IS_REMOTE | CAMEL_PROVIDER_IS_SOURCE | \
	CAMEL_PROVIDER_IS_STORAGE | CAMEL_PROVIDER_SUPPORTS_SSL,

 	/* TODO customize for kolab2 */
 	CAMEL_URL_NEED_USER | CAMEL_URL_NEED_HOST | CAMEL_URL_NEED_AUTH,

	kolab_imapx_conf_entries,

	/* ... */
};

static CamelServiceAuthType kolab_imapx_password_authtype = {
	N_("Password"),
	N_("This option will connect to the Kolab2 server using a plaintext password."),
	"",
	TRUE
};

/*----------------------------------------------------------------------------*/
/* local forward declarations */

static guint kolab_url_hash (gconstpointer);
static gint kolab_url_equal (gconstpointer, gconstpointer);

/*----------------------------------------------------------------------------*/
/* external symbols */

extern void __KOLAB_camel_imapx_module_init (void);

/*----------------------------------------------------------------------------*/

void
camel_kolab_imapx_provider_module_init (void)
{
	__KOLAB_camel_imapx_module_init ();

	kolab_imapx_provider.object_types[CAMEL_PROVIDER_STORE] = camel_kolab_imapx_store_get_type ();
	kolab_imapx_provider.object_types[CAMEL_PROVIDER_TRANSPORT] = CAMEL_INVALID_TYPE;
	kolab_imapx_provider.url_hash = kolab_url_hash;
	kolab_imapx_provider.url_equal = kolab_url_equal;
	kolab_imapx_provider.authtypes = camel_sasl_authtype_list(FALSE);
	kolab_imapx_provider.authtypes = g_list_prepend (kolab_imapx_provider.authtypes,
	                                                 &kolab_imapx_password_authtype);
	kolab_imapx_provider.translation_domain = GETTEXT_PACKAGE;
	kolab_imapx_provider.license = "LGPL";

	/* TODO
	bindtextdomain (GETTEXT_PACKAGE, KOLAB_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	*/
	g_assert (kolab_imapx_provider.object_types[CAMEL_PROVIDER_STORE] != CAMEL_INVALID_TYPE);
	g_debug ("%s: done", __func__);
}     
                                       
void
camel_provider_module_init (void)
{
	camel_kolab_imapx_provider_module_init ();
	
	/* TODO
	 * maybe we need to call the following from within
	 * kolab_camel_provider_module_init ()
	 * (might be needed if the provider plugin system
	 * needs to be initialized from within the backends
	 * as well)
	 */
	g_assert (kolab_imapx_provider.object_types[CAMEL_PROVIDER_STORE] != CAMEL_INVALID_TYPE);
	camel_provider_register (&kolab_imapx_provider);
	g_debug ("%s: %s provider registered",
	         __func__, KOLAB_CAMEL_PROVIDER_PROTOCOL);
}

/*----------------------------------------------------------------------------*/

static void
kolab_add_hash (guint *hash, char *s)
{
	if (s)
		*hash ^= g_str_hash(s);
}

static guint
kolab_url_hash (gconstpointer key)
{
	const CamelURL	*u = (CamelURL *)key;
	guint hash = 0;

	kolab_add_hash (&hash, u->user);
	kolab_add_hash (&hash, u->authmech);
	kolab_add_hash (&hash, u->host);
	hash ^= (guint)u->port;

	return hash;
}

static gint
kolab_check_equal (char *s1, char *s2)
{
	if (s1 == NULL) {
		if (s2 == NULL)
			return TRUE;
		else
			return FALSE;
	}
	if (s2 == NULL)
		return FALSE;

	return strcmp (s1, s2) == 0;
}

static gint
kolab_url_equal (gconstpointer a, gconstpointer b)
{
	const CamelURL	*u1 = a;
	const CamelURL	*u2 = b;
  
	return kolab_check_equal (u1->protocol, u2->protocol)
		&& kolab_check_equal (u1->user, u2->user)
		&& kolab_check_equal (u1->authmech, u2->authmech)
		&& kolab_check_equal (u1->host, u2->host)
		&& u1->port == u2->port;
}

/*----------------------------------------------------------------------------*/
