/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* camel-pop3-provider.c: pop3 provider registration code */
/*
 * Authors :
 *   Dan Winship <danw@ximian.com>
 *   Michael Zucchi <notzed@ximian.com>
 *
 * Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file has been borrowed from the original IMAPX implementation
 * of libcamel1.2-14, which is part of the Evolution Data Server.
 * Since the IMAPX API is not a public libcamel one, yet we need to
 * derive from (and extend) it, a local copy is kept here. The verbatim
 * copies are kept in a separate branch. 
 * This version of the file might have been extended by the
 * evolution-kolab project. Diff against the version in the verbatim branch
 * to see the changeset.
 *
 * changed by: Christian Hilberg <hilberg@kernelconcepts.de>
 * Changes (c) 2010 kernel concepts
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include "camel/camel-provider.h"
#include "camel/camel-session.h"
#include "camel/camel-url.h"
#include "camel/camel-sasl.h"
#include "camel/camel-i18n.h"

#include "camel-imapx-store.h"

static guint imapx_url_hash (gconstpointer key);
static gint  imapx_url_equal (gconstpointer a, gconstpointer b);

CamelProviderConfEntry __KOLAB_imapx_conf_entries[] = {
	{ CAMEL_PROVIDER_CONF_SECTION_START, "mailcheck", NULL,
	  N_("Checking for New Mail") },
/* Not for stable branch -- new string. Set it with gconf-editor instead
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "use_qresync", NULL,
	  N_("Use _Quick Resync if the server supports it"), "1" },
*/
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "use_idle", NULL,
	  N_("Use I_dle if the server supports it"), "1" },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "check_all", NULL,
	  N_("C_heck for new messages in all folders"), "1" },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "check_lsub", NULL,
	  N_("Ch_eck for new messages in subscribed folders"), "0" },
	{ CAMEL_PROVIDER_CONF_SECTION_END },
#ifndef G_OS_WIN32
	{ CAMEL_PROVIDER_CONF_SECTION_START, "cmdsection", NULL,
	  N_("Connection to Server") },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "use_command", NULL,
	  N_("_Use custom command to connect to server"), "0" },
	{ CAMEL_PROVIDER_CONF_ENTRY, "command", "use_command",
	  N_("Command:"), "ssh -C -l %u %h exec /usr/sbin/dovecot --exec-mail imap" },
#if 0
	{ CAMEL_PROVIDER_CONF_CHECKSPIN, "cachedconn", NULL,
	  N_("Numbe_r of cached connections to use"), "y:1:5:7" },
#endif
	{ CAMEL_PROVIDER_CONF_SECTION_END },
#endif
	{ CAMEL_PROVIDER_CONF_SECTION_START, "folders", NULL,
	  N_("Folders") },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "use_lsub", NULL,
	  N_("_Show only subscribed folders"), "1" },
#if 0
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "override_namespace", NULL,
	  N_("O_verride server-supplied folder namespace"), "0" },
	{ CAMEL_PROVIDER_CONF_ENTRY, "namespace", "override_namespace",
	  N_("Namespace:") },
#endif
	{ CAMEL_PROVIDER_CONF_SECTION_END },
	{ CAMEL_PROVIDER_CONF_SECTION_START, "general", NULL, N_("Options") },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "filter", NULL,
	  N_("_Apply filters to new messages in INBOX on this server"), "0" },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "filter_junk", NULL,
	  N_("Check new messages for Jun_k contents"), "0" },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "filter_junk_inbox", "filter_junk",
	  N_("Only check for Junk messages in the IN_BOX folder"), "0" },
	{ CAMEL_PROVIDER_CONF_CHECKBOX, "sync_offline", NULL,
	  N_("Automatically synchroni_ze remote mail locally"), "0" },
	{ CAMEL_PROVIDER_CONF_SECTION_END },
	{ CAMEL_PROVIDER_CONF_END }
};

static CamelProvider imapx_provider = {
	"__KOLAB_imapx",

	N_("IMAP+"),

	N_("For reading and storing mail on IMAP servers."),
	"mail",

	CAMEL_PROVIDER_IS_REMOTE | CAMEL_PROVIDER_IS_SOURCE |
	CAMEL_PROVIDER_IS_STORAGE | CAMEL_PROVIDER_SUPPORTS_SSL,

	CAMEL_URL_NEED_USER | CAMEL_URL_NEED_HOST | CAMEL_URL_ALLOW_AUTH,

	__KOLAB_imapx_conf_entries,

	/* ... */
};

CamelServiceAuthType __KOLAB_camel_imapx_password_authtype = {
	N_("Password"),

	N_("This option will connect to the IMAP server using a "
	   "plaintext password."),

	"",
	TRUE
};

void __KOLAB_camel_imapx_module_init(void);

extern void __KOLAB_camel_exception_setup(void);
extern void __KOLAB_imapx_utils_init(void);

void
__KOLAB_camel_imapx_module_init(void)
{
#if 0	
	imapx_provider.object_types[CAMEL_PROVIDER_STORE] = __KOLAB_camel_imapx_store_get_type();
#endif	
	imapx_provider.url_hash = imapx_url_hash;
	imapx_provider.url_equal = imapx_url_equal;
	imapx_provider.authtypes = camel_sasl_authtype_list(FALSE);
	imapx_provider.authtypes = g_list_prepend(imapx_provider.authtypes, &__KOLAB_camel_imapx_password_authtype);
	imapx_provider.translation_domain = GETTEXT_PACKAGE;

	/* TEMPORARY */
	__KOLAB_camel_exception_setup();
	__KOLAB_imapx_utils_init();
#if 0
	camel_provider_register(&imapx_provider);
	g_debug ("imapx provider registered");
#endif
}

#if 0
void
camel_provider_module_init(void)
{
	camel_imapx_module_init();
}
#endif

static void
imapx_add_hash (guint *hash, gchar *s)
{
	if (s)
		*hash ^= g_str_hash(s);
}

static guint
imapx_url_hash (gconstpointer key)
{
	const CamelURL *u = (CamelURL *)key;
	guint hash = 0;

	imapx_add_hash (&hash, u->user);
	imapx_add_hash (&hash, u->host);
	hash ^= u->port;

	return hash;
}

static gint
imapx_check_equal (gchar *s1, gchar *s2)
{
	if (s1 == NULL) {
		if (s2 == NULL)
			return TRUE;
		else
			return FALSE;
	}

	if (s2 == NULL)
		return FALSE;

	return strcmp (s1, s2) == 0;
}

static gint
imapx_url_equal (gconstpointer a, gconstpointer b)
{
	const CamelURL *u1 = a, *u2 = b;

	return imapx_check_equal (u1->protocol, u2->protocol)
		&& imapx_check_equal (u1->user, u2->user)
		&& imapx_check_equal (u1->host, u2->host)
		&& u1->port == u2->port;
}
