/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            kolab-http-job.c
 *
 *  Tue Mar  1 14:05:54 2011
 *  Copyright  2011  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#include "kolab-http-job.h"

/*----------------------------------------------------------------------------*/

KolabHttpJob*
kolab_http_job_new (void)
{
	KolabHttpJob *job = g_new0 (KolabHttpJob, 1);
	job->url = NULL;
	job->buffer = NULL;
	job->nbytes = 0;
	job->pkcs11pin = NULL;

	return job;
}

void
kolab_http_job_free (KolabHttpJob *job)
{
	if (job == NULL)
		return;

	if (job->url != NULL)
		camel_url_free (job->url);
	if (job->buffer != NULL) {
		g_byte_array_free (job->buffer, TRUE);
	}
	if (job->pkcs11pin != NULL)
		g_free (job->pkcs11pin);
	g_free (job);
}

/*----------------------------------------------------------------------------*/
