/***************************************************************************
 *            kolab-util-error.c
 *
 *  Mon Feb 28 15:46:23 2011
 *  Copyright  2011  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
/*----------------------------------------------------------------------------*/

#include "kolab-util-error.h"

/*----------------------------------------------------------------------------*/
/* CamelIMAPX error GQuark						      */

GQuark
kolab_camel_error_quark (void)
{
        static GQuark quark = 0;

        if (G_UNLIKELY (quark == 0)) {
                const gchar *string = "camel-imapx-error-quark";
                quark = g_quark_from_static_string (string);
        }

        return quark;
}

/*----------------------------------------------------------------------------*/
/* CamelKolab error GQuark                                                    */

GQuark
kolab_camel_kolab_error_quark (void)
{
        static GQuark quark = 0;

        if (G_UNLIKELY (quark == 0)) {
                const gchar *string = "camel-kolab-error-quark";
                quark = g_quark_from_static_string (string);
        }

        return quark;
}

/*----------------------------------------------------------------------------*/
/* KolabUtil error GQuark                                                     */

GQuark
kolab_util_error_quark (void)
{
        static GQuark quark = 0;

        if (G_UNLIKELY (quark == 0)) {
                const gchar *string = "kolab-util--error-quark";
                quark = g_quark_from_static_string (string);
        }

        return quark;
}

/*----------------------------------------------------------------------------*/
/* CamelException <-> GError */

CamelException*
kolab_camelexception_new_from_gerror (const GError *err)
{
	CamelException *ex = camel_exception_new ();
	
	if (err != NULL) {
		camel_exception_set (ex,
		                     KOLAB_CAMEL_ERROR_GENERIC,
		                     err->message);
	}
	return ex;
}

GError*
kolab_gerror_new_from_camelexception (CamelException *ex,
                                      GQuark error_quark)
{
	GError *err = NULL;
	
	if (camel_exception_is_set (ex)) {
		err = g_error_new (error_quark,
		                   KOLAB_CAMEL_ERROR_GENERIC,
		                   "%s",
		                   camel_exception_get_description (ex));
	}
	return err;
}

void
kolab_gerror_propagate_from_camelexception (GError **err,
                                            CamelException *ex,
                                            GQuark error_quark)
{
	GError *tmp_err = NULL;

	g_assert (err == NULL || *err == NULL);

	if (!camel_exception_is_set (ex))
		return;

	tmp_err = kolab_gerror_new_from_camelexception (ex,
	                                                error_quark);
	camel_exception_free (ex);
	g_propagate_error (err, tmp_err);	
}

void
kolab_camelexception_propagate_from_gerror (CamelException *ex, GError *err)
{
	CamelException *tmp_ex;

	tmp_ex = kolab_camelexception_new_from_gerror (err);
	camel_exception_xfer (ex, tmp_ex);
}

/*----------------------------------------------------------------------------*/

