/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-imapx-extd-server.h
 *
 *  2011-11-28, 20:16:38
 *  Copyright 2011, Christian Hilberg
 *  <hilberg@unix-ag.org>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_IMAPX_EXTD_SERVER_H_
#define _CAMEL_IMAPX_EXTD_SERVER_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

#include "camel-imapx-metadata.h"
#include "camel-imapx-server.h"

/*----------------------------------------------------------------------------*/

struct _CamelIMAPXExtdStore;

/*----------------------------------------------------------------------------*/
/* Standard GObject macros */

#define CAMEL_TYPE_IMAPX_EXTD_SERVER	  \
	(camel_imapx_extd_server_get_type ())
#define CAMEL_IMAPX_EXTD_SERVER(obj)	  \
	(G_TYPE_CHECK_INSTANCE_CAST \
	 ((obj), CAMEL_TYPE_IMAPX_EXTD_SERVER, CamelIMAPXExtdServer))
#define CAMEL_IMAPX_EXTD_SERVER_CLASS(klass)	  \
	(G_TYPE_CHECK_CLASS_CAST \
	 ((klass), CAMEL_TYPE_IMAPX_EXTD_SERVER, CamelIMAPXExtdServerClass))
#define CAMEL_IS_IMAPX_EXTD_SERVER(obj)	  \
	(G_TYPE_CHECK_INSTANCE_TYPE \
	 ((obj), CAMEL_TYPE_IMAPX_EXTD_SERVER))
#define CAMEL_IS_IMAPX_EXTD_SERVER_CLASS(klass)	  \
	(G_TYPE_CHECK_CLASS_TYPE \
	 ((klass), CAMEL_TYPE_IMAPX_EXTD_SERVER))
#define CAMEL_IMAPX_EXTD_SERVER_GET_CLASS(obj)	  \
	(G_TYPE_INSTANCE_GET_CLASS \
	 ((obj), CAMEL_TYPE_IMAPX_EXTD_SERVER, CamelIMAPXExtdServerClass))

G_BEGIN_DECLS

typedef struct _CamelIMAPXExtdServer CamelIMAPXExtdServer;
typedef struct _CamelIMAPXExtdServerClass CamelIMAPXExtdServerClass;

struct _CamelIMAPXExtdServer {
	CamelIMAPXServer parent;
};

struct _CamelIMAPXExtdServerClass {
	CamelIMAPXServerClass parent_class;

	gboolean (*connect) (CamelIMAPXServer *self,
	                     GCancellable *cancellable,
	                     GError **err);

	gboolean (*connect_to_server) (CamelIMAPXServer *self,
	                               GCancellable *cancellable,
	                               GError **err);

	CamelAuthenticationResult (*authenticate) (CamelIMAPXServer *self,
	                                           const gchar *mechanism,
	                                           GCancellable *cancellable,
	                                           GError **err);

	GPtrArray* (*list) (CamelIMAPXServer *self,
	                    const gchar *top,
	                    guint32 flags,
	                    const gchar *ext,
	                    GCancellable *cancellable,
	                    GError **err);

	gboolean (*refresh_info) (CamelIMAPXServer *self,
	                          CamelFolder *folder,
	                          GCancellable *cancellable,
	                          GError **err);

	gboolean (*sync_changes) (CamelIMAPXServer *self,
	                          CamelFolder *folder,
	                          GCancellable *cancellable,
	                          GError **err);

	gboolean (*expunge) (CamelIMAPXServer *self,
	                     CamelFolder *folder,
	                     GCancellable *cancellable,
	                     GError **err);

	gboolean (*noop) (CamelIMAPXServer *self,
	                  CamelFolder *folder,
	                  GCancellable *cancellable,
	                  GError **err);

	CamelStream* (*get_message) (CamelIMAPXServer *self,
	                             CamelFolder *folder,
	                             const gchar *uid,
	                             GCancellable *cancellable,
	                             GError **err);

	gboolean (*copy_message) (CamelIMAPXServer *self,
	                          CamelFolder *source,
	                          CamelFolder *dest,
	                          GPtrArray *uids,
	                          gboolean delete_originals,
	                          GCancellable *cancellable,
	                          GError **err);

	gboolean (*append_message) (CamelIMAPXServer *self,
	                            CamelFolder *folder,
	                            CamelMimeMessage *message,
	                            const CamelMessageInfo *mi,
	                            GCancellable *cancellable,
	                            GError **err);

	gboolean (*sync_message) (CamelIMAPXServer *self,
	                          CamelFolder *folder,
	                          const gchar *uid,
	                          GCancellable *cancellable,
	                          GError **err);

	gboolean (*manage_subscription) (CamelIMAPXServer *self,
	                                 const gchar *foldername,
	                                 gboolean subscribe,
	                                 GCancellable *cancellable,
	                                 GError **err);

	gboolean (*create_folder) (CamelIMAPXServer *self,
	                           const gchar *foldername,
	                           GCancellable *cancellable,
	                           GError **err);

	gboolean (*delete_folder) (CamelIMAPXServer *self,
	                           const gchar *foldername,
	                           GCancellable *cancellable,
	                           GError **err);

	gboolean (*rename_folder) (CamelIMAPXServer *self,
	                           const gchar *oldname,
	                           const gchar *newname,
	                           GCancellable *cancellable,
	                           GError **err);

	struct _IMAPXJobQueueInfo* (*get_job_queue_info) (CamelIMAPXServer *self);

	camel_imapx_metadata_proto_t (*metadata_get_proto) (CamelIMAPXExtdServer *self);

	CamelImapxMetadata* (*get_metadata) (CamelIMAPXExtdServer *self,
	                                     CamelImapxMetadataSpec *spec,
	                                     gboolean do_resect,
	                                     GCancellable *cancellable,
	                                     GError **err);

	gboolean (*set_metadata) (CamelIMAPXExtdServer *self,
	                          CamelImapxMetadata *md,
	                          GCancellable *cancellable,
	                          GError **err);
};

GType
camel_imapx_extd_server_get_type (void);

CamelIMAPXExtdServer*
camel_imapx_extd_server_new (struct _CamelIMAPXExtdStore *store);

gboolean
camel_imapx_extd_server_connect (CamelIMAPXServer *self,
                                 GCancellable *cancellable,
                                 GError **err);

gboolean
camel_imapx_extd_server_connect_to_server (CamelIMAPXServer *self,
                                           GCancellable *cancellable,
                                           GError **err);

CamelAuthenticationResult
camel_imapx_extd_server_authenticate (CamelIMAPXServer *self,
                                      const gchar *mechanism,
                                      GCancellable *cancellable,
                                      GError **err);

GPtrArray*
camel_imapx_extd_server_list (CamelIMAPXServer *self,
                              const gchar *top,
                              guint32 flags,
                              const gchar *ext,
                              GCancellable *cancellable,
                              GError **err);
gboolean
camel_imapx_extd_server_refresh_info (CamelIMAPXServer *self,
                                      CamelFolder *folder,
                                      GCancellable *cancellable,
                                      GError **err);

gboolean
camel_imapx_extd_server_sync_changes (CamelIMAPXServer *self,
                                      CamelFolder *folder,
                                      GCancellable *cancellable,
                                      GError **err);

gboolean
camel_imapx_extd_server_expunge (CamelIMAPXServer *self,
                                 CamelFolder *folder,
                                 GCancellable *cancellable,
                                 GError **err);

gboolean
camel_imapx_extd_server_noop (CamelIMAPXServer *self,
                              CamelFolder *folder,
                              GCancellable *cancellable,
                              GError **err);

CamelStream*
camel_imapx_extd_server_get_message (CamelIMAPXServer *self,
                                     CamelFolder *folder,
                                     const gchar *uid,
                                     GCancellable *cancellable,
                                     GError **err);

gboolean
camel_imapx_extd_server_copy_message (CamelIMAPXServer *self,
                                      CamelFolder *source,
                                      CamelFolder *dest,
                                      GPtrArray *uids,
                                      gboolean delete_originals,
                                      GCancellable *cancellable,
                                      GError **err);

gboolean
camel_imapx_extd_server_append_message (CamelIMAPXServer *self,
                                        CamelFolder *folder,
                                        CamelMimeMessage *message,
                                        const CamelMessageInfo *mi,
                                        GCancellable *cancellable,
                                        GError **err);

gboolean
camel_imapx_extd_server_sync_message (CamelIMAPXServer *self,
                                      CamelFolder *folder,
                                      const gchar *uid,
                                      GCancellable *cancellable,
                                      GError **err);

gboolean
camel_imapx_extd_server_manage_subscription (CamelIMAPXServer *self,
                                             const gchar *foldername,
                                             gboolean subscribe,
                                             GCancellable *cancellable,
                                             GError **err);

gboolean
camel_imapx_extd_server_create_folder (CamelIMAPXServer *self,
                                       const gchar *foldername,
                                       GCancellable *cancellable,
                                       GError **err);

gboolean
camel_imapx_extd_server_delete_folder (CamelIMAPXServer *self,
                                       const gchar *foldername,
                                       GCancellable *cancellable,
                                       GError **err);

gboolean
camel_imapx_extd_server_rename_folder (CamelIMAPXServer *self,
                                       const gchar *oldname,
                                       const gchar *newname,
                                       GCancellable *cancellable,
                                       GError **err);
struct _IMAPXJobQueueInfo*
camel_imapx_extd_server_get_job_queue_info (CamelIMAPXServer *self);

camel_imapx_metadata_proto_t
camel_imapx_extd_server_metadata_get_proto (CamelIMAPXExtdServer *self);

CamelImapxMetadata*
camel_imapx_extd_server_get_metadata (CamelIMAPXExtdServer *self,
                                      CamelImapxMetadataSpec *spec,
                                      gboolean do_resect,
                                      GCancellable *cancellable,
                                      GError **err);

gboolean
camel_imapx_extd_server_set_metadata (CamelIMAPXExtdServer *self,
                                      CamelImapxMetadata *md,
                                      GCancellable *cancellable,
                                      GError **err);

G_END_DECLS

/*----------------------------------------------------------------------------*/

#endif /* CAMEL_IMAPX_EXTD_SERVER_H_ */

/*----------------------------------------------------------------------------*/
