/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-kolab-imapx-store.h
 *
 *  Fri Sep  3 12:48:31 2010
 *  Copyright  2010  Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#ifndef _CAMEL_KOLAB_IMAPX_STORE_H_
#define _CAMEL_KOLAB_IMAPX_STORE_H_

/*----------------------------------------------------------------------------*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

#include <libekolabutil/kolab-util-folder.h>

#include "camel-imapx-extd-store.h"

/*----------------------------------------------------------------------------*/
/* GObject macros */

#define CAMEL_TYPE_KOLAB_IMAPX_STORE	  \
	(camel_kolab_imapx_store_get_type ())
#define CAMEL_KOLAB_IMAPX_STORE(obj)	  \
	(G_TYPE_CHECK_INSTANCE_CAST \
	 ((obj), CAMEL_TYPE_KOLAB_IMAPX_STORE, CamelKolabIMAPXStore))
#define CAMEL_KOLAB_IMAPX_STORE_CLASS(cls)	  \
	(G_TYPE_CHECK_CLASS_CAST \
	 ((cls), CAMEL_TYPE_KOLAB_IMAPX_STORE, CamelKolabIMAPXStoreClass))
#define CAMEL_IS_KOLAB_IMAPX_STORE(obj)	  \
	(G_TYPE_CHECK_INSTANCE_TYPE \
	 ((obj), CAMEL_TYPE_KOLAB_IMAPX_STORE))
#define CAMEL_IS_KOLAB_IMAPX_STORE_CLASS(cls)	  \
	(G_TYPE_CHECK_CLASS_TYPE \
	 ((cls), CAMEL_TYPE_KOLAB_IMAPX_STORE))
#define CAMEL_KOLAB_IMAPX_STORE_GET_CLASS(obj)	  \
	(G_TYPE_INSTANCE_GET_CLASS \
	 ((obj), CAMEL_TYPE_KOLAB_IMAPX_STORE, CamelKolabIMAPXStoreClass))


G_BEGIN_DECLS

/* We're a descendant of CamelIMAPXExtdStore */

typedef struct _CamelKolabIMAPXStore CamelKolabIMAPXStore;
typedef struct _CamelKolabIMAPXStoreClass CamelKolabIMAPXStoreClass;

struct _CamelKolabIMAPXStore {
	CamelIMAPXExtdStore parent;
};

struct _CamelKolabIMAPXStoreClass {
	CamelIMAPXExtdStoreClass parent_class;

	gboolean (*set_folder_creation_type) (CamelKolabIMAPXStore *self,
	                                      KolabFolderTypeID type_id);

	gboolean (*set_folder_context) (CamelKolabIMAPXStore *self,
	                                KolabFolderContextID context);

	KolabFolderTypeID (*get_folder_type) (CamelKolabIMAPXStore *self,
	                                      const gchar *foldername,
	                                      GCancellable *cancellable,
	                                      GError **err);

	GList* (*resect_folder_list) (CamelKolabIMAPXStore *self);
};

GType camel_kolab_imapx_store_get_type (void);

/* Kolab extension: set type for newly created folders */
gboolean
camel_kolab_imapx_store_set_folder_creation_type (CamelKolabIMAPXStore *self,
                                                  KolabFolderTypeID type_id);

/* Kolab extension: set the folder context (email, calendar, contacts (defaults to email)) */
gboolean
camel_kolab_imapx_store_set_folder_context (CamelKolabIMAPXStore *self,
                                            KolabFolderContextID context);

/* Kolab extension: get the folder type id */
KolabFolderTypeID
camel_kolab_imapx_store_get_folder_type (CamelKolabIMAPXStore *self,
                                         const gchar *foldername,
                                         GCancellable *cancellable,
                                         GError **err);

/* Kolab extension */
GList*
camel_kolab_imapx_store_resect_folder_list (CamelKolabIMAPXStore *self);

G_END_DECLS

/*----------------------------------------------------------------------------*/

#endif /* _CAMEL_KOLAB_IMAPX_STORE_H_ */

/*----------------------------------------------------------------------------*/
