/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/***************************************************************************
 *            camel-imapx-extd-server-acl.c
 *
 *  2012-07-30, 17:13:28
 *  Copyright 2012, Christian Hilberg
 *  <hilberg@kernelconcepts.de>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/*----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib/gi18n.h>

#include "camel-imapx-extd-store.h"
#include "camel-imapx-extd-store-friend.h"
#include "camel-imapx-extd-server.h"

#include "camel-imapx-extd-server-acl.h"

/*----------------------------------------------------------------------------*/

static gboolean
imapx_extd_server_untagged_acl (CamelIMAPXServer *is,
                                CamelIMAPXStream *stream,
                                GCancellable *cancellable,
                                GError **err);

static gboolean
imapx_extd_server_untagged_myrights (CamelIMAPXServer *is,
                                     CamelIMAPXStream *stream,
                                     GCancellable *cancellable,
                                     GError **err);

static const CamelIMAPXUntaggedRespHandlerDesc desc_acl = {
	IMAPX_IMAP_TOKEN_ACL,                  /* untagged_response     */
	imapx_extd_server_untagged_acl,        /* handler               */
	NULL,                                  /* next_response         */
	TRUE                                   /* skip_stream_when_done */
};

static const CamelIMAPXUntaggedRespHandlerDesc desc_myrights = {
	IMAPX_IMAP_TOKEN_MYRIGHTS,             /* untagged_response     */
	imapx_extd_server_untagged_myrights,   /* handler               */
	NULL,                                  /* next_response         */
	TRUE                                   /* skip_stream_when_done */
};

/*----------------------------------------------------------------------------*/

static gboolean
imapx_extd_server_untagged_acl (CamelIMAPXServer *is,
                                CamelIMAPXStream *stream,
                                GCancellable *cancellable,
                                GError **err)
{
	g_assert (CAMEL_IS_IMAPX_SERVER (is));
	/* cancellable may be NULL */
	g_return_val_if_fail (err == NULL || *err == NULL, FALSE);

	/* FIXME implement me */
	g_assert_not_reached ();

	return TRUE;
}

static gboolean
imapx_extd_server_untagged_myrights (CamelIMAPXServer *is,
                                     CamelIMAPXStream *stream,
                                     GCancellable *cancellable,
                                     GError **err)
{
	g_assert (CAMEL_IS_IMAPX_SERVER (is));
	/* cancellable may be NULL */
	g_return_val_if_fail (err == NULL || *err == NULL, FALSE);

	/* FIXME implement me */
	g_assert_not_reached ();

	return TRUE;
}

/*----------------------------------------------------------------------------*/

KolabGConstList*
camel_imapx_extd_server_acl_get_handler_descriptors (void)
{
	KolabGConstList *list = NULL;
	list = kolab_util_glib_gconstlist_prepend (list,
	                                           (gconstpointer)(&desc_myrights));
	list = kolab_util_glib_gconstlist_prepend (list,
	                                           (gconstpointer)(&desc_acl));
	return list;
}

gboolean
camel_imapx_extd_server_get_myrights (CamelIMAPXServer *is,
                                      /* something */
                                      GCancellable *cancellable,
                                      GError **err)
{
	g_assert (CAMEL_IS_IMAPX_SERVER (is));
	/* assert something */
	/* cancellable may be NULL */
	g_return_val_if_fail (err == NULL || *err == NULL, FALSE);

	/* FIXME implement me */
	g_assert_not_reached ();

	return TRUE;
}

gboolean
camel_imapx_extd_server_get_acl (CamelIMAPXServer *is,
                                 /* something */
                                 GCancellable *cancellable,
                                 GError **err)
{
	g_assert (CAMEL_IS_IMAPX_SERVER (is));
	/* assert something */
	/* cancellable may be NULL */
	g_return_val_if_fail (err == NULL || *err == NULL, FALSE);

	/* FIXME implement me */
	g_assert_not_reached ();

	return TRUE;
}

gboolean
camel_imapx_extd_server_set_acl (CamelIMAPXServer *is,
                                 /* something */
                                 GCancellable *cancellable,
                                 GError **err)
{
	g_assert (CAMEL_IS_IMAPX_SERVER (is));
	/* assert something */
	/* cancellable may be NULL */
	g_return_val_if_fail (err == NULL || *err == NULL, FALSE);

	/* FIXME implement me */
	g_assert_not_reached ();

	return TRUE;
}

/*----------------------------------------------------------------------------*/
