/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#ifndef E_MAIL_CONFIG_KOLAB_BACKEND_H
#define E_MAIL_CONFIG_KOLAB_BACKEND_H

#include <mail/e-mail-config-service-backend.h>

/* Standard GObject macros */
#define E_TYPE_MAIL_CONFIG_KOLAB_BACKEND \
	(e_mail_config_kolab_backend_get_type ())
#define E_MAIL_CONFIG_KOLAB_BACKEND(obj) \
	(G_TYPE_CHECK_INSTANCE_CAST \
	((obj), E_TYPE_MAIL_CONFIG_KOLAB_BACKEND, EMailConfigKolabBackend))
#define E_MAIL_CONFIG_KOLAB_BACKEND_CLASS(cls) \
	(G_TYPE_CHECK_CLASS_CAST \
	((cls), E_TYPE_MAIL_CONFIG_KOLAB_BACKEND, EMailConfigKolabBackendClass))
#define E_IS_MAIL_CONFIG_KOLAB_BACKEND(obj) \
	(G_TYPE_CHECK_INSTANCE_TYPE \
	((obj), E_TYPE_MAIL_CONFIG_KOLAB_BACKEND))
#define E_IS_MAIL_CONFIG_KOLAB_BACKEND_CLASS(cls) \
	(G_TYPE_CHECK_CLASS_TYPE \
	((cls), E_TYPE_MAIL_CONFIG_KOLAB_BACKEND))
#define E_MAIL_CONFIG_KOLAB_BACKEND_GET_CLASS(obj) \
	(G_TYPE_INSTANCE_GET_CLASS \
	((obj), E_TYPE_MAIL_CONFIG_KOLAB_BACKEND, EMailConfigKolabBackendClass))

G_BEGIN_DECLS

typedef struct _EMailConfigKolabBackend EMailConfigKolabBackend;
typedef struct _EMailConfigKolabBackendClass EMailConfigKolabBackendClass;
typedef struct _EMailConfigKolabBackendPrivate EMailConfigKolabBackendPrivate;

struct _EMailConfigKolabBackend {
	EMailConfigServiceBackend parent;
	EMailConfigKolabBackendPrivate *priv;
};

struct _EMailConfigKolabBackendClass {
	EMailConfigServiceBackendClass parent_class;
};

GType		e_mail_config_kolab_backend_get_type
						(void) G_GNUC_CONST;
void		e_mail_config_kolab_backend_type_register
						(GTypeModule *type_module);

G_END_DECLS

#endif /* E_MAIL_CONFIG_KOLAB_BACKEND_H */

