#include <string.h>
#include <libecal/e-cal.h>
#include <libecal/e-cal-component.h>
#include <libecal/e-cal-time-util.h>
#include <libical/ical.h>

#include "e-cal-glue-comp.h"
#include "e-cal-glue-recur.h"
#include "e-cal-glue-recur-util.h"

icalproperty_kind ical_props[] = {  ICAL_ATTENDEE_PROPERTY, 
				    ICAL_CATEGORIES_PROPERTY, 
				    ICAL_COMMENT_PROPERTY, 
				    ICAL_DESCRIPTION_PROPERTY,
				    ICAL_LOCATION_PROPERTY,
				    ICAL_SUMMARY_PROPERTY,
				    ICAL_DTSTART_PROPERTY,
				    ICAL_DTEND_PROPERTY,
				    -1  };
				  

GSList* e_cal_glue_from_ecal_comp_objects_to_glue_components (GList* ecal_comp_objects);

ECalGlueComponent*
get_ecal_comp_properties (ECalComponent* comp)
{

  GSList* attendee_list = NULL;
  GSList* category_list = NULL;
  GSList* comment_list = NULL;
  GSList* summary_list = NULL;
  GSList* desc_list = NULL;
  GSList* location_list = NULL;

  GSList* comp_attendee_list = NULL;
  GSList* comp_comment_list = NULL;
  GSList* comp_desc_list = NULL;
  GSList* l = NULL;
  ECalComponentText summary;

  ECalComponentAttendee *a = NULL;
  ECalComponentText *t = NULL;
  ECalComponentDateTime dt;

  ECalGlueComponent* glue_comp = NULL;

  icaltimetype *tt = NULL;
  icaltimetype ictt;

  const char* location = NULL;
  char* buf;

  time_t dtstart = 0;
  time_t dtend = 0;
  time_t last_modified_date = 0;
  time_t dtstamp = 0;
  time_t created = 0;
  struct tm stm;
  
  e_cal_component_get_attendee_list (comp, &comp_attendee_list);
  e_cal_component_get_categories_list (comp, &category_list);
  e_cal_component_get_description_list (comp, &comp_desc_list);
  e_cal_component_get_summary (comp, &summary);
  e_cal_component_get_comment_list (comp, &comp_comment_list);
  e_cal_component_get_location (comp, &location);

  /* FIXME: We should use the icaltimetype_XXX APIs for the conversion
     of icaltimetype to time_t.  We need to generate a TZID and pass it 
     to icaltimezone_get_zone (tzid) and pass the return value to 
     icaltimetype_as_timet_with_zone () to get the correct time_t value. */

  e_cal_component_get_last_modified (comp, &tt);
  if (tt != NULL) {
    stm.tm_year = tt->year - 1900;
    stm.tm_mon  = tt->month - 1;
    stm.tm_mday = tt->day;
    stm.tm_hour = tt->hour;
    stm.tm_min  = tt->minute;
    stm.tm_sec  = tt->second;
    last_modified_date = mktime (&stm);
    e_cal_component_free_icaltimetype (tt);
    tt = NULL;
  }

  e_cal_component_get_dtstamp (comp, &ictt);
  stm.tm_year = ictt.year - 1900;
  stm.tm_mon  = ictt.month - 1;
  stm.tm_mday = ictt.day;
  stm.tm_hour = ictt.hour;
  stm.tm_min  = ictt.minute;
  stm.tm_sec  = ictt.second;
  dtstamp = mktime (&stm);

  e_cal_component_get_created (comp, &tt);
  if (tt != NULL) {
    stm.tm_year = tt->year - 1900;
    stm.tm_mon  = tt->month - 1;
    stm.tm_mday = tt->day;
    stm.tm_hour = tt->hour;
    stm.tm_min  = tt->minute;
    stm.tm_sec  = tt->second;
    created = mktime (&stm);
    e_cal_component_free_icaltimetype (tt);
    tt = NULL;
  }

  e_cal_component_get_dtend (comp, &dt);
  if (dt.value != NULL) {
    stm.tm_year = dt.value->year - 1900;
    stm.tm_mon  = dt.value->month - 1;
    stm.tm_mday = dt.value->day;
    stm.tm_hour = dt.value->hour;
    stm.tm_min  = dt.value->minute;
    stm.tm_sec  = dt.value->second;
  
    dtend = mktime (&stm);
  }

  e_cal_component_get_dtstart (comp, &dt);
  if (dt.value != NULL) {
    stm.tm_year = dt.value->year - 1900;
    stm.tm_mon  = dt.value->month - 1;
    stm.tm_mday = dt.value->day;
    stm.tm_hour = dt.value->hour;
    stm.tm_min  = dt.value->minute;
    stm.tm_sec  = dt.value->second;
  
    dtstart = mktime (&stm);
  }
  
  for (l = comp_attendee_list; l; l = l->next) {
    a = l->data;
    if (a->value) {
      buf = g_strdup (a->value);
      attendee_list = g_slist_append (attendee_list, buf);
    }
  }
  e_cal_component_free_attendee_list (comp_attendee_list);
  
  for (l = comp_desc_list; l; l = l->next) {
    t = l->data;
    if (t->value) {
      buf = g_strdup (t->value);
      desc_list = g_slist_append (desc_list, buf);
    }
  }
  e_cal_component_free_text_list (comp_desc_list);
  
  for (l = comp_comment_list; l; l = l->next) {
    t = l->data;
    if (t->value) {
      buf = g_strdup (t->value);
      comment_list = g_slist_append (comment_list, buf);
    }
  }
  e_cal_component_free_text_list (comp_comment_list);

  summary_list = g_slist_append (summary_list, g_strdup (summary.value));
  
  location_list = g_slist_append (location_list, g_strdup (location));

  glue_comp = e_cal_glue_component_new ();

  buf = NULL;
  e_cal_component_get_uid (comp, (const char **)&buf);
  e_cal_glue_component_set_uid (glue_comp, buf);

  if (e_cal_component_has_recurrences (comp)) {
    /* It is the master object.  We need to store 
       1. Frequency of recurrence.
       2. Count of recurrence.
       3. Start date of recurrence.
       4. Exception rules. (ah!! things are getting complex. :-( )
       
       Ok. we now store the list of ECalGlueRecurrence* that 
       represent each of rrules and exrules.
     */
    
    GSList* rrule_prop_list = NULL;
    GSList* l;
    GSList* ecal_recur_list = NULL;
    fprintf (stderr, "%s has recurrences\n", buf);

    /* Set the recurrence flag in the glue component*/
    e_cal_glue_component_set_has_recurrences (glue_comp, TRUE);
    
    /* Fetch the rrules */
    e_cal_component_get_rrule_property_list (comp, &rrule_prop_list);
    for (l = rrule_prop_list; l; l = l->next) {
      ECalGlueRecurrence* ecal_recur = e_cal_recur_from_icalproperty (l->data, 
								      FALSE,
								      (icaltimezone *)dt.value->zone,
								      TRUE);
      ecal_recur_list = g_slist_append (ecal_recur_list, ecal_recur);
    }
    e_cal_glue_component_set_rrule_list (glue_comp, ecal_recur_list);

    ecal_recur_list = NULL;
   
    /* Fetch the exrules */
    e_cal_component_get_exrule_property_list (comp, &rrule_prop_list);
    for (l = rrule_prop_list; l; l = l->next) {
      ECalGlueRecurrence* ecal_recur = e_cal_recur_from_icalproperty (l->data, 
								      TRUE, /* exrule */
								      (icaltimezone *)dt.value->zone,
								      TRUE);
      ecal_recur_list = g_slist_append (ecal_recur_list, ecal_recur);
    }
    e_cal_glue_component_set_exrule_list (glue_comp, ecal_recur_list);
  }

  buf = NULL;
  buf = (char *)e_cal_component_get_recurid_as_string (comp);
  if (e_cal_component_is_instance (comp)) 
    fprintf (stderr, "%s is a recurrence instance\n", buf);

  e_cal_glue_component_set_recur_id (glue_comp, buf);

  attendee_list ? e_cal_glue_component_set_attendees    (glue_comp, attendee_list):0;
  summary_list  ? e_cal_glue_component_set_summaries    (glue_comp, summary_list):0;
  location_list ? e_cal_glue_component_set_location     (glue_comp, location_list):0;
  category_list ? e_cal_glue_component_set_categories   (glue_comp, category_list):0;
  desc_list     ? e_cal_glue_component_set_descriptions (glue_comp, desc_list):0;
  comment_list  ? e_cal_glue_component_set_comments     (glue_comp, comment_list):0;

  e_cal_glue_component_set_dtstart (glue_comp, dtstart);
  e_cal_glue_component_set_dtend (glue_comp, dtend);
  e_cal_glue_component_set_last_modified_date (glue_comp, last_modified_date);
  e_cal_glue_component_set_dtstamp (glue_comp, dtstamp);
  e_cal_glue_component_set_created (glue_comp, created);

  return glue_comp;
}

#if 0
ECalGlueComponent*
get_ical_comp_properties (icalcomponent* ical) 
{
  icalproperty* p = NULL; 
  icaltimetype tt;

  GSList* attendee_list = NULL;
  GSList* category_list = NULL;
  GSList* comment_list = NULL;
  GSList* location_list = NULL;
  GSList* summary_list = NULL;
  GSList* desc_list = NULL;
  time_t dtstart;
  time_t dtend;
  struct tm t;

  ECalGlueComponent* comp = NULL;
  
  char* tmp = NULL;
  char* buf = NULL;

  int i = -1;

  if (!ical)
    return NULL;

  while (ical_props [++i] != -1) {        

    p = icalcomponent_get_first_property (ical, ical_props[i]);
    if (!p)
      continue;

    while (p) {
      switch (ical_props [i]) {
      case ICAL_ATTENDEE_PROPERTY:
	tmp = (char *)icalproperty_get_attendee (p);
	if (tmp) {
	  buf = g_strdup (tmp);
	  attendee_list = g_slist_append (attendee_list, buf);	  
	}
	break;

      case ICAL_CATEGORIES_PROPERTY:
	tmp = (char *)icalproperty_get_categories (p);
	if (tmp) {
	  buf = g_strdup (tmp);
	  category_list = g_slist_append (category_list, buf);
	}
	break;

      case ICAL_COMMENT_PROPERTY: 
	tmp = (char *)icalproperty_get_comment (p);
	if (tmp) {
	  buf = g_strdup (tmp);
	  comment_list = g_slist_append (comment_list, buf);
	}
	break;

      case ICAL_DESCRIPTION_PROPERTY:
	tmp = (char *)icalproperty_get_description (p);
	if (tmp) {
	  buf = g_strdup (tmp);
	  desc_list = g_slist_append (desc_list, buf);
	}
	break;

      case ICAL_LOCATION_PROPERTY:
	tmp = (char *)icalproperty_get_location (p);
	if (tmp) {
	  buf = g_strdup (tmp);
	  location_list = g_slist_append (location_list, buf);
	}
	break;

      case ICAL_SUMMARY_PROPERTY:
	tmp = (char *)icalproperty_get_summary (p);
	if (tmp) {
	  buf = g_strdup (tmp);
	  summary_list = g_slist_append (summary_list, buf);
	}
	break;

      case ICAL_DTSTART_PROPERTY:
	tt = icalproperty_get_dtstart (p);
	t.tm_year  = tt.year - 1900;
	t.tm_mon  = tt.month - 1;
	t.tm_mday = tt.day;
	t.tm_hour = tt.hour;
	t.tm_min  = tt.minute;
	t.tm_sec  = tt.second;
	
	dtstart = mktime (&t);
	break;
	
      case ICAL_DTEND_PROPERTY:
	tt = icalproperty_get_dtend (p);
	t.tm_year  = tt.year - 1900;
	t.tm_mon  = tt.month - 1;
	t.tm_mday = tt.day;
	t.tm_hour = tt.hour;
	t.tm_min  = tt.minute;
	t.tm_sec  = tt.second;

	dtend = mktime (&t);
	break;

      default: fprintf (stderr, "Property [%d] not available\n", i);
	break;
      }
      p = icalcomponent_get_next_property (ical, ical_props[i]);
    }
    
  }    

  /*  
  tt = icalproperty_get_dtstart (ical);
  dtstart = icaltime_as_timet_with_zone (tt, NULL);

  tt = icalcomponent_get_dtend (ical);
  dtend  = icaltime_as_timet_with_zone (tt, NULL);
  */
  comp = e_cal_glue_component_new ();

  e_cal_glue_component_set_uid (comp, (char *)icalproperty_get_uid (ical));

  attendee_list ? e_cal_glue_component_set_attendees    (comp, attendee_list):0;
  summary_list  ? e_cal_glue_component_set_summaries    (comp, summary_list):0;
  location_list ? e_cal_glue_component_set_location     (comp, location_list):0;
  category_list ? e_cal_glue_component_set_categories   (comp, category_list):0;
  desc_list     ? e_cal_glue_component_set_descriptions (comp, desc_list):0;
  comment_list  ? e_cal_glue_component_set_comments     (comp, comment_list):0;

  e_cal_glue_component_set_dtstart (comp, dtstart);
  e_cal_glue_component_set_dtend (comp, dtend);

  return comp;
}
#endif

GSList*
e_cal_glue_from_objects_to_glue_components (GList* ical_objects)
{
  GList *l;
  GSList* wrapped_cal_comp = NULL;
  ECalGlueComponent* glue_comp = NULL;
  ECalComponent *comp = NULL;

  if (!ical_objects)
    return NULL;
  
  for (l = ical_objects; l; l = l->next) {    
    
    icalcomponent* clone = NULL;

    clone = icalcomponent_new_clone (l->data);

    comp = e_cal_component_new ();
    e_cal_component_set_icalcomponent (comp, clone);

    glue_comp = get_ecal_comp_properties (comp);
    if (glue_comp)
      wrapped_cal_comp = g_slist_prepend (wrapped_cal_comp, glue_comp);

    g_object_unref (comp);
  }
  wrapped_cal_comp = g_slist_reverse (wrapped_cal_comp);
  
  return wrapped_cal_comp;
}

GSList*
e_cal_glue_from_ecal_comp_objects_to_glue_components (GList* ecal_comp_objects)
{
  GList *l;
  GSList* wrapped_cal_comp = NULL;
  ECalGlueComponent* glue_comp = NULL;

  if (!ecal_comp_objects)
    return NULL;

  for (l = ecal_comp_objects; l; l = l->next) {
    glue_comp = get_ecal_comp_properties (l->data);
    if (glue_comp)
      wrapped_cal_comp = g_slist_prepend (wrapped_cal_comp, glue_comp);
  }

  wrapped_cal_comp = g_slist_reverse (wrapped_cal_comp);
  return wrapped_cal_comp;
}

void
e_cal_glue_free_e_cal_comp_objects (GList* objects)
{
  GList* l;
  
  for (l = objects; l; l = l->next)
    g_object_unref (l->data);

  g_list_free (objects);
}

/*
 * Should the following be used? (or just write a new one?)
 *
 */
gboolean
e_cal_glue_ecal_get_changes (ECal* ecal,
			     const char* change_id,
			     GSList** newitems,
			     GSList** updated,
			     GSList** removed,
			     GError** error)
{
  GList* changes = NULL;
  GList* l;
  ECalChange* ccc;
  ECalGlueComponent* glue_comp;
  const char* uid = NULL;
  
  GSList *added = NULL, *modified = NULL, *deleted = NULL;

  if (!ecal)
    return FALSE;

  if (!e_cal_get_changes (ecal, change_id, &changes, error))
    return FALSE;

  if (!changes)
    return FALSE;

  for (l = changes; l; l = l->next) {
    glue_comp = NULL;
    ccc = l->data;

    switch (ccc->type) {
    case E_CAL_CHANGE_ADDED:
      glue_comp = get_ecal_comp_properties (ccc->comp);
      added = g_slist_prepend (added, glue_comp);
      break;
    case E_CAL_CHANGE_MODIFIED:
      glue_comp = get_ecal_comp_properties (ccc->comp);
      modified = g_slist_prepend (modified, glue_comp);
      break;
    case E_CAL_CHANGE_DELETED:
      e_cal_component_get_uid (ccc->comp, &uid);
      deleted = g_slist_prepend (deleted, g_strdup (uid));
      break;
    }    
  }

  e_cal_free_change_list (changes);

  if (added)
    *newitems = g_slist_reverse (added);

  if (modified)
    *updated = g_slist_reverse (modified);

  if (deleted)
    *removed = g_slist_reverse (deleted);

  return TRUE;
}

void
e_cal_glue_free_glue_component_list (GSList* objects)
{
  GSList* l;
  ECalGlueComponent* comp;

  for (l = objects; l; l = l->next) {
    comp = l->data;
    g_object_unref (comp);
  }
  g_slist_free (l);
}
