/* Evolution calendar - Live query client object
 *
 * Copyright (C) 2001 Ximian, Inc.
 *
 * Author: Federico Mena-Quintero <federico@ximian.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef CAL_QUERY_H
#define CAL_QUERY_H

#include <libgnome/gnome-defs.h>
#include <gtk/gtkobject.h>

#include "evolution-calendar.h"

BEGIN_GNOME_DECLS



#define CAL_QUERY_TYPE            (cal_query_get_type ())
#define CAL_QUERY(obj)            (GTK_CHECK_CAST ((obj), CAL_QUERY_TYPE, CalQuery))
#define CAL_QUERY_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), CAL_QUERY_TYPE, CalQueryClass))
#define IS_CAL_QUERY(obj)         (GTK_CHECK_TYPE ((obj), CAL_QUERY_TYPE))
#define IS_CAL_QUERY_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), CAL_QUERY_TYPE))

/* Status values when a query terminates */
typedef enum {
	CAL_QUERY_DONE_SUCCESS,
	CAL_QUERY_DONE_PARSE_ERROR
} CalQueryDoneStatus;

typedef struct _CalQueryPrivate CalQueryPrivate;

typedef struct {
	GtkObject object;

	/* Private data */
	CalQueryPrivate *priv;
} CalQuery;

typedef struct {
	GtkObjectClass parent_class;

	/* Notification signals */

	void (* obj_updated) (CalQuery *query, const char *uid,
			      gboolean query_in_progress, int n_scanned, int total);
	void (* obj_removed) (CalQuery *query, const char *uid);

	void (* query_done) (CalQuery *query, CalQueryDoneStatus status, const char *error_str);

	void (* eval_error) (CalQuery *query, const char *error_str);
} CalQueryClass;

GtkType cal_query_get_type (void);

CalQuery *cal_query_construct (CalQuery *query,
			       GNOME_Evolution_Calendar_Cal cal,
			       const char *sexp);

CalQuery *cal_query_new (GNOME_Evolution_Calendar_Cal cal,
			 const char *sexp);



END_GNOME_DECLS

#endif
