%define name	firestarter
%define version 0.6.0beta1
%define release 1
%define prefix  /usr

Summary: A firewall tool GNOME
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Applications/Internet
URL: http://firestarter.sourceforge.net

Source: http://download.sourceforge.com/firestarter/firestarter-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-root

Docdir: %{prefix}/doc

Requires: gtk+ >= 1.2.7
Requires: gnome-libs >= 1.2.0

%description
Firestarter is an easy-to-use, yet powerful, Linux firewall tool for GNOME.
Use it to quickly set up a secure environment using the firewall creation
wizard, or use it's monitoring and administrating features with your old
firewall scripts.

%prep

%setup

%build
CFLAGS="-O2" 
%ifarch i586
CFLAGS="-O2 -mpentium -march=pentium" 
%endif
%ifarch i686
CFLAGS="-O2 -mpentiumpro -march=pentiumpro" 
%endif
./configure --prefix=%{prefix} --sysconfdir=/etc
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/sbin

make prefix=$RPM_BUILD_ROOT%{prefix} install

mv $RPM_BUILD_ROOT/usr/bin/firestarter $RPM_BUILD_ROOT/usr/sbin/
ln -s /usr/bin/consolehelper $RPM_BUILD_ROOT/%{prefix}/bin/firestarter

mkdir -p $RPM_BUILD_ROOT/etc/pam.d
cat > $RPM_BUILD_ROOT/etc/pam.d/firestarter <<EOF
auth       sufficient   /lib/security/pam_rootok.so
auth       required     /lib/security/pam_pwdb.so
session    optional     /lib/security/pam_xauth.so
account    required     /lib/security/pam_permit.so
EOF

mkdir -p $RPM_BUILD_ROOT/etc/security/console.apps
cat > $RPM_BUILD_ROOT/etc/security/console.apps/firestarter <<EOF
USER=root
FALLBACK=true
PROGRAM=/usr/sbin/firestarter
SESSION=true
EOF

%files
%defattr(-,root,root)
%doc README ChangeLog AUTHORS TODO COPYING CREDITS
%attr(755,root,root) %{prefix}/sbin/firestarter
%{prefix}/share/gnome/apps/Internet/firestarter.desktop
%{prefix}/share/pixmaps/*
%{prefix}/share/locale/*/*/*
%{prefix}/bin/firestarter
/etc/pam.d/firestarter
/etc/security/console.apps/firestarter

%clean
rm -r $RPM_BUILD_ROOT

%changelog
* Thu Jun 01 2000 Tomas Junnonen
- Significant changes to allow use of consolehelper

* Wed May 31 2000 Tomas Junnonen
- Fixed problem with CFLAGS and LDADD usage of " and `

* Mon May 29 2000 Tomas Junnonen
- First spec file
