/*---[ druid.h ]------------------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The druid/wizard header file
 *--------------------------------------------------------------------*/

#ifndef _FIRESTARTER_DRUID
#define _FIRESTARTER_DRUID

#include <config.h>
#include <gnome.h>

typedef struct _Druid Druid;

struct _Druid
{
	GtkWidget *extdevice;
	GtkWidget *intdevice;
	GtkWidget *intrange;

	GtkWidget *auto_int_ip;

	GtkWidget *services;
	GtkWidget *icmp;
	GtkWidget *tos;
	GtkWidget *masq;
	GtkWidget *ftp, *ssh, *telnet, *smtp, *dns, *finger, *www, *sslweb,
		  *pop, *imap, *ident, *nntp, *ntp, *samba, *routed, *nfs,
		  *x, *dhcp;

	GtkWidget *icmp_echo, *icmp_traceroute, *icmp_tracert, *icmp_unreach,
			*icmp_timestamp, *icmp_masking, *icmp_redir, *icmp_quench;
			
	GtkWidget *tos_client, *tos_server, *tos_X, *tos_option_throughput,
			*tos_option_reliability, *tos_option_delay;

	GtkWidget *pppcheck;
	GtkWidget *dhcpcheck;
};

void rundruid (void);
void save_choices (Druid *data);

#endif
