/*---[ logread.c ]----------------------------------------------------
 * Copyright (C) 2000, 2001 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Functions for reading from the syslog file
 *--------------------------------------------------------------------*/

#include <config.h>
#include <gnome.h>

#include "logread.h"
#include "util.h"
#include "parse.h"

#include "xpm/statuscaught.xpm"

/* [ poll_log_timeout ]
 * Polls the logfile every 700ms for change, if change, parse lines
 */
static int
poll_log_timeout (gpointer file)
{
	gchar buf[512];
	int i, width;
	static gchar *key, *key2;
	gboolean sound = gnome_config_get_bool (
		"/firestarter/Sounds/enablesounds=TRUE");
	gchar *soundfile = gnome_config_get_string (
		"/firestarter/Sounds/hitsoundfile=");

	if (!key) {
		if (detect_netfilter ())
			key = g_strdup ("kernel: IN=");
		else {
			key = g_strdup ("DENY");
			if (!key2)
				key2 = g_strdup ("REJECT");
		}
	}

	if (fgets (buf, 512, file) != NULL) {
		if ( (strstr (buf, key) || (!detect_netfilter () && strstr (buf, key2))) && parse_hit_log (buf)) {
			set_panel_pic (statuscaught_xpm);

			if (sound) {
				gnome_sound_play (soundfile);
				g_free (soundfile);
			}
		}
	}
	return TRUE;
}


int
open_logfile (char *logpath) {
	FILE *file;

	/* Check if user has read access to the log file */
	if (fopen (logpath, "r") == NULL) {
		gchar *string;
		GtkWidget *dialog;

		string = g_strjoin (NULL, _(
			"Log file not found or access denied.\n"
			"Firewall log monitoring disabled.\n\n"
			"You can configure the path to the log file in the "
			"\"preferences\" section."), NULL);
		dialog = gnome_error_dialog (string);
		gnome_dialog_run_and_close (GNOME_DIALOG (dialog));

		g_free (string);
		return -1;
	} else {
		gchar buf[512];

		file = fopen (logpath, "r");
		/* Move to the end of the file */
		while (fgets (buf, 512, file) != NULL) continue;
		gtk_timeout_add (500, poll_log_timeout, file);

		return 1;
	}
}
