/*---[ savelog.c ]----------------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Functions for saving the contents of the hit log to a disk file
 *--------------------------------------------------------------------*/

#include "savelog.h"
#include "firestarter.h"

/* [ savelog_to_disk ]
 * Saves the log to a disk file, called from create_savelog_filesel
 */
static void
savelog_to_disk (GtkWidget *widget, gpointer data)
{
	gchar *text;
	gint i = 0;
	FILE *f;
	gchar *savefile;

	savefile = gtk_file_selection_get_filename (GTK_FILE_SELECTION (data));

	if ((f = fopen (savefile, "w")) == NULL) {
        return;
    }

	while (gtk_clist_get_text (GTK_CLIST (hitlogclist), i, 0, &text)) {
		fprintf (f, "%s\t\t", text);
		
		gtk_clist_get_text (GTK_CLIST (hitlogclist), i, 1, &text);
		fprintf (f, "%s\t\t", text);

		gtk_clist_get_text (GTK_CLIST (hitlogclist), i, 2, &text);
		fprintf (f, "%s\t\t", text);

		gtk_clist_get_text (GTK_CLIST (hitlogclist), i, 3, &text);
		fprintf (f, "%s\n", text);

		i++;
	}
	fclose (f);
}

/* [ create_savelog_filesel ]
 * Creates a file selection dialog, passed to savelog
 */
void
create_savelog_filesel (void)
{
	GtkWidget *filesel;

	filesel = gtk_file_selection_new (_("Select file to save log to"));

	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button),
			    "clicked", GTK_SIGNAL_FUNC (savelog_to_disk),
			    (gpointer) filesel);

	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button),
				   "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
				   (gpointer) filesel);

	gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->cancel_button),
				   "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
				   (gpointer) filesel);

	gtk_widget_show (filesel);
}
