/* sqlqueryform.h
 *
 * Copyright (C) 2001 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __SQL_QUERY_FORM__
#define __SQL_QUERY_FORM__

#include <gnome.h>
#include "sqlqueryexec.h"

#ifdef __cplusplus
extern "C"
{
#endif				/* __cplusplus */

#define SQL_QUERY_FORM(obj)          GTK_CHECK_CAST (obj, sql_query_form_get_type(), SqlQueryForm)
#define SQL_QUERY_FORM_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, sql_query_form_get_type (), SqlQueryFormClass)
#define IS_SQL_QUERY_FORM(obj)       GTK_CHECK_TYPE (obj, sql_query_form_get_type ())


	typedef struct _SqlQueryForm SqlQueryForm;
	typedef struct _SqlQueryFormClass SqlQueryFormClass;

	/* struct for the object's data */
	struct _SqlQueryForm
	{
		GtkVBox object;

		SqlQueryExec *qx;
		GtkWidget *table;	/* inserted into the object's vbox */
		GSList *nodes;	/* ANodes structures */
		GSList *inform;	/* ANodes structures for the ones that will appear in the
				   form (NODE_LINK ones) and that may have the "othernode"
				   field non NULL */
		gulong numrow;
		gboolean new_entry;	/* TRUE if the form is to insert new data */
		gboolean modified;	/* TRUE if some modifications have to be commited */
		gboolean outdated;	/* TRUE if too many things have changed and no 
					   commiting of the modification will be possible */
	};

	/* struct for the object's class */
	struct _SqlQueryFormClass
	{
		GtkVBoxClass parent_class;

		void (*action_refresh) (SqlQueryForm * qfm);
		void (*action_insert) (SqlQueryForm * qfm);
		void (*action_viewall) (SqlQueryForm * qfm);
		void (*action_choose) (SqlQueryForm * qfm, gulong row);
	};

	/* generic widget's functions */
	guint sql_query_form_get_type (void);

	/* numrow == 0 to insert new data, 1 to be at the first row, etc. */
	GtkWidget *sql_query_form_new (SqlQueryExec * exec, gulong numrow);
	void sql_query_form_refresh (SqlQueryForm * qfm);



#ifdef __cplusplus
}
#endif				/* __cplusplus */

#endif
