import gtk
import sys


def _set_message(dialog, primary, secondary):

    # create a HIG compliant message
    message = "<span weight=\"bold\" size=\"larger\">%(primary)s</span>\n" \
              "\n" \
              "%(secondary)s" % vars()

    # HIG says: no title
    dialog.set_title("")
    
    lbl = dialog.vbox.get_children()[0].get_children()[1]
    lbl.set_markup(message)



def error(primary, secondary):

    dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_ERROR,
                               gtk.BUTTONS_OK)
    _set_message(dialog, primary, secondary)
    dialog.run()
    sys.exit(1)



def warning(primary, secondary):

    dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_WARNING,
                               gtk.BUTTONS_OK)
    _set_message(dialog, primary, secondary)
    dialog.run()
    dialog.destroy()



def info(primary, secondary):

    dialog = gtk.MessageDialog(None, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO,
                               gtk.BUTTONS_OK)
    _set_message(dialog, primary, secondary)
    dialog.run()
    dialog.destroy()
