/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* e-hscrollbar.c
 *
 * Copyright (C) 2000  Helix Code, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Ettore Perazzoli
 */

/* This is just a version of GtkHScrollbar that returns TRUE for button_press
   and button_release events.  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gal/util/e-util.h"

#include "e-hscrollbar.h"


#define PARENT_TYPE gtk_hscrollbar_get_type ()
static GtkHScrollbarClass *parent_class = NULL;


static int
impl_button_press_event (GtkWidget *widget,
			 GdkEventButton *event)
{
	(* GTK_WIDGET_CLASS (parent_class)->button_press_event) (widget, event);

	return TRUE;
}

static int
impl_button_release_event (GtkWidget *widget,
			   GdkEventButton *event)
{
	(* GTK_WIDGET_CLASS (parent_class)->button_release_event) (widget, event);

	return TRUE;
}


static void
class_init (EHScrollbarClass *klass)
{
	GtkWidgetClass *widget_class;

	parent_class = gtk_type_class (PARENT_TYPE);

	widget_class = GTK_WIDGET_CLASS (klass);

	widget_class->button_press_event   = impl_button_press_event;
	widget_class->button_release_event = impl_button_release_event;
}

static void
init (EHScrollbar *hscrollbar)
{
}


GtkWidget *
e_hscrollbar_new (GtkAdjustment *adjustment)
{
	EHScrollbar *new;

	new = E_HSCROLLBAR (gtk_object_new (e_hscrollbar_get_type (), "adjustment", adjustment, NULL));
	
	return GTK_WIDGET (new);
}


E_MAKE_TYPE (e_hscrollbar, "EHScrollbar", EHScrollbar, class_init, init, PARENT_TYPE)
