#!/usr/bin/perl -w 

#
#  The XML UI Translation Extractor
#
#  Copyright (C) 2000 Free Software Foundation.
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  This script is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this library; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#  Authors: Kenneth Christiansen <kenneth@gnu.org>
#



use strict;
use File::Basename;
use Getopt::Long;

#---------------------------

my $VERSION     = "0.7";

#---------------------------

my $LOCAL_ARG	= "0";
my $HELP_ARG 	= "0";
my $VERSION_ARG = "0";
my $UPDATE_ARG  = "0";

#---------------------------

my $FILE;
my $OUTFILE;

#---------------------------

my %string 	=  ();
my $n		= "0";

#---------------------------

$| = 1;

GetOptions (
	    "local|l"    => \$LOCAL_ARG,
	    "help|h|?"   => \$HELP_ARG,
	    "version|v"  => \$VERSION_ARG,
	    "update"     => \$UPDATE_ARG,
	    ) or &Error;

&SplitOnArgument;


#---------------------------------------------------
# Check for options. 
# This section will check for the different options.
#---------------------------------------------------

sub SplitOnArgument {

    if ($VERSION_ARG) {
	&Version;

    } elsif ($HELP_ARG) {
	&Help;
   
    } elsif ($LOCAL_ARG) {
        &PlaceLocal;
        &Preparation;
        &WriteFile;

    } elsif ($UPDATE_ARG) {
	&PlaceNormal;
        &Preparation;
	&WriteFile;

    } elsif (@ARGV > 0) {
	&PlaceNormal;
	&Message;
	&Preparation;
	&WriteFile;

    } else {
	&Help;

    }  
}    

sub PlaceNormal {
    $FILE	 = $ARGV[0];
    $OUTFILE     = "$FILE.h";
}   

sub PlaceLocal {
    $FILE	 = $ARGV[0];
    $OUTFILE     = fileparse($FILE, ());
    if (!-e "tmp/") {
    system("mkdir tmp/");
    }
    $OUTFILE     = "./tmp/$OUTFILE.h"
}


#-------------------
sub Version{
    print "The XML UI Translations Extractor $VERSION\n";
    print "Written by Kenneth Christiansen, 2000.\n\n";
    print "Copyright (C) 2000 Free Software Foundation, Inc.\n";
    print "This is free software; see the source for copying conditions.  There is NO\n";
    print "warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n";
    exit;
}

#-------------------  
sub Help{
    print "Usage: ui-extract.pl [FILENAME] [OPTIONS] ...\n";
    print "Generates a headerfile from an xml source.\n\nGraps all strings ";
    print "between <_translatable_node> and it's end tag,\nwhere tag are all allowed ";
    print "xml tags. Read the docs for more info.\n\n"; 
    print "  -V, --version                shows the version\n";
    print "  -H, --help                   shows this help page\n";
    print "\nReport bugs to <kenneth\@gnu.org>.\n";
    exit;
}

#------------------- 
sub Error{
#   print "ui-extract: invalid option @ARGV\n";
    print "Try `ui-extract.pl --help' for more information.\n";
    exit;
}

sub Message {
    print "Generating headerfile for XML translation.\n";
}

sub Preparation {

   if (-s "$OUTFILE"){
	unlink "$OUTFILE";
   }

   &Convert ($FILE);
}

sub WriteFile {

    open OUT, ">>$OUTFILE";
    &addMessages;
    close OUT;

    print  "Wrote $OUTFILE\n";
}

#-------------------
sub Convert($) {

    #-----------------
    # Reading the file
    #-----------------
    my $input; {
	local (*IN);
	local $/; #slurp mode
	open (IN, "<$FILE") || die "can't open $FILE: $!";
	$input = <IN>;
    }
 
    if (!-s "$OUTFILE"){
    	open OUT, ">$OUTFILE";

	print OUT "/*\n";
        print OUT " * Translatable strings file generated by extract-ui.\n";
        print OUT " * Add this file to your project's POTFILES.in\n";
        print OUT " * DO NOT compile it as part of your application.\n";
        print OUT " */\n\n"; 
			
        }   
       	close OUT;

	### For generic translatable XML files ###
 
        if ($FILE =~ /xml$/sg){
        while ($input =~ /[\t\n\s]_[a-zA-Z0-9_]+=\"([^\"]+)\"/sg) {
	   	$string{$1} = [];
        }

	while ($input =~ /<_[a-zA-Z0-9_]+>(..[^_]*)<\/_[a-zA-Z0-9_]+>/sg) {
		$string{$1} = [];
 	}}

        ### For translatable Glade XML files ###

        if ($FILE =~ /glade$/sg){
        my $translate = "label|title|text|format|copyright|comments|preview_text|tooltip";

        while ($input =~ /<($translate)>(..[^<]*)<\/($translate)>/sg) {
                $string{$2} = [];
        }}
    }

sub addMessages{

    foreach my $theMessage (sort keys %string) {
	my ($lineNo,$fileName) = @{ $string{$theMessage} };

    if ($theMessage =~ /\n/) {
	print OUT "gchar *s = N_("; 

	$n = 1;
        for (split /\n/, $theMessage) {
	    $_ =~ s/^\s+//mg;
	    if ($n > 1) { print OUT "              ";}
            $n++;
	    print OUT "\"$_\");\n";
	}

	} else {
		
	    print OUT "gchar *s = N_(\"$theMessage\");\n";

	}
	    
    }
}

