# use Sweden for default mirror
MASTER_SITES += http://ftp.gnome.org/pub/GNOME/sources/$(GARNAME)/$(shell echo $(GARVERSION) | $(SED) -e 's,-.*,,' | $(AWK) -F. '{ print $$1 "." $$2 }')/

# sourceforge.net mirror, random by default
SOURCEFORGE_NET = dl.sourceforge.net

# No static libs or docs
CONFIGURE_ARGS += --disable-static --disable-maintainer-mode --with-html-dir=$(sharedstatedir)/gtk-doc/html --disable-gtk-doc

# For Stable GARNOME, things are assumed to work
#CONFIGURE_ARGS += --disable-debug --disable-tests

# For Unstable GARNOME, things are assumed to be heavily broken
CONFIGURE_ARGS += --enable-debug --enable-tests
CFLAGS += -g
CXXFLAGS += -g


# Superuser sanity check.  Prevent users from building as root, unless they
# *really* mean to.  In that case, they will be able to remove this and the
# identical check in category.mk anyway.
UID ?= $(shell id -u )

ifeq (${UID}, 0)
  # Confront the user with an unambiguos, eye-catching error message,
  # telling him to go read about the very basics.
  define DO_NOT_BUID_AS_ROOT
    ****************************************

    ***  GARNOME should *NOT* be built as root!
    ***  Please read the README, carefully.

    Cowardly refusing to run with superuser privileges
  endef

  $(error ${DO_NOT_BUID_AS_ROOT})
endif

