/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/*
 * Copyright (C) 2004 Fernando Herrera <fherrera@onirica.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gconf-search.h"
#include "gconf-search-dialog.h"
#include "gconf-editor-window.h"
#include "gconf-tree-model.h"
#include "gconf-list-model.h"

typedef struct _Node Node;

struct _Node {
	gint ref_count;
	gint offset;
	gchar *path;

	Node *parent;
	Node *children;
	Node *next;
	Node *prev;
};	

static
gboolean
gconf_tree_model_search_iter_foreach (GtkTreeModel *model, GtkTreePath *path,
				      GtkTreeIter *iter, gpointer data)
{
	GConfListModel *list_model;
	Node    *node;
	SearchIter *st;
	SearchPos *search_pos;
	gchar *key;
	int nchildren, i;
	GtkTreeIter list_iter;
	gchar *found;

	search_pos = g_new0 (SearchPos, 1);

	st = (SearchIter *) data;

	list_model = st->list_model;

	node = iter->user_data;
	found = g_strrstr ((char*) node->path, (char*) st->pattern);

	if (found != NULL) {
		/* We found the pattern in the tree */
		search_pos->tree_iter = gtk_tree_iter_copy (iter);
		search_pos->list_pos = 0;
		st->list = g_slist_append (st->list, search_pos);
		return FALSE;
	}

	if (!st->search_keys && !st->search_values) {
		return FALSE;
	}

	gconf_list_model_set_root_path (GCONF_LIST_MODEL (list_model), (char*) node->path);
	nchildren = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (list_model), NULL);
	for (i = 0; i < nchildren; i++) {
		gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (list_model),
					       &list_iter, NULL, i);
		/* Search in the key names */
		if (st->search_keys) {
			gtk_tree_model_get (GTK_TREE_MODEL (list_model), &list_iter,
					    GCONF_LIST_MODEL_KEY_PATH_COLUMN, &key,
					    -1);
			found = g_strrstr (key, (char*) st->pattern);
			if (found != NULL) {
				/* We found the pattern in the final key name */
				search_pos->tree_iter = gtk_tree_iter_copy (iter);
				search_pos->list_pos = 0;
				st->list = g_slist_append (st->list, search_pos);
				g_free (key);
				return FALSE;
			}

			g_free (key);
		}

		/* Search in the values */
		if (st->search_values) {
			GConfValue *gconf_value;
			GValue value = {0};
			const gchar *gconf_string;

			gtk_tree_model_get_value (GTK_TREE_MODEL (list_model), &list_iter,
						  GCONF_LIST_MODEL_VALUE_COLUMN, &value);
                	gconf_value = g_value_get_boxed (&value);

			/* FIXME: We are only looking into strings... should we do in
			 * int's? */
			if (gconf_value != NULL && gconf_value->type == GCONF_VALUE_STRING)
				gconf_string = gconf_value_get_string (gconf_value);
			else {
				g_value_unset(&value);
				continue;
			}

                	found = g_strrstr (gconf_string, (char*) st->pattern);
			if (found != NULL) {
				/* We found the pattern in the key value */
				search_pos->tree_iter = gtk_tree_iter_copy (iter);
				search_pos->list_pos = 0;
				st->list = g_slist_append (st->list, search_pos);
				return FALSE;
			}
		}
	}

	return FALSE;
}

GSList *
gconf_tree_model_build_match_list (GConfTreeModel *tree_model, GConfListModel *list_model,
				   const char *pattern, gboolean search_keys, gboolean search_values)
{
	GtkTreeIter iter_root;
	SearchIter st;

	st.pattern = pattern;
	st.search_keys = search_keys;
	st.search_values = search_values;
	st.list_model = list_model;
	st.list = NULL;

	if (!gtk_tree_model_get_iter_root (GTK_TREE_MODEL (tree_model), &iter_root)) {

		/* Ugh, something is terribly wrong */
		return NULL;
	}

	gtk_tree_model_foreach (GTK_TREE_MODEL (tree_model),
				gconf_tree_model_search_iter_foreach, &st);

	/* TODO: sort the list!
	 * st.list = g_slist_sort (st.list, cmpiter);
	 */
	return st.list;

}

