/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2007 William Jon McCann <mccann@jhu.edu>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GDM_SETTINGS_KEYS_H
#define _GDM_SETTINGS_KEYS_H

#include <glib.h>

G_BEGIN_DECLS

/* List delimiter for config file lists */
#define GDM_DELIMITER_MODULES ":"
#define GDM_DELIMITER_THEMES "/:"

#define GDM_KEY_CHOOSER "daemon/Chooser"
#define GDM_KEY_AUTOMATIC_LOGIN_ENABLE "daemon/AutomaticLoginEnable"
#define GDM_KEY_AUTOMATIC_LOGIN "daemon/AutomaticLogin"
#define GDM_KEY_GREETER "daemon/Greeter"
#define GDM_KEY_REMOTE_GREETER "daemon/RemoteGreeter"
#define GDM_KEY_ADD_GTK_MODULES "daemon/AddGtkModules"
#define GDM_KEY_GTK_MODULES_LIST "daemon/GtkModulesList"
#define GDM_KEY_GROUP "daemon/Group"
#define GDM_KEY_HALT "daemon/HaltCommand"
#define GDM_KEY_DISPLAY_INIT_DIR "daemon/DisplayInitDir"
#define GDM_KEY_KILL_INIT_CLIENTS "daemon/KillInitClients"
#define GDM_KEY_LOG_DIR "daemon/LogDir"
#define GDM_KEY_PATH "daemon/DefaultPath"
#define GDM_KEY_PID_FILE "daemon/PidFile"
#define GDM_KEY_POSTSESSION "daemon/PostSessionScriptDir"
#define GDM_KEY_PRESESSION "daemon/PreSessionScriptDir"
#define GDM_KEY_POSTLOGIN "daemon/PostLoginScriptDir"
#define GDM_KEY_FAILSAFE_XSERVER "daemon/FailsafeXServer"
#define GDM_KEY_X_KEEPS_CRASHING "daemon/XKeepsCrashing"
#define GDM_KEY_REBOOT  "daemon/RebootCommand"
#define GDM_KEY_CUSTOM_CMD_TEMPLATE "customcommand/CustomCommand"
#define GDM_KEY_CUSTOM_CMD_LABEL_TEMPLATE "customcommand/CustomCommandLabel"
#define GDM_KEY_CUSTOM_CMD_LR_LABEL_TEMPLATE "customcommand/CustomCommandLRLabel"
#define GDM_KEY_CUSTOM_CMD_TEXT_TEMPLATE "customcommand/CustomCommandText"
#define GDM_KEY_CUSTOM_CMD_TOOLTIP_TEMPLATE "customcommand/CustomCommandTooltip"
#define GDM_KEY_CUSTOM_CMD_NO_RESTART_TEMPLATE "customcommand/CustomCommandNoRestart"
#define GDM_KEY_CUSTOM_CMD_IS_PERSISTENT_TEMPLATE "customcommand/CustomCommandIsPersistent"
#define GDM_KEY_ROOT_PATH "daemon/RootPath"
#define GDM_KEY_SERV_AUTHDIR "daemon/ServAuthDir"
#define GDM_KEY_SESSION_DESKTOP_DIR "daemon/SessionDesktopDir"
#define GDM_KEY_BASE_XSESSION "daemon/BaseXsession"
#define GDM_KEY_DEFAULT_SESSION "daemon/DefaultSession"
#define GDM_KEY_SUSPEND "daemon/SuspendCommand"
#define GDM_KEY_USER_AUTHDIR "daemon/UserAuthDir"
#define GDM_KEY_USER_AUTHDIR_FALLBACK "daemon/UserAuthFBDir"
#define GDM_KEY_USER_AUTHFILE "daemon/UserAuthFile"
#define GDM_KEY_USER "daemon/User"
#define GDM_KEY_CONSOLE_NOTIFY "daemon/ConsoleNotify"
#define GDM_KEY_DOUBLE_LOGIN_WARNING "daemon/DoubleLoginWarning"
#define GDM_KEY_ALWAYS_LOGIN_CURRENT_SESSION "daemon/AlwaysLoginCurrentSession"
#define GDM_KEY_DISPLAY_LAST_LOGIN "daemon/DisplayLastLogin"
#define GDM_KEY_TIMED_LOGIN_ENABLE "daemon/TimedLoginEnable"
#define GDM_KEY_TIMED_LOGIN "daemon/TimedLogin"
#define GDM_KEY_TIMED_LOGIN_DELAY "daemon/TimedLoginDelay"
#define GDM_KEY_FLEXI_REAP_DELAY_MINUTES "daemon/FlexiReapDelayMinutes"
#define GDM_KEY_STANDARD_XSERVER "daemon/StandardXServer"
#define GDM_KEY_FLEXIBLE_XSERVERS "daemon/FlexibleXServers"
#define GDM_KEY_DYNAMIC_XSERVERS "daemon/DynamicXServers"
#define GDM_KEY_XNEST "daemon/Xnest"
#define GDM_KEY_XNEST_UNSCALED_FONT_PATH "daemon/XnestUnscaledFontPath"
#define GDM_KEY_FIRST_VT "daemon/FirstVT"
#define GDM_KEY_VT_ALLOCATION "daemon/VTAllocation"
#define GDM_KEY_CONSOLE_CANNOT_HANDLE "daemon/ConsoleCannotHandle"
#define GDM_KEY_XSERVER_TIMEOUT "daemon/GdmXserverTimeout"
#define GDM_KEY_SYSTEM_COMMANDS_IN_MENU "daemon/SystemCommandsInMenu"
#define GDM_KEY_ALLOW_LOGOUT_ACTIONS "daemon/AllowLogoutActions"
#define GDM_KEY_RBAC_SYSTEM_COMMAND_KEYS "daemon/RBACSystemCommandKeys"

#define GDM_KEY_ALLOW_ROOT "security/AllowRoot"
#define GDM_KEY_ALLOW_REMOTE_ROOT "security/AllowRemoteRoot"
#define GDM_KEY_ALLOW_REMOTE_AUTOLOGIN "security/AllowRemoteAutoLogin"
#define GDM_KEY_USER_MAX_FILE "security/UserMaxFile"
#define GDM_KEY_RELAX_PERM "security/RelaxPermissions"
#define GDM_KEY_CHECK_DIR_OWNER "security/CheckDirOwner"
#define GDM_KEY_SUPPORT_AUTOMOUNT "security/SupportAutomount"
#define GDM_KEY_RETRY_DELAY "security/RetryDelay"
#define GDM_KEY_DISALLOW_TCP "security/DisallowTCP"
#define GDM_KEY_PAM_STACK "security/PamStack"
#define GDM_KEY_NEVER_PLACE_COOKIES_ON_NFS "security/NeverPlaceCookiesOnNFS"
#define GDM_KEY_PASSWORD_REQUIRED "security/PasswordRequired"
#define GDM_KEY_XDMCP "xdmcp/Enable"
#define GDM_KEY_MAX_PENDING "xdmcp/MaxPending"
#define GDM_KEY_MAX_SESSIONS "xdmcp/MaxSessions"
#define GDM_KEY_MAX_WAIT "xdmcp/MaxWait"
#define GDM_KEY_DISPLAYS_PER_HOST "xdmcp/DisplaysPerHost"
#define GDM_KEY_UDP_PORT "xdmcp/Port"
#define GDM_KEY_INDIRECT "xdmcp/HonorIndirect"
#define GDM_KEY_MAX_INDIRECT "xdmcp/MaxPendingIndirect"
#define GDM_KEY_MAX_WAIT_INDIRECT "xdmcp/MaxWaitIndirect"
#define GDM_KEY_PING_INTERVAL "xdmcp/PingIntervalSeconds"
#define GDM_KEY_WILLING "xdmcp/Willing"
#define GDM_KEY_XDMCP_PROXY "xdmcp/EnableProxy"
#define GDM_KEY_XDMCP_PROXY_XSERVER "xdmcp/ProxyXServer"
#define GDM_KEY_XDMCP_PROXY_RECONNECT "xdmcp/ProxyReconnect"
#define GDM_KEY_GTK_THEME "gui/GtkTheme"
#define GDM_KEY_GTKRC "gui/GtkRC"
#define GDM_KEY_MAX_ICON_WIDTH "gui/MaxIconWidth"
#define GDM_KEY_MAX_ICON_HEIGHT "gui/MaxIconHeight"
#define GDM_KEY_ALLOW_GTK_THEME_CHANGE "gui/AllowGtkThemeChange"
#define GDM_KEY_GTK_THEMES_TO_ALLOW "gui/GtkThemesToAllow"
#define GDM_KEY_BROWSER "greeter/Browser"
#define GDM_KEY_INCLUDE "greeter/Include"
#define GDM_KEY_EXCLUDE "greeter/Exclude"
#define GDM_KEY_INCLUDE_ALL "greeter/IncludeAll"
#define GDM_KEY_MINIMAL_UID "greeter/MinimalUID"
#define GDM_KEY_DEFAULT_FACE "greeter/DefaultFace"
#define GDM_KEY_GLOBAL_FACE_DIR "greeter/GlobalFaceDir"
#define GDM_KEY_LOCALE_FILE "greeter/LocaleFile"
#define GDM_KEY_LOGO "greeter/Logo"
#define GDM_KEY_CHOOSER_BUTTON_LOGO "greeter/ChooserButtonLogo"
#define GDM_KEY_QUIVER "greeter/Quiver"
#define GDM_KEY_SYSTEM_MENU "greeter/SystemMenu"
#define GDM_KEY_CONFIGURATOR "daemon/Configurator"
#define GDM_KEY_CONFIG_AVAILABLE "greeter/ConfigAvailable"
#define GDM_KEY_CHOOSER_BUTTON "greeter/ChooserButton"
#define GDM_KEY_TITLE_BAR "greeter/TitleBar"
#define GDM_KEY_DEFAULT_WELCOME "greeter/DefaultWelcome"
#define GDM_KEY_DEFAULT_REMOTE_WELCOME "greeter/DefaultRemoteWelcome"
#define GDM_KEY_WELCOME "greeter/Welcome"
#define GDM_KEY_REMOTE_WELCOME "greeter/RemoteWelcome"
#define GDM_KEY_XINERAMA_SCREEN "greeter/XineramaScreen"
#define GDM_KEY_BACKGROUND_PROGRAM "greeter/BackgroundProgram"
#define GDM_KEY_RUN_BACKGROUND_PROGRAM_ALWAYS "greeter/RunBackgroundProgramAlways"
#define GDM_KEY_BACKGROUND_PROGRAM_INITIAL_DELAY "greeter/BackgroundProgramInitialDelay"
#define GDM_KEY_RESTART_BACKGROUND_PROGRAM "greeter/RestartBackgroundProgram"
#define GDM_KEY_BACKGROUND_PROGRAM_RESTART_DELAY "greeter/BackgroundProgramRestartDelay"
#define GDM_KEY_BACKGROUND_IMAGE "greeter/BackgroundImage"
#define GDM_KEY_BACKGROUND_COLOR "greeter/BackgroundColor"
#define GDM_KEY_BACKGROUND_TYPE "greeter/BackgroundType"
#define GDM_KEY_BACKGROUND_SCALE_TO_FIT "greeter/BackgroundScaleToFit"
#define GDM_KEY_BACKGROUND_REMOTE_ONLY_COLOR "greeter/BackgroundRemoteOnlyColor"
#define GDM_KEY_LOCK_POSITION "greeter/LockPosition"
#define GDM_KEY_SET_POSITION "greeter/SetPosition"
#define GDM_KEY_POSITION_X "greeter/PositionX"
#define GDM_KEY_POSITION_Y "greeter/PositionY"
#define GDM_KEY_USE_24_CLOCK "greeter/Use24Clock"
#define GDM_KEY_ENTRY_CIRCLES "greeter/UseCirclesInEntry"
#define GDM_KEY_ENTRY_INVISIBLE "greeter/UseInvisibleInEntry"
#define GDM_KEY_GRAPHICAL_THEME "greeter/GraphicalTheme"
#define GDM_KEY_GRAPHICAL_THEMES "greeter/GraphicalThemes"
#define GDM_KEY_GRAPHICAL_THEME_RAND "greeter/GraphicalThemeRand"
#define GDM_KEY_GRAPHICAL_THEME_DIR "greeter/GraphicalThemeDir"
#define GDM_KEY_GRAPHICAL_THEMED_COLOR "greeter/GraphicalThemedColor"
#define GDM_KEY_INFO_MSG_FILE "greeter/InfoMsgFile"
#define GDM_KEY_INFO_MSG_FONT "greeter/InfoMsgFont"
#define GDM_KEY_PRE_FETCH_PROGRAM "greeter/PreFetchProgram"
#define GDM_KEY_SOUND_ON_LOGIN "greeter/SoundOnLogin"
#define GDM_KEY_SOUND_ON_LOGIN_SUCCESS "greeter/SoundOnLoginSuccess"
#define GDM_KEY_SOUND_ON_LOGIN_FAILURE "greeter/SoundOnLoginFailure"
#define GDM_KEY_SOUND_ON_LOGIN_FILE "greeter/SoundOnLoginFile"
#define GDM_KEY_SOUND_ON_LOGIN_SUCCESS_FILE "greeter/SoundOnLoginSuccessFile"
#define GDM_KEY_SOUND_ON_LOGIN_FAILURE_FILE "greeter/SoundOnLoginFailureFile"
#define GDM_KEY_SOUND_PROGRAM "daemon/SoundProgram"
#define GDM_KEY_SCAN_TIME "chooser/ScanTime"
#define GDM_KEY_DEFAULT_HOST_IMG "chooser/DefaultHostImg"
#define GDM_KEY_HOST_IMAGE_DIR "chooser/HostImageDir"
#define GDM_KEY_HOSTS "chooser/Hosts"
#define GDM_KEY_MULTICAST "chooser/Multicast"
#define GDM_KEY_MULTICAST_ADDR "chooser/MulticastAddr"
#define GDM_KEY_BROADCAST "chooser/Broadcast"
#define GDM_KEY_ALLOW_ADD "chooser/AllowAdd"
#define GDM_KEY_DEBUG "debug/Enable"
#define GDM_KEY_DEBUG_GESTURES "debug/Gestures"
#define GDM_KEY_SHOW_GNOME_FAILSAFE "greeter/ShowGnomeFailsafeSession"
#define GDM_KEY_SHOW_XTERM_FAILSAFE "greeter/ShowXtermFailsafeSession"
#define GDM_KEY_SHOW_LAST_SESSION "greeter/ShowLastSession"

#define GDM_KEY_SERVER_PREFIX "server-"
#define GDM_KEY_SERVER_NAME "name"
#define GDM_KEY_SERVER_COMMAND "command"
#define GDM_KEY_SERVER_FLEXIBLE "flexible"
#define GDM_KEY_SERVER_CHOOSABLE "choosable"
#define GDM_KEY_SERVER_HANDLED "handled"
#define GDM_KEY_SERVER_CHOOSER "chooser"
#define GDM_KEY_SERVER_PRIORITY "priority"

G_END_DECLS

#endif /* _GDM_SETTINGS_KEYS_H */
