/* gcp-diagnostic-colors.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-diagnostic-colors.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define GCP_TYPE_DIAGNOSTIC_COLORS (gcp_diagnostic_colors_get_type ())
#define GCP_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColors))
#define GCP_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColorsClass))
#define GCP_IS_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_COLORS))
#define GCP_IS_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_COLORS))
#define GCP_DIAGNOSTIC_COLORS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColorsClass))

typedef struct _GcpDiagnosticColors GcpDiagnosticColors;
typedef struct _GcpDiagnosticColorsClass GcpDiagnosticColorsClass;
typedef struct _GcpDiagnosticColorsPrivate GcpDiagnosticColorsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GCP_DIAGNOSTIC_TYPE_SEVERITY (gcp_diagnostic_severity_get_type ())
typedef struct _GcpParamSpecDiagnosticColors GcpParamSpecDiagnosticColors;

struct _GcpDiagnosticColors {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GcpDiagnosticColorsPrivate * priv;
};

struct _GcpDiagnosticColorsClass {
	GTypeClass parent_class;
	void (*finalize) (GcpDiagnosticColors *self);
};

struct _GcpDiagnosticColorsPrivate {
	GdkRGBA d_errorColor;
	GdkRGBA d_warningColor;
	GdkRGBA d_infoColor;
};

typedef enum  {
	GCP_DIAGNOSTIC_SEVERITY_NONE,
	GCP_DIAGNOSTIC_SEVERITY_INFO,
	GCP_DIAGNOSTIC_SEVERITY_WARNING,
	GCP_DIAGNOSTIC_SEVERITY_ERROR,
	GCP_DIAGNOSTIC_SEVERITY_FATAL,
	GCP_DIAGNOSTIC_SEVERITY_NUM
} GcpDiagnosticSeverity;

struct _GcpParamSpecDiagnosticColors {
	GParamSpec parent_instance;
};


static gpointer gcp_diagnostic_colors_parent_class = NULL;
static GType gcp_diagnostic_colors_type_id = 0;

gpointer gcp_diagnostic_colors_ref (gpointer instance);
void gcp_diagnostic_colors_unref (gpointer instance);
GParamSpec* gcp_param_spec_diagnostic_colors (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_diagnostic_colors (GValue* value, gpointer v_object);
void gcp_value_take_diagnostic_colors (GValue* value, gpointer v_object);
gpointer gcp_value_get_diagnostic_colors (const GValue* value);
GType gcp_diagnostic_colors_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_colors_register_type (GTypeModule * module);
#define GCP_DIAGNOSTIC_COLORS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColorsPrivate))
enum  {
	GCP_DIAGNOSTIC_COLORS_DUMMY_PROPERTY
};
GcpDiagnosticColors* gcp_diagnostic_colors_new (GtkStyleContext* context);
GcpDiagnosticColors* gcp_diagnostic_colors_construct (GType object_type, GtkStyleContext* context);
static void gcp_diagnostic_colors_update_color (GcpDiagnosticColors* self, GtkStyleContext* context, const gchar* color_name, GdkRGBA* defcol, gdouble alpha, GdkRGBA* result);
static void gcp_diagnostic_colors_mix_colors (GcpDiagnosticColors* self, GdkRGBA* source, GdkRGBA* dest, GdkRGBA* result);
void gcp_diagnostic_colors_mix_in_widget (GcpDiagnosticColors* self, GtkWidget* widget);
void gcp_diagnostic_colors_mix_in_color (GcpDiagnosticColors* self, GtkWidget* widget, GdkRGBA* dest);
GType gcp_diagnostic_severity_get_type (void) G_GNUC_CONST;
GdkRGBA* gcp_diagnostic_colors_get (GcpDiagnosticColors* self, GcpDiagnosticSeverity severity);
static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self);
void gcp_diagnostic_colors_get_error_color (GcpDiagnosticColors* self, GdkRGBA* result);
void gcp_diagnostic_colors_get_warning_color (GcpDiagnosticColors* self, GdkRGBA* result);
void gcp_diagnostic_colors_get_info_color (GcpDiagnosticColors* self, GdkRGBA* result);
static void gcp_diagnostic_colors_finalize (GcpDiagnosticColors* obj);


GcpDiagnosticColors* gcp_diagnostic_colors_construct (GType object_type, GtkStyleContext* context) {
	GcpDiagnosticColors* self = NULL;
	GdkRGBA _tmp0_ = {0};
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_ = {0};
	GdkRGBA _tmp5_ = {0};
	GdkRGBA _tmp6_ = {0};
	GdkRGBA _tmp7_ = {0};
	GdkRGBA _tmp8_ = {0};
	g_return_val_if_fail (context != NULL, NULL);
	self = (GcpDiagnosticColors*) g_type_create_instance (object_type);
	_tmp0_.red = (gdouble) 1;
	_tmp0_.green = (gdouble) 0;
	_tmp0_.blue = (gdouble) 0;
	_tmp0_.alpha = (gdouble) 1;
	gcp_diagnostic_colors_update_color (self, context, "error_bg_color", &_tmp0_, 0.5, &_tmp1_);
	_tmp2_ = _tmp1_;
	self->priv->d_errorColor = _tmp2_;
	_tmp3_.red = (gdouble) 1;
	_tmp3_.green = 0.5;
	_tmp3_.blue = (gdouble) 0;
	_tmp3_.alpha = (gdouble) 1;
	gcp_diagnostic_colors_update_color (self, context, "warning_bg_color", &_tmp3_, 0.5, &_tmp4_);
	_tmp5_ = _tmp4_;
	self->priv->d_warningColor = _tmp5_;
	_tmp6_.red = (gdouble) 0;
	_tmp6_.green = (gdouble) 0;
	_tmp6_.blue = (gdouble) 1;
	_tmp6_.alpha = (gdouble) 1;
	gcp_diagnostic_colors_update_color (self, context, "info_bg_color", &_tmp6_, 0.5, &_tmp7_);
	_tmp8_ = _tmp7_;
	self->priv->d_infoColor = _tmp8_;
	return self;
}


GcpDiagnosticColors* gcp_diagnostic_colors_new (GtkStyleContext* context) {
	return gcp_diagnostic_colors_construct (GCP_TYPE_DIAGNOSTIC_COLORS, context);
}


static void gcp_diagnostic_colors_mix_colors (GcpDiagnosticColors* self, GdkRGBA* source, GdkRGBA* dest, GdkRGBA* result) {
	GdkRGBA _tmp0_ = {0};
	GdkRGBA mixed;
	g_return_if_fail (self != NULL);
	_tmp0_.red = (gdouble) 0;
	_tmp0_.green = (gdouble) 0;
	_tmp0_.blue = (gdouble) 0;
	_tmp0_.alpha = (gdouble) 0;
	mixed = _tmp0_;
	mixed.alpha = (*source).alpha + ((*dest).alpha * (1 - (*source).alpha));
	mixed.red = (((*source).red * (*source).alpha) + (((*dest).red * (*dest).alpha) * (1 - (*source).alpha))) / mixed.alpha;
	mixed.green = (((*source).green * (*source).alpha) + (((*dest).green * (*dest).alpha) * (1 - (*source).alpha))) / mixed.alpha;
	mixed.blue = (((*source).blue * (*source).alpha) + (((*dest).blue * (*dest).alpha) * (1 - (*source).alpha))) / mixed.alpha;
	*result = mixed;
	return;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void gcp_diagnostic_colors_mix_in_widget (GcpDiagnosticColors* self, GtkWidget* widget) {
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* ctx;
	GdkRGBA dest = {0};
	GtkStateFlags _tmp2_;
	GdkRGBA _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_widget_get_style_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	ctx = _tmp1_;
	gtk_style_context_save (ctx);
	gtk_style_context_add_class (ctx, GTK_STYLE_CLASS_VIEW);
	_tmp2_ = gtk_widget_get_state_flags (widget);
	gtk_style_context_get_background_color (ctx, _tmp2_, &_tmp3_);
	dest = _tmp3_;
	gcp_diagnostic_colors_mix_in_color (self, widget, &dest);
	gtk_style_context_restore (ctx);
	_g_object_unref0 (ctx);
}


void gcp_diagnostic_colors_mix_in_color (GcpDiagnosticColors* self, GtkWidget* widget, GdkRGBA* dest) {
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* ctx;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_ = {0};
	GdkRGBA _tmp5_ = {0};
	GdkRGBA _tmp6_ = {0};
	GdkRGBA _tmp7_ = {0};
	GdkRGBA _tmp8_ = {0};
	GdkRGBA _tmp9_ = {0};
	GdkRGBA _tmp10_ = {0};
	GdkRGBA _tmp11_ = {0};
	GdkRGBA _tmp12_ = {0};
	GdkRGBA _tmp13_ = {0};
	GdkRGBA _tmp14_ = {0};
	GdkRGBA _tmp15_ = {0};
	GdkRGBA _tmp16_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_widget_get_style_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	ctx = _tmp1_;
	gtk_style_context_save (ctx);
	gtk_style_context_add_class (ctx, GTK_STYLE_CLASS_VIEW);
	_tmp2_.red = (gdouble) 1;
	_tmp2_.green = (gdouble) 0;
	_tmp2_.blue = (gdouble) 0;
	_tmp2_.alpha = (gdouble) 1;
	gcp_diagnostic_colors_update_color (self, ctx, "error_bg_color", &_tmp2_, 0.5, &_tmp3_);
	_tmp4_ = _tmp3_;
	gcp_diagnostic_colors_mix_colors (self, &_tmp4_, dest, &_tmp5_);
	_tmp6_ = _tmp5_;
	self->priv->d_errorColor = _tmp6_;
	_tmp7_.red = (gdouble) 1;
	_tmp7_.green = 0.5;
	_tmp7_.blue = (gdouble) 0;
	_tmp7_.alpha = (gdouble) 1;
	gcp_diagnostic_colors_update_color (self, ctx, "warning_bg_color", &_tmp7_, 0.5, &_tmp8_);
	_tmp9_ = _tmp8_;
	gcp_diagnostic_colors_mix_colors (self, &_tmp9_, dest, &_tmp10_);
	_tmp11_ = _tmp10_;
	self->priv->d_warningColor = _tmp11_;
	_tmp12_.red = (gdouble) 0;
	_tmp12_.green = (gdouble) 0;
	_tmp12_.blue = (gdouble) 1;
	_tmp12_.alpha = (gdouble) 1;
	gcp_diagnostic_colors_update_color (self, ctx, "info_bg_color", &_tmp12_, 0.5, &_tmp13_);
	_tmp14_ = _tmp13_;
	gcp_diagnostic_colors_mix_colors (self, &_tmp14_, dest, &_tmp15_);
	_tmp16_ = _tmp15_;
	self->priv->d_infoColor = _tmp16_;
	gtk_style_context_restore (ctx);
	_g_object_unref0 (ctx);
}


static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self) {
	GdkRGBA* dup;
	dup = g_new0 (GdkRGBA, 1);
	memcpy (dup, self, sizeof (GdkRGBA));
	return dup;
}


static gpointer __gdk_rgba_dup0 (gpointer self) {
	return self ? _gdk_rgba_dup (self) : NULL;
}


GdkRGBA* gcp_diagnostic_colors_get (GcpDiagnosticColors* self, GcpDiagnosticSeverity severity) {
	GdkRGBA* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (severity) {
		case GCP_DIAGNOSTIC_SEVERITY_INFO:
		{
			GdkRGBA* _tmp0_;
			_tmp0_ = __gdk_rgba_dup0 (&self->priv->d_infoColor);
			result = _tmp0_;
			return result;
		}
		case GCP_DIAGNOSTIC_SEVERITY_WARNING:
		{
			GdkRGBA* _tmp1_;
			_tmp1_ = __gdk_rgba_dup0 (&self->priv->d_warningColor);
			result = _tmp1_;
			return result;
		}
		case GCP_DIAGNOSTIC_SEVERITY_ERROR:
		case GCP_DIAGNOSTIC_SEVERITY_FATAL:
		{
			GdkRGBA* _tmp2_;
			_tmp2_ = __gdk_rgba_dup0 (&self->priv->d_errorColor);
			result = _tmp2_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}


static void gcp_diagnostic_colors_update_color (GcpDiagnosticColors* self, GtkStyleContext* context, const gchar* color_name, GdkRGBA* defcol, gdouble alpha, GdkRGBA* result) {
	GdkRGBA col = {0};
	GdkRGBA _tmp0_ = {0};
	gboolean _tmp1_;
	gdouble h = 0.0;
	gdouble s = 0.0;
	gdouble v = 0.0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (color_name != NULL);
	_tmp1_ = gtk_style_context_lookup_color (context, color_name, &_tmp0_);
	col = _tmp0_;
	if (!_tmp1_) {
		col = *defcol;
	}
	gtk_rgb_to_hsv (col.red, col.green, col.blue, &_tmp2_, &_tmp3_, &_tmp4_);
	h = _tmp2_;
	s = _tmp3_;
	v = _tmp4_;
	if (s < 0.5) {
		col.red = col.red * 0.5;
		col.blue = col.blue * 0.5;
		col.green = col.green * 0.5;
	}
	col.alpha = col.alpha * alpha;
	*result = col;
	return;
}


void gcp_diagnostic_colors_get_error_color (GcpDiagnosticColors* self, GdkRGBA* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->d_errorColor;
	return;
}


void gcp_diagnostic_colors_get_warning_color (GcpDiagnosticColors* self, GdkRGBA* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->d_warningColor;
	return;
}


void gcp_diagnostic_colors_get_info_color (GcpDiagnosticColors* self, GdkRGBA* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->d_infoColor;
	return;
}


static void gcp_value_diagnostic_colors_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gcp_value_diagnostic_colors_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gcp_diagnostic_colors_unref (value->data[0].v_pointer);
	}
}


static void gcp_value_diagnostic_colors_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gcp_diagnostic_colors_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gcp_value_diagnostic_colors_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gcp_value_diagnostic_colors_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GcpDiagnosticColors* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gcp_diagnostic_colors_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gcp_value_diagnostic_colors_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GcpDiagnosticColors** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gcp_diagnostic_colors_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gcp_param_spec_diagnostic_colors (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GcpParamSpecDiagnosticColors* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GCP_TYPE_DIAGNOSTIC_COLORS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gcp_value_get_diagnostic_colors (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_TYPE_DIAGNOSTIC_COLORS), NULL);
	return value->data[0].v_pointer;
}


void gcp_value_set_diagnostic_colors (GValue* value, gpointer v_object) {
	GcpDiagnosticColors* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_TYPE_DIAGNOSTIC_COLORS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_TYPE_DIAGNOSTIC_COLORS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gcp_diagnostic_colors_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_diagnostic_colors_unref (old);
	}
}


void gcp_value_take_diagnostic_colors (GValue* value, gpointer v_object) {
	GcpDiagnosticColors* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_TYPE_DIAGNOSTIC_COLORS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_TYPE_DIAGNOSTIC_COLORS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_diagnostic_colors_unref (old);
	}
}


static void gcp_diagnostic_colors_class_init (GcpDiagnosticColorsClass * klass) {
	gcp_diagnostic_colors_parent_class = g_type_class_peek_parent (klass);
	GCP_DIAGNOSTIC_COLORS_CLASS (klass)->finalize = gcp_diagnostic_colors_finalize;
	g_type_class_add_private (klass, sizeof (GcpDiagnosticColorsPrivate));
}


static void gcp_diagnostic_colors_instance_init (GcpDiagnosticColors * self) {
	self->priv = GCP_DIAGNOSTIC_COLORS_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gcp_diagnostic_colors_finalize (GcpDiagnosticColors* obj) {
	GcpDiagnosticColors * self;
	self = GCP_DIAGNOSTIC_COLORS (obj);
}


GType gcp_diagnostic_colors_get_type (void) {
	return gcp_diagnostic_colors_type_id;
}


GType gcp_diagnostic_colors_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { gcp_value_diagnostic_colors_init, gcp_value_diagnostic_colors_free_value, gcp_value_diagnostic_colors_copy_value, gcp_value_diagnostic_colors_peek_pointer, "p", gcp_value_diagnostic_colors_collect_value, "p", gcp_value_diagnostic_colors_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GcpDiagnosticColorsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_diagnostic_colors_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpDiagnosticColors), 0, (GInstanceInitFunc) gcp_diagnostic_colors_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	gcp_diagnostic_colors_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GcpDiagnosticColors", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gcp_diagnostic_colors_type_id;
}


gpointer gcp_diagnostic_colors_ref (gpointer instance) {
	GcpDiagnosticColors* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gcp_diagnostic_colors_unref (gpointer instance) {
	GcpDiagnosticColors* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GCP_DIAGNOSTIC_COLORS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



