/* gcp-diagnostic-message.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-diagnostic-message.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define GCP_TYPE_DIAGNOSTIC_MESSAGE (gcp_diagnostic_message_get_type ())
#define GCP_DIAGNOSTIC_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_MESSAGE, GcpDiagnosticMessage))
#define GCP_DIAGNOSTIC_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_MESSAGE, GcpDiagnosticMessageClass))
#define GCP_IS_DIAGNOSTIC_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_MESSAGE))
#define GCP_IS_DIAGNOSTIC_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_MESSAGE))
#define GCP_DIAGNOSTIC_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_MESSAGE, GcpDiagnosticMessageClass))

typedef struct _GcpDiagnosticMessage GcpDiagnosticMessage;
typedef struct _GcpDiagnosticMessageClass GcpDiagnosticMessageClass;
typedef struct _GcpDiagnosticMessagePrivate GcpDiagnosticMessagePrivate;

#define GCP_TYPE_DIAGNOSTIC (gcp_diagnostic_get_type ())
#define GCP_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnostic))
#define GCP_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))
#define GCP_IS_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC))
#define GCP_IS_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC))
#define GCP_DIAGNOSTIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC, GcpDiagnosticClass))

typedef struct _GcpDiagnostic GcpDiagnostic;
typedef struct _GcpDiagnosticClass GcpDiagnosticClass;

#define GCP_TYPE_DIAGNOSTIC_COLORS (gcp_diagnostic_colors_get_type ())
#define GCP_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColors))
#define GCP_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColorsClass))
#define GCP_IS_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DIAGNOSTIC_COLORS))
#define GCP_IS_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DIAGNOSTIC_COLORS))
#define GCP_DIAGNOSTIC_COLORS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DIAGNOSTIC_COLORS, GcpDiagnosticColorsClass))

typedef struct _GcpDiagnosticColors GcpDiagnosticColors;
typedef struct _GcpDiagnosticColorsClass GcpDiagnosticColorsClass;

#define GCP_DIAGNOSTIC_TYPE_SEVERITY (gcp_diagnostic_severity_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gcp_diagnostic_colors_unref0(var) ((var == NULL) ? NULL : (var = (gcp_diagnostic_colors_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GCP_TYPE_EXPAND_RANGE (gcp_expand_range_get_type ())
#define GCP_EXPAND_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_EXPAND_RANGE, GcpExpandRange))
#define GCP_EXPAND_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_EXPAND_RANGE, GcpExpandRangeClass))
#define GCP_IS_EXPAND_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_EXPAND_RANGE))
#define GCP_IS_EXPAND_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_EXPAND_RANGE))
#define GCP_EXPAND_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_EXPAND_RANGE, GcpExpandRangeClass))

typedef struct _GcpExpandRange GcpExpandRange;
typedef struct _GcpExpandRangeClass GcpExpandRangeClass;

#define GCP_TYPE_SOURCE_LOCATION (gcp_source_location_get_type ())
#define GCP_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocation))
#define GCP_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))
#define GCP_IS_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_LOCATION))
#define GCP_IS_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_LOCATION))
#define GCP_SOURCE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))

typedef struct _GcpSourceLocation GcpSourceLocation;
typedef struct _GcpSourceLocationClass GcpSourceLocationClass;

#define GCP_TYPE_SOURCE_RANGE_SUPPORT (gcp_source_range_support_get_type ())
#define GCP_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupport))
#define GCP_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT))
#define GCP_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SOURCE_RANGE_SUPPORT, GcpSourceRangeSupportIface))

typedef struct _GcpSourceRangeSupport GcpSourceRangeSupport;
typedef struct _GcpSourceRangeSupportIface GcpSourceRangeSupportIface;

#define GCP_TYPE_SOURCE_RANGE (gcp_source_range_get_type ())
#define GCP_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRange))
#define GCP_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))
#define GCP_IS_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE))
#define GCP_IS_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_RANGE))
#define GCP_SOURCE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))

typedef struct _GcpSourceRange GcpSourceRange;
typedef struct _GcpSourceRangeClass GcpSourceRangeClass;
#define _gcp_expand_range_unref0(var) ((var == NULL) ? NULL : (var = (gcp_expand_range_unref (var), NULL)))

struct _GcpDiagnosticMessage {
	GtkEventBox parent_instance;
	GcpDiagnosticMessagePrivate * priv;
};

struct _GcpDiagnosticMessageClass {
	GtkEventBoxClass parent_class;
};

typedef enum  {
	GCP_DIAGNOSTIC_SEVERITY_NONE,
	GCP_DIAGNOSTIC_SEVERITY_INFO,
	GCP_DIAGNOSTIC_SEVERITY_WARNING,
	GCP_DIAGNOSTIC_SEVERITY_ERROR,
	GCP_DIAGNOSTIC_SEVERITY_FATAL,
	GCP_DIAGNOSTIC_SEVERITY_NUM
} GcpDiagnosticSeverity;

struct _GcpDiagnosticMessagePrivate {
	GcpDiagnostic** d_diagnostics;
	gint d_diagnostics_length1;
	gint _d_diagnostics_size_;
	GtkBox* d_vbox;
	GcpDiagnosticColors* d_colors;
	GtkSourceView* d_view;
	GcpDiagnosticSeverity d_rulingSeverity;
	gboolean d_inserted;
	gint d_width;
	gint d_height;
	gboolean d_updating;
};

struct _GcpSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcpSourceRange* (*get_range) (GcpSourceRangeSupport* self);
	GcpSourceRange** (*get_ranges) (GcpSourceRangeSupport* self, int* result_length1);
};


static gpointer gcp_diagnostic_message_parent_class = NULL;
static GType gcp_diagnostic_message_type_id = 0;

GType gcp_diagnostic_message_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_message_register_type (GTypeModule * module);
GType gcp_diagnostic_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_register_type (GTypeModule * module);
gpointer gcp_diagnostic_colors_ref (gpointer instance);
void gcp_diagnostic_colors_unref (gpointer instance);
GParamSpec* gcp_param_spec_diagnostic_colors (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_diagnostic_colors (GValue* value, gpointer v_object);
void gcp_value_take_diagnostic_colors (GValue* value, gpointer v_object);
gpointer gcp_value_get_diagnostic_colors (const GValue* value);
GType gcp_diagnostic_colors_get_type (void) G_GNUC_CONST;
GType gcp_diagnostic_colors_register_type (GTypeModule * module);
GType gcp_diagnostic_severity_get_type (void) G_GNUC_CONST;
#define GCP_DIAGNOSTIC_MESSAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_DIAGNOSTIC_MESSAGE, GcpDiagnosticMessagePrivate))
enum  {
	GCP_DIAGNOSTIC_MESSAGE_DUMMY_PROPERTY
};
GcpDiagnosticMessage* gcp_diagnostic_message_new (GtkSourceView* view, GcpDiagnostic** diagnostics, int diagnostics_length1);
GcpDiagnosticMessage* gcp_diagnostic_message_construct (GType object_type, GtkSourceView* view, GcpDiagnostic** diagnostics, int diagnostics_length1);
static GcpDiagnostic** _vala_array_dup5 (GcpDiagnostic** self, int length);
GcpDiagnosticColors* gcp_diagnostic_colors_new (GtkStyleContext* context);
GcpDiagnosticColors* gcp_diagnostic_colors_construct (GType object_type, GtkStyleContext* context);
static void gcp_diagnostic_message_on_view_style_updated (GcpDiagnosticMessage* self);
static void _gcp_diagnostic_message_on_view_style_updated_gtk_widget_style_updated (GtkWidget* _sender, gpointer self);
static void gcp_diagnostic_message_on_style_scheme_changed (GcpDiagnosticMessage* self);
static void _gcp_diagnostic_message_on_style_scheme_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean gcp_diagnostic_message_on_view_key_press (GcpDiagnosticMessage* self, GdkEventKey* event);
static gboolean _gcp_diagnostic_message_on_view_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void gcp_diagnostic_message_update (GcpDiagnosticMessage* self);
static void gcp_diagnostic_message_style_changed (GcpDiagnosticMessage* self);
void gcp_diagnostic_colors_mix_in_widget (GcpDiagnosticColors* self, GtkWidget* widget);
static void gcp_diagnostic_message_real_destroy (GtkWidget* base);
static void gcp_diagnostic_message_real_style_updated (GtkWidget* base);
static gboolean gcp_diagnostic_message_get_mixed_severity (GcpDiagnosticMessage* self);
GcpDiagnosticSeverity gcp_diagnostic_get_severity (GcpDiagnostic* self);
gchar* gcp_diagnostic_severity_to_string (GcpDiagnosticSeverity self);
const gchar* gcp_diagnostic_get_message (GcpDiagnostic* self);
static GcpDiagnosticSeverity gcp_diagnostic_message_get_diagnostics_ruling_severity (GcpDiagnosticMessage* self);
void gcp_diagnostic_message_reposition (GcpDiagnosticMessage* self);
gpointer gcp_expand_range_ref (gpointer instance);
void gcp_expand_range_unref (gpointer instance);
GParamSpec* gcp_param_spec_expand_range (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_expand_range (GValue* value, gpointer v_object);
void gcp_value_take_expand_range (GValue* value, gpointer v_object);
gpointer gcp_value_get_expand_range (const GValue* value);
GType gcp_expand_range_get_type (void) G_GNUC_CONST;
GType gcp_expand_range_register_type (GTypeModule * module);
GType gcp_source_location_get_type (void) G_GNUC_CONST;
GType gcp_source_location_register_type (GTypeModule * module);
static void gcp_diagnostic_message_expand_range (GcpDiagnosticMessage* self, GcpExpandRange* topx, GcpExpandRange* bottomx, GcpExpandRange* y, GcpSourceLocation* location);
gboolean gcp_source_location_buffer_coordinates (GcpSourceLocation* self, GtkTextView* view, GdkRectangle* rect);
gint gcp_expand_range_get_min (GcpExpandRange* self);
void gcp_expand_range_reset (GcpExpandRange* self);
gint gcp_expand_range_get_max (GcpExpandRange* self);
void gcp_expand_range_add (GcpExpandRange* self, gint val);
GcpExpandRange* gcp_expand_range_new (void);
GcpExpandRange* gcp_expand_range_construct (GType object_type);
GType gcp_source_range_get_type (void) G_GNUC_CONST;
GType gcp_source_range_register_type (GTypeModule * module);
GType gcp_source_range_support_get_type (void) G_GNUC_CONST;
GType gcp_source_range_support_register_type (GTypeModule * module);
GcpSourceRange** gcp_source_range_support_get_ranges (GcpSourceRangeSupport* self, int* result_length1);
GcpSourceLocation* gcp_source_range_get_start (GcpSourceRange* self);
GcpSourceLocation* gcp_source_range_get_end (GcpSourceRange* self);
GcpSourceLocation* gcp_diagnostic_get_location (GcpDiagnostic* self);
static GtkSizeRequestMode gcp_diagnostic_message_real_get_request_mode (GtkWidget* base);
static void gcp_diagnostic_message_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width);
static void gcp_diagnostic_message_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum_height, gint* natural_height);
static void gcp_diagnostic_message_add_class_for_severity (GcpDiagnosticMessage* self, GtkStyleContext* ctx);
static gboolean gcp_diagnostic_message_real_draw (GtkWidget* base, cairo_t* context);
GcpDiagnostic** gcp_diagnostic_message_get_diagnostics (GcpDiagnosticMessage* self, int* result_length1);
void gcp_diagnostic_message_set_diagnostics (GcpDiagnosticMessage* self, GcpDiagnostic** value, int value_length1);
static GcpDiagnostic** _vala_array_dup6 (GcpDiagnostic** self, int length);
static void gcp_diagnostic_message_finalize (GObject* obj);
static void _vala_gcp_diagnostic_message_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gcp_diagnostic_message_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GcpDiagnostic** _vala_array_dup5 (GcpDiagnostic** self, int length) {
	GcpDiagnostic** result;
	int i;
	result = g_new0 (GcpDiagnostic*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = _g_object_ref0 (self[i]);
	}
	return result;
}


static void _gcp_diagnostic_message_on_view_style_updated_gtk_widget_style_updated (GtkWidget* _sender, gpointer self) {
	gcp_diagnostic_message_on_view_style_updated (self);
}


static void _gcp_diagnostic_message_on_style_scheme_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	gcp_diagnostic_message_on_style_scheme_changed (self);
}


static gboolean _gcp_diagnostic_message_on_view_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = gcp_diagnostic_message_on_view_key_press (self, event);
	return result;
}


GcpDiagnosticMessage* gcp_diagnostic_message_construct (GType object_type, GtkSourceView* view, GcpDiagnostic** diagnostics, int diagnostics_length1) {
	GcpDiagnosticMessage * self = NULL;
	GcpDiagnostic** _tmp0_;
	GcpDiagnostic** _tmp1_;
	GtkStyleContext* _tmp2_ = NULL;
	GcpDiagnosticColors* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	g_return_val_if_fail (view != NULL, NULL);
	self = (GcpDiagnosticMessage*) g_object_new (object_type, NULL);
	_tmp0_ = (_tmp1_ = diagnostics, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup5 (_tmp1_, diagnostics_length1));
	self->priv->d_diagnostics = (_vala_array_free (self->priv->d_diagnostics, self->priv->d_diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_diagnostics = _tmp0_;
	self->priv->d_diagnostics_length1 = diagnostics_length1;
	self->priv->_d_diagnostics_size_ = diagnostics_length1;
	self->priv->d_view = view;
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp3_ = gcp_diagnostic_colors_new (_tmp2_);
	_gcp_diagnostic_colors_unref0 (self->priv->d_colors);
	self->priv->d_colors = _tmp3_;
	g_signal_connect_object ((GtkWidget*) self->priv->d_view, "style-updated", (GCallback) _gcp_diagnostic_message_on_view_style_updated_gtk_widget_style_updated, self, 0);
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->d_view);
	g_signal_connect_object ((GObject*) _tmp4_, "notify::style-scheme", (GCallback) _gcp_diagnostic_message_on_style_scheme_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->d_view, "key-press-event", (GCallback) _gcp_diagnostic_message_on_view_key_press_gtk_widget_key_press_event, self, 0);
	self->priv->d_inserted = FALSE;
	gcp_diagnostic_message_update (self);
	return self;
}


GcpDiagnosticMessage* gcp_diagnostic_message_new (GtkSourceView* view, GcpDiagnostic** diagnostics, int diagnostics_length1) {
	return gcp_diagnostic_message_construct (GCP_TYPE_DIAGNOSTIC_MESSAGE, view, diagnostics, diagnostics_length1);
}


static gboolean gcp_diagnostic_message_on_view_key_press (GcpDiagnosticMessage* self, GdkEventKey* event) {
	gboolean result = FALSE;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gdk_keyval_from_name ("Escape");
	if ((*event).keyval == _tmp0_) {
		gtk_widget_destroy ((GtkWidget*) self);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void gcp_diagnostic_message_on_style_scheme_changed (GcpDiagnosticMessage* self) {
	g_return_if_fail (self != NULL);
	gcp_diagnostic_message_style_changed (self);
}


static void gcp_diagnostic_message_style_changed (GcpDiagnosticMessage* self) {
	GtkStyleContext* _tmp0_ = NULL;
	GcpDiagnosticColors* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = gcp_diagnostic_colors_new (_tmp0_);
	_gcp_diagnostic_colors_unref0 (self->priv->d_colors);
	self->priv->d_colors = _tmp1_;
	if (self->priv->d_view != NULL) {
		gcp_diagnostic_colors_mix_in_widget (self->priv->d_colors, (GtkWidget*) self->priv->d_view);
	}
	gcp_diagnostic_message_update (self);
}


static void gcp_diagnostic_message_on_view_style_updated (GcpDiagnosticMessage* self) {
	g_return_if_fail (self != NULL);
	gcp_diagnostic_message_style_changed (self);
}


static void gcp_diagnostic_message_real_destroy (GtkWidget* base) {
	GcpDiagnosticMessage * self;
	self = (GcpDiagnosticMessage*) base;
	if (self->priv->d_view != NULL) {
		guint _tmp0_;
		GtkTextBuffer* _tmp1_ = NULL;
		guint _tmp2_;
		GQuark _tmp3_;
		guint _tmp4_;
		g_signal_parse_name ("style-updated", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->d_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _gcp_diagnostic_message_on_view_style_updated_gtk_widget_style_updated, self);
		_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) self->priv->d_view);
		g_signal_parse_name ("notify::style-scheme", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _gcp_diagnostic_message_on_style_scheme_changed_g_object_notify, self);
		g_signal_parse_name ("key-press-event", GTK_TYPE_WIDGET, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->d_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _gcp_diagnostic_message_on_view_key_press_gtk_widget_key_press_event, self);
	}
	GTK_WIDGET_CLASS (gcp_diagnostic_message_parent_class)->destroy ((GtkWidget*) GTK_EVENT_BOX (self));
}


static void gcp_diagnostic_message_real_style_updated (GtkWidget* base) {
	GcpDiagnosticMessage * self;
	self = (GcpDiagnosticMessage*) base;
	GTK_WIDGET_CLASS (gcp_diagnostic_message_parent_class)->style_updated ((GtkWidget*) GTK_EVENT_BOX (self));
	gcp_diagnostic_message_style_changed (self);
}


static void gcp_diagnostic_message_update (GcpDiagnosticMessage* self) {
	GtkBox* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* ctx;
	GdkRGBA color = {0};
	GdkRGBA _tmp3_ = {0};
	gboolean _tmp4_;
	gboolean ismixed;
	GcpDiagnosticSeverity _tmp16_;
	g_return_if_fail (self != NULL);
	if (self->priv->d_updating) {
		return;
	}
	if (self->priv->d_vbox != NULL) {
		gtk_widget_destroy ((GtkWidget*) self->priv->d_vbox);
		_g_object_unref0 (self->priv->d_vbox);
		self->priv->d_vbox = NULL;
	}
	if (self->priv->d_view == NULL) {
		return;
	}
	self->priv->d_updating = TRUE;
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 1);
	_g_object_unref0 (self->priv->d_vbox);
	self->priv->d_vbox = g_object_ref_sink (_tmp0_);
	gtk_widget_show ((GtkWidget*) self->priv->d_vbox);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self->priv->d_view);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ctx = _tmp2_;
	gtk_style_context_save (ctx);
	gtk_style_context_add_class (ctx, GTK_STYLE_CLASS_VIEW);
	gtk_style_context_get_color (ctx, GTK_STATE_FLAG_NORMAL, &_tmp3_);
	color = _tmp3_;
	gtk_style_context_restore (ctx);
	_tmp4_ = gcp_diagnostic_message_get_mixed_severity (self);
	ismixed = _tmp4_;
	{
		GcpDiagnostic** d_collection;
		int d_collection_length1;
		int d_it;
		d_collection = self->priv->d_diagnostics;
		d_collection_length1 = self->priv->d_diagnostics_length1;
		for (d_it = 0; d_it < self->priv->d_diagnostics_length1; d_it = d_it + 1) {
			GcpDiagnostic* _tmp5_;
			GcpDiagnostic* d;
			_tmp5_ = _g_object_ref0 (d_collection[d_it]);
			d = _tmp5_;
			{
				GtkLabel* _tmp6_ = NULL;
				GtkLabel* label;
				_tmp6_ = (GtkLabel*) gtk_label_new (NULL);
				label = g_object_ref_sink (_tmp6_);
				if (ismixed) {
					GcpDiagnosticSeverity _tmp7_;
					gchar* _tmp8_ = NULL;
					gchar* _tmp9_;
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_;
					_tmp7_ = gcp_diagnostic_get_severity (d);
					_tmp8_ = gcp_diagnostic_severity_to_string (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = gcp_diagnostic_get_message (d);
					_tmp11_ = g_markup_escape_text (_tmp10_, (gssize) (-1));
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strdup_printf ("<b>%s</b>: %s", _tmp9_, _tmp12_);
					_tmp14_ = _tmp13_;
					gtk_label_set_markup (label, _tmp14_);
					_g_free0 (_tmp14_);
					_g_free0 (_tmp12_);
					_g_free0 (_tmp9_);
				} else {
					const gchar* _tmp15_ = NULL;
					_tmp15_ = gcp_diagnostic_get_message (d);
					gtk_label_set_text (label, _tmp15_);
				}
				gtk_widget_set_margin_left ((GtkWidget*) label, 6);
				gtk_widget_set_margin_right ((GtkWidget*) label, 6);
				gtk_widget_show ((GtkWidget*) label);
				gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
				gtk_widget_set_valign ((GtkWidget*) label, GTK_ALIGN_CENTER);
				g_object_set (label, "wrap", TRUE, NULL);
				gtk_box_pack_start (self->priv->d_vbox, (GtkWidget*) label, FALSE, TRUE, (guint) 0);
				_g_object_unref0 (label);
				_g_object_unref0 (d);
			}
		}
	}
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->d_vbox);
	gtk_widget_show ((GtkWidget*) self);
	_tmp16_ = gcp_diagnostic_message_get_diagnostics_ruling_severity (self);
	self->priv->d_rulingSeverity = _tmp16_;
	gcp_diagnostic_message_reposition (self);
	self->priv->d_updating = FALSE;
	_g_object_unref0 (ctx);
}


static void gcp_diagnostic_message_expand_range (GcpDiagnosticMessage* self, GcpExpandRange* topx, GcpExpandRange* bottomx, GcpExpandRange* y, GcpSourceLocation* location) {
	GdkRectangle rect = {0};
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (topx != NULL);
	g_return_if_fail (bottomx != NULL);
	g_return_if_fail (y != NULL);
	g_return_if_fail (location != NULL);
	gcp_source_location_buffer_coordinates (location, (GtkTextView*) self->priv->d_view, &_tmp0_);
	rect = _tmp0_;
	_tmp1_ = gcp_expand_range_get_min (y);
	if (rect.y < _tmp1_) {
		gcp_expand_range_reset (bottomx);
	}
	_tmp2_ = gcp_expand_range_get_max (y);
	if ((rect.y + rect.height) > _tmp2_) {
		gcp_expand_range_reset (topx);
	}
	gcp_expand_range_add (y, rect.y);
	gcp_expand_range_add (y, rect.y + rect.height);
	_tmp3_ = gcp_expand_range_get_min (y);
	if (rect.y == _tmp3_) {
		gcp_expand_range_add (topx, rect.x);
		gcp_expand_range_add (topx, rect.x + rect.width);
	}
	_tmp4_ = gcp_expand_range_get_max (y);
	if ((rect.y + rect.height) == _tmp4_) {
		gcp_expand_range_add (bottomx, rect.x);
		gcp_expand_range_add (bottomx, rect.x + rect.width);
	}
}


static gpointer _gcp_expand_range_ref0 (gpointer self) {
	return self ? gcp_expand_range_ref (self) : NULL;
}


void gcp_diagnostic_message_reposition (GcpDiagnosticMessage* self) {
	GcpExpandRange* _tmp0_ = NULL;
	GcpExpandRange* topx;
	GcpExpandRange* _tmp1_ = NULL;
	GcpExpandRange* bottomx;
	GcpExpandRange* _tmp2_ = NULL;
	GcpExpandRange* y;
	gint ymin = 0;
	gint ymax = 0;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GdkWindow* _tmp14_ = NULL;
	GdkWindow* _tmp15_;
	GdkWindow* window;
	gint aligny = 0;
	gint alignyat = 0;
	GcpExpandRange* xrange = NULL;
	gint _tmp16_;
	gint xmin = 0;
	gint xmax = 0;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint xc = 0;
	gint width = 0;
	gint _tmp23_;
	gint minwidth = 0;
	gint _tmp25_;
	gint _tmp26_;
	gint yc;
	g_return_if_fail (self != NULL);
	_tmp0_ = gcp_expand_range_new ();
	topx = _tmp0_;
	_tmp1_ = gcp_expand_range_new ();
	bottomx = _tmp1_;
	_tmp2_ = gcp_expand_range_new ();
	y = _tmp2_;
	{
		GcpDiagnostic** d_collection;
		int d_collection_length1;
		int d_it;
		d_collection = self->priv->d_diagnostics;
		d_collection_length1 = self->priv->d_diagnostics_length1;
		for (d_it = 0; d_it < self->priv->d_diagnostics_length1; d_it = d_it + 1) {
			GcpDiagnostic* _tmp3_;
			GcpDiagnostic* d;
			_tmp3_ = _g_object_ref0 (d_collection[d_it]);
			d = _tmp3_;
			{
				GcpSourceRange** _tmp4_ = NULL;
				gint _tmp5_;
				GcpSourceLocation* _tmp9_ = NULL;
				_tmp4_ = gcp_source_range_support_get_ranges ((GcpSourceRangeSupport*) d, &_tmp5_);
				{
					GcpSourceRange** r_collection;
					int r_collection_length1;
					int r_it;
					r_collection = _tmp4_;
					r_collection_length1 = _tmp5_;
					for (r_it = 0; r_it < _tmp5_; r_it = r_it + 1) {
						GcpSourceRange* _tmp6_;
						GcpSourceRange* r;
						_tmp6_ = _g_object_ref0 (r_collection[r_it]);
						r = _tmp6_;
						{
							GcpSourceLocation* _tmp7_ = NULL;
							GcpSourceLocation* _tmp8_ = NULL;
							_tmp7_ = gcp_source_range_get_start (r);
							gcp_diagnostic_message_expand_range (self, topx, bottomx, y, _tmp7_);
							_tmp8_ = gcp_source_range_get_end (r);
							gcp_diagnostic_message_expand_range (self, topx, bottomx, y, _tmp8_);
							_g_object_unref0 (r);
						}
					}
					r_collection = (_vala_array_free (r_collection, r_collection_length1, (GDestroyNotify) g_object_unref), NULL);
				}
				_tmp9_ = gcp_diagnostic_get_location (d);
				gcp_diagnostic_message_expand_range (self, topx, bottomx, y, _tmp9_);
				_g_object_unref0 (d);
			}
		}
	}
	_tmp10_ = gcp_expand_range_get_min (y);
	gtk_text_view_buffer_to_window_coords ((GtkTextView*) self->priv->d_view, GTK_TEXT_WINDOW_TEXT, 0, _tmp10_, NULL, &_tmp11_);
	ymin = _tmp11_;
	_tmp12_ = gcp_expand_range_get_max (y);
	gtk_text_view_buffer_to_window_coords ((GtkTextView*) self->priv->d_view, GTK_TEXT_WINDOW_TEXT, 0, _tmp12_, NULL, &_tmp13_);
	ymax = _tmp13_;
	_tmp14_ = gtk_text_view_get_window ((GtkTextView*) self->priv->d_view, GTK_TEXT_WINDOW_TEXT);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	window = _tmp15_;
	_tmp16_ = gdk_window_get_height (window);
	if (ymin > (_tmp16_ - ymax)) {
		GcpExpandRange* _tmp17_;
		aligny = 1;
		alignyat = ymin - 3;
		_tmp17_ = _gcp_expand_range_ref0 (topx);
		_gcp_expand_range_unref0 (xrange);
		xrange = _tmp17_;
	} else {
		GcpExpandRange* _tmp18_;
		aligny = 0;
		alignyat = ymax + 3;
		_tmp18_ = _gcp_expand_range_ref0 (bottomx);
		_gcp_expand_range_unref0 (xrange);
		xrange = _tmp18_;
	}
	_tmp19_ = gcp_expand_range_get_min (xrange);
	gtk_text_view_buffer_to_window_coords ((GtkTextView*) self->priv->d_view, GTK_TEXT_WINDOW_TEXT, _tmp19_, 0, &_tmp20_, NULL);
	xmin = _tmp20_;
	_tmp21_ = gcp_expand_range_get_max (xrange);
	gtk_text_view_buffer_to_window_coords ((GtkTextView*) self->priv->d_view, GTK_TEXT_WINDOW_TEXT, _tmp21_, 0, &_tmp22_, NULL);
	xmax = _tmp22_;
	_tmp23_ = gdk_window_get_width (window);
	if ((_tmp23_ - xmin) > xmax) {
		gint _tmp24_;
		xc = xmin;
		_tmp24_ = gdk_window_get_width (window);
		width = _tmp24_ - xmin;
	} else {
		xc = 0;
		width = xmax;
	}
	if (!self->priv->d_inserted) {
		gtk_text_view_add_child_in_window ((GtkTextView*) self->priv->d_view, (GtkWidget*) self, GTK_TEXT_WINDOW_TEXT, 0, 0);
	}
	GTK_WIDGET_CLASS (gcp_diagnostic_message_parent_class)->get_preferred_width ((GtkWidget*) GTK_EVENT_BOX (self), NULL, &_tmp25_);
	minwidth = _tmp25_;
	if (minwidth < width) {
		width = minwidth;
	}
	GTK_WIDGET_CLASS (gcp_diagnostic_message_parent_class)->get_preferred_height_for_width ((GtkWidget*) GTK_EVENT_BOX (self), width, &_tmp26_, NULL);
	self->priv->d_height = _tmp26_;
	self->priv->d_width = width;
	yc = alignyat - (self->priv->d_height * aligny);
	gtk_text_view_move_child ((GtkTextView*) self->priv->d_view, (GtkWidget*) self, xc, yc);
	self->priv->d_inserted = TRUE;
	gtk_widget_queue_resize ((GtkWidget*) self);
	_gcp_expand_range_unref0 (xrange);
	_g_object_unref0 (window);
	_gcp_expand_range_unref0 (y);
	_gcp_expand_range_unref0 (bottomx);
	_gcp_expand_range_unref0 (topx);
}


static GtkSizeRequestMode gcp_diagnostic_message_real_get_request_mode (GtkWidget* base) {
	GcpDiagnosticMessage * self;
	GtkSizeRequestMode result = 0;
	self = (GcpDiagnosticMessage*) base;
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}


static void gcp_diagnostic_message_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width) {
	GcpDiagnosticMessage * self;
	gint _minimum_width = 0;
	gint _natural_width = 0;
	self = (GcpDiagnosticMessage*) base;
	_minimum_width = self->priv->d_width;
	_natural_width = self->priv->d_width;
	if (minimum_width) {
		*minimum_width = _minimum_width;
	}
	if (natural_width) {
		*natural_width = _natural_width;
	}
}


static void gcp_diagnostic_message_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* minimum_height, gint* natural_height) {
	GcpDiagnosticMessage * self;
	gint _minimum_height = 0;
	gint _natural_height = 0;
	self = (GcpDiagnosticMessage*) base;
	if (width == self->priv->d_width) {
		_minimum_height = self->priv->d_height;
		_natural_height = self->priv->d_height;
	} else {
		gint _tmp0_;
		gint _tmp1_;
		GTK_WIDGET_CLASS (gcp_diagnostic_message_parent_class)->get_preferred_height_for_width ((GtkWidget*) GTK_EVENT_BOX (self), width, &_tmp0_, &_tmp1_);
		_minimum_height = _tmp0_;
		_natural_height = _tmp1_;
	}
	if (minimum_height) {
		*minimum_height = _minimum_height;
	}
	if (natural_height) {
		*natural_height = _natural_height;
	}
}


static void gcp_diagnostic_message_add_class_for_severity (GcpDiagnosticMessage* self, GtkStyleContext* ctx) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	switch (self->priv->d_rulingSeverity) {
		case GCP_DIAGNOSTIC_SEVERITY_ERROR:
		case GCP_DIAGNOSTIC_SEVERITY_FATAL:
		{
			gtk_style_context_add_class (ctx, GTK_STYLE_CLASS_ERROR);
			break;
		}
		case GCP_DIAGNOSTIC_SEVERITY_WARNING:
		{
			gtk_style_context_add_class (ctx, GTK_STYLE_CLASS_WARNING);
			break;
		}
		case GCP_DIAGNOSTIC_SEVERITY_INFO:
		{
			gtk_style_context_add_class (ctx, GTK_STYLE_CLASS_INFO);
			break;
		}
		default:
		{
			break;
		}
	}
}


static gboolean gcp_diagnostic_message_real_draw (GtkWidget* base, cairo_t* context) {
	GcpDiagnosticMessage * self;
	gboolean result = FALSE;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* ctx;
	GtkStyleContext* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	self = (GcpDiagnosticMessage*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	alloc = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ctx = _tmp2_;
	gtk_style_context_save (ctx);
	gcp_diagnostic_message_add_class_for_severity (self, ctx);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_render_background (_tmp3_, context, (gdouble) 0, (gdouble) 0, (gdouble) alloc.width, (gdouble) alloc.height);
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_render_frame (_tmp4_, context, (gdouble) 0, (gdouble) 0, (gdouble) alloc.width, (gdouble) alloc.height);
	gtk_style_context_save (ctx);
	GTK_WIDGET_CLASS (gcp_diagnostic_message_parent_class)->draw ((GtkWidget*) GTK_EVENT_BOX (self), context);
	result = FALSE;
	_g_object_unref0 (ctx);
	return result;
}


static gboolean gcp_diagnostic_message_get_mixed_severity (GcpDiagnosticMessage* self) {
	gboolean result;
	gboolean first;
	GcpDiagnosticSeverity s;
	g_return_val_if_fail (self != NULL, FALSE);
	first = TRUE;
	s = GCP_DIAGNOSTIC_SEVERITY_NONE;
	{
		GcpDiagnostic** d_collection;
		int d_collection_length1;
		int d_it;
		d_collection = self->priv->d_diagnostics;
		d_collection_length1 = self->priv->d_diagnostics_length1;
		for (d_it = 0; d_it < self->priv->d_diagnostics_length1; d_it = d_it + 1) {
			GcpDiagnostic* _tmp0_;
			GcpDiagnostic* d;
			_tmp0_ = _g_object_ref0 (d_collection[d_it]);
			d = _tmp0_;
			{
				GcpDiagnosticSeverity _tmp2_;
				if (first) {
					GcpDiagnosticSeverity _tmp1_;
					first = FALSE;
					_tmp1_ = gcp_diagnostic_get_severity (d);
					s = _tmp1_;
				}
				_tmp2_ = gcp_diagnostic_get_severity (d);
				if (s != _tmp2_) {
					result = TRUE;
					_g_object_unref0 (d);
					return result;
				}
				_g_object_unref0 (d);
			}
		}
	}
	result = FALSE;
	return result;
}


GcpDiagnostic** gcp_diagnostic_message_get_diagnostics (GcpDiagnosticMessage* self, int* result_length1) {
	GcpDiagnostic** result;
	GcpDiagnostic** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_diagnostics;
	*result_length1 = self->priv->d_diagnostics_length1;
	result = _tmp0_;
	return result;
}


static GcpDiagnostic** _vala_array_dup6 (GcpDiagnostic** self, int length) {
	GcpDiagnostic** result;
	int i;
	result = g_new0 (GcpDiagnostic*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = _g_object_ref0 (self[i]);
	}
	return result;
}


void gcp_diagnostic_message_set_diagnostics (GcpDiagnosticMessage* self, GcpDiagnostic** value, int value_length1) {
	GcpDiagnostic** _tmp0_;
	GcpDiagnostic** _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (_tmp1_ = value, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup6 (_tmp1_, value_length1));
	self->priv->d_diagnostics = (_vala_array_free (self->priv->d_diagnostics, self->priv->d_diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_diagnostics = _tmp0_;
	self->priv->d_diagnostics_length1 = value_length1;
	self->priv->_d_diagnostics_size_ = value_length1;
	gcp_diagnostic_message_update (self);
}


static GcpDiagnosticSeverity gcp_diagnostic_message_get_diagnostics_ruling_severity (GcpDiagnosticMessage* self) {
	GcpDiagnosticSeverity result;
	GcpDiagnosticSeverity severity;
	gboolean first;
	g_return_val_if_fail (self != NULL, 0);
	severity = GCP_DIAGNOSTIC_SEVERITY_NONE;
	first = TRUE;
	{
		GcpDiagnostic** d_collection;
		int d_collection_length1;
		int d_it;
		d_collection = self->priv->d_diagnostics;
		d_collection_length1 = self->priv->d_diagnostics_length1;
		for (d_it = 0; d_it < self->priv->d_diagnostics_length1; d_it = d_it + 1) {
			GcpDiagnostic* _tmp0_;
			GcpDiagnostic* d;
			_tmp0_ = _g_object_ref0 (d_collection[d_it]);
			d = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				if (first) {
					_tmp1_ = TRUE;
				} else {
					GcpDiagnosticSeverity _tmp2_;
					_tmp2_ = gcp_diagnostic_get_severity (d);
					_tmp1_ = _tmp2_ > severity;
				}
				if (_tmp1_) {
					GcpDiagnosticSeverity _tmp3_;
					_tmp3_ = gcp_diagnostic_get_severity (d);
					severity = _tmp3_;
				}
				first = FALSE;
				_g_object_unref0 (d);
			}
		}
	}
	result = severity;
	return result;
}


static void gcp_diagnostic_message_class_init (GcpDiagnosticMessageClass * klass) {
	gcp_diagnostic_message_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpDiagnosticMessagePrivate));
	GTK_WIDGET_CLASS (klass)->destroy = gcp_diagnostic_message_real_destroy;
	GTK_WIDGET_CLASS (klass)->style_updated = gcp_diagnostic_message_real_style_updated;
	GTK_WIDGET_CLASS (klass)->get_request_mode = gcp_diagnostic_message_real_get_request_mode;
	GTK_WIDGET_CLASS (klass)->get_preferred_width = gcp_diagnostic_message_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height_for_width = gcp_diagnostic_message_real_get_preferred_height_for_width;
	GTK_WIDGET_CLASS (klass)->draw = gcp_diagnostic_message_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_gcp_diagnostic_message_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gcp_diagnostic_message_set_property;
	G_OBJECT_CLASS (klass)->finalize = gcp_diagnostic_message_finalize;
}


static void gcp_diagnostic_message_instance_init (GcpDiagnosticMessage * self) {
	self->priv = GCP_DIAGNOSTIC_MESSAGE_GET_PRIVATE (self);
}


static void gcp_diagnostic_message_finalize (GObject* obj) {
	GcpDiagnosticMessage * self;
	self = GCP_DIAGNOSTIC_MESSAGE (obj);
	self->priv->d_diagnostics = (_vala_array_free (self->priv->d_diagnostics, self->priv->d_diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->d_vbox);
	_gcp_diagnostic_colors_unref0 (self->priv->d_colors);
	G_OBJECT_CLASS (gcp_diagnostic_message_parent_class)->finalize (obj);
}


GType gcp_diagnostic_message_get_type (void) {
	return gcp_diagnostic_message_type_id;
}


GType gcp_diagnostic_message_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpDiagnosticMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_diagnostic_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpDiagnosticMessage), 0, (GInstanceInitFunc) gcp_diagnostic_message_instance_init, NULL };
	gcp_diagnostic_message_type_id = g_type_module_register_type (module, GTK_TYPE_EVENT_BOX, "GcpDiagnosticMessage", &g_define_type_info, 0);
	return gcp_diagnostic_message_type_id;
}


static void _vala_gcp_diagnostic_message_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcpDiagnosticMessage * self;
	self = GCP_DIAGNOSTIC_MESSAGE (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gcp_diagnostic_message_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GcpDiagnosticMessage * self;
	self = GCP_DIAGNOSTIC_MESSAGE (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



