/* gcp-scrollbar-marker.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-scrollbar-marker.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <cairo.h>
#include <gcp-utils-c.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define GCP_TYPE_SCROLLBAR_MARKER (gcp_scrollbar_marker_get_type ())
#define GCP_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarker))
#define GCP_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarkerClass))
#define GCP_IS_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SCROLLBAR_MARKER))
#define GCP_IS_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SCROLLBAR_MARKER))
#define GCP_SCROLLBAR_MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarkerClass))

typedef struct _GcpScrollbarMarker GcpScrollbarMarker;
typedef struct _GcpScrollbarMarkerClass GcpScrollbarMarkerClass;
typedef struct _GcpScrollbarMarkerPrivate GcpScrollbarMarkerPrivate;

#define GCP_SCROLLBAR_MARKER_TYPE_MARKER (gcp_scrollbar_marker_marker_get_type ())
#define GCP_SCROLLBAR_MARKER_MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_SCROLLBAR_MARKER_TYPE_MARKER, GcpScrollbarMarkerMarker))
#define GCP_SCROLLBAR_MARKER_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_SCROLLBAR_MARKER_TYPE_MARKER, GcpScrollbarMarkerMarkerClass))
#define GCP_SCROLLBAR_MARKER_IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_SCROLLBAR_MARKER_TYPE_MARKER))
#define GCP_SCROLLBAR_MARKER_IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_SCROLLBAR_MARKER_TYPE_MARKER))
#define GCP_SCROLLBAR_MARKER_MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_SCROLLBAR_MARKER_TYPE_MARKER, GcpScrollbarMarkerMarkerClass))

typedef struct _GcpScrollbarMarkerMarker GcpScrollbarMarkerMarker;
typedef struct _GcpScrollbarMarkerMarkerClass GcpScrollbarMarkerMarkerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GCP_TYPE_SOURCE_RANGE (gcp_source_range_get_type ())
#define GCP_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRange))
#define GCP_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))
#define GCP_IS_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE))
#define GCP_IS_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_RANGE))
#define GCP_SOURCE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))

typedef struct _GcpSourceRange GcpSourceRange;
typedef struct _GcpSourceRangeClass GcpSourceRangeClass;
#define _gcp_scrollbar_marker_marker_unref0(var) ((var == NULL) ? NULL : (var = (gcp_scrollbar_marker_marker_unref (var), NULL)))

#define GCP_TYPE_SOURCE_LOCATION (gcp_source_location_get_type ())
#define GCP_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocation))
#define GCP_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))
#define GCP_IS_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_LOCATION))
#define GCP_IS_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_LOCATION))
#define GCP_SOURCE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))

typedef struct _GcpSourceLocation GcpSourceLocation;
typedef struct _GcpSourceLocationClass GcpSourceLocationClass;
typedef struct _GcpScrollbarMarkerMarkerPrivate GcpScrollbarMarkerMarkerPrivate;
typedef struct _GcpScrollbarMarkerParamSpecMarker GcpScrollbarMarkerParamSpecMarker;
typedef struct _GcpParamSpecScrollbarMarker GcpParamSpecScrollbarMarker;

struct _GcpScrollbarMarker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GcpScrollbarMarkerPrivate * priv;
};

struct _GcpScrollbarMarkerClass {
	GTypeClass parent_class;
	void (*finalize) (GcpScrollbarMarker *self);
};

struct _GcpScrollbarMarkerPrivate {
	GtkScrollbar* d_scrollbar;
	GeeHashMap* d_markers;
	gint d_spacing;
	gint d_maxline;
	gint d_border;
	gint d_width;
	guint d_mergeId;
};

struct _GcpScrollbarMarkerMarker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GcpScrollbarMarkerMarkerPrivate * priv;
};

struct _GcpScrollbarMarkerMarkerClass {
	GTypeClass parent_class;
	void (*finalize) (GcpScrollbarMarkerMarker *self);
};

struct _GcpScrollbarMarkerMarkerPrivate {
	GdkRGBA d_color;
	GcpSourceRange* d_range;
};

struct _GcpScrollbarMarkerParamSpecMarker {
	GParamSpec parent_instance;
};

struct _GcpParamSpecScrollbarMarker {
	GParamSpec parent_instance;
};


static gpointer gcp_scrollbar_marker_parent_class = NULL;
static gpointer gcp_scrollbar_marker_marker_parent_class = NULL;
static GType gcp_scrollbar_marker_marker_type_id = 0;
static GType gcp_scrollbar_marker_type_id = 0;

gpointer gcp_scrollbar_marker_ref (gpointer instance);
void gcp_scrollbar_marker_unref (gpointer instance);
GParamSpec* gcp_param_spec_scrollbar_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_scrollbar_marker (GValue* value, gpointer v_object);
void gcp_value_take_scrollbar_marker (GValue* value, gpointer v_object);
gpointer gcp_value_get_scrollbar_marker (const GValue* value);
GType gcp_scrollbar_marker_get_type (void) G_GNUC_CONST;
GType gcp_scrollbar_marker_register_type (GTypeModule * module);
gpointer gcp_scrollbar_marker_marker_ref (gpointer instance);
void gcp_scrollbar_marker_marker_unref (gpointer instance);
GParamSpec* gcp_scrollbar_marker_param_spec_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_scrollbar_marker_value_set_marker (GValue* value, gpointer v_object);
void gcp_scrollbar_marker_value_take_marker (GValue* value, gpointer v_object);
gpointer gcp_scrollbar_marker_value_get_marker (const GValue* value);
GType gcp_scrollbar_marker_marker_get_type (void) G_GNUC_CONST;
GType gcp_scrollbar_marker_marker_register_type (GTypeModule * module);
#define GCP_SCROLLBAR_MARKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarkerPrivate))
enum  {
	GCP_SCROLLBAR_MARKER_DUMMY_PROPERTY
};
static gboolean gcp_scrollbar_marker_on_scrollbar_draw (GcpScrollbarMarker* self, cairo_t* ctx);
static gboolean _gcp_scrollbar_marker_on_scrollbar_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
GcpScrollbarMarker* gcp_scrollbar_marker_new (GtkScrollbar* scrollbar);
GcpScrollbarMarker* gcp_scrollbar_marker_construct (GType object_type, GtkScrollbar* scrollbar);
static void gcp_scrollbar_marker_on_style_updated (GcpScrollbarMarker* self);
static void _gcp_scrollbar_marker_on_style_updated_gtk_widget_style_updated (GtkWidget* _sender, gpointer self);
static void gcp_scrollbar_marker_update_spacing (GcpScrollbarMarker* self);
guint gcp_scrollbar_marker_new_merge_id (GcpScrollbarMarker* self);
GType gcp_source_range_get_type (void) G_GNUC_CONST;
GType gcp_source_range_register_type (GTypeModule * module);
void gcp_scrollbar_marker_add_with_id (GcpScrollbarMarker* self, guint id, GcpSourceRange* range, GdkRGBA* color);
GcpScrollbarMarkerMarker* gcp_scrollbar_marker_marker_new (GcpSourceRange* range, GdkRGBA* color);
GcpScrollbarMarkerMarker* gcp_scrollbar_marker_marker_construct (GType object_type, GcpSourceRange* range, GdkRGBA* color);
guint gcp_scrollbar_marker_add (GcpScrollbarMarker* self, GcpSourceRange* range, GdkRGBA* color);
void gcp_scrollbar_marker_remove (GcpScrollbarMarker* self, guint id);
void gcp_scrollbar_marker_clear (GcpScrollbarMarker* self);
static void gcp_scrollbar_marker_draw_marker (GcpScrollbarMarker* self, cairo_t* ctx, GdkRectangle* rect, GcpScrollbarMarkerMarker* marker);
GcpSourceRange* gcp_scrollbar_marker_marker_get_range (GcpScrollbarMarkerMarker* self);
GType gcp_source_location_get_type (void) G_GNUC_CONST;
GType gcp_source_location_register_type (GTypeModule * module);
GcpSourceLocation* gcp_source_range_get_end (GcpSourceRange* self);
gint gcp_source_location_get_line (GcpSourceLocation* self);
GcpSourceLocation* gcp_source_range_get_start (GcpSourceRange* self);
void gcp_scrollbar_marker_marker_get_color (GcpScrollbarMarkerMarker* self, GdkRGBA* result);
gint gcp_scrollbar_marker_get_max_line (GcpScrollbarMarker* self);
void gcp_scrollbar_marker_set_max_line (GcpScrollbarMarker* self, gint value);
GtkScrollbar* gcp_scrollbar_marker_get_scrollbar (GcpScrollbarMarker* self);
#define GCP_SCROLLBAR_MARKER_MARKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_SCROLLBAR_MARKER_TYPE_MARKER, GcpScrollbarMarkerMarkerPrivate))
enum  {
	GCP_SCROLLBAR_MARKER_MARKER_DUMMY_PROPERTY
};
static void gcp_scrollbar_marker_marker_finalize (GcpScrollbarMarkerMarker* obj);
static void gcp_scrollbar_marker_finalize (GcpScrollbarMarker* obj);


static gboolean _gcp_scrollbar_marker_on_scrollbar_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = gcp_scrollbar_marker_on_scrollbar_draw (self, cr);
	return result;
}


static void _gcp_scrollbar_marker_on_style_updated_gtk_widget_style_updated (GtkWidget* _sender, gpointer self) {
	gcp_scrollbar_marker_on_style_updated (self);
}


GcpScrollbarMarker* gcp_scrollbar_marker_construct (GType object_type, GtkScrollbar* scrollbar) {
	GcpScrollbarMarker* self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	g_return_val_if_fail (scrollbar != NULL, NULL);
	self = (GcpScrollbarMarker*) g_type_create_instance (object_type);
	self->priv->d_scrollbar = scrollbar;
	g_signal_connect_after ((GtkWidget*) self->priv->d_scrollbar, "draw", (GCallback) _gcp_scrollbar_marker_on_scrollbar_draw_gtk_widget_draw, self);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_markers);
	self->priv->d_markers = _tmp0_;
	self->priv->d_maxline = 0;
	g_signal_connect ((GtkWidget*) self->priv->d_scrollbar, "style-updated", (GCallback) _gcp_scrollbar_marker_on_style_updated_gtk_widget_style_updated, self);
	gcp_scrollbar_marker_update_spacing (self);
	return self;
}


GcpScrollbarMarker* gcp_scrollbar_marker_new (GtkScrollbar* scrollbar) {
	return gcp_scrollbar_marker_construct (GCP_TYPE_SCROLLBAR_MARKER, scrollbar);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gcp_scrollbar_marker_update_spacing (GcpScrollbarMarker* self) {
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* ctx;
	gint _tmp2_;
	gint stepper_size;
	gint _tmp3_;
	gint stepper_spacing;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self->priv->d_scrollbar);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = gcp_utils_c_get_style_property_int (ctx, "stepper-size");
	stepper_size = _tmp2_;
	_tmp3_ = gcp_utils_c_get_style_property_int (ctx, "stepper-spacing");
	stepper_spacing = _tmp3_;
	_tmp4_ = gcp_utils_c_get_style_property_int (ctx, "trough-border");
	self->priv->d_border = _tmp4_;
	_tmp5_ = gcp_utils_c_get_style_property_int (ctx, "slider-width");
	self->priv->d_width = _tmp5_;
	self->priv->d_spacing = (stepper_size + stepper_spacing) + 2;
	_g_object_unref0 (ctx);
}


static void gcp_scrollbar_marker_on_style_updated (GcpScrollbarMarker* self) {
	g_return_if_fail (self != NULL);
	gcp_scrollbar_marker_update_spacing (self);
}


guint gcp_scrollbar_marker_new_merge_id (GcpScrollbarMarker* self) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	self->priv->d_mergeId = self->priv->d_mergeId + 1;
	result = self->priv->d_mergeId;
	return result;
}


void gcp_scrollbar_marker_add_with_id (GcpScrollbarMarker* self, guint id, GcpSourceRange* range, GdkRGBA* color) {
	GcpScrollbarMarkerMarker* _tmp0_ = NULL;
	GcpScrollbarMarkerMarker* marker;
	GeeLinkedList* lst = NULL;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (range != NULL);
	_tmp0_ = gcp_scrollbar_marker_marker_new (range, color);
	marker = _tmp0_;
	_tmp1_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_markers, GUINT_TO_POINTER (id));
	if (_tmp1_) {
		gpointer _tmp2_ = NULL;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->d_markers, GUINT_TO_POINTER (id));
		_g_object_unref0 (lst);
		lst = (GeeLinkedList*) _tmp2_;
	} else {
		GeeLinkedList* _tmp3_ = NULL;
		_tmp3_ = gee_linked_list_new (GCP_SCROLLBAR_MARKER_TYPE_MARKER, (GBoxedCopyFunc) gcp_scrollbar_marker_marker_ref, gcp_scrollbar_marker_marker_unref, NULL);
		_g_object_unref0 (lst);
		lst = _tmp3_;
		gee_abstract_map_set ((GeeAbstractMap*) self->priv->d_markers, GUINT_TO_POINTER (id), lst);
	}
	gee_abstract_collection_add ((GeeAbstractCollection*) lst, marker);
	gtk_widget_queue_draw ((GtkWidget*) self->priv->d_scrollbar);
	_g_object_unref0 (lst);
	_gcp_scrollbar_marker_marker_unref0 (marker);
}


guint gcp_scrollbar_marker_add (GcpScrollbarMarker* self, GcpSourceRange* range, GdkRGBA* color) {
	guint result = 0U;
	guint _tmp0_;
	guint id;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (range != NULL, 0U);
	_tmp0_ = gcp_scrollbar_marker_new_merge_id (self);
	id = _tmp0_;
	gcp_scrollbar_marker_add_with_id (self, id, range, color);
	result = id;
	return result;
}


void gcp_scrollbar_marker_remove (GcpScrollbarMarker* self, guint id) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->d_markers, GUINT_TO_POINTER (id));
	if (!_tmp0_) {
		return;
	}
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->d_markers, GUINT_TO_POINTER (id), NULL);
	gtk_widget_queue_draw ((GtkWidget*) self->priv->d_scrollbar);
}


void gcp_scrollbar_marker_clear (GcpScrollbarMarker* self) {
	g_return_if_fail (self != NULL);
	gee_abstract_map_clear ((GeeAbstractMap*) self->priv->d_markers);
	self->priv->d_mergeId = (guint) 0;
	gtk_widget_queue_draw ((GtkWidget*) self->priv->d_scrollbar);
}


static void gcp_scrollbar_marker_draw_marker (GcpScrollbarMarker* self, cairo_t* ctx, GdkRectangle* rect, GcpScrollbarMarkerMarker* marker) {
	GcpSourceRange* _tmp0_ = NULL;
	GcpSourceRange* _tmp1_;
	GcpSourceRange* range;
	GcpSourceLocation* _tmp2_ = NULL;
	gint _tmp3_;
	GcpSourceLocation* _tmp4_ = NULL;
	gint _tmp5_;
	guint height;
	gdouble scale;
	GcpSourceLocation* _tmp6_ = NULL;
	gint _tmp7_;
	gdouble _tmp8_;
	gdouble y;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble dy;
	GdkRGBA _tmp11_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (marker != NULL);
	_tmp0_ = gcp_scrollbar_marker_marker_get_range (marker);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	range = _tmp1_;
	_tmp2_ = gcp_source_range_get_end (range);
	_tmp3_ = gcp_source_location_get_line (_tmp2_);
	_tmp4_ = gcp_source_range_get_start (range);
	_tmp5_ = gcp_source_location_get_line (_tmp4_);
	height = (guint) ((_tmp3_ - _tmp5_) + 1);
	scale = ((gdouble) (*rect).height) / ((gdouble) self->priv->d_maxline);
	_tmp6_ = gcp_source_range_get_start (range);
	_tmp7_ = gcp_source_location_get_line (_tmp6_);
	_tmp8_ = round (((*rect).y + ((_tmp7_ - 1) * scale)) - 0.5);
	y = _tmp8_ + 0.5;
	_tmp9_ = round (height * scale);
	_tmp10_ = fmax ((gdouble) 1, _tmp9_);
	dy = _tmp10_;
	gcp_scrollbar_marker_marker_get_color (marker, &_tmp11_);
	gdk_cairo_set_source_rgba (ctx, &_tmp11_);
	cairo_set_line_width (ctx, (gdouble) 1);
	if (dy > 1.5) {
		cairo_rectangle (ctx, (*rect).x + 0.5, y, (gdouble) ((*rect).width - 1), dy);
		cairo_fill (ctx);
	} else {
		cairo_move_to (ctx, (*rect).x + 0.5, y);
		cairo_line_to (ctx, (((*rect).x + 0.5) + (*rect).width) - 1, y);
		cairo_stroke (ctx);
	}
	_g_object_unref0 (range);
}


static gboolean gcp_scrollbar_marker_on_scrollbar_draw (GcpScrollbarMarker* self, cairo_t* ctx) {
	gboolean result = FALSE;
	GdkRectangle range = {0};
	GdkRectangle _tmp0_ = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	gtk_range_get_range_rect ((GtkRange*) self->priv->d_scrollbar, &_tmp0_);
	range = _tmp0_;
	range.x = range.x + self->priv->d_border;
	range.width = self->priv->d_width;
	range.y = range.y + self->priv->d_spacing;
	range.height = range.height - (2 * self->priv->d_spacing);
	{
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_;
		GeeIterator* _key_it;
		_tmp1_ = gee_map_get_keys ((GeeMap*) self->priv->d_markers);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_key_it = _tmp4_;
		while (TRUE) {
			gboolean _tmp5_;
			gpointer _tmp6_ = NULL;
			guint key;
			gpointer _tmp7_ = NULL;
			GeeLinkedList* lst;
			_tmp5_ = gee_iterator_next (_key_it);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = gee_iterator_get (_key_it);
			key = GPOINTER_TO_UINT (_tmp6_);
			_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->d_markers, GUINT_TO_POINTER (key));
			lst = (GeeLinkedList*) _tmp7_;
			{
				GeeLinkedList* _tmp8_;
				GeeLinkedList* _marker_list;
				gint _tmp9_;
				gint _marker_size;
				gint _marker_index;
				_tmp8_ = _g_object_ref0 (lst);
				_marker_list = _tmp8_;
				_tmp9_ = gee_collection_get_size ((GeeCollection*) _marker_list);
				_marker_size = _tmp9_;
				_marker_index = -1;
				while (TRUE) {
					gpointer _tmp10_ = NULL;
					GcpScrollbarMarkerMarker* marker;
					_marker_index = _marker_index + 1;
					if (!(_marker_index < _marker_size)) {
						break;
					}
					_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _marker_list, _marker_index);
					marker = (GcpScrollbarMarkerMarker*) _tmp10_;
					gcp_scrollbar_marker_draw_marker (self, ctx, &range, marker);
					_gcp_scrollbar_marker_marker_unref0 (marker);
				}
				_g_object_unref0 (_marker_list);
			}
			_g_object_unref0 (lst);
		}
		_g_object_unref0 (_key_it);
	}
	result = FALSE;
	return result;
}


gint gcp_scrollbar_marker_get_max_line (GcpScrollbarMarker* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->d_maxline;
	return result;
}


void gcp_scrollbar_marker_set_max_line (GcpScrollbarMarker* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->d_maxline = value;
	gtk_widget_queue_draw ((GtkWidget*) self->priv->d_scrollbar);
}


GtkScrollbar* gcp_scrollbar_marker_get_scrollbar (GcpScrollbarMarker* self) {
	GtkScrollbar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_scrollbar;
	return result;
}


GcpScrollbarMarkerMarker* gcp_scrollbar_marker_marker_construct (GType object_type, GcpSourceRange* range, GdkRGBA* color) {
	GcpScrollbarMarkerMarker* self = NULL;
	GcpSourceRange* _tmp0_;
	g_return_val_if_fail (range != NULL, NULL);
	self = (GcpScrollbarMarkerMarker*) g_type_create_instance (object_type);
	self->priv->d_color = *color;
	_tmp0_ = _g_object_ref0 (range);
	_g_object_unref0 (self->priv->d_range);
	self->priv->d_range = _tmp0_;
	return self;
}


GcpScrollbarMarkerMarker* gcp_scrollbar_marker_marker_new (GcpSourceRange* range, GdkRGBA* color) {
	return gcp_scrollbar_marker_marker_construct (GCP_SCROLLBAR_MARKER_TYPE_MARKER, range, color);
}


GcpSourceRange* gcp_scrollbar_marker_marker_get_range (GcpScrollbarMarkerMarker* self) {
	GcpSourceRange* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->d_range;
	return result;
}


void gcp_scrollbar_marker_marker_get_color (GcpScrollbarMarkerMarker* self, GdkRGBA* result) {
	g_return_if_fail (self != NULL);
	*result = self->priv->d_color;
	return;
}


static void gcp_scrollbar_marker_value_marker_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gcp_scrollbar_marker_value_marker_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gcp_scrollbar_marker_marker_unref (value->data[0].v_pointer);
	}
}


static void gcp_scrollbar_marker_value_marker_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gcp_scrollbar_marker_marker_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gcp_scrollbar_marker_value_marker_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gcp_scrollbar_marker_value_marker_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GcpScrollbarMarkerMarker* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gcp_scrollbar_marker_marker_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gcp_scrollbar_marker_value_marker_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GcpScrollbarMarkerMarker** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gcp_scrollbar_marker_marker_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gcp_scrollbar_marker_param_spec_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GcpScrollbarMarkerParamSpecMarker* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GCP_SCROLLBAR_MARKER_TYPE_MARKER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gcp_scrollbar_marker_value_get_marker (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_SCROLLBAR_MARKER_TYPE_MARKER), NULL);
	return value->data[0].v_pointer;
}


void gcp_scrollbar_marker_value_set_marker (GValue* value, gpointer v_object) {
	GcpScrollbarMarkerMarker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_SCROLLBAR_MARKER_TYPE_MARKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_SCROLLBAR_MARKER_TYPE_MARKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gcp_scrollbar_marker_marker_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_scrollbar_marker_marker_unref (old);
	}
}


void gcp_scrollbar_marker_value_take_marker (GValue* value, gpointer v_object) {
	GcpScrollbarMarkerMarker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_SCROLLBAR_MARKER_TYPE_MARKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_SCROLLBAR_MARKER_TYPE_MARKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_scrollbar_marker_marker_unref (old);
	}
}


static void gcp_scrollbar_marker_marker_class_init (GcpScrollbarMarkerMarkerClass * klass) {
	gcp_scrollbar_marker_marker_parent_class = g_type_class_peek_parent (klass);
	GCP_SCROLLBAR_MARKER_MARKER_CLASS (klass)->finalize = gcp_scrollbar_marker_marker_finalize;
	g_type_class_add_private (klass, sizeof (GcpScrollbarMarkerMarkerPrivate));
}


static void gcp_scrollbar_marker_marker_instance_init (GcpScrollbarMarkerMarker * self) {
	self->priv = GCP_SCROLLBAR_MARKER_MARKER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gcp_scrollbar_marker_marker_finalize (GcpScrollbarMarkerMarker* obj) {
	GcpScrollbarMarkerMarker * self;
	self = GCP_SCROLLBAR_MARKER_MARKER (obj);
	_g_object_unref0 (self->priv->d_range);
}


GType gcp_scrollbar_marker_marker_get_type (void) {
	return gcp_scrollbar_marker_marker_type_id;
}


GType gcp_scrollbar_marker_marker_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { gcp_scrollbar_marker_value_marker_init, gcp_scrollbar_marker_value_marker_free_value, gcp_scrollbar_marker_value_marker_copy_value, gcp_scrollbar_marker_value_marker_peek_pointer, "p", gcp_scrollbar_marker_value_marker_collect_value, "p", gcp_scrollbar_marker_value_marker_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GcpScrollbarMarkerMarkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_scrollbar_marker_marker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpScrollbarMarkerMarker), 0, (GInstanceInitFunc) gcp_scrollbar_marker_marker_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	gcp_scrollbar_marker_marker_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GcpScrollbarMarkerMarker", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gcp_scrollbar_marker_marker_type_id;
}


gpointer gcp_scrollbar_marker_marker_ref (gpointer instance) {
	GcpScrollbarMarkerMarker* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gcp_scrollbar_marker_marker_unref (gpointer instance) {
	GcpScrollbarMarkerMarker* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GCP_SCROLLBAR_MARKER_MARKER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void gcp_value_scrollbar_marker_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gcp_value_scrollbar_marker_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gcp_scrollbar_marker_unref (value->data[0].v_pointer);
	}
}


static void gcp_value_scrollbar_marker_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gcp_scrollbar_marker_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gcp_value_scrollbar_marker_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gcp_value_scrollbar_marker_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GcpScrollbarMarker* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gcp_scrollbar_marker_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gcp_value_scrollbar_marker_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GcpScrollbarMarker** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gcp_scrollbar_marker_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gcp_param_spec_scrollbar_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GcpParamSpecScrollbarMarker* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GCP_TYPE_SCROLLBAR_MARKER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gcp_value_get_scrollbar_marker (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_TYPE_SCROLLBAR_MARKER), NULL);
	return value->data[0].v_pointer;
}


void gcp_value_set_scrollbar_marker (GValue* value, gpointer v_object) {
	GcpScrollbarMarker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_TYPE_SCROLLBAR_MARKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_TYPE_SCROLLBAR_MARKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gcp_scrollbar_marker_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_scrollbar_marker_unref (old);
	}
}


void gcp_value_take_scrollbar_marker (GValue* value, gpointer v_object) {
	GcpScrollbarMarker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_TYPE_SCROLLBAR_MARKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_TYPE_SCROLLBAR_MARKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_scrollbar_marker_unref (old);
	}
}


static void gcp_scrollbar_marker_class_init (GcpScrollbarMarkerClass * klass) {
	gcp_scrollbar_marker_parent_class = g_type_class_peek_parent (klass);
	GCP_SCROLLBAR_MARKER_CLASS (klass)->finalize = gcp_scrollbar_marker_finalize;
	g_type_class_add_private (klass, sizeof (GcpScrollbarMarkerPrivate));
}


static void gcp_scrollbar_marker_instance_init (GcpScrollbarMarker * self) {
	self->priv = GCP_SCROLLBAR_MARKER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gcp_scrollbar_marker_finalize (GcpScrollbarMarker* obj) {
	GcpScrollbarMarker * self;
	guint _tmp0_;
	self = GCP_SCROLLBAR_MARKER (obj);
	if (self->priv->d_scrollbar == NULL) {
		goto _return;
	}
	g_signal_parse_name ("draw", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->d_scrollbar, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _gcp_scrollbar_marker_on_scrollbar_draw_gtk_widget_draw, self);
	_return:
	_g_object_unref0 (self->priv->d_markers);
}


GType gcp_scrollbar_marker_get_type (void) {
	return gcp_scrollbar_marker_type_id;
}


GType gcp_scrollbar_marker_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { gcp_value_scrollbar_marker_init, gcp_value_scrollbar_marker_free_value, gcp_value_scrollbar_marker_copy_value, gcp_value_scrollbar_marker_peek_pointer, "p", gcp_value_scrollbar_marker_collect_value, "p", gcp_value_scrollbar_marker_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GcpScrollbarMarkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_scrollbar_marker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpScrollbarMarker), 0, (GInstanceInitFunc) gcp_scrollbar_marker_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	gcp_scrollbar_marker_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GcpScrollbarMarker", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gcp_scrollbar_marker_type_id;
}


gpointer gcp_scrollbar_marker_ref (gpointer instance) {
	GcpScrollbarMarker* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gcp_scrollbar_marker_unref (gpointer instance) {
	GcpScrollbarMarker* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GCP_SCROLLBAR_MARKER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



