/* gcp-backend.c generated by valac 0.12.0, the Vala compiler
 * generated from gcp-backend.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-document.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>


#define GCP_TYPE_BACKEND (gcp_backend_get_type ())
#define GCP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_BACKEND, GcpBackend))
#define GCP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_BACKEND, GcpBackendClass))
#define GCP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_BACKEND))
#define GCP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_BACKEND))
#define GCP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_BACKEND, GcpBackendClass))

typedef struct _GcpBackend GcpBackend;
typedef struct _GcpBackendClass GcpBackendClass;
typedef struct _GcpBackendPrivate GcpBackendPrivate;

#define GCP_TYPE_DOCUMENT (gcp_document_get_type ())
#define GCP_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_DOCUMENT, GcpDocument))
#define GCP_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_DOCUMENT, GcpDocumentClass))
#define GCP_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_DOCUMENT))
#define GCP_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_DOCUMENT))
#define GCP_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_DOCUMENT, GcpDocumentClass))

typedef struct _GcpDocument GcpDocument;
typedef struct _GcpDocumentClass GcpDocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GCP_TYPE_SYMBOL_BROWSER_SUPPORT (gcp_symbol_browser_support_get_type ())
#define GCP_SYMBOL_BROWSER_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SYMBOL_BROWSER_SUPPORT, GcpSymbolBrowserSupport))
#define GCP_IS_SYMBOL_BROWSER_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SYMBOL_BROWSER_SUPPORT))
#define GCP_SYMBOL_BROWSER_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCP_TYPE_SYMBOL_BROWSER_SUPPORT, GcpSymbolBrowserSupportIface))

typedef struct _GcpSymbolBrowserSupport GcpSymbolBrowserSupport;
typedef struct _GcpSymbolBrowserSupportIface GcpSymbolBrowserSupportIface;

#define GCP_TYPE_SYMBOL_BROWSER (gcp_symbol_browser_get_type ())
#define GCP_SYMBOL_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SYMBOL_BROWSER, GcpSymbolBrowser))
#define GCP_SYMBOL_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SYMBOL_BROWSER, GcpSymbolBrowserClass))
#define GCP_IS_SYMBOL_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SYMBOL_BROWSER))
#define GCP_IS_SYMBOL_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SYMBOL_BROWSER))
#define GCP_SYMBOL_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SYMBOL_BROWSER, GcpSymbolBrowserClass))

typedef struct _GcpSymbolBrowser GcpSymbolBrowser;
typedef struct _GcpSymbolBrowserClass GcpSymbolBrowserClass;

struct _GcpBackend {
	GObject parent_instance;
	GcpBackendPrivate * priv;
};

struct _GcpBackendClass {
	GObjectClass parent_class;
	GcpDocument* (*create_document) (GcpBackend* self, GeditDocument* document);
	void (*destroy_document) (GcpBackend* self, GcpDocument* document);
	void (*unregister) (GcpBackend* self, GcpDocument* document);
	void (*on_document_changed) (GcpBackend* self, GcpDocument* doc);
	gchar** (*get_supported_languages) (GcpBackend* self, int* result_length1);
};

struct _GcpBackendPrivate {
	GeeArrayList* d_documents;
};

struct _GcpSymbolBrowserSupportIface {
	GTypeInterface parent_iface;
	GcpSymbolBrowser* (*get_symbol_browser) (GcpSymbolBrowserSupport* self);
};


static gpointer gcp_backend_parent_class = NULL;
static GType gcp_backend_type_id = 0;

GType gcp_backend_get_type (void) G_GNUC_CONST;
GType gcp_backend_register_type (GTypeModule * module);
GType gcp_document_get_type (void) G_GNUC_CONST;
GType gcp_document_register_type (GTypeModule * module);
#define GCP_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_BACKEND, GcpBackendPrivate))
enum  {
	GCP_BACKEND_DUMMY_PROPERTY,
	GCP_BACKEND_SUPPORTED_LANGUAGES,
	GCP_BACKEND_DOCUMENTS
};
GcpBackend* gcp_backend_construct (GType object_type);
GcpDocument* gcp_backend_create_document (GcpBackend* self, GeditDocument* document);
static GcpDocument* gcp_backend_real_create_document (GcpBackend* self, GeditDocument* document);
GcpDocument* gcp_backend_register (GcpBackend* self, GeditDocument* document);
void gcp_backend_on_document_changed (GcpBackend* self, GcpDocument* doc);
static void _gcp_backend_on_document_changed_gcp_document_changed (GcpDocument* _sender, gpointer self);
void gcp_backend_destroy_document (GcpBackend* self, GcpDocument* document);
static void gcp_backend_real_destroy_document (GcpBackend* self, GcpDocument* document);
void gcp_backend_unregister (GcpBackend* self, GcpDocument* document);
static void gcp_backend_real_unregister (GcpBackend* self, GcpDocument* document);
static void gcp_backend_real_on_document_changed (GcpBackend* self, GcpDocument* doc);
GType gcp_symbol_browser_get_type (void) G_GNUC_CONST;
GType gcp_symbol_browser_register_type (GTypeModule * module);
GType gcp_symbol_browser_support_get_type (void) G_GNUC_CONST;
GType gcp_symbol_browser_support_register_type (GTypeModule * module);
GcpSymbolBrowser* gcp_symbol_browser_support_get_symbol_browser (GcpSymbolBrowserSupport* self);
void gcp_symbol_browser_set_tainted (GcpSymbolBrowser* self, gboolean value);
gchar** gcp_backend_get_supported_languages (GcpBackend* self, int* result_length1);
GeeList* gcp_backend_get_documents (GcpBackend* self);
static void gcp_backend_finalize (GObject* obj);
static void _vala_gcp_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


GcpBackend* gcp_backend_construct (GType object_type) {
	GcpBackend * self = NULL;
	GeeArrayList* _tmp0_ = NULL;
	self = (GcpBackend*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (GCP_TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (self->priv->d_documents);
	self->priv->d_documents = _tmp0_;
	return self;
}


static GcpDocument* gcp_backend_real_create_document (GcpBackend* self, GeditDocument* document) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gcp_backend_create_document'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GcpDocument* gcp_backend_create_document (GcpBackend* self, GeditDocument* document) {
	return GCP_BACKEND_GET_CLASS (self)->create_document (self, document);
}


static void _gcp_backend_on_document_changed_gcp_document_changed (GcpDocument* _sender, gpointer self) {
	gcp_backend_on_document_changed (self, _sender);
}


GcpDocument* gcp_backend_register (GcpBackend* self, GeditDocument* document) {
	GcpDocument* result = NULL;
	GcpDocument* _tmp0_ = NULL;
	GcpDocument* ret;
	g_return_val_if_fail (self != NULL, NULL);
	if (document == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = gcp_backend_create_document (self, document);
	ret = _tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->d_documents, ret);
	g_signal_connect_object (ret, "changed", (GCallback) _gcp_backend_on_document_changed_gcp_document_changed, self, 0);
	result = ret;
	return result;
}


static void gcp_backend_real_destroy_document (GcpBackend* self, GcpDocument* document) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (document != NULL);
	g_signal_parse_name ("changed", GCP_TYPE_DOCUMENT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (document, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _gcp_backend_on_document_changed_gcp_document_changed, self);
}


void gcp_backend_destroy_document (GcpBackend* self, GcpDocument* document) {
	GCP_BACKEND_GET_CLASS (self)->destroy_document (self, document);
}


static void gcp_backend_real_unregister (GcpBackend* self, GcpDocument* document) {
	g_return_if_fail (self != NULL);
	if (document == NULL) {
		return;
	}
	gcp_backend_destroy_document (self, document);
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->d_documents, document);
}


void gcp_backend_unregister (GcpBackend* self, GcpDocument* document) {
	GCP_BACKEND_GET_CLASS (self)->unregister (self, document);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gcp_backend_real_on_document_changed (GcpBackend* self, GcpDocument* doc) {
	GcpDocument* _tmp0_;
	GcpSymbolBrowserSupport* _tmp1_;
	GcpSymbolBrowserSupport* s;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = doc;
	_tmp1_ = _g_object_ref0 (GCP_IS_SYMBOL_BROWSER_SUPPORT (_tmp0_) ? ((GcpSymbolBrowserSupport*) _tmp0_) : NULL);
	s = _tmp1_;
	if (s != NULL) {
		GcpSymbolBrowser* _tmp2_ = NULL;
		_tmp2_ = gcp_symbol_browser_support_get_symbol_browser (s);
		gcp_symbol_browser_set_tainted (_tmp2_, TRUE);
	}
	_g_object_unref0 (s);
}


void gcp_backend_on_document_changed (GcpBackend* self, GcpDocument* doc) {
	GCP_BACKEND_GET_CLASS (self)->on_document_changed (self, doc);
}


gchar** gcp_backend_get_supported_languages (GcpBackend* self, int* result_length1) {
	return GCP_BACKEND_GET_CLASS (self)->get_supported_languages (self, result_length1);
}


GeeList* gcp_backend_get_documents (GcpBackend* self) {
	GeeList* result;
	GeeList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_abstract_list_get_read_only_view ((GeeAbstractList*) self->priv->d_documents);
	result = _tmp0_;
	return result;
}


static void gcp_backend_class_init (GcpBackendClass * klass) {
	gcp_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpBackendPrivate));
	GCP_BACKEND_CLASS (klass)->create_document = gcp_backend_real_create_document;
	GCP_BACKEND_CLASS (klass)->destroy_document = gcp_backend_real_destroy_document;
	GCP_BACKEND_CLASS (klass)->unregister = gcp_backend_real_unregister;
	GCP_BACKEND_CLASS (klass)->on_document_changed = gcp_backend_real_on_document_changed;
	G_OBJECT_CLASS (klass)->get_property = _vala_gcp_backend_get_property;
	G_OBJECT_CLASS (klass)->finalize = gcp_backend_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_BACKEND_SUPPORTED_LANGUAGES, g_param_spec_boxed ("supported-languages", "supported-languages", "supported-languages", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_BACKEND_DOCUMENTS, g_param_spec_object ("documents", "documents", "documents", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gcp_backend_instance_init (GcpBackend * self) {
	self->priv = GCP_BACKEND_GET_PRIVATE (self);
}


static void gcp_backend_finalize (GObject* obj) {
	GcpBackend * self;
	self = GCP_BACKEND (obj);
	_g_object_unref0 (self->priv->d_documents);
	G_OBJECT_CLASS (gcp_backend_parent_class)->finalize (obj);
}


GType gcp_backend_get_type (void) {
	return gcp_backend_type_id;
}


GType gcp_backend_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpBackend), 0, (GInstanceInitFunc) gcp_backend_instance_init, NULL };
	gcp_backend_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GcpBackend", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return gcp_backend_type_id;
}


static void _vala_gcp_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcpBackend * self;
	self = GCP_BACKEND (object);
	switch (property_id) {
		case GCP_BACKEND_DOCUMENTS:
		g_value_take_object (value, gcp_backend_get_documents (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



