/* gcp-c-backend.c generated by valac 0.17.4.20-387e, the Vala compiler
 * generated from gcp-c-backend.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gcp.h>
#include <clang-c/Index.h>
#include <gee.h>
#include <gio/gio.h>
#include <gedit/gedit-document.h>
#include <stdlib.h>
#include <string.h>
#include <libpeas/peas.h>


#define GCP_C_TYPE_BACKEND (gcp_c_backend_get_type ())
#define GCP_C_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_TYPE_BACKEND, GcpCBackend))
#define GCP_C_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_TYPE_BACKEND, GcpCBackendClass))
#define GCP_C_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_TYPE_BACKEND))
#define GCP_C_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_TYPE_BACKEND))
#define GCP_C_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_TYPE_BACKEND, GcpCBackendClass))

typedef struct _GcpCBackend GcpCBackend;
typedef struct _GcpCBackendClass GcpCBackendClass;
typedef struct _GcpCBackendPrivate GcpCBackendPrivate;

#define GCP_C_TYPE_COMPILE_ARGS (gcp_c_compile_args_get_type ())
#define GCP_C_COMPILE_ARGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_TYPE_COMPILE_ARGS, GcpCCompileArgs))
#define GCP_C_COMPILE_ARGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_TYPE_COMPILE_ARGS, GcpCCompileArgsClass))
#define GCP_C_IS_COMPILE_ARGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_TYPE_COMPILE_ARGS))
#define GCP_C_IS_COMPILE_ARGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_TYPE_COMPILE_ARGS))
#define GCP_C_COMPILE_ARGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_TYPE_COMPILE_ARGS, GcpCCompileArgsClass))

typedef struct _GcpCCompileArgs GcpCCompileArgs;
typedef struct _GcpCCompileArgsClass GcpCCompileArgsClass;

#define GCP_C_TYPE_DOCUMENT (gcp_c_document_get_type ())
#define GCP_C_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_TYPE_DOCUMENT, GcpCDocument))
#define GCP_C_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_TYPE_DOCUMENT, GcpCDocumentClass))
#define GCP_C_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_TYPE_DOCUMENT))
#define GCP_C_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_TYPE_DOCUMENT))
#define GCP_C_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_TYPE_DOCUMENT, GcpCDocumentClass))

typedef struct _GcpCDocument GcpCDocument;
typedef struct _GcpCDocumentClass GcpCDocumentClass;
#define _clang_disposeIndex0(var) ((var == NULL) ? NULL : (var = (clang_disposeIndex (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GCP_C_TYPE_TRANSLATION_UNIT (gcp_c_translation_unit_get_type ())
#define GCP_C_TRANSLATION_UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_C_TYPE_TRANSLATION_UNIT, GcpCTranslationUnit))
#define GCP_C_TRANSLATION_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_C_TYPE_TRANSLATION_UNIT, GcpCTranslationUnitClass))
#define GCP_C_IS_TRANSLATION_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_C_TYPE_TRANSLATION_UNIT))
#define GCP_C_IS_TRANSLATION_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_C_TYPE_TRANSLATION_UNIT))
#define GCP_C_TRANSLATION_UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_C_TYPE_TRANSLATION_UNIT, GcpCTranslationUnitClass))

typedef struct _GcpCTranslationUnit GcpCTranslationUnit;
typedef struct _GcpCTranslationUnitClass GcpCTranslationUnitClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GcpCBackend {
	GcpBackendImplementation parent_instance;
	GcpCBackendPrivate * priv;
};

struct _GcpCBackendClass {
	GcpBackendImplementationClass parent_class;
};

struct _GcpCBackendPrivate {
	void* d_index;
	GcpCCompileArgs* d_compileArgs;
	GeeHashMap* d_documentMap;
	guint d_changedId;
};


static gpointer gcp_c_backend_parent_class = NULL;
static GType gcp_c_backend_type_id = 0;

GType gcp_c_backend_get_type (void) G_GNUC_CONST;
GType gcp_c_backend_register_type (GTypeModule * module);
GType gcp_c_compile_args_get_type (void) G_GNUC_CONST;
GType gcp_c_compile_args_register_type (GTypeModule * module);
GType gcp_c_document_get_type (void) G_GNUC_CONST;
GType gcp_c_document_register_type (GTypeModule * module);
#define GCP_C_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_C_TYPE_BACKEND, GcpCBackendPrivate))
enum  {
	GCP_C_BACKEND_DUMMY_PROPERTY,
	GCP_C_BACKEND_INDEX
};
static void gcp_c_backend_map_document (GcpCBackend* self, GFile* file, GcpCDocument* doc);
static void gcp_c_backend_unmap_document (GcpCBackend* self, GFile* file, GcpCDocument* doc);
static GcpDocument* gcp_c_backend_real_create_document (GcpBackendImplementation* base, GeditDocument* document);
GcpCDocument* gcp_c_document_new (GeditDocument* document);
GcpCDocument* gcp_c_document_construct (GType object_type, GeditDocument* document);
void gcp_c_compile_args_monitor (GcpCCompileArgs* self, GFile* file);
static void gcp_c_backend_on_location_changed (GcpCBackend* self, GcpDocument* document, GFile* previous_location);
static void _gcp_c_backend_on_location_changed_gcp_document_location_changed (GcpDocument* _sender, GFile* previous_location, gpointer self);
static void gcp_c_backend_real_destroy_document (GcpBackendImplementation* base, GcpDocument* document);
void gcp_c_compile_args_remove_monitor (GcpCCompileArgs* self, GFile* file);
static void gcp_c_backend_parse (GcpCBackend* self, GcpCDocument* doc, gchar** args, int args_length1);
gpointer gcp_c_translation_unit_ref (gpointer instance);
void gcp_c_translation_unit_unref (gpointer instance);
GParamSpec* gcp_c_param_spec_translation_unit (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_c_value_set_translation_unit (GValue* value, gpointer v_object);
void gcp_c_value_take_translation_unit (GValue* value, gpointer v_object);
gpointer gcp_c_value_get_translation_unit (const GValue* value);
GType gcp_c_translation_unit_get_type (void) G_GNUC_CONST;
GType gcp_c_translation_unit_register_type (GTypeModule * module);
GcpCTranslationUnit* gcp_c_document_get_translation_unit (GcpCDocument* self);
void gcp_c_translation_unit_parse (GcpCTranslationUnit* self, const void* idx, const gchar* source, gchar** args, int args_length1, GcpUnsavedFile* unsaved, int unsaved_length1);
static GcpUnsavedFile* gcp_c_backend_get_unsaved_files (GcpCBackend* self, int* result_length1);
static void _vala_GcpUnsavedFile_array_free (GcpUnsavedFile* array, gint array_length);
static void gcp_c_backend_reparse (GcpCBackend* self);
void gcp_c_translation_unit_reparse (GcpCTranslationUnit* self, GcpUnsavedFile* unsaved, int unsaved_length1);
static void gcp_c_backend_on_arguments_changed (GcpCBackend* self, GFile* file);
gchar** gcp_c_compile_args_get (GcpCCompileArgs* self, GFile* file, int* result_length1);
static void gcp_c_backend_real_on_document_changed (GcpBackendImplementation* base, GcpDocument* doc);
void gcp_c_translation_unit_set_tainted (GcpCTranslationUnit* self, gboolean value);
static gboolean __lambda11_ (GcpCBackend* self);
static gboolean ___lambda11__gsource_func (gpointer self);
GcpCBackend* gcp_c_backend_new (void);
GcpCBackend* gcp_c_backend_construct (GType object_type);
const void* gcp_c_backend_get_index (GcpCBackend* self);
static GObject * gcp_c_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GcpCCompileArgs* gcp_c_compile_args_new (void);
GcpCCompileArgs* gcp_c_compile_args_construct (GType object_type);
static void _gcp_c_backend_on_arguments_changed_gcp_c_compile_args_arguments_changed (GcpCCompileArgs* _sender, GFile* file, gpointer self);
static guint _g_file_hash_ghash_func (gconstpointer key);
static void gcp_c_backend_finalize (GObject* obj);
static void _vala_gcp_c_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void peas_register_types (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void gcp_c_backend_map_document (GcpCBackend* self, GFile* file, GcpCDocument* doc) {
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = self->priv->d_documentMap;
	_tmp1_ = file;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (!_tmp2_) {
		GeeLinkedList* _tmp3_;
		GeeLinkedList* r;
		GeeLinkedList* _tmp4_;
		GcpCDocument* _tmp5_;
		GeeHashMap* _tmp6_;
		GFile* _tmp7_;
		GeeLinkedList* _tmp8_;
		_tmp3_ = gee_linked_list_new (GCP_C_TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
		r = _tmp3_;
		_tmp4_ = r;
		_tmp5_ = doc;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
		_tmp6_ = self->priv->d_documentMap;
		_tmp7_ = file;
		_tmp8_ = r;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp7_, _tmp8_);
		_g_object_unref0 (r);
	} else {
		GeeHashMap* _tmp9_;
		GFile* _tmp10_;
		gpointer _tmp11_ = NULL;
		GeeLinkedList* r;
		GeeLinkedList* _tmp12_;
		GcpCDocument* _tmp13_;
		_tmp9_ = self->priv->d_documentMap;
		_tmp10_ = file;
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
		r = (GeeLinkedList*) _tmp11_;
		_tmp12_ = r;
		_tmp13_ = doc;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
		_g_object_unref0 (r);
	}
}


static void gcp_c_backend_unmap_document (GcpCBackend* self, GFile* file, GcpCDocument* doc) {
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = self->priv->d_documentMap;
	_tmp1_ = file;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		GeeHashMap* _tmp3_;
		GFile* _tmp4_;
		gpointer _tmp5_ = NULL;
		GeeLinkedList* r;
		GeeLinkedList* _tmp6_;
		GcpCDocument* _tmp7_;
		GeeLinkedList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp3_ = self->priv->d_documentMap;
		_tmp4_ = file;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
		r = (GeeLinkedList*) _tmp5_;
		_tmp6_ = r;
		_tmp7_ = doc;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, _tmp7_);
		_tmp8_ = r;
		_tmp9_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == 0) {
			GeeHashMap* _tmp11_;
			GFile* _tmp12_;
			_tmp11_ = self->priv->d_documentMap;
			_tmp12_ = file;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp11_, _tmp12_, NULL);
		}
		_g_object_unref0 (r);
	}
}


static void _gcp_c_backend_on_location_changed_gcp_document_location_changed (GcpDocument* _sender, GFile* previous_location, gpointer self) {
	gcp_c_backend_on_location_changed (self, _sender, previous_location);
}


static GcpDocument* gcp_c_backend_real_create_document (GcpBackendImplementation* base, GeditDocument* document) {
	GcpCBackend * self;
	GcpDocument* result = NULL;
	GeditDocument* _tmp0_;
	GcpCDocument* _tmp1_;
	GcpCDocument* doc;
	GcpCDocument* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GcpCDocument* _tmp13_;
	self = (GcpCBackend*) base;
	g_return_val_if_fail (document != NULL, NULL);
	_tmp0_ = document;
	_tmp1_ = gcp_c_document_new (_tmp0_);
	doc = _tmp1_;
	_tmp2_ = doc;
	_tmp3_ = gcp_document_get_location ((GcpDocument*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		GcpCDocument* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GcpCDocument* _tmp8_;
		GcpCCompileArgs* _tmp9_;
		GcpCDocument* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		_tmp5_ = doc;
		_tmp6_ = gcp_document_get_location ((GcpDocument*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = doc;
		gcp_c_backend_map_document (self, _tmp7_, _tmp8_);
		_tmp9_ = self->priv->d_compileArgs;
		_tmp10_ = doc;
		_tmp11_ = gcp_document_get_location ((GcpDocument*) _tmp10_);
		_tmp12_ = _tmp11_;
		gcp_c_compile_args_monitor (_tmp9_, _tmp12_);
	}
	_tmp13_ = doc;
	g_signal_connect_object ((GcpDocument*) _tmp13_, "location-changed", (GCallback) _gcp_c_backend_on_location_changed_gcp_document_location_changed, self, 0);
	result = (GcpDocument*) doc;
	return result;
}


static void gcp_c_backend_real_destroy_document (GcpBackendImplementation* base, GcpDocument* document) {
	GcpCBackend * self;
	GcpDocument* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GcpDocument* _tmp11_;
	self = (GcpCBackend*) base;
	g_return_if_fail (document != NULL);
	_tmp0_ = document;
	_tmp1_ = gcp_document_get_location (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GcpDocument* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		GcpDocument* _tmp6_;
		GcpCCompileArgs* _tmp7_;
		GcpDocument* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		_tmp3_ = document;
		_tmp4_ = gcp_document_get_location (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = document;
		gcp_c_backend_unmap_document (self, _tmp5_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, GCP_C_TYPE_DOCUMENT) ? ((GcpCDocument*) _tmp6_) : NULL);
		_tmp7_ = self->priv->d_compileArgs;
		_tmp8_ = document;
		_tmp9_ = gcp_document_get_location (_tmp8_);
		_tmp10_ = _tmp9_;
		gcp_c_compile_args_remove_monitor (_tmp7_, _tmp10_);
	}
	_tmp11_ = document;
	GCP_BACKEND_IMPLEMENTATION_CLASS (gcp_c_backend_parent_class)->destroy_document (G_TYPE_CHECK_INSTANCE_CAST (self, GCP_TYPE_BACKEND_IMPLEMENTATION, GcpBackendImplementation), _tmp11_);
}


static void gcp_c_backend_on_location_changed (GcpCBackend* self, GcpDocument* document, GFile* previous_location) {
	GFile* _tmp0_;
	GcpDocument* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (document != NULL);
	_tmp0_ = previous_location;
	if (_tmp0_ != NULL) {
		GFile* _tmp1_;
		GcpDocument* _tmp2_;
		GcpCCompileArgs* _tmp3_;
		GFile* _tmp4_;
		_tmp1_ = previous_location;
		_tmp2_ = document;
		gcp_c_backend_unmap_document (self, _tmp1_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GCP_C_TYPE_DOCUMENT) ? ((GcpCDocument*) _tmp2_) : NULL);
		_tmp3_ = self->priv->d_compileArgs;
		_tmp4_ = previous_location;
		gcp_c_compile_args_remove_monitor (_tmp3_, _tmp4_);
	}
	_tmp5_ = document;
	_tmp6_ = gcp_document_get_location (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GcpDocument* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GcpDocument* _tmp11_;
		GcpCCompileArgs* _tmp12_;
		GcpDocument* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		_tmp8_ = document;
		_tmp9_ = gcp_document_get_location (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = document;
		gcp_c_backend_map_document (self, _tmp10_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GCP_C_TYPE_DOCUMENT) ? ((GcpCDocument*) _tmp11_) : NULL);
		_tmp12_ = self->priv->d_compileArgs;
		_tmp13_ = document;
		_tmp14_ = gcp_document_get_location (_tmp13_);
		_tmp15_ = _tmp14_;
		gcp_c_compile_args_monitor (_tmp12_, _tmp15_);
	}
}


static void _vala_GcpUnsavedFile_array_free (GcpUnsavedFile* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gcp_unsaved_file_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void gcp_c_backend_parse (GcpCBackend* self, GcpCDocument* doc, gchar** args, int args_length1) {
	GcpCDocument* _tmp0_;
	GcpCTranslationUnit* _tmp1_;
	GcpCTranslationUnit* _tmp2_;
	const void* _tmp3_;
	GcpCDocument* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GcpUnsavedFile* _tmp10_;
	gint _tmp10__length1;
	GcpUnsavedFile* _tmp11_;
	gint _tmp11__length1;
	GcpUnsavedFile* _tmp12_;
	gint _tmp12__length1;
	GcpCDocument* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = doc;
	_tmp1_ = gcp_c_document_get_translation_unit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->d_index;
	_tmp4_ = doc;
	_tmp5_ = gcp_document_get_location ((GcpDocument*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_file_get_path (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = args;
	_tmp9__length1 = args_length1;
	_tmp10_ = gcp_c_backend_get_unsaved_files (self, &_tmp10__length1);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp10__length1;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _tmp11__length1;
	gcp_c_translation_unit_parse (_tmp2_, _tmp3_, _tmp8_, _tmp9_, _tmp9__length1, _tmp12_, _tmp11__length1);
	_tmp12_ = (_vala_GcpUnsavedFile_array_free (_tmp12_, _tmp12__length1), NULL);
	_g_free0 (_tmp8_);
	_tmp13_ = doc;
	gcp_document_set_tainted ((GcpDocument*) _tmp13_, FALSE);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gcp_c_backend_reparse (GcpCBackend* self) {
	GcpUnsavedFile* _tmp0_;
	gint _tmp0__length1;
	GcpUnsavedFile* _tmp1_;
	gint _tmp1__length1;
	GcpUnsavedFile* uf;
	gint uf_length1;
	gint _uf_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gcp_c_backend_get_unsaved_files (self, &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	uf = _tmp1_;
	uf_length1 = _tmp1__length1;
	_uf_size_ = uf_length1;
	{
		GcpCBackend* _tmp2_;
		GcpCBackend* _doc_list;
		GcpCBackend* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _doc_size;
		gint _doc_index;
		_tmp2_ = _g_object_ref0 (self);
		_doc_list = _tmp2_;
		_tmp3_ = _doc_list;
		_tmp4_ = gcp_backend_get_size ((GcpBackend*) _tmp3_);
		_tmp5_ = _tmp4_;
		_doc_size = _tmp5_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GcpCBackend* _tmp9_;
			gint _tmp10_;
			GcpDocument* _tmp11_ = NULL;
			GcpDocument* doc;
			GcpDocument* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			GcpDocument* _tmp15_;
			GcpCDocument* _tmp16_;
			GcpCDocument* d;
			GcpCDocument* _tmp17_;
			GcpCTranslationUnit* _tmp18_;
			GcpCTranslationUnit* _tmp19_;
			GcpUnsavedFile* _tmp20_;
			gint _tmp20__length1;
			GcpCDocument* _tmp21_;
			_tmp6_ = _doc_index;
			_doc_index = _tmp6_ + 1;
			_tmp7_ = _doc_index;
			_tmp8_ = _doc_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _doc_list;
			_tmp10_ = _doc_index;
			_tmp11_ = gcp_backend_get ((GcpBackend*) _tmp9_, _tmp10_);
			doc = _tmp11_;
			_tmp12_ = doc;
			_tmp13_ = gcp_document_get_tainted (_tmp12_);
			_tmp14_ = _tmp13_;
			if (!_tmp14_) {
				_g_object_unref0 (doc);
				continue;
			}
			_tmp15_ = doc;
			_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, GCP_C_TYPE_DOCUMENT) ? ((GcpCDocument*) _tmp15_) : NULL);
			d = _tmp16_;
			_tmp17_ = d;
			_tmp18_ = gcp_c_document_get_translation_unit (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = uf;
			_tmp20__length1 = uf_length1;
			gcp_c_translation_unit_reparse (_tmp19_, _tmp20_, _tmp20__length1);
			_tmp21_ = d;
			gcp_document_set_tainted ((GcpDocument*) _tmp21_, FALSE);
			_g_object_unref0 (d);
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	uf = (_vala_GcpUnsavedFile_array_free (uf, uf_length1), NULL);
}


static void gcp_c_backend_on_arguments_changed (GcpCBackend* self, GFile* file) {
	GeeHashMap* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GcpCCompileArgs* _tmp3_;
	GFile* _tmp4_;
	gint _tmp5_ = 0;
	gchar** _tmp6_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->d_documentMap;
	_tmp1_ = file;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->d_compileArgs;
	_tmp4_ = file;
	_tmp6_ = gcp_c_compile_args_get (_tmp3_, _tmp4_, &_tmp5_);
	args = _tmp6_;
	args_length1 = _tmp5_;
	_args_size_ = args_length1;
	_tmp7_ = args;
	_tmp7__length1 = args_length1;
	if (_tmp7_ == NULL) {
		gchar** _tmp8_ = NULL;
		_tmp8_ = g_new0 (gchar*, 0 + 1);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		args = _tmp8_;
		args_length1 = 0;
		_args_size_ = args_length1;
	}
	{
		GeeHashMap* _tmp9_;
		GFile* _tmp10_;
		gpointer _tmp11_ = NULL;
		GeeLinkedList* _doc_list;
		GeeLinkedList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _doc_size;
		gint _doc_index;
		_tmp9_ = self->priv->d_documentMap;
		_tmp10_ = file;
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
		_doc_list = (GeeLinkedList*) _tmp11_;
		_tmp12_ = _doc_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_doc_size = _tmp14_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			GeeLinkedList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_ = NULL;
			GcpCDocument* doc;
			GcpCDocument* _tmp21_;
			gchar** _tmp22_;
			gint _tmp22__length1;
			_tmp15_ = _doc_index;
			_doc_index = _tmp15_ + 1;
			_tmp16_ = _doc_index;
			_tmp17_ = _doc_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _doc_list;
			_tmp19_ = _doc_index;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
			doc = (GcpCDocument*) _tmp20_;
			_tmp21_ = doc;
			_tmp22_ = args;
			_tmp22__length1 = args_length1;
			gcp_c_backend_parse (self, _tmp21_, _tmp22_, _tmp22__length1);
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
}


static gboolean __lambda11_ (GcpCBackend* self) {
	gboolean result = FALSE;
	self->priv->d_changedId = (guint) 0;
	gcp_c_backend_reparse (self);
	result = FALSE;
	return result;
}


static gboolean ___lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda11_ (self);
	return result;
}


static void gcp_c_backend_real_on_document_changed (GcpBackendImplementation* base, GcpDocument* doc) {
	GcpCBackend * self;
	GcpDocument* _tmp0_;
	GcpDocument* _tmp1_;
	GcpCDocument* _tmp2_;
	GcpCDocument* d;
	GcpCDocument* _tmp3_;
	GcpCTranslationUnit* _tmp4_;
	GcpCTranslationUnit* _tmp5_;
	guint _tmp6_;
	guint _tmp8_ = 0U;
	self = (GcpCBackend*) base;
	g_return_if_fail (doc != NULL);
	_tmp0_ = doc;
	GCP_BACKEND_IMPLEMENTATION_CLASS (gcp_c_backend_parent_class)->on_document_changed (G_TYPE_CHECK_INSTANCE_CAST (self, GCP_TYPE_BACKEND_IMPLEMENTATION, GcpBackendImplementation), _tmp0_);
	_tmp1_ = doc;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GCP_C_TYPE_DOCUMENT) ? ((GcpCDocument*) _tmp1_) : NULL);
	d = _tmp2_;
	_tmp3_ = d;
	_tmp4_ = gcp_c_document_get_translation_unit (_tmp3_);
	_tmp5_ = _tmp4_;
	gcp_c_translation_unit_set_tainted (_tmp5_, TRUE);
	_tmp6_ = self->priv->d_changedId;
	if (_tmp6_ != ((guint) 0)) {
		guint _tmp7_;
		_tmp7_ = self->priv->d_changedId;
		g_source_remove (_tmp7_);
	}
	_tmp8_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda11__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->d_changedId = _tmp8_;
	_g_object_unref0 (d);
}


GcpCBackend* gcp_c_backend_construct (GType object_type) {
	GcpCBackend * self = NULL;
	self = (GcpCBackend*) gcp_backend_implementation_construct (object_type);
	return self;
}


GcpCBackend* gcp_c_backend_new (void) {
	return gcp_c_backend_construct (GCP_C_TYPE_BACKEND);
}


const void* gcp_c_backend_get_index (GcpCBackend* self) {
	const void* result;
	const void* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_index;
	result = _tmp0_;
	return result;
}


static GcpUnsavedFile* gcp_c_backend_get_unsaved_files (GcpCBackend* self, int* result_length1) {
	GcpUnsavedFile* result;
	GeeArrayList* _tmp0_;
	GeeArrayList* docs;
	GeeArrayList* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GcpUnsavedFile* _tmp24_ = NULL;
	GcpUnsavedFile* ret;
	gint ret_length1;
	gint _ret_size_;
	GcpUnsavedFile* _tmp48_;
	gint _tmp48__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (GCP_TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	docs = _tmp0_;
	{
		GcpCBackend* _tmp1_;
		GcpCBackend* _doc_list;
		GcpCBackend* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _doc_size;
		gint _doc_index;
		_tmp1_ = _g_object_ref0 (self);
		_doc_list = _tmp1_;
		_tmp2_ = _doc_list;
		_tmp3_ = gcp_backend_get_size ((GcpBackend*) _tmp2_);
		_tmp4_ = _tmp3_;
		_doc_size = _tmp4_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GcpCBackend* _tmp8_;
			gint _tmp9_;
			GcpDocument* _tmp10_ = NULL;
			GcpDocument* doc;
			gboolean _tmp11_ = FALSE;
			GcpDocument* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
			gboolean _tmp18_;
			_tmp5_ = _doc_index;
			_doc_index = _tmp5_ + 1;
			_tmp6_ = _doc_index;
			_tmp7_ = _doc_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _doc_list;
			_tmp9_ = _doc_index;
			_tmp10_ = gcp_backend_get ((GcpBackend*) _tmp8_, _tmp9_);
			doc = _tmp10_;
			_tmp12_ = doc;
			_tmp13_ = gcp_document_get_location (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				GcpDocument* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = doc;
				_tmp16_ = gcp_document_get_text (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = _tmp17_ != NULL;
			} else {
				_tmp11_ = FALSE;
			}
			_tmp18_ = _tmp11_;
			if (_tmp18_) {
				GeeArrayList* _tmp19_;
				GcpDocument* _tmp20_;
				_tmp19_ = docs;
				_tmp20_ = doc;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	_tmp21_ = docs;
	_tmp22_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_new0 (GcpUnsavedFile, _tmp23_);
	ret = _tmp24_;
	ret_length1 = _tmp23_;
	_ret_size_ = ret_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp25_;
			_tmp25_ = TRUE;
			while (TRUE) {
				gboolean _tmp26_;
				gint _tmp28_;
				GcpUnsavedFile* _tmp29_;
				gint _tmp29__length1;
				GcpUnsavedFile* _tmp30_;
				gint _tmp30__length1;
				gint _tmp31_;
				GeeArrayList* _tmp32_;
				gint _tmp33_;
				gpointer _tmp34_ = NULL;
				GcpDocument* _tmp35_;
				GFile* _tmp36_;
				GFile* _tmp37_;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_;
				GeeArrayList* _tmp40_;
				gint _tmp41_;
				gpointer _tmp42_ = NULL;
				GcpDocument* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				GcpUnsavedFile _tmp46_ = {0};
				GcpUnsavedFile _tmp47_;
				_tmp26_ = _tmp25_;
				if (!_tmp26_) {
					gint _tmp27_;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp25_ = FALSE;
				_tmp28_ = i;
				_tmp29_ = ret;
				_tmp29__length1 = ret_length1;
				if (!(_tmp28_ < _tmp29__length1)) {
					break;
				}
				_tmp30_ = ret;
				_tmp30__length1 = ret_length1;
				_tmp31_ = i;
				_tmp32_ = docs;
				_tmp33_ = i;
				_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp33_);
				_tmp35_ = (GcpDocument*) _tmp34_;
				_tmp36_ = gcp_document_get_location (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_file_get_path (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = docs;
				_tmp41_ = i;
				_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, _tmp41_);
				_tmp43_ = (GcpDocument*) _tmp42_;
				_tmp44_ = gcp_document_get_text (_tmp43_);
				_tmp45_ = _tmp44_;
				gcp_unsaved_file_init (&_tmp46_, _tmp39_, _tmp45_);
				gcp_unsaved_file_destroy (&_tmp30_[_tmp31_]);
				_tmp30_[_tmp31_] = _tmp46_;
				_tmp47_ = _tmp30_[_tmp31_];
				_g_object_unref0 (_tmp43_);
				_g_free0 (_tmp39_);
				_g_object_unref0 (_tmp35_);
			}
		}
	}
	_tmp48_ = ret;
	_tmp48__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp48__length1;
	}
	result = _tmp48_;
	_g_object_unref0 (docs);
	return result;
}


static void _gcp_c_backend_on_arguments_changed_gcp_c_compile_args_arguments_changed (GcpCCompileArgs* _sender, GFile* file, gpointer self) {
	gcp_c_backend_on_arguments_changed (self, file);
}


static guint _g_file_hash_ghash_func (gconstpointer key) {
	guint result;
	result = g_file_hash (key);
	return result;
}


static GObject * gcp_c_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GcpCBackend * self;
	void* _tmp0_;
	GcpCCompileArgs* _tmp1_;
	GcpCCompileArgs* _tmp2_;
	GeeHashMap* _tmp3_;
	parent_class = G_OBJECT_CLASS (gcp_c_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCP_C_TYPE_BACKEND, GcpCBackend);
	_tmp0_ = clang_createIndex (TRUE, FALSE);
	_clang_disposeIndex0 (self->priv->d_index);
	self->priv->d_index = _tmp0_;
	_tmp1_ = gcp_c_compile_args_new ();
	_g_object_unref0 (self->priv->d_compileArgs);
	self->priv->d_compileArgs = _tmp1_;
	_tmp2_ = self->priv->d_compileArgs;
	g_signal_connect_object (_tmp2_, "arguments-changed", (GCallback) _gcp_c_backend_on_arguments_changed_gcp_c_compile_args_arguments_changed, self, 0);
	_tmp3_ = gee_hash_map_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, _g_file_hash_ghash_func, (GEqualFunc) g_file_equal, NULL);
	_g_object_unref0 (self->priv->d_documentMap);
	self->priv->d_documentMap = _tmp3_;
	self->priv->d_changedId = (guint) 0;
	return obj;
}


static void gcp_c_backend_class_init (GcpCBackendClass * klass) {
	gcp_c_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcpCBackendPrivate));
	GCP_BACKEND_IMPLEMENTATION_CLASS (klass)->create_document = gcp_c_backend_real_create_document;
	GCP_BACKEND_IMPLEMENTATION_CLASS (klass)->destroy_document = gcp_c_backend_real_destroy_document;
	GCP_BACKEND_IMPLEMENTATION_CLASS (klass)->on_document_changed = gcp_c_backend_real_on_document_changed;
	G_OBJECT_CLASS (klass)->get_property = _vala_gcp_c_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = gcp_c_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = gcp_c_backend_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCP_C_BACKEND_INDEX, g_param_spec_pointer ("index", "index", "index", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gcp_c_backend_instance_init (GcpCBackend * self) {
	self->priv = GCP_C_BACKEND_GET_PRIVATE (self);
}


static void gcp_c_backend_finalize (GObject* obj) {
	GcpCBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCP_C_TYPE_BACKEND, GcpCBackend);
	_clang_disposeIndex0 (self->priv->d_index);
	_g_object_unref0 (self->priv->d_compileArgs);
	_g_object_unref0 (self->priv->d_documentMap);
	G_OBJECT_CLASS (gcp_c_backend_parent_class)->finalize (obj);
}


GType gcp_c_backend_get_type (void) {
	return gcp_c_backend_type_id;
}


GType gcp_c_backend_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GcpCBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_c_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpCBackend), 0, (GInstanceInitFunc) gcp_c_backend_instance_init, NULL };
	gcp_c_backend_type_id = g_type_module_register_type (module, GCP_TYPE_BACKEND_IMPLEMENTATION, "GcpCBackend", &g_define_type_info, 0);
	return gcp_c_backend_type_id;
}


static void _vala_gcp_c_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcpCBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCP_C_TYPE_BACKEND, GcpCBackend);
	switch (property_id) {
		case GCP_C_BACKEND_INDEX:
		g_value_set_pointer (value, gcp_c_backend_get_index (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void peas_register_types (GTypeModule* module) {
	GTypeModule* _tmp0_;
	PeasObjectModule* _tmp1_;
	PeasObjectModule* mod;
	g_return_if_fail (module != NULL);
	gcp_c_backend_register_type (module);
	gcp_c_document_register_type (module);
	gcp_c_document_cursor_wrapper_register_type (module);
	gcp_c_compile_args_register_type (module);
	gcp_c_compile_args_cache_register_type (module);
	gcp_c_compile_args_makefile_register_type (module);
	gcp_c_translation_unit_register_type (module);
	gcp_c_semantic_value_register_type (module);
	gcp_c_semantic_value_translator_register_type (module);
	gcp_c_translator_register_type (module);
	_tmp0_ = module;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, peas_object_module_get_type ()) ? ((PeasObjectModule*) _tmp0_) : NULL);
	mod = _tmp1_;
	peas_object_module_register_extension_type (mod, GCP_TYPE_BACKEND, GCP_C_TYPE_BACKEND);
	_g_object_unref0 (mod);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



