/* gcp-scrollbar-marker.c generated by valac 0.19.0, the Vala compiler
 * generated from gcp-scrollbar-marker.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <cairo.h>
#include <gcp-utils-c.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define GCP_TYPE_SCROLLBAR_MARKER (gcp_scrollbar_marker_get_type ())
#define GCP_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarker))
#define GCP_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarkerClass))
#define GCP_IS_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SCROLLBAR_MARKER))
#define GCP_IS_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SCROLLBAR_MARKER))
#define GCP_SCROLLBAR_MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarkerClass))

typedef struct _GcpScrollbarMarker GcpScrollbarMarker;
typedef struct _GcpScrollbarMarkerClass GcpScrollbarMarkerClass;
typedef struct _GcpScrollbarMarkerPrivate GcpScrollbarMarkerPrivate;

#define GCP_SCROLLBAR_MARKER_TYPE_MARKER (gcp_scrollbar_marker_marker_get_type ())
#define GCP_SCROLLBAR_MARKER_MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_SCROLLBAR_MARKER_TYPE_MARKER, GcpScrollbarMarkerMarker))
#define GCP_SCROLLBAR_MARKER_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_SCROLLBAR_MARKER_TYPE_MARKER, GcpScrollbarMarkerMarkerClass))
#define GCP_SCROLLBAR_MARKER_IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_SCROLLBAR_MARKER_TYPE_MARKER))
#define GCP_SCROLLBAR_MARKER_IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_SCROLLBAR_MARKER_TYPE_MARKER))
#define GCP_SCROLLBAR_MARKER_MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_SCROLLBAR_MARKER_TYPE_MARKER, GcpScrollbarMarkerMarkerClass))

typedef struct _GcpScrollbarMarkerMarker GcpScrollbarMarkerMarker;
typedef struct _GcpScrollbarMarkerMarkerClass GcpScrollbarMarkerMarkerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GCP_TYPE_SOURCE_RANGE (gcp_source_range_get_type ())
#define GCP_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRange))
#define GCP_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))
#define GCP_IS_SOURCE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_RANGE))
#define GCP_IS_SOURCE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_RANGE))
#define GCP_SOURCE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_RANGE, GcpSourceRangeClass))

typedef struct _GcpSourceRange GcpSourceRange;
typedef struct _GcpSourceRangeClass GcpSourceRangeClass;
#define _gcp_scrollbar_marker_marker_unref0(var) ((var == NULL) ? NULL : (var = (gcp_scrollbar_marker_marker_unref (var), NULL)))

#define GCP_TYPE_SOURCE_LOCATION (gcp_source_location_get_type ())
#define GCP_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocation))
#define GCP_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))
#define GCP_IS_SOURCE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCP_TYPE_SOURCE_LOCATION))
#define GCP_IS_SOURCE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCP_TYPE_SOURCE_LOCATION))
#define GCP_SOURCE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCP_TYPE_SOURCE_LOCATION, GcpSourceLocationClass))

typedef struct _GcpSourceLocation GcpSourceLocation;
typedef struct _GcpSourceLocationClass GcpSourceLocationClass;
typedef struct _GcpScrollbarMarkerMarkerPrivate GcpScrollbarMarkerMarkerPrivate;
typedef struct _GcpScrollbarMarkerParamSpecMarker GcpScrollbarMarkerParamSpecMarker;
typedef struct _GcpParamSpecScrollbarMarker GcpParamSpecScrollbarMarker;

struct _GcpScrollbarMarker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GcpScrollbarMarkerPrivate * priv;
};

struct _GcpScrollbarMarkerClass {
	GTypeClass parent_class;
	void (*finalize) (GcpScrollbarMarker *self);
};

struct _GcpScrollbarMarkerPrivate {
	GtkScrollbar* d_scrollbar;
	GeeHashMap* d_markers;
	gint d_spacing;
	gint d_maxline;
	gint d_border;
	gint d_width;
	guint d_mergeId;
};

struct _GcpScrollbarMarkerMarker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GcpScrollbarMarkerMarkerPrivate * priv;
};

struct _GcpScrollbarMarkerMarkerClass {
	GTypeClass parent_class;
	void (*finalize) (GcpScrollbarMarkerMarker *self);
};

struct _GcpScrollbarMarkerMarkerPrivate {
	GdkRGBA d_color;
	GcpSourceRange* d_range;
};

struct _GcpScrollbarMarkerParamSpecMarker {
	GParamSpec parent_instance;
};

struct _GcpParamSpecScrollbarMarker {
	GParamSpec parent_instance;
};


static gpointer gcp_scrollbar_marker_parent_class = NULL;
static gpointer gcp_scrollbar_marker_marker_parent_class = NULL;

gpointer gcp_scrollbar_marker_ref (gpointer instance);
void gcp_scrollbar_marker_unref (gpointer instance);
GParamSpec* gcp_param_spec_scrollbar_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_value_set_scrollbar_marker (GValue* value, gpointer v_object);
void gcp_value_take_scrollbar_marker (GValue* value, gpointer v_object);
gpointer gcp_value_get_scrollbar_marker (const GValue* value);
GType gcp_scrollbar_marker_get_type (void) G_GNUC_CONST;
gpointer gcp_scrollbar_marker_marker_ref (gpointer instance);
void gcp_scrollbar_marker_marker_unref (gpointer instance);
GParamSpec* gcp_scrollbar_marker_param_spec_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gcp_scrollbar_marker_value_set_marker (GValue* value, gpointer v_object);
void gcp_scrollbar_marker_value_take_marker (GValue* value, gpointer v_object);
gpointer gcp_scrollbar_marker_value_get_marker (const GValue* value);
GType gcp_scrollbar_marker_marker_get_type (void) G_GNUC_CONST;
#define GCP_SCROLLBAR_MARKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarkerPrivate))
enum  {
	GCP_SCROLLBAR_MARKER_DUMMY_PROPERTY
};
static gboolean gcp_scrollbar_marker_on_scrollbar_draw (GcpScrollbarMarker* self, cairo_t* ctx);
static gboolean _gcp_scrollbar_marker_on_scrollbar_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
GcpScrollbarMarker* gcp_scrollbar_marker_new (GtkScrollbar* scrollbar);
GcpScrollbarMarker* gcp_scrollbar_marker_construct (GType object_type, GtkScrollbar* scrollbar);
static void gcp_scrollbar_marker_on_style_updated (GcpScrollbarMarker* self);
static void _gcp_scrollbar_marker_on_style_updated_gtk_widget_style_updated (GtkWidget* _sender, gpointer self);
static void gcp_scrollbar_marker_update_spacing (GcpScrollbarMarker* self);
guint gcp_scrollbar_marker_new_merge_id (GcpScrollbarMarker* self);
GType gcp_source_range_get_type (void) G_GNUC_CONST;
void gcp_scrollbar_marker_add_with_id (GcpScrollbarMarker* self, guint id, GcpSourceRange* range, GdkRGBA* color);
GcpScrollbarMarkerMarker* gcp_scrollbar_marker_marker_new (GcpSourceRange* range, GdkRGBA* color);
GcpScrollbarMarkerMarker* gcp_scrollbar_marker_marker_construct (GType object_type, GcpSourceRange* range, GdkRGBA* color);
guint gcp_scrollbar_marker_add (GcpScrollbarMarker* self, GcpSourceRange* range, GdkRGBA* color);
void gcp_scrollbar_marker_remove (GcpScrollbarMarker* self, guint id);
void gcp_scrollbar_marker_clear (GcpScrollbarMarker* self);
static void gcp_scrollbar_marker_draw_marker (GcpScrollbarMarker* self, cairo_t* ctx, GdkRectangle* rect, GcpScrollbarMarkerMarker* marker);
GcpSourceRange* gcp_scrollbar_marker_marker_get_range (GcpScrollbarMarkerMarker* self);
GType gcp_source_location_get_type (void) G_GNUC_CONST;
GcpSourceLocation* gcp_source_range_get_end (GcpSourceRange* self);
gint gcp_source_location_get_line (GcpSourceLocation* self);
GcpSourceLocation* gcp_source_range_get_start (GcpSourceRange* self);
void gcp_scrollbar_marker_marker_get_color (GcpScrollbarMarkerMarker* self, GdkRGBA* result);
gint gcp_scrollbar_marker_get_max_line (GcpScrollbarMarker* self);
void gcp_scrollbar_marker_set_max_line (GcpScrollbarMarker* self, gint value);
GtkScrollbar* gcp_scrollbar_marker_get_scrollbar (GcpScrollbarMarker* self);
#define GCP_SCROLLBAR_MARKER_MARKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCP_SCROLLBAR_MARKER_TYPE_MARKER, GcpScrollbarMarkerMarkerPrivate))
enum  {
	GCP_SCROLLBAR_MARKER_MARKER_DUMMY_PROPERTY
};
static void gcp_scrollbar_marker_marker_finalize (GcpScrollbarMarkerMarker* obj);
static void gcp_scrollbar_marker_finalize (GcpScrollbarMarker* obj);


static gboolean _gcp_scrollbar_marker_on_scrollbar_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = gcp_scrollbar_marker_on_scrollbar_draw (self, cr);
	return result;
}


static void _gcp_scrollbar_marker_on_style_updated_gtk_widget_style_updated (GtkWidget* _sender, gpointer self) {
	gcp_scrollbar_marker_on_style_updated (self);
}


GcpScrollbarMarker* gcp_scrollbar_marker_construct (GType object_type, GtkScrollbar* scrollbar) {
	GcpScrollbarMarker* self = NULL;
	GtkScrollbar* _tmp0_;
	GtkScrollbar* _tmp1_;
	GeeHashMap* _tmp2_;
	GtkScrollbar* _tmp3_;
	g_return_val_if_fail (scrollbar != NULL, NULL);
	self = (GcpScrollbarMarker*) g_type_create_instance (object_type);
	_tmp0_ = scrollbar;
	self->priv->d_scrollbar = _tmp0_;
	_tmp1_ = self->priv->d_scrollbar;
	g_signal_connect_after ((GtkWidget*) _tmp1_, "draw", (GCallback) _gcp_scrollbar_marker_on_scrollbar_draw_gtk_widget_draw, self);
	_tmp2_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GEE_TYPE_LINKED_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_markers);
	self->priv->d_markers = _tmp2_;
	self->priv->d_maxline = 0;
	_tmp3_ = self->priv->d_scrollbar;
	g_signal_connect ((GtkWidget*) _tmp3_, "style-updated", (GCallback) _gcp_scrollbar_marker_on_style_updated_gtk_widget_style_updated, self);
	gcp_scrollbar_marker_update_spacing (self);
	return self;
}


GcpScrollbarMarker* gcp_scrollbar_marker_new (GtkScrollbar* scrollbar) {
	return gcp_scrollbar_marker_construct (GCP_TYPE_SCROLLBAR_MARKER, scrollbar);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gcp_scrollbar_marker_update_spacing (GcpScrollbarMarker* self) {
	GtkScrollbar* _tmp0_;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* ctx;
	gint _tmp3_ = 0;
	gint stepper_size;
	gint _tmp4_ = 0;
	gint stepper_spacing;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_scrollbar;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ctx = _tmp2_;
	_tmp3_ = gcp_utils_c_get_style_property_int (ctx, "stepper-size");
	stepper_size = _tmp3_;
	_tmp4_ = gcp_utils_c_get_style_property_int (ctx, "stepper-spacing");
	stepper_spacing = _tmp4_;
	_tmp5_ = gcp_utils_c_get_style_property_int (ctx, "trough-border");
	self->priv->d_border = _tmp5_;
	_tmp6_ = gcp_utils_c_get_style_property_int (ctx, "slider-width");
	self->priv->d_width = _tmp6_;
	self->priv->d_spacing = (stepper_size + stepper_spacing) + 2;
	_g_object_unref0 (ctx);
}


static void gcp_scrollbar_marker_on_style_updated (GcpScrollbarMarker* self) {
	g_return_if_fail (self != NULL);
	gcp_scrollbar_marker_update_spacing (self);
}


guint gcp_scrollbar_marker_new_merge_id (GcpScrollbarMarker* self) {
	guint result = 0U;
	guint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->d_mergeId;
	self->priv->d_mergeId = _tmp0_ + 1;
	_tmp1_ = self->priv->d_mergeId;
	result = _tmp1_;
	return result;
}


void gcp_scrollbar_marker_add_with_id (GcpScrollbarMarker* self, guint id, GcpSourceRange* range, GdkRGBA* color) {
	GcpSourceRange* _tmp0_;
	GdkRGBA _tmp1_;
	GcpScrollbarMarkerMarker* _tmp2_;
	GcpScrollbarMarkerMarker* marker;
	GeeLinkedList* lst = NULL;
	GeeHashMap* _tmp3_;
	guint _tmp4_;
	gboolean _tmp5_ = FALSE;
	GeeLinkedList* _tmp13_;
	GcpScrollbarMarkerMarker* _tmp14_;
	GtkScrollbar* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (range != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = range;
	_tmp1_ = *color;
	_tmp2_ = gcp_scrollbar_marker_marker_new (_tmp0_, &_tmp1_);
	marker = _tmp2_;
	_tmp3_ = self->priv->d_markers;
	_tmp4_ = id;
	_tmp5_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp3_, (gpointer) ((guintptr) _tmp4_));
	if (_tmp5_) {
		GeeHashMap* _tmp6_;
		guint _tmp7_;
		gpointer _tmp8_ = NULL;
		_tmp6_ = self->priv->d_markers;
		_tmp7_ = id;
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, (gpointer) ((guintptr) _tmp7_));
		_g_object_unref0 (lst);
		lst = (GeeLinkedList*) _tmp8_;
	} else {
		GeeLinkedList* _tmp9_;
		GeeHashMap* _tmp10_;
		guint _tmp11_;
		GeeLinkedList* _tmp12_;
		_tmp9_ = gee_linked_list_new (GCP_SCROLLBAR_MARKER_TYPE_MARKER, (GBoxedCopyFunc) gcp_scrollbar_marker_marker_ref, gcp_scrollbar_marker_marker_unref, NULL);
		_g_object_unref0 (lst);
		lst = _tmp9_;
		_tmp10_ = self->priv->d_markers;
		_tmp11_ = id;
		_tmp12_ = lst;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, (gpointer) ((guintptr) _tmp11_), _tmp12_);
	}
	_tmp13_ = lst;
	_tmp14_ = marker;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
	_tmp15_ = self->priv->d_scrollbar;
	gtk_widget_queue_draw ((GtkWidget*) _tmp15_);
	_g_object_unref0 (lst);
	_gcp_scrollbar_marker_marker_unref0 (marker);
}


guint gcp_scrollbar_marker_add (GcpScrollbarMarker* self, GcpSourceRange* range, GdkRGBA* color) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	guint id;
	GcpSourceRange* _tmp1_;
	GdkRGBA _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (range != NULL, 0U);
	g_return_val_if_fail (color != NULL, 0U);
	_tmp0_ = gcp_scrollbar_marker_new_merge_id (self);
	id = _tmp0_;
	_tmp1_ = range;
	_tmp2_ = *color;
	gcp_scrollbar_marker_add_with_id (self, id, _tmp1_, &_tmp2_);
	result = id;
	return result;
}


void gcp_scrollbar_marker_remove (GcpScrollbarMarker* self, guint id) {
	GeeHashMap* _tmp0_;
	guint _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeHashMap* _tmp3_;
	guint _tmp4_;
	GtkScrollbar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_markers;
	_tmp1_ = id;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((guintptr) _tmp1_));
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->d_markers;
	_tmp4_ = id;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, (gpointer) ((guintptr) _tmp4_), NULL);
	_tmp5_ = self->priv->d_scrollbar;
	gtk_widget_queue_draw ((GtkWidget*) _tmp5_);
}


void gcp_scrollbar_marker_clear (GcpScrollbarMarker* self) {
	GeeHashMap* _tmp0_;
	GtkScrollbar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_markers;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	self->priv->d_mergeId = (guint) 0;
	_tmp1_ = self->priv->d_scrollbar;
	gtk_widget_queue_draw ((GtkWidget*) _tmp1_);
}


static void gcp_scrollbar_marker_draw_marker (GcpScrollbarMarker* self, cairo_t* ctx, GdkRectangle* rect, GcpScrollbarMarkerMarker* marker) {
	GcpScrollbarMarkerMarker* _tmp0_;
	GcpSourceRange* _tmp1_;
	GcpSourceRange* _tmp2_;
	GcpSourceRange* _tmp3_;
	GcpSourceRange* range;
	GcpSourceRange* _tmp4_;
	GcpSourceLocation* _tmp5_;
	GcpSourceLocation* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GcpSourceRange* _tmp9_;
	GcpSourceLocation* _tmp10_;
	GcpSourceLocation* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	guint height;
	GdkRectangle _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gdouble scale;
	GdkRectangle _tmp17_;
	gint _tmp18_;
	GcpSourceRange* _tmp19_;
	GcpSourceLocation* _tmp20_;
	GcpSourceLocation* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_ = 0.0;
	gdouble y;
	guint _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_ = 0.0;
	gdouble _tmp29_ = 0.0;
	gdouble dy;
	cairo_t* _tmp30_;
	GcpScrollbarMarkerMarker* _tmp31_;
	GdkRGBA _tmp32_;
	GdkRGBA _tmp33_;
	cairo_t* _tmp34_;
	gdouble _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (rect != NULL);
	g_return_if_fail (marker != NULL);
	_tmp0_ = marker;
	_tmp1_ = gcp_scrollbar_marker_marker_get_range (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	range = _tmp3_;
	_tmp4_ = range;
	_tmp5_ = gcp_source_range_get_end (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gcp_source_location_get_line (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = range;
	_tmp10_ = gcp_source_range_get_start (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gcp_source_location_get_line (_tmp11_);
	_tmp13_ = _tmp12_;
	height = (guint) ((_tmp8_ - _tmp13_) + 1);
	_tmp14_ = *rect;
	_tmp15_ = _tmp14_.height;
	_tmp16_ = self->priv->d_maxline;
	scale = ((gdouble) _tmp15_) / ((gdouble) _tmp16_);
	_tmp17_ = *rect;
	_tmp18_ = _tmp17_.y;
	_tmp19_ = range;
	_tmp20_ = gcp_source_range_get_start (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = gcp_source_location_get_line (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = scale;
	_tmp25_ = round ((_tmp18_ + ((_tmp23_ - 1) * _tmp24_)) - 0.5);
	y = _tmp25_ + 0.5;
	_tmp26_ = height;
	_tmp27_ = scale;
	_tmp28_ = round (_tmp26_ * _tmp27_);
	_tmp29_ = fmax ((gdouble) 1, _tmp28_);
	dy = _tmp29_;
	_tmp30_ = ctx;
	_tmp31_ = marker;
	gcp_scrollbar_marker_marker_get_color (_tmp31_, &_tmp32_);
	_tmp33_ = _tmp32_;
	gdk_cairo_set_source_rgba (_tmp30_, &_tmp33_);
	_tmp34_ = ctx;
	cairo_set_line_width (_tmp34_, (gdouble) 1);
	_tmp35_ = dy;
	if (_tmp35_ > 1.5) {
		cairo_t* _tmp36_;
		GdkRectangle _tmp37_;
		gint _tmp38_;
		gdouble _tmp39_;
		GdkRectangle _tmp40_;
		gint _tmp41_;
		gdouble _tmp42_;
		cairo_t* _tmp43_;
		_tmp36_ = ctx;
		_tmp37_ = *rect;
		_tmp38_ = _tmp37_.x;
		_tmp39_ = y;
		_tmp40_ = *rect;
		_tmp41_ = _tmp40_.width;
		_tmp42_ = dy;
		cairo_rectangle (_tmp36_, _tmp38_ + 0.5, _tmp39_, (gdouble) (_tmp41_ - 1), _tmp42_);
		_tmp43_ = ctx;
		cairo_fill (_tmp43_);
	} else {
		cairo_t* _tmp44_;
		GdkRectangle _tmp45_;
		gint _tmp46_;
		gdouble _tmp47_;
		cairo_t* _tmp48_;
		GdkRectangle _tmp49_;
		gint _tmp50_;
		GdkRectangle _tmp51_;
		gint _tmp52_;
		gdouble _tmp53_;
		cairo_t* _tmp54_;
		_tmp44_ = ctx;
		_tmp45_ = *rect;
		_tmp46_ = _tmp45_.x;
		_tmp47_ = y;
		cairo_move_to (_tmp44_, _tmp46_ + 0.5, _tmp47_);
		_tmp48_ = ctx;
		_tmp49_ = *rect;
		_tmp50_ = _tmp49_.x;
		_tmp51_ = *rect;
		_tmp52_ = _tmp51_.width;
		_tmp53_ = y;
		cairo_line_to (_tmp48_, ((_tmp50_ + 0.5) + _tmp52_) - 1, _tmp53_);
		_tmp54_ = ctx;
		cairo_stroke (_tmp54_);
	}
	_g_object_unref0 (range);
}


static gboolean gcp_scrollbar_marker_on_scrollbar_draw (GcpScrollbarMarker* self, cairo_t* ctx) {
	gboolean result = FALSE;
	GdkRectangle range = {0};
	GtkScrollbar* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->priv->d_scrollbar;
	gtk_range_get_range_rect ((GtkRange*) _tmp0_, &_tmp1_);
	range = _tmp1_;
	_tmp2_ = range.x;
	_tmp3_ = self->priv->d_border;
	range.x = _tmp2_ + _tmp3_;
	_tmp4_ = self->priv->d_width;
	range.width = _tmp4_;
	_tmp5_ = range.y;
	_tmp6_ = self->priv->d_spacing;
	range.y = _tmp5_ + _tmp6_;
	_tmp7_ = range.height;
	_tmp8_ = self->priv->d_spacing;
	range.height = _tmp7_ - (2 * _tmp8_);
	{
		GeeHashMap* _tmp9_;
		GeeSet* _tmp10_;
		GeeSet* _tmp11_;
		GeeSet* _tmp12_;
		GeeIterator* _tmp13_ = NULL;
		GeeIterator* _tmp14_;
		GeeIterator* _key_it;
		_tmp9_ = self->priv->d_markers;
		_tmp10_ = gee_abstract_map_get_keys ((GeeMap*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_key_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			gboolean _tmp16_ = FALSE;
			GeeIterator* _tmp17_;
			gpointer _tmp18_ = NULL;
			guint key;
			GeeHashMap* _tmp19_;
			guint _tmp20_;
			gpointer _tmp21_ = NULL;
			GeeLinkedList* lst;
			_tmp15_ = _key_it;
			_tmp16_ = gee_iterator_next (_tmp15_);
			if (!_tmp16_) {
				break;
			}
			_tmp17_ = _key_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			key = (guint) ((guintptr) _tmp18_);
			_tmp19_ = self->priv->d_markers;
			_tmp20_ = key;
			_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, (gpointer) ((guintptr) _tmp20_));
			lst = (GeeLinkedList*) _tmp21_;
			{
				GeeLinkedList* _tmp22_;
				GeeLinkedList* _tmp23_;
				GeeLinkedList* _marker_list;
				GeeLinkedList* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gint _marker_size;
				gint _marker_index;
				_tmp22_ = lst;
				_tmp23_ = _g_object_ref0 (_tmp22_);
				_marker_list = _tmp23_;
				_tmp24_ = _marker_list;
				_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
				_tmp26_ = _tmp25_;
				_marker_size = _tmp26_;
				_marker_index = -1;
				while (TRUE) {
					gint _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					GeeLinkedList* _tmp30_;
					gint _tmp31_;
					gpointer _tmp32_ = NULL;
					GcpScrollbarMarkerMarker* marker;
					cairo_t* _tmp33_;
					GdkRectangle _tmp34_;
					GcpScrollbarMarkerMarker* _tmp35_;
					_tmp27_ = _marker_index;
					_marker_index = _tmp27_ + 1;
					_tmp28_ = _marker_index;
					_tmp29_ = _marker_size;
					if (!(_tmp28_ < _tmp29_)) {
						break;
					}
					_tmp30_ = _marker_list;
					_tmp31_ = _marker_index;
					_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
					marker = (GcpScrollbarMarkerMarker*) _tmp32_;
					_tmp33_ = ctx;
					_tmp34_ = range;
					_tmp35_ = marker;
					gcp_scrollbar_marker_draw_marker (self, _tmp33_, &_tmp34_, _tmp35_);
					_gcp_scrollbar_marker_marker_unref0 (marker);
				}
				_g_object_unref0 (_marker_list);
			}
			_g_object_unref0 (lst);
		}
		_g_object_unref0 (_key_it);
	}
	result = FALSE;
	return result;
}


gint gcp_scrollbar_marker_get_max_line (GcpScrollbarMarker* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->d_maxline;
	result = _tmp0_;
	return result;
}


void gcp_scrollbar_marker_set_max_line (GcpScrollbarMarker* self, gint value) {
	gint _tmp0_;
	GtkScrollbar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->d_maxline = _tmp0_;
	_tmp1_ = self->priv->d_scrollbar;
	gtk_widget_queue_draw ((GtkWidget*) _tmp1_);
}


GtkScrollbar* gcp_scrollbar_marker_get_scrollbar (GcpScrollbarMarker* self) {
	GtkScrollbar* result;
	GtkScrollbar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_scrollbar;
	result = _tmp0_;
	return result;
}


GcpScrollbarMarkerMarker* gcp_scrollbar_marker_marker_construct (GType object_type, GcpSourceRange* range, GdkRGBA* color) {
	GcpScrollbarMarkerMarker* self = NULL;
	GdkRGBA _tmp0_;
	GcpSourceRange* _tmp1_;
	GcpSourceRange* _tmp2_;
	g_return_val_if_fail (range != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	self = (GcpScrollbarMarkerMarker*) g_type_create_instance (object_type);
	_tmp0_ = *color;
	self->priv->d_color = _tmp0_;
	_tmp1_ = range;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->d_range);
	self->priv->d_range = _tmp2_;
	return self;
}


GcpScrollbarMarkerMarker* gcp_scrollbar_marker_marker_new (GcpSourceRange* range, GdkRGBA* color) {
	return gcp_scrollbar_marker_marker_construct (GCP_SCROLLBAR_MARKER_TYPE_MARKER, range, color);
}


GcpSourceRange* gcp_scrollbar_marker_marker_get_range (GcpScrollbarMarkerMarker* self) {
	GcpSourceRange* result;
	GcpSourceRange* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_range;
	result = _tmp0_;
	return result;
}


void gcp_scrollbar_marker_marker_get_color (GcpScrollbarMarkerMarker* self, GdkRGBA* result) {
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_color;
	*result = _tmp0_;
	return;
}


static void gcp_scrollbar_marker_value_marker_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gcp_scrollbar_marker_value_marker_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gcp_scrollbar_marker_marker_unref (value->data[0].v_pointer);
	}
}


static void gcp_scrollbar_marker_value_marker_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gcp_scrollbar_marker_marker_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gcp_scrollbar_marker_value_marker_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gcp_scrollbar_marker_value_marker_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GcpScrollbarMarkerMarker* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gcp_scrollbar_marker_marker_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gcp_scrollbar_marker_value_marker_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GcpScrollbarMarkerMarker** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gcp_scrollbar_marker_marker_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gcp_scrollbar_marker_param_spec_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GcpScrollbarMarkerParamSpecMarker* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GCP_SCROLLBAR_MARKER_TYPE_MARKER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gcp_scrollbar_marker_value_get_marker (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_SCROLLBAR_MARKER_TYPE_MARKER), NULL);
	return value->data[0].v_pointer;
}


void gcp_scrollbar_marker_value_set_marker (GValue* value, gpointer v_object) {
	GcpScrollbarMarkerMarker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_SCROLLBAR_MARKER_TYPE_MARKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_SCROLLBAR_MARKER_TYPE_MARKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gcp_scrollbar_marker_marker_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_scrollbar_marker_marker_unref (old);
	}
}


void gcp_scrollbar_marker_value_take_marker (GValue* value, gpointer v_object) {
	GcpScrollbarMarkerMarker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_SCROLLBAR_MARKER_TYPE_MARKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_SCROLLBAR_MARKER_TYPE_MARKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_scrollbar_marker_marker_unref (old);
	}
}


static void gcp_scrollbar_marker_marker_class_init (GcpScrollbarMarkerMarkerClass * klass) {
	gcp_scrollbar_marker_marker_parent_class = g_type_class_peek_parent (klass);
	GCP_SCROLLBAR_MARKER_MARKER_CLASS (klass)->finalize = gcp_scrollbar_marker_marker_finalize;
	g_type_class_add_private (klass, sizeof (GcpScrollbarMarkerMarkerPrivate));
}


static void gcp_scrollbar_marker_marker_instance_init (GcpScrollbarMarkerMarker * self) {
	self->priv = GCP_SCROLLBAR_MARKER_MARKER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gcp_scrollbar_marker_marker_finalize (GcpScrollbarMarkerMarker* obj) {
	GcpScrollbarMarkerMarker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCP_SCROLLBAR_MARKER_TYPE_MARKER, GcpScrollbarMarkerMarker);
	_g_object_unref0 (self->priv->d_range);
}


GType gcp_scrollbar_marker_marker_get_type (void) {
	static volatile gsize gcp_scrollbar_marker_marker_type_id__volatile = 0;
	if (g_once_init_enter (&gcp_scrollbar_marker_marker_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gcp_scrollbar_marker_value_marker_init, gcp_scrollbar_marker_value_marker_free_value, gcp_scrollbar_marker_value_marker_copy_value, gcp_scrollbar_marker_value_marker_peek_pointer, "p", gcp_scrollbar_marker_value_marker_collect_value, "p", gcp_scrollbar_marker_value_marker_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GcpScrollbarMarkerMarkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_scrollbar_marker_marker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpScrollbarMarkerMarker), 0, (GInstanceInitFunc) gcp_scrollbar_marker_marker_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gcp_scrollbar_marker_marker_type_id;
		gcp_scrollbar_marker_marker_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GcpScrollbarMarkerMarker", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gcp_scrollbar_marker_marker_type_id__volatile, gcp_scrollbar_marker_marker_type_id);
	}
	return gcp_scrollbar_marker_marker_type_id__volatile;
}


gpointer gcp_scrollbar_marker_marker_ref (gpointer instance) {
	GcpScrollbarMarkerMarker* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gcp_scrollbar_marker_marker_unref (gpointer instance) {
	GcpScrollbarMarkerMarker* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GCP_SCROLLBAR_MARKER_MARKER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void gcp_value_scrollbar_marker_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gcp_value_scrollbar_marker_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gcp_scrollbar_marker_unref (value->data[0].v_pointer);
	}
}


static void gcp_value_scrollbar_marker_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gcp_scrollbar_marker_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gcp_value_scrollbar_marker_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gcp_value_scrollbar_marker_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GcpScrollbarMarker* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gcp_scrollbar_marker_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gcp_value_scrollbar_marker_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GcpScrollbarMarker** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gcp_scrollbar_marker_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gcp_param_spec_scrollbar_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GcpParamSpecScrollbarMarker* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GCP_TYPE_SCROLLBAR_MARKER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gcp_value_get_scrollbar_marker (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_TYPE_SCROLLBAR_MARKER), NULL);
	return value->data[0].v_pointer;
}


void gcp_value_set_scrollbar_marker (GValue* value, gpointer v_object) {
	GcpScrollbarMarker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_TYPE_SCROLLBAR_MARKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_TYPE_SCROLLBAR_MARKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gcp_scrollbar_marker_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_scrollbar_marker_unref (old);
	}
}


void gcp_value_take_scrollbar_marker (GValue* value, gpointer v_object) {
	GcpScrollbarMarker* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GCP_TYPE_SCROLLBAR_MARKER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GCP_TYPE_SCROLLBAR_MARKER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gcp_scrollbar_marker_unref (old);
	}
}


static void gcp_scrollbar_marker_class_init (GcpScrollbarMarkerClass * klass) {
	gcp_scrollbar_marker_parent_class = g_type_class_peek_parent (klass);
	GCP_SCROLLBAR_MARKER_CLASS (klass)->finalize = gcp_scrollbar_marker_finalize;
	g_type_class_add_private (klass, sizeof (GcpScrollbarMarkerPrivate));
}


static void gcp_scrollbar_marker_instance_init (GcpScrollbarMarker * self) {
	self->priv = GCP_SCROLLBAR_MARKER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gcp_scrollbar_marker_finalize (GcpScrollbarMarker* obj) {
	GcpScrollbarMarker * self;
	GtkScrollbar* _tmp0_;
	GtkScrollbar* _tmp1_;
	guint _tmp2_ = 0U;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCP_TYPE_SCROLLBAR_MARKER, GcpScrollbarMarker);
	_tmp0_ = self->priv->d_scrollbar;
	if (_tmp0_ == NULL) {
		goto _return;
	}
	_tmp1_ = self->priv->d_scrollbar;
	g_signal_parse_name ("draw", GTK_TYPE_WIDGET, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _gcp_scrollbar_marker_on_scrollbar_draw_gtk_widget_draw, self);
	_return:
	_g_object_unref0 (self->priv->d_markers);
}


GType gcp_scrollbar_marker_get_type (void) {
	static volatile gsize gcp_scrollbar_marker_type_id__volatile = 0;
	if (g_once_init_enter (&gcp_scrollbar_marker_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gcp_value_scrollbar_marker_init, gcp_value_scrollbar_marker_free_value, gcp_value_scrollbar_marker_copy_value, gcp_value_scrollbar_marker_peek_pointer, "p", gcp_value_scrollbar_marker_collect_value, "p", gcp_value_scrollbar_marker_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GcpScrollbarMarkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gcp_scrollbar_marker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcpScrollbarMarker), 0, (GInstanceInitFunc) gcp_scrollbar_marker_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gcp_scrollbar_marker_type_id;
		gcp_scrollbar_marker_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GcpScrollbarMarker", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gcp_scrollbar_marker_type_id__volatile, gcp_scrollbar_marker_type_id);
	}
	return gcp_scrollbar_marker_type_id__volatile;
}


gpointer gcp_scrollbar_marker_ref (gpointer instance) {
	GcpScrollbarMarker* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gcp_scrollbar_marker_unref (gpointer instance) {
	GcpScrollbarMarker* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GCP_SCROLLBAR_MARKER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



