/* gca-document.c generated by valac 0.20.1, the Vala compiler
 * generated from gca-document.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-document.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include <gio/gunixoutputstream.h>


#define GCA_TYPE_DOCUMENT (gca_document_get_type ())
#define GCA_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DOCUMENT, GcaDocument))
#define GCA_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DOCUMENT, GcaDocumentClass))
#define GCA_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DOCUMENT))
#define GCA_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DOCUMENT))
#define GCA_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DOCUMENT, GcaDocumentClass))

typedef struct _GcaDocument GcaDocument;
typedef struct _GcaDocumentClass GcaDocumentClass;
typedef struct _GcaDocumentPrivate GcaDocumentPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GcaDocumentUnsavedDataPathData GcaDocumentUnsavedDataPathData;

#define GCA_TYPE_SOURCE_LOCATION (gca_source_location_get_type ())
typedef struct _GcaSourceLocation GcaSourceLocation;

struct _GcaDocument {
	GObject parent_instance;
	GcaDocumentPrivate * priv;
};

struct _GcaDocumentClass {
	GObjectClass parent_class;
};

struct _GcaDocumentPrivate {
	GeditDocument* d_document;
	gboolean d_untitled;
	gboolean d_modified;
	gchar* d_text;
	GFile* d_location;
	gboolean d_dispose_ran;
	gchar* d_path;
	GFile* d_unsaved_file;
};

struct _GcaDocumentUnsavedDataPathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GcaDocument* self;
	gchar* result;
	gboolean _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* orig;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint idx;
	gchar* filename;
	gint _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* cdir;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* tmpdir;
	const gchar* _tmp22_;
	GFile* _tmp23_;
	GFile* f;
	GFile* _tmp24_;
	GError* e;
	GError* _tmp25_;
	GError* _tmp26_;
	GError* _tmp27_;
	gboolean _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* tmpfilename;
	const gchar* _tmp33_;
	gint _tmp34_;
	gint tmpfile;
	gint _tmp35_;
	GUnixOutputStream* _tmp36_;
	GUnixOutputStream* ostream;
	GUnixOutputStream* _tmp37_;
	const gchar* _tmp38_;
	guint8* _tmp39_;
	gint _tmp39__length1;
	guint8* _tmp40_;
	gint _tmp40__length1;
	guint8* _tmp41_;
	guint8* b;
	gint b_length1;
	gint _b_size_;
	GUnixOutputStream* _tmp42_;
	guint8* _tmp43_;
	gint _tmp43__length1;
	GError* _vala1_e;
	GFile* _tmp44_;
	GUnixOutputStream* _tmp45_;
	GError* _tmp46_;
	GError* _tmp47_;
	GUnixOutputStream* _tmp48_;
	const gchar* _tmp49_;
	GFile* _tmp50_;
	GFile* _tmp51_;
	gchar* _tmp52_;
	GError * _inner_error_;
};

struct _GcaSourceLocation {
	gint line;
	gint column;
};


static gpointer gca_document_parent_class = NULL;
static gboolean gca_document_s_needs_tmp_chmod;
static gboolean gca_document_s_needs_tmp_chmod = TRUE;

GType gca_document_get_type (void) G_GNUC_CONST;
#define GCA_DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_DOCUMENT, GcaDocumentPrivate))
enum  {
	GCA_DOCUMENT_DUMMY_PROPERTY,
	GCA_DOCUMENT_DOCUMENT,
	GCA_DOCUMENT_LOCATION,
	GCA_DOCUMENT_TEXT,
	GCA_DOCUMENT_IS_MODIFIED,
	GCA_DOCUMENT_CURSOR,
	GCA_DOCUMENT_PATH
};
GcaDocument* gca_document_new (GeditDocument* document);
GcaDocument* gca_document_construct (GType object_type, GeditDocument* document);
static void gca_document_update_modified (GcaDocument* self);
static void gca_document_on_document_modified_changed (GcaDocument* self);
static void _gca_document_on_document_modified_changed_gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self);
static void gca_document_on_document_end_user_action (GcaDocument* self);
static void _gca_document_on_document_end_user_action_gtk_text_buffer_end_user_action (GtkTextBuffer* _sender, gpointer self);
static void gca_document_on_location_changed (GcaDocument* self);
static void _gca_document_on_location_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gca_document_on_shortname_changed (GcaDocument* self);
static void _gca_document_on_shortname_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gca_document_on_document_saved (GcaDocument* self);
static void _gca_document_on_document_saved_gedit_document_saved (GeditDocument* _sender, GError* _error_, gpointer self);
static void gca_document_update_location (GcaDocument* self);
static void gca_document_real_dispose (GObject* base);
static void gca_document_clear_unsaved_file (GcaDocument* self);
static void gca_document_update_path (GcaDocument* self);
gchar* gca_document_get_path (GcaDocument* self);
GeditDocument* gca_document_get_document (GcaDocument* self);
static void gca_document_update_text (GcaDocument* self);
void gca_document_emit_changed (GcaDocument* self);
static void gca_document_unsaved_data_path_data_free (gpointer _data);
void gca_document_unsaved_data_path (GcaDocument* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* gca_document_unsaved_data_path_finish (GcaDocument* self, GAsyncResult* _res_, GError** error);
static gboolean gca_document_unsaved_data_path_co (GcaDocumentUnsavedDataPathData* _data_);
static void gca_document_unsaved_data_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GFile* gca_document_get_location (GcaDocument* self);
const gchar* gca_document_get_text (GcaDocument* self);
gboolean gca_document_get_is_modified (GcaDocument* self);
GType gca_source_location_get_type (void) G_GNUC_CONST;
GcaSourceLocation* gca_source_location_dup (const GcaSourceLocation* self);
void gca_source_location_free (GcaSourceLocation* self);
void gca_document_get_cursor (GcaDocument* self, GcaSourceLocation* result);
static void gca_document_finalize (GObject* obj);
static void _vala_gca_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	return self ? g_object_ref (self) : NULL;
#line 214 "gca-document.c"
}


static void _gca_document_on_document_modified_changed_gtk_text_buffer_modified_changed (GtkTextBuffer* _sender, gpointer self) {
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_on_document_modified_changed (self);
#line 221 "gca-document.c"
}


static void _gca_document_on_document_end_user_action_gtk_text_buffer_end_user_action (GtkTextBuffer* _sender, gpointer self) {
#line 59 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_on_document_end_user_action (self);
#line 228 "gca-document.c"
}


static void _gca_document_on_location_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 60 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_on_location_changed (self);
#line 235 "gca-document.c"
}


static void _gca_document_on_shortname_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_on_shortname_changed (self);
#line 242 "gca-document.c"
}


static void _gca_document_on_document_saved_gedit_document_saved (GeditDocument* _sender, GError* _error_, gpointer self) {
#line 62 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_on_document_saved (self);
#line 249 "gca-document.c"
}


GcaDocument* gca_document_construct (GType object_type, GeditDocument* document) {
	GcaDocument * self = NULL;
	GeditDocument* _tmp0_;
	GeditDocument* _tmp1_;
	GeditDocument* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeditDocument* _tmp4_;
	GeditDocument* _tmp5_;
	GeditDocument* _tmp6_;
	GeditDocument* _tmp7_;
	GeditDocument* _tmp8_;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_val_if_fail (document != NULL, NULL);
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self = (GcaDocument*) g_object_new (object_type, NULL);
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = document;
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_object_unref0 (self->priv->d_document);
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self->priv->d_document = _tmp1_;
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp2_ = self->priv->d_document;
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp3_ = gedit_document_is_untitled (_tmp2_);
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self->priv->d_untitled = _tmp3_;
#line 53 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self->priv->d_modified = FALSE;
#line 54 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (self->priv->d_text);
#line 54 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self->priv->d_text = NULL;
#line 56 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_update_modified (self);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp4_ = self->priv->d_document;
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_signal_connect_object ((GtkTextBuffer*) _tmp4_, "modified-changed", (GCallback) _gca_document_on_document_modified_changed_gtk_text_buffer_modified_changed, self, 0);
#line 59 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp5_ = self->priv->d_document;
#line 59 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_signal_connect_object ((GtkTextBuffer*) _tmp5_, "end-user-action", (GCallback) _gca_document_on_document_end_user_action_gtk_text_buffer_end_user_action, self, 0);
#line 60 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp6_ = self->priv->d_document;
#line 60 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_signal_connect_object ((GObject*) _tmp6_, "notify::location", (GCallback) _gca_document_on_location_changed_g_object_notify, self, 0);
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp7_ = self->priv->d_document;
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_signal_connect_object ((GObject*) _tmp7_, "notify::shortname", (GCallback) _gca_document_on_shortname_changed_g_object_notify, self, 0);
#line 62 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp8_ = self->priv->d_document;
#line 62 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_signal_connect_object (_tmp8_, "saved", (GCallback) _gca_document_on_document_saved_gedit_document_saved, self, 0);
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_object_unref0 (self->priv->d_location);
#line 64 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self->priv->d_location = NULL;
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (self->priv->d_path);
#line 65 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self->priv->d_path = NULL;
#line 67 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_update_location (self);
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	return self;
#line 322 "gca-document.c"
}


GcaDocument* gca_document_new (GeditDocument* document) {
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	return gca_document_construct (GCA_TYPE_DOCUMENT, document);
#line 329 "gca-document.c"
}


static void gca_document_real_dispose (GObject* base) {
	GcaDocument * self;
	gboolean _tmp0_;
#line 70 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self = (GcaDocument*) base;
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = self->priv->d_dispose_ran;
#line 72 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (!_tmp0_) {
#line 342 "gca-document.c"
		GeditDocument* _tmp1_;
		guint _tmp2_ = 0U;
		GeditDocument* _tmp3_;
		guint _tmp4_ = 0U;
		GQuark _tmp5_ = 0U;
		GeditDocument* _tmp6_;
		guint _tmp7_ = 0U;
		GQuark _tmp8_ = 0U;
		GeditDocument* _tmp9_;
		guint _tmp10_ = 0U;
		GeditDocument* _tmp11_;
		guint _tmp12_ = 0U;
#line 74 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		self->priv->d_dispose_ran = TRUE;
#line 76 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp1_ = self->priv->d_document;
#line 76 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_signal_parse_name ("modified-changed", GTK_TYPE_TEXT_BUFFER, &_tmp2_, NULL, FALSE);
#line 76 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _gca_document_on_document_modified_changed_gtk_text_buffer_modified_changed, self);
#line 77 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp3_ = self->priv->d_document;
#line 77 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_signal_parse_name ("notify::location", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
#line 77 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_signal_handlers_disconnect_matched ((GObject*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _gca_document_on_location_changed_g_object_notify, self);
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp6_ = self->priv->d_document;
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_signal_parse_name ("notify::shortname", G_TYPE_OBJECT, &_tmp7_, &_tmp8_, TRUE);
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_signal_handlers_disconnect_matched ((GObject*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, _tmp8_, NULL, (GCallback) _gca_document_on_shortname_changed_g_object_notify, self);
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp9_ = self->priv->d_document;
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_signal_parse_name ("end-user-action", GTK_TYPE_TEXT_BUFFER, &_tmp10_, NULL, FALSE);
#line 80 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _gca_document_on_document_end_user_action_gtk_text_buffer_end_user_action, self);
#line 81 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp11_ = self->priv->d_document;
#line 81 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_signal_parse_name ("saved", gedit_document_get_type (), &_tmp12_, NULL, FALSE);
#line 81 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _gca_document_on_document_saved_gedit_document_saved, self);
#line 83 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		gca_document_clear_unsaved_file (self);
#line 389 "gca-document.c"
	}
#line 86 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	G_OBJECT_CLASS (gca_document_parent_class)->dispose (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 393 "gca-document.c"
}


static void gca_document_update_path (GcaDocument* self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* npath;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_if_fail (self != NULL);
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = gca_document_get_path (self);
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp1_ = _tmp0_;
#line 91 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	npath = _tmp1_;
#line 93 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp2_ = npath;
#line 93 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp3_ = self->priv->d_path;
#line 93 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (g_strcmp0 (_tmp2_, _tmp3_) != 0) {
#line 417 "gca-document.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* prevpath;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
#line 95 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp4_ = self->priv->d_path;
#line 95 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 95 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		prevpath = _tmp5_;
#line 96 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp6_ = npath;
#line 96 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 96 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (self->priv->d_path);
#line 96 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		self->priv->d_path = _tmp7_;
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp8_ = prevpath;
#line 98 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_signal_emit_by_name (self, "path-changed", _tmp8_);
#line 93 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (prevpath);
#line 444 "gca-document.c"
	}
#line 89 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (npath);
#line 448 "gca-document.c"
}


static void gca_document_update_location (GcaDocument* self) {
	gboolean _tmp0_ = FALSE;
	GeditDocument* _tmp1_;
	GeditDocument* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp7_;
#line 102 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_if_fail (self != NULL);
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp1_ = gca_document_get_document (self);
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp2_ = _tmp1_;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp3_ = gedit_document_is_untitled (_tmp2_);
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_tmp3_) {
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp0_ = TRUE;
#line 470 "gca-document.c"
	} else {
		GeditDocument* _tmp4_;
		GeditDocument* _tmp5_;
		gboolean _tmp6_ = FALSE;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp4_ = gca_document_get_document (self);
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp5_ = _tmp4_;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp6_ = gedit_document_is_local (_tmp5_);
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp0_ = !_tmp6_;
#line 483 "gca-document.c"
	}
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp7_ = _tmp0_;
#line 104 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_tmp7_) {
#line 106 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_object_unref0 (self->priv->d_location);
#line 106 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		self->priv->d_location = NULL;
#line 493 "gca-document.c"
	} else {
		GeditDocument* _tmp8_;
		GeditDocument* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp8_ = gca_document_get_document (self);
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp9_ = _tmp8_;
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp10_ = gedit_document_get_location (_tmp9_);
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp11_ = _tmp10_;
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_object_unref0 (self->priv->d_location);
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		self->priv->d_location = _tmp11_;
#line 511 "gca-document.c"
	}
#line 113 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_update_path (self);
#line 515 "gca-document.c"
}


static void gca_document_update_modified (GcaDocument* self) {
	gboolean _tmp0_;
	GeditDocument* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
#line 116 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = self->priv->d_modified;
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp1_ = self->priv->d_document;
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp2_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp1_);
#line 118 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_tmp0_ == _tmp2_) {
#line 120 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		return;
#line 537 "gca-document.c"
	}
#line 123 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (self->priv->d_text);
#line 123 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self->priv->d_text = NULL;
#line 124 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp3_ = self->priv->d_modified;
#line 124 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self->priv->d_modified = !_tmp3_;
#line 126 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp4_ = self->priv->d_modified;
#line 126 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_tmp4_) {
#line 128 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		gca_document_update_text (self);
#line 553 "gca-document.c"
	} else {
#line 132 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		gca_document_emit_changed (self);
#line 557 "gca-document.c"
	}
}


void gca_document_emit_changed (GcaDocument* self) {
#line 136 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_if_fail (self != NULL);
#line 138 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_signal_emit_by_name (self, "changed");
#line 567 "gca-document.c"
}


static void gca_document_clear_unsaved_file (GcaDocument* self) {
	GFile* _tmp0_;
	GError * _inner_error_ = NULL;
#line 141 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_if_fail (self != NULL);
#line 143 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = self->priv->d_unsaved_file;
#line 143 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_tmp0_ != NULL) {
#line 580 "gca-document.c"
		{
			GFile* _tmp1_;
#line 147 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_tmp1_ = self->priv->d_unsaved_file;
#line 147 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_file_delete (_tmp1_, NULL, &_inner_error_);
#line 147 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			if (_inner_error_ != NULL) {
#line 589 "gca-document.c"
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_clear_error (&_inner_error_);
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_inner_error_ = NULL;
#line 600 "gca-document.c"
		}
		__finally1:
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		if (_inner_error_ != NULL) {
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_clear_error (&_inner_error_);
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			return;
#line 611 "gca-document.c"
		}
#line 150 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_object_unref0 (self->priv->d_unsaved_file);
#line 150 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		self->priv->d_unsaved_file = NULL;
#line 617 "gca-document.c"
	}
}


static void gca_document_update_text (GcaDocument* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GeditDocument* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GeditDocument* _tmp3_;
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_ = NULL;
#line 154 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_if_fail (self != NULL);
#line 159 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = self->priv->d_document;
#line 159 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp0_, &_tmp1_, &_tmp2_);
#line 159 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	start = _tmp1_;
#line 159 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	end = _tmp2_;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp3_ = self->priv->d_document;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp4_ = start;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp5_ = end;
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp6_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp3_, &_tmp4_, &_tmp5_, TRUE);
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (self->priv->d_text);
#line 160 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self->priv->d_text = _tmp6_;
#line 162 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_clear_unsaved_file (self);
#line 164 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_emit_changed (self);
#line 658 "gca-document.c"
}


static void gca_document_unsaved_data_path_data_free (gpointer _data) {
	GcaDocumentUnsavedDataPathData* _data_;
	_data_ = _data;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (_data_->result);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_object_unref0 (_data_->self);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_slice_free (GcaDocumentUnsavedDataPathData, _data_);
#line 671 "gca-document.c"
}


void gca_document_unsaved_data_path (GcaDocument* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GcaDocumentUnsavedDataPathData* _data_;
	GcaDocument* _tmp0_;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_ = g_slice_new0 (GcaDocumentUnsavedDataPathData);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, gca_document_unsaved_data_path);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, gca_document_unsaved_data_path_data_free);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->self = _tmp0_;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_unsaved_data_path_co (_data_);
#line 690 "gca-document.c"
}


gchar* gca_document_unsaved_data_path_finish (GcaDocument* self, GAsyncResult* _res_, GError** error) {
	gchar* result;
	GcaDocumentUnsavedDataPathData* _data_;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		return NULL;
#line 701 "gca-document.c"
	}
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	result = _data_->result;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->result = NULL;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	return result;
#line 711 "gca-document.c"
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 908 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 908 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 909 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 909 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 909 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 909 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 911 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 911 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 738 "gca-document.c"
		gchar* _tmp4_;
#line 912 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 912 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 912 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 746 "gca-document.c"
	} else {
#line 914 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = -1;
#line 914 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 752 "gca-document.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1190 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1191 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1192 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1192 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 788 "gca-document.c"
		glong _tmp3_;
		glong _tmp4_;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1193 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 797 "gca-document.c"
	}
#line 1195 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1195 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 803 "gca-document.c"
		glong _tmp6_;
		glong _tmp7_;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1196 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 812 "gca-document.c"
	}
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 818 "gca-document.c"
		glong _tmp10_;
		glong _tmp11_;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 827 "gca-document.c"
	} else {
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 831 "gca-document.c"
	}
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp12_ = _tmp8_;
#line 1198 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp14_ = end;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_tmp14_ >= ((glong) 0)) {
#line 841 "gca-document.c"
		glong _tmp15_;
		glong _tmp16_;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp15_ = end;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = _tmp15_ <= _tmp16_;
#line 850 "gca-document.c"
	} else {
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp13_ = FALSE;
#line 854 "gca-document.c"
	}
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp17_ = _tmp13_;
#line 1199 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp17_, NULL);
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1200 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp21_ = end;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp22_ = start;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1201 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 878 "gca-document.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 250 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	return self ? g_error_copy (self) : NULL;
#line 885 "gca-document.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1260 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1261 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1261 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1261 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1262 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1262 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1262 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1262 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 929 "gca-document.c"
	}
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 935 "gca-document.c"
}


static void gca_document_unsaved_data_path_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GcaDocumentUnsavedDataPathData* _data_;
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_ = _user_data_;
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_source_object_ = source_object;
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_res_ = _res_;
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_unsaved_data_path_co (_data_);
#line 949 "gca-document.c"
}


static gboolean gca_document_unsaved_data_path_co (GcaDocumentUnsavedDataPathData* _data_) {
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	switch (_data_->_state_) {
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		case 0:
#line 958 "gca-document.c"
		goto _state_0;
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		case 1:
#line 962 "gca-document.c"
		goto _state_1;
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		case 2:
#line 966 "gca-document.c"
		goto _state_2;
		default:
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_assert_not_reached ();
#line 971 "gca-document.c"
	}
	_state_0:
#line 215 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp0_ = _data_->self->priv->d_modified;
#line 215 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (!_data_->_tmp0_) {
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->result = NULL;
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		if (_data_->_state_ == 0) {
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 984 "gca-document.c"
		} else {
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 988 "gca-document.c"
		}
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_object_unref (_data_->_async_result);
#line 217 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		return FALSE;
#line 994 "gca-document.c"
	}
#line 220 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp1_ = _data_->self->priv->d_unsaved_file;
#line 220 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_data_->_tmp1_ != NULL) {
#line 222 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp2_ = _data_->self->priv->d_unsaved_file;
#line 222 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp3_ = NULL;
#line 222 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp3_ = g_file_get_path (_data_->_tmp2_);
#line 222 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->result = _data_->_tmp3_;
#line 222 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		if (_data_->_state_ == 0) {
#line 222 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1012 "gca-document.c"
		} else {
#line 222 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1016 "gca-document.c"
		}
#line 222 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_object_unref (_data_->_async_result);
#line 222 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		return FALSE;
#line 1022 "gca-document.c"
	}
#line 225 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp4_ = gca_document_get_path (_data_->self);
#line 225 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp5_ = _data_->_tmp4_;
#line 225 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->orig = _data_->_tmp5_;
#line 226 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp6_ = _data_->orig;
#line 226 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp7_ = 0;
#line 226 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp7_ = string_last_index_of (_data_->_tmp6_, ".", 0);
#line 226 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->idx = _data_->_tmp7_;
#line 229 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp8_ = _data_->idx;
#line 229 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_data_->_tmp8_ != (-1)) {
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp9_ = _data_->orig;
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp10_ = _data_->idx;
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp11_ = _data_->orig;
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp12_ = strlen (_data_->_tmp11_);
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp13_ = _data_->_tmp12_;
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp14_ = NULL;
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp14_ = string_slice (_data_->_tmp9_, (glong) (_data_->_tmp10_ + 1), (glong) _data_->_tmp13_);
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp16_ = NULL;
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp16_ = g_strdup_printf ("gca-unsaved-XXXXXX.%s", _data_->_tmp15_);
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->filename);
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->filename = _data_->_tmp16_;
#line 231 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->_tmp15_);
#line 1068 "gca-document.c"
	} else {
#line 235 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp17_ = g_strdup ("gca-unsaved-XXXXXX");
#line 235 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->filename);
#line 235 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->filename = _data_->_tmp17_;
#line 1076 "gca-document.c"
	}
#line 238 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp18_ = NULL;
#line 238 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp18_ = g_get_user_cache_dir ();
#line 238 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp19_ = g_strdup (_data_->_tmp18_);
#line 238 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->cdir = _data_->_tmp19_;
#line 239 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp20_ = _data_->cdir;
#line 239 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp21_ = NULL;
#line 239 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp21_ = g_build_filename (_data_->_tmp20_, "gedit", "plugins", "codeassistance", NULL);
#line 239 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->tmpdir = _data_->_tmp21_;
#line 240 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp22_ = _data_->tmpdir;
#line 240 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp23_ = NULL;
#line 240 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp23_ = g_file_new_for_path (_data_->_tmp22_);
#line 240 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->f = _data_->_tmp23_;
#line 1102 "gca-document.c"
	{
#line 244 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp24_ = _data_->f;
#line 244 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_file_make_directory_with_parents (_data_->_tmp24_, NULL, &_data_->_inner_error_);
#line 244 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		if (_data_->_inner_error_ != NULL) {
#line 244 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
#line 1112 "gca-document.c"
				goto __catch2_g_io_error;
			}
			goto __finally2;
		}
	}
	goto __finally2;
	__catch2_g_io_error:
	{
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->e = _data_->_inner_error_;
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_inner_error_ = NULL;
#line 248 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp25_ = _data_->e;
#line 248 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		if (!g_error_matches (_data_->_tmp25_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
#line 250 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_data_->_tmp26_ = _data_->e;
#line 250 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_data_->_tmp27_ = _g_error_copy0 (_data_->_tmp26_);
#line 250 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_data_->_inner_error_ = _data_->_tmp27_;
#line 250 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_error_free0 (_data_->e);
#line 1137 "gca-document.c"
			goto __finally2;
		}
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_error_free0 (_data_->e);
#line 1142 "gca-document.c"
	}
	__finally2:
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_data_->_inner_error_ != NULL) {
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_error_free (_data_->_inner_error_);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_object_unref0 (_data_->f);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->tmpdir);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->cdir);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->filename);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->orig);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		if (_data_->_state_ == 0) {
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1165 "gca-document.c"
		} else {
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1169 "gca-document.c"
		}
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_object_unref (_data_->_async_result);
#line 242 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		return FALSE;
#line 1175 "gca-document.c"
	}
#line 254 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp28_ = gca_document_s_needs_tmp_chmod;
#line 254 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_data_->_tmp28_) {
#line 256 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp29_ = _data_->tmpdir;
#line 256 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_chmod (_data_->_tmp29_, 0700);
#line 257 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		gca_document_s_needs_tmp_chmod = FALSE;
#line 1187 "gca-document.c"
	}
#line 260 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp30_ = _data_->tmpdir;
#line 260 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp31_ = _data_->filename;
#line 260 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp32_ = NULL;
#line 260 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp32_ = g_build_filename (_data_->_tmp30_, _data_->_tmp31_, NULL);
#line 260 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->tmpfilename = _data_->_tmp32_;
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp33_ = _data_->tmpfilename;
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp34_ = 0;
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp34_ = g_mkstemp (_data_->_tmp33_);
#line 261 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->tmpfile = _data_->_tmp34_;
#line 263 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp35_ = _data_->tmpfile;
#line 263 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp36_ = (GUnixOutputStream*) g_unix_output_stream_new (_data_->_tmp35_, TRUE);
#line 263 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->ostream = _data_->_tmp36_;
#line 1213 "gca-document.c"
	{
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp37_ = _data_->ostream;
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp38_ = _data_->self->priv->d_text;
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp39_ = string_get_data (_data_->_tmp38_, &_data_->_tmp39__length1);
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp40_ = _data_->_tmp39_;
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp40__length1 = _data_->_tmp39__length1;
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_state_ = 1;
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_output_stream_write_async ((GOutputStream*) _data_->_tmp37_, _data_->_tmp40_, (gsize) _data_->_tmp40__length1, G_PRIORITY_DEFAULT, NULL, gca_document_unsaved_data_path_ready, _data_);
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		return FALSE;
#line 1231 "gca-document.c"
		_state_1:
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_output_stream_write_finish ((GOutputStream*) _data_->_tmp37_, _data_->_res_, &_data_->_inner_error_);
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		if (_data_->_inner_error_ != NULL) {
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
#line 1239 "gca-document.c"
				goto __catch3_g_io_error;
			}
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_object_unref0 (_data_->ostream);
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->tmpfilename);
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_object_unref0 (_data_->f);
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->tmpdir);
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->cdir);
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->filename);
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->orig);
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_clear_error (&_data_->_inner_error_);
#line 267 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			return FALSE;
#line 1262 "gca-document.c"
		}
#line 269 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp41_ = NULL;
#line 269 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp41_ = g_new0 (guint8, 1);
#line 269 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp41_[0] = (guint8) '\n';
#line 269 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->b = _data_->_tmp41_;
#line 269 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->b_length1 = 1;
#line 269 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_b_size_ = _data_->b_length1;
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp42_ = _data_->ostream;
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp43_ = _data_->b;
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp43__length1 = _data_->b_length1;
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_state_ = 2;
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_output_stream_write_async ((GOutputStream*) _data_->_tmp42_, _data_->_tmp43_, (gsize) _data_->_tmp43__length1, G_PRIORITY_DEFAULT, NULL, gca_document_unsaved_data_path_ready, _data_);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		return FALSE;
#line 1288 "gca-document.c"
		_state_2:
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_output_stream_write_finish ((GOutputStream*) _data_->_tmp42_, _data_->_res_, &_data_->_inner_error_);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		if (_data_->_inner_error_ != NULL) {
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_data_->b = (g_free (_data_->b), NULL);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
#line 1298 "gca-document.c"
				goto __catch3_g_io_error;
			}
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_data_->b = (g_free (_data_->b), NULL);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_object_unref0 (_data_->ostream);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->tmpfilename);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_object_unref0 (_data_->f);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->tmpdir);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->cdir);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->filename);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->orig);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_clear_error (&_data_->_inner_error_);
#line 270 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			return FALSE;
#line 1323 "gca-document.c"
		}
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->b = (g_free (_data_->b), NULL);
#line 1327 "gca-document.c"
	}
	goto __finally3;
	__catch3_g_io_error:
	{
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_vala1_e = _data_->_inner_error_;
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_inner_error_ = NULL;
#line 1336 "gca-document.c"
		{
#line 276 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_data_->_tmp44_ = _data_->f;
#line 276 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_file_delete (_data_->_tmp44_, NULL, &_data_->_inner_error_);
#line 276 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			if (_data_->_inner_error_ != NULL) {
#line 1344 "gca-document.c"
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_clear_error (&_data_->_inner_error_);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_data_->_inner_error_ = NULL;
#line 1355 "gca-document.c"
		}
		__finally4:
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		if (_data_->_inner_error_ != NULL) {
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_error_free0 (_data_->_vala1_e);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_error_free0 (_data_->_vala1_e);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_object_unref0 (_data_->ostream);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->tmpfilename);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_object_unref0 (_data_->f);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->tmpdir);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->cdir);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->filename);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->orig);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_clear_error (&_data_->_inner_error_);
#line 274 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			return FALSE;
#line 1384 "gca-document.c"
		}
		{
#line 281 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_data_->_tmp45_ = _data_->ostream;
#line 281 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_output_stream_close ((GOutputStream*) _data_->_tmp45_, NULL, &_data_->_inner_error_);
#line 281 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			if (_data_->_inner_error_ != NULL) {
#line 1393 "gca-document.c"
				goto __catch5_g_error;
			}
		}
		goto __finally5;
		__catch5_g_error:
		{
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_clear_error (&_data_->_inner_error_);
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_data_->_inner_error_ = NULL;
#line 1404 "gca-document.c"
		}
		__finally5:
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		if (_data_->_inner_error_ != NULL) {
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_error_free0 (_data_->_vala1_e);
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_error_free0 (_data_->_vala1_e);
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_object_unref0 (_data_->ostream);
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->tmpfilename);
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_object_unref0 (_data_->f);
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->tmpdir);
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->cdir);
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->filename);
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			_g_free0 (_data_->orig);
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_clear_error (&_data_->_inner_error_);
#line 279 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			return FALSE;
#line 1433 "gca-document.c"
		}
#line 284 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp46_ = _data_->_vala1_e;
#line 284 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_tmp47_ = _g_error_copy0 (_data_->_tmp46_);
#line 284 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_data_->_inner_error_ = _data_->_tmp47_;
#line 284 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_error_free0 (_data_->_vala1_e);
#line 1443 "gca-document.c"
		goto __finally3;
	}
	__finally3:
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_data_->_inner_error_ != NULL) {
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_error_free (_data_->_inner_error_);
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_object_unref0 (_data_->ostream);
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->tmpfilename);
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_object_unref0 (_data_->f);
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->tmpdir);
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->cdir);
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->filename);
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->orig);
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		if (_data_->_state_ == 0) {
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1471 "gca-document.c"
		} else {
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1475 "gca-document.c"
		}
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_object_unref (_data_->_async_result);
#line 265 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		return FALSE;
#line 1481 "gca-document.c"
	}
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp48_ = _data_->ostream;
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_output_stream_close ((GOutputStream*) _data_->_tmp48_, NULL, &_data_->_inner_error_);
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_data_->_inner_error_ != NULL) {
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_error_free (_data_->_inner_error_);
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_object_unref0 (_data_->ostream);
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->tmpfilename);
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_object_unref0 (_data_->f);
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->tmpdir);
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->cdir);
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->filename);
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_g_free0 (_data_->orig);
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		if (_data_->_state_ == 0) {
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1511 "gca-document.c"
		} else {
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1515 "gca-document.c"
		}
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_object_unref (_data_->_async_result);
#line 287 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		return FALSE;
#line 1521 "gca-document.c"
	}
#line 288 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp49_ = _data_->tmpfilename;
#line 288 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp50_ = NULL;
#line 288 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp50_ = g_file_new_for_path (_data_->_tmp49_);
#line 288 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_object_unref0 (_data_->self->priv->d_unsaved_file);
#line 288 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->self->priv->d_unsaved_file = _data_->_tmp50_;
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp51_ = _data_->self->priv->d_unsaved_file;
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp52_ = NULL;
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->_tmp52_ = g_file_get_path (_data_->_tmp51_);
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_data_->result = _data_->_tmp52_;
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_object_unref0 (_data_->ostream);
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (_data_->tmpfilename);
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_object_unref0 (_data_->f);
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (_data_->tmpdir);
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (_data_->cdir);
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (_data_->filename);
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (_data_->orig);
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_data_->_state_ == 0) {
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1559 "gca-document.c"
	} else {
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1563 "gca-document.c"
	}
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_object_unref (_data_->_async_result);
#line 290 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	return FALSE;
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_object_unref0 (_data_->ostream);
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (_data_->tmpfilename);
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_object_unref0 (_data_->f);
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (_data_->tmpdir);
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (_data_->cdir);
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (_data_->filename);
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (_data_->orig);
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_data_->_state_ == 0) {
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1587 "gca-document.c"
	} else {
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1591 "gca-document.c"
	}
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_object_unref (_data_->_async_result);
#line 213 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	return FALSE;
#line 1597 "gca-document.c"
}


static void gca_document_on_document_end_user_action (GcaDocument* self) {
	gboolean _tmp0_;
#line 293 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_if_fail (self != NULL);
#line 295 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = self->priv->d_modified;
#line 295 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_tmp0_) {
#line 297 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		gca_document_update_text (self);
#line 1611 "gca-document.c"
	}
}


static void gca_document_on_document_modified_changed (GcaDocument* self) {
#line 301 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_if_fail (self != NULL);
#line 303 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_update_modified (self);
#line 1621 "gca-document.c"
}


static void gca_document_on_location_changed (GcaDocument* self) {
#line 306 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_if_fail (self != NULL);
#line 308 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_update_location (self);
#line 1630 "gca-document.c"
}


static void gca_document_on_document_saved (GcaDocument* self) {
#line 311 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_if_fail (self != NULL);
#line 313 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_emit_changed (self);
#line 1639 "gca-document.c"
}


static void gca_document_on_shortname_changed (GcaDocument* self) {
#line 316 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_if_fail (self != NULL);
#line 318 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_update_path (self);
#line 1648 "gca-document.c"
}


GeditDocument* gca_document_get_document (GcaDocument* self) {
	GeditDocument* result;
	GeditDocument* _tmp0_;
#line 45 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = self->priv->d_document;
#line 45 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	result = _tmp0_;
#line 45 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	return result;
#line 1663 "gca-document.c"
}


GFile* gca_document_get_location (GcaDocument* self) {
	GFile* result;
	GFile* _tmp0_;
#line 169 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 169 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = self->priv->d_location;
#line 169 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	result = _tmp0_;
#line 169 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	return result;
#line 1678 "gca-document.c"
}


const gchar* gca_document_get_text (GcaDocument* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 174 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 174 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = self->priv->d_text;
#line 174 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	result = _tmp0_;
#line 174 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	return result;
#line 1693 "gca-document.c"
}


gboolean gca_document_get_is_modified (GcaDocument* self) {
	gboolean result;
	gboolean _tmp0_;
#line 179 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 179 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = self->priv->d_modified;
#line 179 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	result = _tmp0_;
#line 179 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	return result;
#line 1708 "gca-document.c"
}


void gca_document_get_cursor (GcaDocument* self, GcaSourceLocation* result) {
	GeditDocument* _tmp0_;
	GtkTextMark* _tmp1_ = NULL;
	GtkTextMark* _tmp2_;
	GtkTextMark* mark;
	GtkTextIter iter = {0};
	GeditDocument* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GcaSourceLocation _tmp7_ = {0};
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_if_fail (self != NULL);
#line 186 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = self->priv->d_document;
#line 186 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp1_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp0_);
#line 186 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 186 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	mark = _tmp2_;
#line 189 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp3_ = self->priv->d_document;
#line 189 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp4_, mark);
#line 189 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	iter = _tmp4_;
#line 191 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp5_ = gtk_text_iter_get_line (&iter);
#line 191 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp6_ = gtk_text_iter_get_line_offset (&iter);
#line 191 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	memset (&_tmp7_, 0, sizeof (GcaSourceLocation));
#line 191 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp7_.line = _tmp5_ + 1;
#line 191 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp7_.column = _tmp6_ + 1;
#line 191 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	*result = _tmp7_;
#line 191 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_object_unref0 (mark);
#line 191 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	return;
#line 1755 "gca-document.c"
}


gchar* gca_document_get_path (GcaDocument* self) {
	gchar* result;
	GFile* _tmp0_;
#line 200 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 202 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_tmp0_ = self->priv->d_location;
#line 202 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	if (_tmp0_ == NULL) {
#line 1768 "gca-document.c"
		GeditDocument* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
#line 204 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp1_ = self->priv->d_document;
#line 204 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_object_get (_tmp1_, "shortname", &_tmp2_, NULL);
#line 204 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp3_ = _tmp2_;
#line 204 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		result = _tmp3_;
#line 204 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		return result;
#line 1782 "gca-document.c"
	} else {
		GFile* _tmp4_;
		gchar* _tmp5_ = NULL;
#line 208 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp4_ = self->priv->d_location;
#line 208 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		_tmp5_ = g_file_get_path (_tmp4_);
#line 208 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		result = _tmp5_;
#line 208 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		return result;
#line 1794 "gca-document.c"
	}
}


static void gca_document_class_init (GcaDocumentClass * klass) {
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	gca_document_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_type_class_add_private (klass, sizeof (GcaDocumentPrivate));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	G_OBJECT_CLASS (klass)->dispose = gca_document_real_dispose;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gca_document_get_property;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	G_OBJECT_CLASS (klass)->finalize = gca_document_finalize;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DOCUMENT_DOCUMENT, g_param_spec_object ("document", "document", "document", gedit_document_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DOCUMENT_LOCATION, g_param_spec_object ("location", "location", "location", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DOCUMENT_TEXT, g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DOCUMENT_IS_MODIFIED, g_param_spec_boolean ("is-modified", "is-modified", "is-modified", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DOCUMENT_CURSOR, g_param_spec_boxed ("cursor", "cursor", "cursor", GCA_TYPE_SOURCE_LOCATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DOCUMENT_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_signal_new ("path_changed", GCA_TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	g_signal_new ("changed", GCA_TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1826 "gca-document.c"
}


static void gca_document_instance_init (GcaDocument * self) {
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self->priv = GCA_DOCUMENT_GET_PRIVATE (self);
#line 1833 "gca-document.c"
}


static void gca_document_finalize (GObject* obj) {
	GcaDocument * self;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_DOCUMENT, GcaDocument);
#line 27 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_object_unref0 (self->priv->d_document);
#line 31 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (self->priv->d_text);
#line 32 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_object_unref0 (self->priv->d_location);
#line 34 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_free0 (self->priv->d_path);
#line 36 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	_g_object_unref0 (self->priv->d_unsaved_file);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	G_OBJECT_CLASS (gca_document_parent_class)->finalize (obj);
#line 1853 "gca-document.c"
}


GType gca_document_get_type (void) {
	static volatile gsize gca_document_type_id__volatile = 0;
	if (g_once_init_enter (&gca_document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaDocument), 0, (GInstanceInitFunc) gca_document_instance_init, NULL };
		GType gca_document_type_id;
		gca_document_type_id = g_type_register_static (G_TYPE_OBJECT, "GcaDocument", &g_define_type_info, 0);
		g_once_init_leave (&gca_document_type_id__volatile, gca_document_type_id);
	}
	return gca_document_type_id__volatile;
}


static void _vala_gca_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcaDocument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCA_TYPE_DOCUMENT, GcaDocument);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
	switch (property_id) {
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		case GCA_DOCUMENT_DOCUMENT:
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_value_set_object (value, gca_document_get_document (self));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		break;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		case GCA_DOCUMENT_LOCATION:
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_value_set_object (value, gca_document_get_location (self));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		break;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		case GCA_DOCUMENT_TEXT:
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_value_set_string (value, gca_document_get_text (self));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		break;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		case GCA_DOCUMENT_IS_MODIFIED:
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_value_set_boolean (value, gca_document_get_is_modified (self));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		break;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		case GCA_DOCUMENT_CURSOR:
#line 1900 "gca-document.c"
		{
			GcaSourceLocation boxed;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			gca_document_get_cursor (self, &boxed);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
			g_value_set_boxed (value, &boxed);
#line 1907 "gca-document.c"
		}
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		break;
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		case GCA_DOCUMENT_PATH:
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		g_value_take_string (value, gca_document_get_path (self));
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		break;
#line 1917 "gca-document.c"
		default:
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/jesse/devel/gedit-code-assistance/src/gca-document.vala"
		break;
#line 1923 "gca-document.c"
	}
}



