/* gca-view.c generated by valac 0.20.1, the Vala compiler
 * generated from gca-view.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gedit/gedit-view.h>
#include <gedit/gedit-document.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <gio/gio.h>


#define GCA_TYPE_VIEW (gca_view_get_type ())
#define GCA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_VIEW, GcaView))
#define GCA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_VIEW, GcaViewClass))
#define GCA_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_VIEW))
#define GCA_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_VIEW))
#define GCA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_VIEW, GcaViewClass))

typedef struct _GcaView GcaView;
typedef struct _GcaViewClass GcaViewClass;
typedef struct _GcaViewPrivate GcaViewPrivate;

#define GCA_TYPE_DOCUMENT (gca_document_get_type ())
#define GCA_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DOCUMENT, GcaDocument))
#define GCA_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DOCUMENT, GcaDocumentClass))
#define GCA_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DOCUMENT))
#define GCA_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DOCUMENT))
#define GCA_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DOCUMENT, GcaDocumentClass))

typedef struct _GcaDocument GcaDocument;
typedef struct _GcaDocumentClass GcaDocumentClass;

#define GCA_TYPE_BACKEND (gca_backend_get_type ())
#define GCA_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_BACKEND, GcaBackend))
#define GCA_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_BACKEND, GcaBackendClass))
#define GCA_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_BACKEND))
#define GCA_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_BACKEND))
#define GCA_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_BACKEND, GcaBackendClass))

typedef struct _GcaBackend GcaBackend;
typedef struct _GcaBackendClass GcaBackendClass;

#define GCA_TYPE_SCROLLBAR_MARKER (gca_scrollbar_marker_get_type ())
#define GCA_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarker))
#define GCA_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarkerClass))
#define GCA_IS_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_SCROLLBAR_MARKER))
#define GCA_IS_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_SCROLLBAR_MARKER))
#define GCA_SCROLLBAR_MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarkerClass))

typedef struct _GcaScrollbarMarker GcaScrollbarMarker;
typedef struct _GcaScrollbarMarkerClass GcaScrollbarMarkerClass;

#define GCA_TYPE_REMOTE_SERVICE (gca_remote_service_get_type ())
#define GCA_REMOTE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_REMOTE_SERVICE, GcaRemoteService))
#define GCA_IS_REMOTE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_REMOTE_SERVICE))
#define GCA_REMOTE_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_TYPE_REMOTE_SERVICE, GcaRemoteServiceIface))

typedef struct _GcaRemoteService GcaRemoteService;
typedef struct _GcaRemoteServiceIface GcaRemoteServiceIface;

#define GCA_TYPE_REMOTE_SERVICES (gca_remote_services_get_type ())

#define GCA_TYPE_REMOTE_DOCUMENT (gca_remote_document_get_type ())
#define GCA_REMOTE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocument))
#define GCA_REMOTE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocumentClass))
#define GCA_IS_REMOTE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_REMOTE_DOCUMENT))
#define GCA_IS_REMOTE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_REMOTE_DOCUMENT))
#define GCA_REMOTE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocumentClass))

typedef struct _GcaRemoteDocument GcaRemoteDocument;
typedef struct _GcaRemoteDocumentClass GcaRemoteDocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gca_scrollbar_marker_unref0(var) ((var == NULL) ? NULL : (var = (gca_scrollbar_marker_unref (var), NULL)))

#define GCA_TYPE_DIAGNOSTIC_SERVICE (gca_diagnostic_service_get_type ())
#define GCA_DIAGNOSTIC_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticService))
#define GCA_DIAGNOSTIC_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticServiceClass))
#define GCA_IS_DIAGNOSTIC_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC_SERVICE))
#define GCA_IS_DIAGNOSTIC_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC_SERVICE))
#define GCA_DIAGNOSTIC_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticServiceClass))

typedef struct _GcaDiagnosticService GcaDiagnosticService;
typedef struct _GcaDiagnosticServiceClass GcaDiagnosticServiceClass;

#define GCA_TYPE_BACKEND_MANAGER (gca_backend_manager_get_type ())
#define GCA_BACKEND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_BACKEND_MANAGER, GcaBackendManager))
#define GCA_BACKEND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_BACKEND_MANAGER, GcaBackendManagerClass))
#define GCA_IS_BACKEND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_BACKEND_MANAGER))
#define GCA_IS_BACKEND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_BACKEND_MANAGER))
#define GCA_BACKEND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_BACKEND_MANAGER, GcaBackendManagerClass))

typedef struct _GcaBackendManager GcaBackendManager;
typedef struct _GcaBackendManagerClass GcaBackendManagerClass;
typedef struct _Block1Data Block1Data;
#define _gca_backend_manager_unref0(var) ((var == NULL) ? NULL : (var = (gca_backend_manager_unref (var), NULL)))

struct _GcaView {
	GObject parent_instance;
	GcaViewPrivate * priv;
};

struct _GcaViewClass {
	GObjectClass parent_class;
};

typedef enum  {
	GCA_REMOTE_SERVICES_DIAGNOSTICS = 1 << 0,
	GCA_REMOTE_SERVICES_SEMANTIC_VALUES = 1 << 1,
	GCA_REMOTE_SERVICES_SYMBOLS = 1 << 2
} GcaRemoteServices;

struct _GcaRemoteServiceIface {
	GTypeInterface parent_iface;
	GcaRemoteServices (*services) (GcaRemoteService* self);
	void (*update) (GcaRemoteService* self, GcaView* view, GcaRemoteDocument* document);
	void (*destroy) (GcaRemoteService* self);
};

struct _GcaViewPrivate {
	GeditView* d_view;
	GcaDocument* d_document;
	GcaBackend* d_backend;
	GcaScrollbarMarker* d_scrollbar_marker;
	guint d_timeout;
	GcaRemoteService** d_services;
	gint d_services_length1;
	gint _d_services_size_;
};

struct _Block1Data {
	int _ref_count_;
	GcaView * self;
	GcaBackendManager* manager;
};


static gpointer gca_view_parent_class = NULL;

GType gca_view_get_type (void) G_GNUC_CONST;
GType gca_document_get_type (void) G_GNUC_CONST;
GType gca_backend_get_type (void) G_GNUC_CONST;
gpointer gca_scrollbar_marker_ref (gpointer instance);
void gca_scrollbar_marker_unref (gpointer instance);
GParamSpec* gca_param_spec_scrollbar_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_scrollbar_marker (GValue* value, gpointer v_object);
void gca_value_take_scrollbar_marker (GValue* value, gpointer v_object);
gpointer gca_value_get_scrollbar_marker (const GValue* value);
GType gca_scrollbar_marker_get_type (void) G_GNUC_CONST;
GType gca_remote_services_get_type (void) G_GNUC_CONST;
gpointer gca_remote_document_ref (gpointer instance);
void gca_remote_document_unref (gpointer instance);
GParamSpec* gca_param_spec_remote_document (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_remote_document (GValue* value, gpointer v_object);
void gca_value_take_remote_document (GValue* value, gpointer v_object);
gpointer gca_value_get_remote_document (const GValue* value);
GType gca_remote_document_get_type (void) G_GNUC_CONST;
GType gca_remote_service_get_type (void) G_GNUC_CONST;
#define GCA_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_VIEW, GcaViewPrivate))
enum  {
	GCA_VIEW_DUMMY_PROPERTY,
	GCA_VIEW_VIEW,
	GCA_VIEW_DOCUMENT,
	GCA_VIEW_SCROLLBAR_MARKER
};
GcaView* gca_view_new (GeditView* view);
GcaView* gca_view_construct (GType object_type, GeditView* view);
static void gca_view_on_notify_buffer (GcaView* self);
static void _gca_view_on_notify_buffer_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gca_view_connect_document (GcaView* self, GeditDocument* document);
GcaScrollbarMarker* gca_scrollbar_marker_new (GtkScrollbar* scrollbar);
GcaScrollbarMarker* gca_scrollbar_marker_construct (GType object_type, GtkScrollbar* scrollbar);
GcaDiagnosticService* gca_diagnostic_service_new (void);
GcaDiagnosticService* gca_diagnostic_service_construct (GType object_type);
GType gca_diagnostic_service_get_type (void) G_GNUC_CONST;
void gca_view_deactivate (GcaView* self);
static void gca_view_disconnect_document (GcaView* self);
void gca_view_update (GcaView* self, GcaRemoteDocument* doc);
gboolean gca_backend_supports (GcaBackend* self, GcaRemoteServices services);
GcaRemoteServices gca_remote_service_services (GcaRemoteService* self);
void gca_remote_service_update (GcaRemoteService* self, GcaView* view, GcaRemoteDocument* document);
GeditDocument* gca_document_get_document (GcaDocument* self);
static void gca_view_on_notify_language (GcaView* self);
static void _gca_view_on_notify_language_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void gca_view_on_document_changed (GcaView* self);
static void _gca_view_on_document_changed_gca_document_changed (GcaDocument* _sender, gpointer self);
static void gca_view_on_document_path_changed (GcaView* self, const gchar* prevpath);
static void _gca_view_on_document_path_changed_gca_document_path_changed (GcaDocument* _sender, const gchar* previous_path, gpointer self);
static void gca_view_unregister_backend (GcaView* self);
GcaDocument* gca_document_new (GeditDocument* document);
GcaDocument* gca_document_construct (GType object_type, GeditDocument* document);
static void gca_view_update_backend (GcaView* self);
void gca_scrollbar_marker_set_max_line (GcaScrollbarMarker* self, gint value);
static gboolean __lambda9_ (GcaView* self);
static gboolean ___lambda9__gsource_func (gpointer self);
gpointer gca_backend_manager_ref (gpointer instance);
void gca_backend_manager_unref (gpointer instance);
GParamSpec* gca_param_spec_backend_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_backend_manager (GValue* value, gpointer v_object);
void gca_value_take_backend_manager (GValue* value, gpointer v_object);
gpointer gca_value_get_backend_manager (const GValue* value);
GType gca_backend_manager_get_type (void) G_GNUC_CONST;
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
GcaBackendManager* gca_backend_manager_get_instance (void);
void gca_backend_manager_backend (GcaBackendManager* self, const gchar* language, GAsyncReadyCallback _callback_, gpointer _user_data_);
GcaBackend* gca_backend_manager_backend_finish (GcaBackendManager* self, GAsyncResult* _res_);
static void ___lambda8_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void gca_view_register_backend (GcaView* self, GcaBackend* backend);
static void ____lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void gca_remote_service_destroy (GcaRemoteService* self);
void gca_backend_unregister (GcaBackend* self, GcaView* view);
void gca_backend_register (GcaBackend* self, GcaView* view);
GeditView* gca_view_get_view (GcaView* self);
GcaDocument* gca_view_get_document (GcaView* self);
GcaScrollbarMarker* gca_view_get_scrollbar_marker (GcaView* self);
static void gca_view_finalize (GObject* obj);
static void _vala_gca_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _gca_view_on_notify_buffer_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_on_notify_buffer (self);
#line 248 "gca-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 54 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 255 "gca-view.c"
}


GcaView* gca_view_construct (GType object_type, GeditView* view) {
	GcaView * self = NULL;
	GeditView* _tmp0_;
	GeditView* _tmp1_;
	GeditView* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GeditView* _tmp5_;
	GtkContainer* _tmp6_;
	GtkContainer* _tmp7_;
	GtkScrolledWindow* _tmp8_;
	GtkScrolledWindow* sw;
	GtkScrolledWindow* _tmp9_;
	GcaDiagnosticService* _tmp13_;
	GcaRemoteService** _tmp14_ = NULL;
#line 46 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_val_if_fail (view != NULL, NULL);
#line 46 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self = (GcaView*) g_object_new (object_type, NULL);
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = view;
#line 48 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->d_view = _tmp0_;
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp1_ = self->priv->d_view;
#line 50 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_connect_object ((GObject*) _tmp1_, "notify::buffer", (GCallback) _gca_view_on_notify_buffer_g_object_notify, self, 0);
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp2_ = self->priv->d_view;
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp4_ = _tmp3_;
#line 52 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_connect_document (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gedit_document_get_type ()) ? ((GeditDocument*) _tmp4_) : NULL);
#line 54 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp5_ = self->priv->d_view;
#line 54 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp6_ = gtk_widget_get_parent ((GtkWidget*) _tmp5_);
#line 54 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp7_ = _tmp6_;
#line 54 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_SCROLLED_WINDOW) ? ((GtkScrolledWindow*) _tmp7_) : NULL);
#line 54 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	sw = _tmp8_;
#line 56 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp9_ = sw;
#line 56 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	if (_tmp9_ != NULL) {
#line 308 "gca-view.c"
		GtkScrolledWindow* _tmp10_;
		GtkWidget* _tmp11_ = NULL;
		GcaScrollbarMarker* _tmp12_;
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp10_ = sw;
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp11_ = gtk_scrolled_window_get_vscrollbar (_tmp10_);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp12_ = gca_scrollbar_marker_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GTK_TYPE_SCROLLBAR) ? ((GtkScrollbar*) _tmp11_) : NULL);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_gca_scrollbar_marker_unref0 (self->priv->d_scrollbar_marker);
#line 58 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		self->priv->d_scrollbar_marker = _tmp12_;
#line 322 "gca-view.c"
	}
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp13_ = gca_diagnostic_service_new ();
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp14_ = g_new0 (GcaRemoteService*, 1 + 1);
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp14_[0] = (GcaRemoteService*) _tmp13_;
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->d_services = (_vala_array_free (self->priv->d_services, self->priv->d_services_length1, (GDestroyNotify) g_object_unref), NULL);
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->d_services = _tmp14_;
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->d_services_length1 = 1;
#line 61 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->_d_services_size_ = self->priv->d_services_length1;
#line 46 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_g_object_unref0 (sw);
#line 46 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	return self;
#line 342 "gca-view.c"
}


GcaView* gca_view_new (GeditView* view) {
#line 46 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	return gca_view_construct (GCA_TYPE_VIEW, view);
#line 349 "gca-view.c"
}


void gca_view_deactivate (GcaView* self) {
	GeditView* _tmp0_;
	guint _tmp1_ = 0U;
	GQuark _tmp2_ = 0U;
#line 81 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = self->priv->d_view;
#line 83 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_parse_name ("notify::buffer", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
#line 83 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _gca_view_on_notify_buffer_g_object_notify, self);
#line 85 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_disconnect_document (self);
#line 87 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->d_view = NULL;
#line 369 "gca-view.c"
}


void gca_view_update (GcaView* self, GcaRemoteDocument* doc) {
	GcaRemoteService** _tmp0_;
	gint _tmp0__length1;
#line 90 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (self != NULL);
#line 90 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (doc != NULL);
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = self->priv->d_services;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0__length1 = self->priv->d_services_length1;
#line 384 "gca-view.c"
	{
		GcaRemoteService** service_collection = NULL;
		gint service_collection_length1 = 0;
		gint _service_collection_size_ = 0;
		gint service_it = 0;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		service_collection = _tmp0_;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		service_collection_length1 = _tmp0__length1;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		for (service_it = 0; service_it < _tmp0__length1; service_it = service_it + 1) {
#line 396 "gca-view.c"
			GcaRemoteService* _tmp1_;
			GcaRemoteService* service = NULL;
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
			_tmp1_ = _g_object_ref0 (service_collection[service_it]);
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
			service = _tmp1_;
#line 403 "gca-view.c"
			{
				GcaBackend* _tmp2_;
				GcaRemoteService* _tmp3_;
				GcaRemoteServices _tmp4_ = 0;
				gboolean _tmp5_ = FALSE;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
				_tmp2_ = self->priv->d_backend;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
				_tmp3_ = service;
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
				_tmp4_ = gca_remote_service_services (_tmp3_);
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
				_tmp5_ = gca_backend_supports (_tmp2_, _tmp4_);
#line 94 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
				if (_tmp5_) {
#line 419 "gca-view.c"
					GcaRemoteService* _tmp6_;
					GcaRemoteDocument* _tmp7_;
#line 96 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
					_tmp6_ = service;
#line 96 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
					_tmp7_ = doc;
#line 96 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
					gca_remote_service_update (_tmp6_, self, _tmp7_);
#line 428 "gca-view.c"
				}
#line 92 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
				_g_object_unref0 (service);
#line 432 "gca-view.c"
			}
		}
	}
}


static void _gca_view_on_notify_language_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_on_notify_language (self);
#line 442 "gca-view.c"
}


static void _gca_view_on_document_changed_gca_document_changed (GcaDocument* _sender, gpointer self) {
#line 111 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_on_document_changed (self);
#line 449 "gca-view.c"
}


static void _gca_view_on_document_path_changed_gca_document_path_changed (GcaDocument* _sender, const gchar* previous_path, gpointer self) {
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_on_document_path_changed (self, previous_path);
#line 456 "gca-view.c"
}


static void gca_view_disconnect_document (GcaView* self) {
	GcaDocument* _tmp0_;
	GcaDocument* _tmp1_;
	GeditDocument* _tmp2_;
	GeditDocument* _tmp3_;
	GeditDocument* _tmp4_;
	GeditDocument* buf;
	GeditDocument* _tmp5_;
	guint _tmp6_ = 0U;
	GQuark _tmp7_ = 0U;
	GcaDocument* _tmp8_;
	guint _tmp9_ = 0U;
	GcaDocument* _tmp10_;
	guint _tmp11_ = 0U;
#line 101 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (self != NULL);
#line 103 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = self->priv->d_document;
#line 103 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	if (_tmp0_ == NULL) {
#line 105 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		return;
#line 482 "gca-view.c"
	}
#line 108 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp1_ = self->priv->d_document;
#line 108 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp2_ = gca_document_get_document (_tmp1_);
#line 108 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp3_ = _tmp2_;
#line 108 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 108 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	buf = _tmp4_;
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp5_ = buf;
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_parse_name ("notify::language", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
#line 110 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_handlers_disconnect_matched ((GObject*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _gca_view_on_notify_language_g_object_notify, self);
#line 111 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp8_ = self->priv->d_document;
#line 111 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_parse_name ("changed", GCA_TYPE_DOCUMENT, &_tmp9_, NULL, FALSE);
#line 111 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _gca_view_on_document_changed_gca_document_changed, self);
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp10_ = self->priv->d_document;
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_parse_name ("path-changed", GCA_TYPE_DOCUMENT, &_tmp11_, NULL, FALSE);
#line 112 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _gca_view_on_document_path_changed_gca_document_path_changed, self);
#line 114 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_unregister_backend (self);
#line 116 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_g_object_unref0 (self->priv->d_document);
#line 116 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->d_document = NULL;
#line 101 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_g_object_unref0 (buf);
#line 520 "gca-view.c"
}


static void gca_view_connect_document (GcaView* self, GeditDocument* document) {
	GeditDocument* _tmp0_;
	GeditDocument* _tmp1_;
	GcaDocument* _tmp2_;
	GcaDocument* _tmp3_;
	GeditDocument* _tmp4_;
	GeditDocument* _tmp5_;
	GeditDocument* _tmp6_;
	GeditDocument* buf;
	GeditDocument* _tmp7_;
	GcaDocument* _tmp8_;
	GcaDocument* _tmp9_;
#line 119 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (self != NULL);
#line 121 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_disconnect_document (self);
#line 123 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = document;
#line 123 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	if (_tmp0_ == NULL) {
#line 125 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		return;
#line 546 "gca-view.c"
	}
#line 128 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp1_ = document;
#line 128 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp2_ = gca_document_new (_tmp1_);
#line 128 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_g_object_unref0 (self->priv->d_document);
#line 128 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->d_document = _tmp2_;
#line 130 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp3_ = self->priv->d_document;
#line 130 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp4_ = gca_document_get_document (_tmp3_);
#line 130 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp5_ = _tmp4_;
#line 130 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 130 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	buf = _tmp6_;
#line 132 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp7_ = buf;
#line 132 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_connect_object ((GObject*) _tmp7_, "notify::language", (GCallback) _gca_view_on_notify_language_g_object_notify, self, 0);
#line 134 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp8_ = self->priv->d_document;
#line 134 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_connect_object (_tmp8_, "changed", (GCallback) _gca_view_on_document_changed_gca_document_changed, self, 0);
#line 135 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp9_ = self->priv->d_document;
#line 135 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_connect_object (_tmp9_, "path-changed", (GCallback) _gca_view_on_document_path_changed_gca_document_path_changed, self, 0);
#line 137 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_update_backend (self);
#line 119 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_g_object_unref0 (buf);
#line 582 "gca-view.c"
}


static void gca_view_on_document_path_changed (GcaView* self, const gchar* prevpath) {
	const gchar* _tmp0_;
#line 140 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (self != NULL);
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = prevpath;
#line 142 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_emit_by_name (self, "path-changed", _tmp0_);
#line 594 "gca-view.c"
}


static gboolean __lambda9_ (GcaView* self) {
	gboolean result = FALSE;
#line 155 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->d_timeout = (guint) 0;
#line 156 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	result = FALSE;
#line 157 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	return result;
#line 608 "gca-view.c"
}


static gboolean ___lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda9_ (self);
#line 154 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	return result;
#line 617 "gca-view.c"
}


static void gca_view_on_document_changed (GcaView* self) {
	GcaScrollbarMarker* _tmp0_;
	GcaDocument* _tmp1_;
	GeditDocument* _tmp2_;
	GeditDocument* _tmp3_;
	gint _tmp4_ = 0;
	guint _tmp5_;
	guint _tmp7_ = 0U;
#line 145 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = self->priv->d_scrollbar_marker;
#line 147 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp1_ = self->priv->d_document;
#line 147 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp2_ = gca_document_get_document (_tmp1_);
#line 147 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp3_ = _tmp2_;
#line 147 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp4_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) _tmp3_);
#line 147 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_scrollbar_marker_set_max_line (_tmp0_, _tmp4_);
#line 149 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp5_ = self->priv->d_timeout;
#line 149 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	if (_tmp5_ != ((guint) 0)) {
#line 647 "gca-view.c"
		guint _tmp6_;
#line 151 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp6_ = self->priv->d_timeout;
#line 151 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		g_source_remove (_tmp6_);
#line 653 "gca-view.c"
	}
#line 154 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp7_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda9__gsource_func, g_object_ref (self), g_object_unref);
#line 154 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->d_timeout = _tmp7_;
#line 659 "gca-view.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	return _data1_;
#line 668 "gca-view.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 677 "gca-view.c"
		GcaView * self;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		self = _data1_->self;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_gca_backend_manager_unref0 (_data1_->manager);
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_g_object_unref0 (self);
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		g_slice_free (Block1Data, _data1_);
#line 687 "gca-view.c"
	}
}


static gpointer _gca_backend_manager_ref0 (gpointer self) {
#line 168 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	return self ? gca_backend_manager_ref (self) : NULL;
#line 695 "gca-view.c"
}


static void ___lambda8_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	GcaView * self;
	GcaBackendManager* _tmp0_;
	GAsyncResult* _tmp1_;
	GcaBackend* _tmp2_ = NULL;
	GcaBackend* backend;
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self = _data1_->self;
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (res != NULL);
#line 171 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = _data1_->manager;
#line 171 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp1_ = res;
#line 171 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp2_ = gca_backend_manager_backend_finish (_tmp0_, _tmp1_);
#line 171 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	backend = _tmp2_;
#line 172 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_register_backend (self, backend);
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_g_object_unref0 (backend);
#line 721 "gca-view.c"
}


static void ____lambda8__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	___lambda8_ (self, source_object, res);
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	block1_data_unref (self);
#line 730 "gca-view.c"
}


static void gca_view_update_backend (GcaView* self) {
	gboolean _tmp0_ = FALSE;
	GcaDocument* _tmp1_;
	gboolean _tmp7_;
#line 161 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (self != NULL);
#line 163 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_unregister_backend (self);
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp1_ = self->priv->d_document;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	if (_tmp1_ != NULL) {
#line 746 "gca-view.c"
		GcaDocument* _tmp2_;
		GeditDocument* _tmp3_;
		GeditDocument* _tmp4_;
		GtkSourceLanguage* _tmp5_;
		GtkSourceLanguage* _tmp6_;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp2_ = self->priv->d_document;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp3_ = gca_document_get_document (_tmp2_);
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp4_ = _tmp3_;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp5_ = gtk_source_buffer_get_language ((GtkSourceBuffer*) _tmp4_);
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp6_ = _tmp5_;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp0_ = _tmp6_ != NULL;
#line 764 "gca-view.c"
	} else {
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp0_ = FALSE;
#line 768 "gca-view.c"
	}
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp7_ = _tmp0_;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	if (_tmp7_) {
#line 774 "gca-view.c"
		Block1Data* _data1_;
		GcaBackendManager* _tmp8_;
		GcaBackendManager* _tmp9_;
		GcaBackendManager* _tmp10_;
		GcaBackendManager* _tmp11_;
		GcaDocument* _tmp12_;
		GeditDocument* _tmp13_;
		GeditDocument* _tmp14_;
		GtkSourceLanguage* _tmp15_;
		GtkSourceLanguage* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_data1_ = g_slice_new0 (Block1Data);
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_data1_->_ref_count_ = 1;
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_data1_->self = g_object_ref (self);
#line 168 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp8_ = gca_backend_manager_get_instance ();
#line 168 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp9_ = _tmp8_;
#line 168 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp10_ = _gca_backend_manager_ref0 (_tmp9_);
#line 168 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_data1_->manager = _tmp10_;
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp11_ = _data1_->manager;
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp12_ = self->priv->d_document;
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp13_ = gca_document_get_document (_tmp12_);
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp14_ = _tmp13_;
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp15_ = gtk_source_buffer_get_language ((GtkSourceBuffer*) _tmp14_);
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp16_ = _tmp15_;
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp17_ = gtk_source_language_get_id (_tmp16_);
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_tmp18_ = _tmp17_;
#line 170 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		gca_backend_manager_backend (_tmp11_, _tmp18_, ____lambda8__gasync_ready_callback, block1_data_ref (_data1_));
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		block1_data_unref (_data1_);
#line 166 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		_data1_ = NULL;
#line 823 "gca-view.c"
	}
}


static void gca_view_unregister_backend (GcaView* self) {
	GcaBackend* _tmp0_;
	GcaRemoteService** _tmp1_;
	gint _tmp1__length1;
	GcaBackend* _tmp4_;
#line 177 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (self != NULL);
#line 179 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = self->priv->d_backend;
#line 179 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	if (_tmp0_ == NULL) {
#line 181 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		return;
#line 841 "gca-view.c"
	}
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp1_ = self->priv->d_services;
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp1__length1 = self->priv->d_services_length1;
#line 847 "gca-view.c"
	{
		GcaRemoteService** service_collection = NULL;
		gint service_collection_length1 = 0;
		gint _service_collection_size_ = 0;
		gint service_it = 0;
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		service_collection = _tmp1_;
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		service_collection_length1 = _tmp1__length1;
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		for (service_it = 0; service_it < _tmp1__length1; service_it = service_it + 1) {
#line 859 "gca-view.c"
			GcaRemoteService* _tmp2_;
			GcaRemoteService* service = NULL;
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
			_tmp2_ = _g_object_ref0 (service_collection[service_it]);
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
			service = _tmp2_;
#line 866 "gca-view.c"
			{
				GcaRemoteService* _tmp3_;
#line 186 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
				_tmp3_ = service;
#line 186 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
				gca_remote_service_destroy (_tmp3_);
#line 184 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
				_g_object_unref0 (service);
#line 875 "gca-view.c"
			}
		}
	}
#line 189 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp4_ = self->priv->d_backend;
#line 189 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_backend_unregister (_tmp4_, self);
#line 190 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_g_object_unref0 (self->priv->d_backend);
#line 190 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->d_backend = NULL;
#line 887 "gca-view.c"
}


static void gca_view_register_backend (GcaView* self, GcaBackend* backend) {
	GcaBackend* _tmp0_;
	GcaBackend* _tmp1_;
	GcaBackend* _tmp2_;
	GcaBackend* _tmp3_;
#line 193 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (self != NULL);
#line 195 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = backend;
#line 195 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 195 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_g_object_unref0 (self->priv->d_backend);
#line 195 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->d_backend = _tmp1_;
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp2_ = backend;
#line 197 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	if (_tmp2_ == NULL) {
#line 199 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		return;
#line 912 "gca-view.c"
	}
#line 202 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp3_ = backend;
#line 202 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_backend_register (_tmp3_, self);
#line 203 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_on_document_changed (self);
#line 920 "gca-view.c"
}


static void gca_view_on_notify_buffer (GcaView* self) {
	GeditView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
#line 206 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (self != NULL);
#line 208 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_disconnect_document (self);
#line 209 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = self->priv->d_view;
#line 209 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
#line 209 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp2_ = _tmp1_;
#line 209 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_connect_document (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gedit_document_get_type ()) ? ((GeditDocument*) _tmp2_) : NULL);
#line 940 "gca-view.c"
}


static void gca_view_on_notify_language (GcaView* self) {
#line 212 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_if_fail (self != NULL);
#line 214 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_update_backend (self);
#line 949 "gca-view.c"
}


GeditView* gca_view_get_view (GcaView* self) {
	GeditView* result;
	GeditView* _tmp0_;
#line 68 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 68 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = self->priv->d_view;
#line 68 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	result = _tmp0_;
#line 68 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	return result;
#line 964 "gca-view.c"
}


GcaDocument* gca_view_get_document (GcaView* self) {
	GcaDocument* result;
	GcaDocument* _tmp0_;
#line 73 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 73 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = self->priv->d_document;
#line 73 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	result = _tmp0_;
#line 73 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	return result;
#line 979 "gca-view.c"
}


GcaScrollbarMarker* gca_view_get_scrollbar_marker (GcaView* self) {
	GcaScrollbarMarker* result;
	GcaScrollbarMarker* _tmp0_;
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_tmp0_ = self->priv->d_scrollbar_marker;
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	result = _tmp0_;
#line 78 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	return result;
#line 994 "gca-view.c"
}


static void gca_view_class_init (GcaViewClass * klass) {
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	gca_view_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_type_class_add_private (klass, sizeof (GcaViewPrivate));
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gca_view_get_property;
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	G_OBJECT_CLASS (klass)->finalize = gca_view_finalize;
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_VIEW_VIEW, g_param_spec_object ("view", "view", "view", gedit_view_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_VIEW_DOCUMENT, g_param_spec_object ("document", "document", "document", GCA_TYPE_DOCUMENT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_VIEW_SCROLLBAR_MARKER, gca_param_spec_scrollbar_marker ("scrollbar-marker", "scrollbar-marker", "scrollbar-marker", GCA_TYPE_SCROLLBAR_MARKER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_new ("changed", GCA_TYPE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	g_signal_new ("path_changed", GCA_TYPE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 1017 "gca-view.c"
}


static void gca_view_instance_init (GcaView * self) {
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv = GCA_VIEW_GET_PRIVATE (self);
#line 1024 "gca-view.c"
}


static void gca_view_finalize (GObject* obj) {
	GcaView * self;
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_VIEW, GcaView);
#line 36 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_g_object_unref0 (self->priv->d_document);
#line 37 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_g_object_unref0 (self->priv->d_backend);
#line 38 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	_gca_scrollbar_marker_unref0 (self->priv->d_scrollbar_marker);
#line 41 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	self->priv->d_services = (_vala_array_free (self->priv->d_services, self->priv->d_services_length1, (GDestroyNotify) g_object_unref), NULL);
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	G_OBJECT_CLASS (gca_view_parent_class)->finalize (obj);
#line 1042 "gca-view.c"
}


/**
 * Wrapper around Gedit.View.
 *
 * View is a wrapper around Gedit.View. It keeps track of changes to the document
 * of the gedit view and of the language of the document and registers itself
 * with the appropriate assistance backend.
 */
GType gca_view_get_type (void) {
	static volatile gsize gca_view_type_id__volatile = 0;
	if (g_once_init_enter (&gca_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaView), 0, (GInstanceInitFunc) gca_view_instance_init, NULL };
		GType gca_view_type_id;
		gca_view_type_id = g_type_register_static (G_TYPE_OBJECT, "GcaView", &g_define_type_info, 0);
		g_once_init_leave (&gca_view_type_id__volatile, gca_view_type_id);
	}
	return gca_view_type_id__volatile;
}


static void _vala_gca_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcaView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCA_TYPE_VIEW, GcaView);
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
	switch (property_id) {
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		case GCA_VIEW_VIEW:
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		g_value_set_object (value, gca_view_get_view (self));
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		break;
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		case GCA_VIEW_DOCUMENT:
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		g_value_set_object (value, gca_view_get_document (self));
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		break;
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		case GCA_VIEW_SCROLLBAR_MARKER:
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		gca_value_set_scrollbar_marker (value, gca_view_get_scrollbar_marker (self));
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		break;
#line 1088 "gca-view.c"
		default:
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/home/jesse/devel/gedit-code-assistance/src/gca-view.vala"
		break;
#line 1094 "gca-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



