/* gca-diagnostic.c generated by valac 0.22.1, the Vala compiler
 * generated from gca-diagnostic.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GCA_TYPE_SOURCE_RANGE_SUPPORT (gca_source_range_support_get_type ())
#define GCA_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_SOURCE_RANGE_SUPPORT, GcaSourceRangeSupport))
#define GCA_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_SOURCE_RANGE_SUPPORT))
#define GCA_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_TYPE_SOURCE_RANGE_SUPPORT, GcaSourceRangeSupportIface))

typedef struct _GcaSourceRangeSupport GcaSourceRangeSupport;
typedef struct _GcaSourceRangeSupportIface GcaSourceRangeSupportIface;

#define GCA_TYPE_SOURCE_RANGE (gca_source_range_get_type ())

#define GCA_TYPE_SOURCE_LOCATION (gca_source_location_get_type ())
typedef struct _GcaSourceLocation GcaSourceLocation;
typedef struct _GcaSourceRange GcaSourceRange;

#define GCA_TYPE_DIAGNOSTIC (gca_diagnostic_get_type ())
#define GCA_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC, GcaDiagnostic))
#define GCA_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC, GcaDiagnosticClass))
#define GCA_IS_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC))
#define GCA_IS_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC))
#define GCA_DIAGNOSTIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC, GcaDiagnosticClass))

typedef struct _GcaDiagnostic GcaDiagnostic;
typedef struct _GcaDiagnosticClass GcaDiagnosticClass;
typedef struct _GcaDiagnosticPrivate GcaDiagnosticPrivate;

#define GCA_DIAGNOSTIC_TYPE_FIXIT (gca_diagnostic_fixit_get_type ())
typedef struct _GcaDiagnosticFixit GcaDiagnosticFixit;

#define GCA_DIAGNOSTIC_TYPE_SEVERITY (gca_diagnostic_severity_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define GCA_DBUS_TYPE_DIAGNOSTIC (gca_dbus_diagnostic_get_type ())

#define GCA_DBUS_TYPE_FIXIT (gca_dbus_fixit_get_type ())

#define GCA_DBUS_TYPE_SOURCE_RANGE (gca_dbus_source_range_get_type ())

#define GCA_DBUS_TYPE_SOURCE_LOCATION (gca_dbus_source_location_get_type ())
typedef struct _GcaDBusSourceLocation GcaDBusSourceLocation;
typedef struct _GcaDBusSourceRange GcaDBusSourceRange;
typedef struct _GcaDBusFixit GcaDBusFixit;
typedef struct _GcaDBusDiagnostic GcaDBusDiagnostic;

struct _GcaSourceLocation {
	gint line;
	gint column;
};

struct _GcaSourceRange {
	GcaSourceLocation start;
	GcaSourceLocation end;
};

struct _GcaSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcaSourceRange* (*get_ranges) (GcaSourceRangeSupport* self, int* result_length1);
};

struct _GcaDiagnostic {
	GObject parent_instance;
	GcaDiagnosticPrivate * priv;
};

struct _GcaDiagnosticClass {
	GObjectClass parent_class;
};

struct _GcaDiagnosticFixit {
	GcaSourceRange range;
	gchar* replacement;
};

typedef enum  {
	GCA_DIAGNOSTIC_SEVERITY_NONE,
	GCA_DIAGNOSTIC_SEVERITY_INFO,
	GCA_DIAGNOSTIC_SEVERITY_WARNING,
	GCA_DIAGNOSTIC_SEVERITY_DEPRECATED,
	GCA_DIAGNOSTIC_SEVERITY_ERROR,
	GCA_DIAGNOSTIC_SEVERITY_FATAL
} GcaDiagnosticSeverity;

struct _GcaDiagnosticPrivate {
	GcaSourceRange* d_location;
	gint d_location_length1;
	gint _d_location_size_;
	GcaDiagnosticFixit* d_fixits;
	gint d_fixits_length1;
	gint _d_fixits_size_;
	GcaDiagnosticSeverity d_severity;
	gchar* d_message;
};

struct _GcaDBusSourceLocation {
	gint64 line;
	gint64 column;
};

struct _GcaDBusSourceRange {
	gint64 file;
	GcaDBusSourceLocation start;
	GcaDBusSourceLocation end;
};

struct _GcaDBusFixit {
	GcaDBusSourceRange location;
	gchar* replacement;
};

struct _GcaDBusDiagnostic {
	guint32 severity;
	GcaDBusFixit* fixits;
	gint fixits_length1;
	GcaDBusSourceRange* locations;
	gint locations_length1;
	gchar* message;
};


static gpointer gca_diagnostic_parent_class = NULL;
static GcaSourceRangeSupportIface* gca_diagnostic_gca_source_range_support_parent_iface = NULL;

GType gca_source_range_get_type (void) G_GNUC_CONST;
GType gca_source_location_get_type (void) G_GNUC_CONST;
GcaSourceLocation* gca_source_location_dup (const GcaSourceLocation* self);
void gca_source_location_free (GcaSourceLocation* self);
GcaSourceRange* gca_source_range_dup (const GcaSourceRange* self);
void gca_source_range_free (GcaSourceRange* self);
GType gca_source_range_support_get_type (void) G_GNUC_CONST;
GType gca_diagnostic_get_type (void) G_GNUC_CONST;
GType gca_diagnostic_fixit_get_type (void) G_GNUC_CONST;
GcaDiagnosticFixit* gca_diagnostic_fixit_dup (const GcaDiagnosticFixit* self);
void gca_diagnostic_fixit_free (GcaDiagnosticFixit* self);
void gca_diagnostic_fixit_copy (const GcaDiagnosticFixit* self, GcaDiagnosticFixit* dest);
void gca_diagnostic_fixit_destroy (GcaDiagnosticFixit* self);
GType gca_diagnostic_severity_get_type (void) G_GNUC_CONST;
#define GCA_DIAGNOSTIC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_DIAGNOSTIC, GcaDiagnosticPrivate))
enum  {
	GCA_DIAGNOSTIC_DUMMY_PROPERTY,
	GCA_DIAGNOSTIC_SEVERITY,
	GCA_DIAGNOSTIC_MESSAGE
};
gchar* gca_diagnostic_severity_to_string (GcaDiagnosticSeverity self);
static void _vala_GcaDiagnosticFixit_array_free (GcaDiagnosticFixit* array, gint array_length);
GType gca_dbus_diagnostic_get_type (void) G_GNUC_CONST;
GType gca_dbus_fixit_get_type (void) G_GNUC_CONST;
GType gca_dbus_source_range_get_type (void) G_GNUC_CONST;
GType gca_dbus_source_location_get_type (void) G_GNUC_CONST;
GcaDBusSourceLocation* gca_dbus_source_location_dup (const GcaDBusSourceLocation* self);
void gca_dbus_source_location_free (GcaDBusSourceLocation* self);
GcaDBusSourceRange* gca_dbus_source_range_dup (const GcaDBusSourceRange* self);
void gca_dbus_source_range_free (GcaDBusSourceRange* self);
GcaDBusFixit* gca_dbus_fixit_dup (const GcaDBusFixit* self);
void gca_dbus_fixit_free (GcaDBusFixit* self);
void gca_dbus_fixit_copy (const GcaDBusFixit* self, GcaDBusFixit* dest);
void gca_dbus_fixit_destroy (GcaDBusFixit* self);
GcaDBusDiagnostic* gca_dbus_diagnostic_dup (const GcaDBusDiagnostic* self);
void gca_dbus_diagnostic_free (GcaDBusDiagnostic* self);
void gca_dbus_diagnostic_copy (const GcaDBusDiagnostic* self, GcaDBusDiagnostic* dest);
void gca_dbus_diagnostic_destroy (GcaDBusDiagnostic* self);
GcaDiagnostic* gca_diagnostic_new_from_dbus (GcaDBusDiagnostic* diagnostic);
GcaDiagnostic* gca_diagnostic_construct_from_dbus (GType object_type, GcaDBusDiagnostic* diagnostic);
void gca_diagnostic_fixit_from_dbus (GcaDBusFixit* fixit, GcaDiagnosticFixit* result);
void gca_source_range_from_dbus (GcaDBusSourceRange* range, GcaSourceRange* result);
GcaDiagnostic* gca_diagnostic_new (GcaDiagnosticSeverity severity, GcaSourceRange* location, int location_length1, GcaDiagnosticFixit* fixits, int fixits_length1, const gchar* message);
GcaDiagnostic* gca_diagnostic_construct (GType object_type, GcaDiagnosticSeverity severity, GcaSourceRange* location, int location_length1, GcaDiagnosticFixit* fixits, int fixits_length1, const gchar* message);
static GcaSourceRange* _vala_array_dup1 (GcaSourceRange* self, int length);
static GcaDiagnosticFixit* _vala_array_dup2 (GcaDiagnosticFixit* self, int length);
static gchar* gca_diagnostic_loc_string (GcaDiagnostic* self);
gchar* gca_source_range_to_string (GcaSourceRange *self);
gchar* gca_diagnostic_to_markup (GcaDiagnostic* self, gboolean include_severity);
static GcaSourceRange* _vala_array_dup3 (GcaSourceRange* self, int length);
GcaDiagnosticFixit* gca_diagnostic_get_fixits (GcaDiagnostic* self, int* result_length1);
GcaDiagnosticSeverity gca_diagnostic_get_severity (GcaDiagnostic* self);
const gchar* gca_diagnostic_get_message (GcaDiagnostic* self);
GcaSourceRange* gca_diagnostic_get_location (GcaDiagnostic* self, int* result_length1);
static void gca_diagnostic_finalize (GObject* obj);
static void _vala_gca_diagnostic_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gchar* gca_diagnostic_severity_to_string (GcaDiagnosticSeverity self) {
	gchar* result = NULL;
	switch (self) {
		case GCA_DIAGNOSTIC_SEVERITY_NONE:
		{
			gchar* _tmp0_ = NULL;
			_tmp0_ = g_strdup ("None");
			result = _tmp0_;
			return result;
		}
		case GCA_DIAGNOSTIC_SEVERITY_INFO:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("Info");
			result = _tmp1_;
			return result;
		}
		case GCA_DIAGNOSTIC_SEVERITY_WARNING:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("Warning");
			result = _tmp2_;
			return result;
		}
		case GCA_DIAGNOSTIC_SEVERITY_DEPRECATED:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("Deprecated");
			result = _tmp3_;
			return result;
		}
		case GCA_DIAGNOSTIC_SEVERITY_ERROR:
		{
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("Error");
			result = _tmp4_;
			return result;
		}
		case GCA_DIAGNOSTIC_SEVERITY_FATAL:
		{
			gchar* _tmp5_ = NULL;
			_tmp5_ = g_strdup ("Fatal");
			result = _tmp5_;
			return result;
		}
		default:
		{
			gchar* _tmp6_ = NULL;
			_tmp6_ = g_strdup ("Unknown");
			result = _tmp6_;
			return result;
		}
	}
}


GType gca_diagnostic_severity_get_type (void) {
	static volatile gsize gca_diagnostic_severity_type_id__volatile = 0;
	if (g_once_init_enter (&gca_diagnostic_severity_type_id__volatile)) {
		static const GEnumValue values[] = {{GCA_DIAGNOSTIC_SEVERITY_NONE, "GCA_DIAGNOSTIC_SEVERITY_NONE", "none"}, {GCA_DIAGNOSTIC_SEVERITY_INFO, "GCA_DIAGNOSTIC_SEVERITY_INFO", "info"}, {GCA_DIAGNOSTIC_SEVERITY_WARNING, "GCA_DIAGNOSTIC_SEVERITY_WARNING", "warning"}, {GCA_DIAGNOSTIC_SEVERITY_DEPRECATED, "GCA_DIAGNOSTIC_SEVERITY_DEPRECATED", "deprecated"}, {GCA_DIAGNOSTIC_SEVERITY_ERROR, "GCA_DIAGNOSTIC_SEVERITY_ERROR", "error"}, {GCA_DIAGNOSTIC_SEVERITY_FATAL, "GCA_DIAGNOSTIC_SEVERITY_FATAL", "fatal"}, {0, NULL, NULL}};
		GType gca_diagnostic_severity_type_id;
		gca_diagnostic_severity_type_id = g_enum_register_static ("GcaDiagnosticSeverity", values);
		g_once_init_leave (&gca_diagnostic_severity_type_id__volatile, gca_diagnostic_severity_type_id);
	}
	return gca_diagnostic_severity_type_id__volatile;
}


static void _vala_GcaDiagnosticFixit_array_free (GcaDiagnosticFixit* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gca_diagnostic_fixit_destroy (&array[i]);
		}
	}
	g_free (array);
}


GcaDiagnostic* gca_diagnostic_construct_from_dbus (GType object_type, GcaDBusDiagnostic* diagnostic) {
	GcaDiagnostic * self = NULL;
	GcaDiagnosticFixit* f = NULL;
	GcaDBusDiagnostic _tmp0_ = {0};
	GcaDBusFixit* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GcaDiagnosticFixit* _tmp2_ = NULL;
	gint f_length1 = 0;
	gint _f_size_ = 0;
	GcaSourceRange* l = NULL;
	GcaDBusDiagnostic _tmp17_ = {0};
	GcaDBusSourceRange* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	GcaSourceRange* _tmp19_ = NULL;
	gint l_length1 = 0;
	gint _l_size_ = 0;
	GcaDBusDiagnostic _tmp34_ = {0};
	guint32 _tmp35_ = 0U;
	GcaSourceRange* _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	GcaDiagnosticFixit* _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	GcaDBusDiagnostic _tmp38_ = {0};
	const gchar* _tmp39_ = NULL;
	g_return_val_if_fail (diagnostic != NULL, NULL);
	_tmp0_ = *diagnostic;
	_tmp1_ = _tmp0_.fixits;
	_tmp1__length1 = _tmp0_.fixits_length1;
	_tmp2_ = g_new0 (GcaDiagnosticFixit, _tmp1__length1);
	f = _tmp2_;
	f_length1 = _tmp1__length1;
	_f_size_ = f_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gint _tmp6_ = 0;
				GcaDBusDiagnostic _tmp7_ = {0};
				GcaDBusFixit* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				GcaDiagnosticFixit* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				GcaDBusDiagnostic _tmp11_ = {0};
				GcaDBusFixit* _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				GcaDBusFixit _tmp14_ = {0};
				GcaDiagnosticFixit _tmp15_ = {0};
				GcaDiagnosticFixit _tmp16_ = {0};
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = *diagnostic;
				_tmp8_ = _tmp7_.fixits;
				_tmp8__length1 = _tmp7_.fixits_length1;
				if (!(_tmp6_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = f;
				_tmp9__length1 = f_length1;
				_tmp10_ = i;
				_tmp11_ = *diagnostic;
				_tmp12_ = _tmp11_.fixits;
				_tmp12__length1 = _tmp11_.fixits_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				gca_diagnostic_fixit_from_dbus (&_tmp14_, &_tmp15_);
				gca_diagnostic_fixit_destroy (&_tmp9_[_tmp10_]);
				_tmp9_[_tmp10_] = _tmp15_;
				_tmp16_ = _tmp9_[_tmp10_];
			}
		}
	}
	_tmp17_ = *diagnostic;
	_tmp18_ = _tmp17_.locations;
	_tmp18__length1 = _tmp17_.locations_length1;
	_tmp19_ = g_new0 (GcaSourceRange, _tmp18__length1);
	l = _tmp19_;
	l_length1 = _tmp18__length1;
	_l_size_ = l_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gboolean _tmp21_ = FALSE;
				gint _tmp23_ = 0;
				GcaDBusDiagnostic _tmp24_ = {0};
				GcaDBusSourceRange* _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				GcaSourceRange* _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				gint _tmp27_ = 0;
				GcaDBusDiagnostic _tmp28_ = {0};
				GcaDBusSourceRange* _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				gint _tmp30_ = 0;
				GcaDBusSourceRange _tmp31_ = {0};
				GcaSourceRange _tmp32_ = {0};
				GcaSourceRange _tmp33_ = {0};
				_tmp21_ = _tmp20_;
				if (!_tmp21_) {
					gint _tmp22_ = 0;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp23_ = i;
				_tmp24_ = *diagnostic;
				_tmp25_ = _tmp24_.locations;
				_tmp25__length1 = _tmp24_.locations_length1;
				if (!(_tmp23_ < _tmp25__length1)) {
					break;
				}
				_tmp26_ = l;
				_tmp26__length1 = l_length1;
				_tmp27_ = i;
				_tmp28_ = *diagnostic;
				_tmp29_ = _tmp28_.locations;
				_tmp29__length1 = _tmp28_.locations_length1;
				_tmp30_ = i;
				_tmp31_ = _tmp29_[_tmp30_];
				gca_source_range_from_dbus (&_tmp31_, &_tmp32_);
				_tmp26_[_tmp27_] = _tmp32_;
				_tmp33_ = _tmp26_[_tmp27_];
			}
		}
	}
	_tmp34_ = *diagnostic;
	_tmp35_ = _tmp34_.severity;
	_tmp36_ = l;
	_tmp36__length1 = l_length1;
	_tmp37_ = f;
	_tmp37__length1 = f_length1;
	_tmp38_ = *diagnostic;
	_tmp39_ = _tmp38_.message;
	self = (GcaDiagnostic*) gca_diagnostic_construct (object_type, (GcaDiagnosticSeverity) _tmp35_, _tmp36_, _tmp36__length1, _tmp37_, _tmp37__length1, _tmp39_);
	l = (g_free (l), NULL);
	f = (_vala_GcaDiagnosticFixit_array_free (f, f_length1), NULL);
	return self;
}


GcaDiagnostic* gca_diagnostic_new_from_dbus (GcaDBusDiagnostic* diagnostic) {
	return gca_diagnostic_construct_from_dbus (GCA_TYPE_DIAGNOSTIC, diagnostic);
}


static GcaSourceRange* _vala_array_dup1 (GcaSourceRange* self, int length) {
	return g_memdup (self, length * sizeof (GcaSourceRange));
}


static GcaDiagnosticFixit* _vala_array_dup2 (GcaDiagnosticFixit* self, int length) {
	GcaDiagnosticFixit* result;
	int i;
	result = g_new0 (GcaDiagnosticFixit, length);
	for (i = 0; i < length; i++) {
		GcaDiagnosticFixit _tmp0_ = {0};
		gca_diagnostic_fixit_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


GcaDiagnostic* gca_diagnostic_construct (GType object_type, GcaDiagnosticSeverity severity, GcaSourceRange* location, int location_length1, GcaDiagnosticFixit* fixits, int fixits_length1, const gchar* message) {
	GcaDiagnostic * self = NULL;
	GcaDiagnosticSeverity _tmp0_ = 0;
	GcaSourceRange* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GcaSourceRange* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GcaDiagnosticFixit* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GcaDiagnosticFixit* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (message != NULL, NULL);
	self = (GcaDiagnostic*) g_object_new (object_type, NULL);
	_tmp0_ = severity;
	self->priv->d_severity = _tmp0_;
	_tmp1_ = location;
	_tmp1__length1 = location_length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp1__length1;
	self->priv->d_location = (g_free (self->priv->d_location), NULL);
	self->priv->d_location = _tmp2_;
	self->priv->d_location_length1 = _tmp2__length1;
	self->priv->_d_location_size_ = self->priv->d_location_length1;
	_tmp3_ = fixits;
	_tmp3__length1 = fixits_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	self->priv->d_fixits = (_vala_GcaDiagnosticFixit_array_free (self->priv->d_fixits, self->priv->d_fixits_length1), NULL);
	self->priv->d_fixits = _tmp4_;
	self->priv->d_fixits_length1 = _tmp4__length1;
	self->priv->_d_fixits_size_ = self->priv->d_fixits_length1;
	_tmp5_ = message;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->priv->d_message);
	self->priv->d_message = _tmp6_;
	return self;
}


GcaDiagnostic* gca_diagnostic_new (GcaDiagnosticSeverity severity, GcaSourceRange* location, int location_length1, GcaDiagnosticFixit* fixits, int fixits_length1, const gchar* message) {
	return gca_diagnostic_construct (GCA_TYPE_DIAGNOSTIC, severity, location, location_length1, fixits, fixits_length1, message);
}


static gchar* gca_diagnostic_loc_string (GcaDiagnostic* self) {
	gchar* result = NULL;
	gchar** r = NULL;
	GcaSourceRange* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint r_length1 = 0;
	gint _r_size_ = 0;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gchar* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_location;
	_tmp0__length1 = self->priv->d_location_length1;
	_tmp1_ = g_new0 (gchar*, _tmp0__length1 + 1);
	r = _tmp1_;
	r_length1 = _tmp0__length1;
	_r_size_ = r_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				GcaSourceRange* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp8_ = 0;
				GcaSourceRange* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->d_location;
				_tmp6__length1 = self->priv->d_location_length1;
				if (!(_tmp5_ < _tmp6__length1)) {
					break;
				}
				_tmp7_ = r;
				_tmp7__length1 = r_length1;
				_tmp8_ = i;
				_tmp9_ = self->priv->d_location;
				_tmp9__length1 = self->priv->d_location_length1;
				_tmp10_ = i;
				_tmp11_ = gca_source_range_to_string (&_tmp9_[_tmp10_]);
				_g_free0 (_tmp7_[_tmp8_]);
				_tmp7_[_tmp8_] = _tmp11_;
				_tmp12_ = _tmp7_[_tmp8_];
			}
		}
	}
	_tmp13_ = r;
	_tmp13__length1 = r_length1;
	_tmp14_ = g_strjoinv (", ", _tmp13_);
	result = _tmp14_;
	r = (_vala_array_free (r, r_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gchar* gca_diagnostic_to_markup (GcaDiagnostic* self, gboolean include_severity) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = include_severity;
	if (_tmp0_) {
		GcaDiagnosticSeverity _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp1_ = self->priv->d_severity;
		_tmp2_ = gca_diagnostic_severity_to_string (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gca_diagnostic_loc_string (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->d_message;
		_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) (-1));
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("<b>%s</b> %s: %s", _tmp3_, _tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		result = _tmp10_;
		return result;
	} else {
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp11_ = gca_diagnostic_loc_string (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->d_message;
		_tmp14_ = g_markup_escape_text (_tmp13_, (gssize) (-1));
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%s: %s", _tmp12_, _tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_g_free0 (_tmp12_);
		result = _tmp17_;
		return result;
	}
}


static GcaSourceRange* _vala_array_dup3 (GcaSourceRange* self, int length) {
	return g_memdup (self, length * sizeof (GcaSourceRange));
}


static GcaSourceRange* gca_diagnostic_real_get_ranges (GcaSourceRangeSupport* base, int* result_length1) {
	GcaSourceRange* result;
	GcaDiagnostic* self;
	GcaSourceRange* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GcaSourceRange* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GcaSourceRange* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	self = (GcaDiagnostic*) base;
	_tmp0_ = self->priv->d_location;
	_tmp0__length1 = self->priv->d_location_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


GcaDiagnosticFixit* gca_diagnostic_get_fixits (GcaDiagnostic* self, int* result_length1) {
	GcaDiagnosticFixit* result;
	GcaDiagnosticFixit* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GcaDiagnosticFixit* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_fixits;
	_tmp0__length1 = self->priv->d_fixits_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


GcaDiagnosticSeverity gca_diagnostic_get_severity (GcaDiagnostic* self) {
	GcaDiagnosticSeverity result;
	GcaDiagnosticSeverity _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->d_severity;
	result = _tmp0_;
	return result;
}


const gchar* gca_diagnostic_get_message (GcaDiagnostic* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_message;
	result = _tmp0_;
	return result;
}


GcaSourceRange* gca_diagnostic_get_location (GcaDiagnostic* self, int* result_length1) {
	GcaSourceRange* result;
	GcaSourceRange* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GcaSourceRange* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_location;
	_tmp0__length1 = self->priv->d_location_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


void gca_diagnostic_fixit_from_dbus (GcaDBusFixit* fixit, GcaDiagnosticFixit* result) {
	GcaDBusFixit _tmp0_ = {0};
	GcaDBusSourceRange _tmp1_ = {0};
	GcaSourceRange _tmp2_ = {0};
	GcaDBusFixit _tmp3_ = {0};
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GcaDiagnosticFixit _tmp6_ = {0};
	g_return_if_fail (fixit != NULL);
	_tmp0_ = *fixit;
	_tmp1_ = _tmp0_.location;
	gca_source_range_from_dbus (&_tmp1_, &_tmp2_);
	_tmp3_ = *fixit;
	_tmp4_ = _tmp3_.replacement;
	_tmp5_ = g_strdup (_tmp4_);
	memset (&_tmp6_, 0, sizeof (GcaDiagnosticFixit));
	_tmp6_.range = _tmp2_;
	_g_free0 (_tmp6_.replacement);
	_tmp6_.replacement = _tmp5_;
	*result = _tmp6_;
	return;
}


void gca_diagnostic_fixit_copy (const GcaDiagnosticFixit* self, GcaDiagnosticFixit* dest) {
	GcaSourceRange _tmp0_ = {0};
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_tmp0_ = (*self).range;
	(*dest).range = _tmp0_;
	_tmp1_ = (*self).replacement;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).replacement);
	(*dest).replacement = _tmp2_;
}


void gca_diagnostic_fixit_destroy (GcaDiagnosticFixit* self) {
	_g_free0 ((*self).replacement);
}


GcaDiagnosticFixit* gca_diagnostic_fixit_dup (const GcaDiagnosticFixit* self) {
	GcaDiagnosticFixit* dup;
	dup = g_new0 (GcaDiagnosticFixit, 1);
	gca_diagnostic_fixit_copy (self, dup);
	return dup;
}


void gca_diagnostic_fixit_free (GcaDiagnosticFixit* self) {
	gca_diagnostic_fixit_destroy (self);
	g_free (self);
}


GType gca_diagnostic_fixit_get_type (void) {
	static volatile gsize gca_diagnostic_fixit_type_id__volatile = 0;
	if (g_once_init_enter (&gca_diagnostic_fixit_type_id__volatile)) {
		GType gca_diagnostic_fixit_type_id;
		gca_diagnostic_fixit_type_id = g_boxed_type_register_static ("GcaDiagnosticFixit", (GBoxedCopyFunc) gca_diagnostic_fixit_dup, (GBoxedFreeFunc) gca_diagnostic_fixit_free);
		g_once_init_leave (&gca_diagnostic_fixit_type_id__volatile, gca_diagnostic_fixit_type_id);
	}
	return gca_diagnostic_fixit_type_id__volatile;
}


static void gca_diagnostic_class_init (GcaDiagnosticClass * klass) {
	gca_diagnostic_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcaDiagnosticPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gca_diagnostic_get_property;
	G_OBJECT_CLASS (klass)->finalize = gca_diagnostic_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DIAGNOSTIC_SEVERITY, g_param_spec_enum ("severity", "severity", "severity", GCA_DIAGNOSTIC_TYPE_SEVERITY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GCA_DIAGNOSTIC_MESSAGE, g_param_spec_string ("message", "message", "message", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gca_diagnostic_gca_source_range_support_interface_init (GcaSourceRangeSupportIface * iface) {
	gca_diagnostic_gca_source_range_support_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_ranges = gca_diagnostic_real_get_ranges;
}


static void gca_diagnostic_instance_init (GcaDiagnostic * self) {
	self->priv = GCA_DIAGNOSTIC_GET_PRIVATE (self);
}


static void gca_diagnostic_finalize (GObject* obj) {
	GcaDiagnostic * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_DIAGNOSTIC, GcaDiagnostic);
	self->priv->d_location = (g_free (self->priv->d_location), NULL);
	self->priv->d_fixits = (_vala_GcaDiagnosticFixit_array_free (self->priv->d_fixits, self->priv->d_fixits_length1), NULL);
	_g_free0 (self->priv->d_message);
	G_OBJECT_CLASS (gca_diagnostic_parent_class)->finalize (obj);
}


GType gca_diagnostic_get_type (void) {
	static volatile gsize gca_diagnostic_type_id__volatile = 0;
	if (g_once_init_enter (&gca_diagnostic_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDiagnosticClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_diagnostic_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaDiagnostic), 0, (GInstanceInitFunc) gca_diagnostic_instance_init, NULL };
		static const GInterfaceInfo gca_source_range_support_info = { (GInterfaceInitFunc) gca_diagnostic_gca_source_range_support_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gca_diagnostic_type_id;
		gca_diagnostic_type_id = g_type_register_static (G_TYPE_OBJECT, "GcaDiagnostic", &g_define_type_info, 0);
		g_type_add_interface_static (gca_diagnostic_type_id, GCA_TYPE_SOURCE_RANGE_SUPPORT, &gca_source_range_support_info);
		g_once_init_leave (&gca_diagnostic_type_id__volatile, gca_diagnostic_type_id);
	}
	return gca_diagnostic_type_id__volatile;
}


static void _vala_gca_diagnostic_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcaDiagnostic * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCA_TYPE_DIAGNOSTIC, GcaDiagnostic);
	switch (property_id) {
		case GCA_DIAGNOSTIC_SEVERITY:
		g_value_set_enum (value, gca_diagnostic_get_severity (self));
		break;
		case GCA_DIAGNOSTIC_MESSAGE:
		g_value_set_string (value, gca_diagnostic_get_message (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



