/* gca-diagnostics.c generated by valac 0.22.1, the Vala compiler
 * generated from gca-diagnostics.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gedit/gedit-view.h>
#include <gtksourceview/gtksource.h>
#include <cairo.h>
#include <gedit/gedit-document.h>
#include <float.h>
#include <math.h>


#define GCA_TYPE_REMOTE_SERVICE (gca_remote_service_get_type ())
#define GCA_REMOTE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_REMOTE_SERVICE, GcaRemoteService))
#define GCA_IS_REMOTE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_REMOTE_SERVICE))
#define GCA_REMOTE_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_TYPE_REMOTE_SERVICE, GcaRemoteServiceIface))

typedef struct _GcaRemoteService GcaRemoteService;
typedef struct _GcaRemoteServiceIface GcaRemoteServiceIface;

#define GCA_TYPE_REMOTE_SERVICES (gca_remote_services_get_type ())

#define GCA_TYPE_VIEW (gca_view_get_type ())
#define GCA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_VIEW, GcaView))
#define GCA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_VIEW, GcaViewClass))
#define GCA_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_VIEW))
#define GCA_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_VIEW))
#define GCA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_VIEW, GcaViewClass))

typedef struct _GcaView GcaView;
typedef struct _GcaViewClass GcaViewClass;

#define GCA_TYPE_REMOTE_DOCUMENT (gca_remote_document_get_type ())
#define GCA_REMOTE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocument))
#define GCA_REMOTE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocumentClass))
#define GCA_IS_REMOTE_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_REMOTE_DOCUMENT))
#define GCA_IS_REMOTE_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_REMOTE_DOCUMENT))
#define GCA_REMOTE_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_REMOTE_DOCUMENT, GcaRemoteDocumentClass))

typedef struct _GcaRemoteDocument GcaRemoteDocument;
typedef struct _GcaRemoteDocumentClass GcaRemoteDocumentClass;

#define GCA_TYPE_DIAGNOSTIC_SERVICE (gca_diagnostic_service_get_type ())
#define GCA_DIAGNOSTIC_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticService))
#define GCA_DIAGNOSTIC_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticServiceClass))
#define GCA_IS_DIAGNOSTIC_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC_SERVICE))
#define GCA_IS_DIAGNOSTIC_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC_SERVICE))
#define GCA_DIAGNOSTIC_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticServiceClass))

typedef struct _GcaDiagnosticService GcaDiagnosticService;
typedef struct _GcaDiagnosticServiceClass GcaDiagnosticServiceClass;
typedef struct _GcaDiagnosticServicePrivate GcaDiagnosticServicePrivate;

#define GCA_TYPE_DIAGNOSTICS (gca_diagnostics_get_type ())
#define GCA_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTICS, GcaDiagnostics))
#define GCA_DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTICS, GcaDiagnosticsClass))
#define GCA_IS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTICS))
#define GCA_IS_DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTICS))
#define GCA_DIAGNOSTICS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTICS, GcaDiagnosticsClass))

typedef struct _GcaDiagnostics GcaDiagnostics;
typedef struct _GcaDiagnosticsClass GcaDiagnosticsClass;

#define GCA_DBUS_TYPE_DIAGNOSTICS (gca_dbus_diagnostics_get_type ())
#define GCA_DBUS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_DBUS_TYPE_DIAGNOSTICS, GcaDBusDiagnostics))
#define GCA_DBUS_IS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_DBUS_TYPE_DIAGNOSTICS))
#define GCA_DBUS_DIAGNOSTICS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_DBUS_TYPE_DIAGNOSTICS, GcaDBusDiagnosticsIface))

typedef struct _GcaDBusDiagnostics GcaDBusDiagnostics;
typedef struct _GcaDBusDiagnosticsIface GcaDBusDiagnosticsIface;

#define GCA_DBUS_TYPE_DIAGNOSTICS_PROXY (gca_dbus_diagnostics_proxy_get_type ())

#define GCA_DBUS_TYPE_DIAGNOSTIC (gca_dbus_diagnostic_get_type ())

#define GCA_DBUS_TYPE_FIXIT (gca_dbus_fixit_get_type ())

#define GCA_DBUS_TYPE_SOURCE_RANGE (gca_dbus_source_range_get_type ())

#define GCA_DBUS_TYPE_SOURCE_LOCATION (gca_dbus_source_location_get_type ())
typedef struct _GcaDBusSourceLocation GcaDBusSourceLocation;
typedef struct _GcaDBusSourceRange GcaDBusSourceRange;
typedef struct _GcaDBusFixit GcaDBusFixit;
typedef struct _GcaDBusDiagnostic GcaDBusDiagnostic;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gca_remote_document_unref0(var) ((var == NULL) ? NULL : (var = (gca_remote_document_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;

#define GCA_TYPE_DIAGNOSTIC (gca_diagnostic_get_type ())
#define GCA_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC, GcaDiagnostic))
#define GCA_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC, GcaDiagnosticClass))
#define GCA_IS_DIAGNOSTIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC))
#define GCA_IS_DIAGNOSTIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC))
#define GCA_DIAGNOSTIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC, GcaDiagnosticClass))

typedef struct _GcaDiagnostic GcaDiagnostic;
typedef struct _GcaDiagnosticClass GcaDiagnosticClass;
typedef struct _GcaDiagnosticsPrivate GcaDiagnosticsPrivate;

#define GCA_TYPE_SOURCE_INDEX (gca_source_index_get_type ())
#define GCA_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_SOURCE_INDEX, GcaSourceIndex))
#define GCA_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_SOURCE_INDEX, GcaSourceIndexClass))
#define GCA_IS_SOURCE_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_SOURCE_INDEX))
#define GCA_IS_SOURCE_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_SOURCE_INDEX))
#define GCA_SOURCE_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_SOURCE_INDEX, GcaSourceIndexClass))

typedef struct _GcaSourceIndex GcaSourceIndex;
typedef struct _GcaSourceIndexClass GcaSourceIndexClass;

#define GCA_TYPE_DIAGNOSTIC_TAGS (gca_diagnostic_tags_get_type ())
#define GCA_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC_TAGS, GcaDiagnosticTags))
#define GCA_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC_TAGS, GcaDiagnosticTagsClass))
#define GCA_IS_DIAGNOSTIC_TAGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC_TAGS))
#define GCA_IS_DIAGNOSTIC_TAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC_TAGS))
#define GCA_DIAGNOSTIC_TAGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC_TAGS, GcaDiagnosticTagsClass))

typedef struct _GcaDiagnosticTags GcaDiagnosticTags;
typedef struct _GcaDiagnosticTagsClass GcaDiagnosticTagsClass;

#define GCA_TYPE_DIAGNOSTIC_MESSAGE (gca_diagnostic_message_get_type ())
#define GCA_DIAGNOSTIC_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC_MESSAGE, GcaDiagnosticMessage))
#define GCA_DIAGNOSTIC_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC_MESSAGE, GcaDiagnosticMessageClass))
#define GCA_IS_DIAGNOSTIC_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC_MESSAGE))
#define GCA_IS_DIAGNOSTIC_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC_MESSAGE))
#define GCA_DIAGNOSTIC_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC_MESSAGE, GcaDiagnosticMessageClass))

typedef struct _GcaDiagnosticMessage GcaDiagnosticMessage;
typedef struct _GcaDiagnosticMessageClass GcaDiagnosticMessageClass;

#define GCA_TYPE_DOCUMENT (gca_document_get_type ())
#define GCA_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DOCUMENT, GcaDocument))
#define GCA_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DOCUMENT, GcaDocumentClass))
#define GCA_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DOCUMENT))
#define GCA_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DOCUMENT))
#define GCA_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DOCUMENT, GcaDocumentClass))

typedef struct _GcaDocument GcaDocument;
typedef struct _GcaDocumentClass GcaDocumentClass;

#define GCA_TYPE_SOURCE_RANGE_SUPPORT (gca_source_range_support_get_type ())
#define GCA_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_SOURCE_RANGE_SUPPORT, GcaSourceRangeSupport))
#define GCA_IS_SOURCE_RANGE_SUPPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_SOURCE_RANGE_SUPPORT))
#define GCA_SOURCE_RANGE_SUPPORT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GCA_TYPE_SOURCE_RANGE_SUPPORT, GcaSourceRangeSupportIface))

typedef struct _GcaSourceRangeSupport GcaSourceRangeSupport;
typedef struct _GcaSourceRangeSupportIface GcaSourceRangeSupportIface;

#define GCA_TYPE_SOURCE_RANGE (gca_source_range_get_type ())

#define GCA_TYPE_SOURCE_LOCATION (gca_source_location_get_type ())
typedef struct _GcaSourceLocation GcaSourceLocation;
typedef struct _GcaSourceRange GcaSourceRange;

#define GCA_TYPE_SCROLLBAR_MARKER (gca_scrollbar_marker_get_type ())
#define GCA_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarker))
#define GCA_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarkerClass))
#define GCA_IS_SCROLLBAR_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_SCROLLBAR_MARKER))
#define GCA_IS_SCROLLBAR_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_SCROLLBAR_MARKER))
#define GCA_SCROLLBAR_MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_SCROLLBAR_MARKER, GcaScrollbarMarkerClass))

typedef struct _GcaScrollbarMarker GcaScrollbarMarker;
typedef struct _GcaScrollbarMarkerClass GcaScrollbarMarkerClass;
#define _gca_scrollbar_marker_unref0(var) ((var == NULL) ? NULL : (var = (gca_scrollbar_marker_unref (var), NULL)))

#define GCA_TYPE_DIAGNOSTIC_COLORS (gca_diagnostic_colors_get_type ())
#define GCA_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_TYPE_DIAGNOSTIC_COLORS, GcaDiagnosticColors))
#define GCA_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_TYPE_DIAGNOSTIC_COLORS, GcaDiagnosticColorsClass))
#define GCA_IS_DIAGNOSTIC_COLORS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_TYPE_DIAGNOSTIC_COLORS))
#define GCA_IS_DIAGNOSTIC_COLORS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_TYPE_DIAGNOSTIC_COLORS))
#define GCA_DIAGNOSTIC_COLORS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_TYPE_DIAGNOSTIC_COLORS, GcaDiagnosticColorsClass))

typedef struct _GcaDiagnosticColors GcaDiagnosticColors;
typedef struct _GcaDiagnosticColorsClass GcaDiagnosticColorsClass;

#define GCA_SOURCE_INDEX_TYPE_ITERATOR (gca_source_index_iterator_get_type ())
#define GCA_SOURCE_INDEX_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GCA_SOURCE_INDEX_TYPE_ITERATOR, GcaSourceIndexIterator))
#define GCA_SOURCE_INDEX_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GCA_SOURCE_INDEX_TYPE_ITERATOR, GcaSourceIndexIteratorClass))
#define GCA_SOURCE_INDEX_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GCA_SOURCE_INDEX_TYPE_ITERATOR))
#define GCA_SOURCE_INDEX_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GCA_SOURCE_INDEX_TYPE_ITERATOR))
#define GCA_SOURCE_INDEX_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GCA_SOURCE_INDEX_TYPE_ITERATOR, GcaSourceIndexIteratorClass))

typedef struct _GcaSourceIndexIterator GcaSourceIndexIterator;
typedef struct _GcaSourceIndexIteratorClass GcaSourceIndexIteratorClass;

#define GCA_DIAGNOSTIC_TYPE_SEVERITY (gca_diagnostic_severity_get_type ())
#define _gca_diagnostic_colors_unref0(var) ((var == NULL) ? NULL : (var = (gca_diagnostic_colors_unref (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

#define GCA_DIAGNOSTIC_TYPE_FIXIT (gca_diagnostic_fixit_get_type ())
typedef struct _GcaDiagnosticFixit GcaDiagnosticFixit;

typedef enum  {
	GCA_REMOTE_SERVICES_DIAGNOSTICS = 1 << 0,
	GCA_REMOTE_SERVICES_SEMANTIC_VALUES = 1 << 1,
	GCA_REMOTE_SERVICES_SYMBOLS = 1 << 2
} GcaRemoteServices;

struct _GcaRemoteServiceIface {
	GTypeInterface parent_iface;
	GcaRemoteServices (*services) (GcaRemoteService* self);
	void (*update) (GcaRemoteService* self, GcaView* view, GcaRemoteDocument* document);
	void (*destroy) (GcaRemoteService* self);
};

struct _GcaDiagnosticService {
	GObject parent_instance;
	GcaDiagnosticServicePrivate * priv;
};

struct _GcaDiagnosticServiceClass {
	GObjectClass parent_class;
};

struct _GcaDBusSourceLocation {
	gint64 line;
	gint64 column;
};

struct _GcaDBusSourceRange {
	gint64 file;
	GcaDBusSourceLocation start;
	GcaDBusSourceLocation end;
};

struct _GcaDBusFixit {
	GcaDBusSourceRange location;
	gchar* replacement;
};

struct _GcaDBusDiagnostic {
	guint32 severity;
	GcaDBusFixit* fixits;
	gint fixits_length1;
	GcaDBusSourceRange* locations;
	gint locations_length1;
	gchar* message;
};

struct _GcaDBusDiagnosticsIface {
	GTypeInterface parent_iface;
	void (*diagnostics) (GcaDBusDiagnostics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GcaDBusDiagnostic* (*diagnostics_finish) (GcaDBusDiagnostics* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _GcaDiagnosticServicePrivate {
	GcaDiagnostics* d_diagnostics;
	GcaDBusDiagnostics* d_proxy;
	char* d_path;
};

struct _Block4Data {
	int _ref_count_;
	GcaDiagnosticService * self;
	GcaRemoteDocument* document;
};

struct _Block5Data {
	int _ref_count_;
	GcaDiagnosticService * self;
	GcaDBusDiagnostics* proxy;
};

struct _GcaDiagnostics {
	GObject parent_instance;
	GcaDiagnosticsPrivate * priv;
};

struct _GcaDiagnosticsClass {
	GObjectClass parent_class;
};

struct _GcaDiagnosticsPrivate {
	GcaView* d_view;
	GcaSourceIndex* d_index;
	GcaDiagnosticTags* d_tags;
	GeeHashMap* d_diagnostics_at_end;
	GcaDiagnostic** d_cursor_diagnostics;
	gint d_cursor_diagnostics_length1;
	gint _d_cursor_diagnostics_size_;
	GcaDiagnosticMessage* d_cursor_diagnostic_message;
	guint d_last_marker_id;
};

struct _GcaSourceLocation {
	gint line;
	gint column;
};

struct _GcaSourceRange {
	GcaSourceLocation start;
	GcaSourceLocation end;
};

struct _GcaSourceRangeSupportIface {
	GTypeInterface parent_iface;
	GcaSourceRange* (*get_ranges) (GcaSourceRangeSupport* self, int* result_length1);
};

typedef enum  {
	GCA_DIAGNOSTIC_SEVERITY_NONE,
	GCA_DIAGNOSTIC_SEVERITY_INFO,
	GCA_DIAGNOSTIC_SEVERITY_WARNING,
	GCA_DIAGNOSTIC_SEVERITY_DEPRECATED,
	GCA_DIAGNOSTIC_SEVERITY_ERROR,
	GCA_DIAGNOSTIC_SEVERITY_FATAL
} GcaDiagnosticSeverity;

struct _GcaDiagnosticFixit {
	GcaSourceRange range;
	gchar* replacement;
};


static gpointer gca_diagnostic_service_parent_class = NULL;
static GcaRemoteServiceIface* gca_diagnostic_service_gca_remote_service_parent_iface = NULL;
static gpointer gca_diagnostics_parent_class = NULL;

GType gca_remote_services_get_type (void) G_GNUC_CONST;
GType gca_view_get_type (void) G_GNUC_CONST;
gpointer gca_remote_document_ref (gpointer instance);
void gca_remote_document_unref (gpointer instance);
GParamSpec* gca_param_spec_remote_document (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_remote_document (GValue* value, gpointer v_object);
void gca_value_take_remote_document (GValue* value, gpointer v_object);
gpointer gca_value_get_remote_document (const GValue* value);
GType gca_remote_document_get_type (void) G_GNUC_CONST;
GType gca_remote_service_get_type (void) G_GNUC_CONST;
GType gca_diagnostic_service_get_type (void) G_GNUC_CONST;
GType gca_diagnostics_get_type (void) G_GNUC_CONST;
GType gca_dbus_diagnostics_proxy_get_type (void) G_GNUC_CONST;
guint gca_dbus_diagnostics_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType gca_dbus_diagnostic_get_type (void) G_GNUC_CONST;
GType gca_dbus_fixit_get_type (void) G_GNUC_CONST;
GType gca_dbus_source_range_get_type (void) G_GNUC_CONST;
GType gca_dbus_source_location_get_type (void) G_GNUC_CONST;
GcaDBusSourceLocation* gca_dbus_source_location_dup (const GcaDBusSourceLocation* self);
void gca_dbus_source_location_free (GcaDBusSourceLocation* self);
GcaDBusSourceRange* gca_dbus_source_range_dup (const GcaDBusSourceRange* self);
void gca_dbus_source_range_free (GcaDBusSourceRange* self);
GcaDBusFixit* gca_dbus_fixit_dup (const GcaDBusFixit* self);
void gca_dbus_fixit_free (GcaDBusFixit* self);
void gca_dbus_fixit_copy (const GcaDBusFixit* self, GcaDBusFixit* dest);
void gca_dbus_fixit_destroy (GcaDBusFixit* self);
GcaDBusDiagnostic* gca_dbus_diagnostic_dup (const GcaDBusDiagnostic* self);
void gca_dbus_diagnostic_free (GcaDBusDiagnostic* self);
void gca_dbus_diagnostic_copy (const GcaDBusDiagnostic* self, GcaDBusDiagnostic* dest);
void gca_dbus_diagnostic_destroy (GcaDBusDiagnostic* self);
GType gca_dbus_diagnostics_get_type (void) G_GNUC_CONST;
#define GCA_DIAGNOSTIC_SERVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticServicePrivate))
enum  {
	GCA_DIAGNOSTIC_SERVICE_DUMMY_PROPERTY
};
static GcaRemoteServices gca_diagnostic_service_real_services (GcaRemoteService* base);
static void gca_diagnostic_service_real_update (GcaRemoteService* base, GcaView* view, GcaRemoteDocument* document);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
GcaDiagnostics* gca_diagnostics_new (GcaView* view);
GcaDiagnostics* gca_diagnostics_construct (GType object_type, GcaView* view);
const char* gca_remote_document_get_path (GcaRemoteDocument* self);
void gca_remote_document_get_proxy (GcaRemoteDocument* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GAsyncReadyCallback _callback_, gpointer _user_data_);
gpointer gca_remote_document_get_proxy_finish (GcaRemoteDocument* self, GAsyncResult* _res_, GError** error);
static void ___lambda13_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res);
static void gca_diagnostic_service_update_proxy (GcaDiagnosticService* self);
void gca_log_debug (const gchar* format, ...);
static void ____lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
void gca_dbus_diagnostics_diagnostics (GcaDBusDiagnostics* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
GcaDBusDiagnostic* gca_dbus_diagnostics_diagnostics_finish (GcaDBusDiagnostics* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void __lambda14_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res);
GType gca_diagnostic_get_type (void) G_GNUC_CONST;
void gca_diagnostics_update (GcaDiagnostics* self, GcaDiagnostic** diagnostics, int diagnostics_length1);
static GcaDiagnostic** gca_diagnostic_service_transform (GcaDiagnosticService* self, GcaDBusDiagnostic* diagnostics, int diagnostics_length1, int* result_length1);
static void _vala_GcaDBusDiagnostic_array_free (GcaDBusDiagnostic* array, gint array_length);
static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GcaDiagnostic* gca_diagnostic_new_from_dbus (GcaDBusDiagnostic* diagnostic);
GcaDiagnostic* gca_diagnostic_construct_from_dbus (GType object_type, GcaDBusDiagnostic* diagnostic);
static void gca_diagnostic_service_real_destroy (GcaRemoteService* base);
void gca_diagnostics_destroy (GcaDiagnostics* self);
GcaDiagnosticService* gca_diagnostic_service_new (void);
GcaDiagnosticService* gca_diagnostic_service_construct (GType object_type);
static void gca_diagnostic_service_finalize (GObject* obj);
GType gca_source_index_get_type (void) G_GNUC_CONST;
GType gca_diagnostic_tags_get_type (void) G_GNUC_CONST;
GType gca_diagnostic_message_get_type (void) G_GNUC_CONST;
#define GCA_DIAGNOSTICS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GCA_TYPE_DIAGNOSTICS, GcaDiagnosticsPrivate))
enum  {
	GCA_DIAGNOSTICS_DUMMY_PROPERTY
};
GcaSourceIndex* gca_source_index_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
GcaSourceIndex* gca_source_index_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
GeditView* gca_view_get_view (GcaView* self);
GcaDiagnosticTags* gca_diagnostic_tags_new (GtkTextView* view);
GcaDiagnosticTags* gca_diagnostic_tags_construct (GType object_type, GtkTextView* view);
static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self);
static void gca_diagnostics_register_marks (GcaDiagnostics* self);
static gboolean gca_diagnostics_on_view_query_tooltip (GcaDiagnostics* self, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip);
static gboolean _gca_diagnostics_on_view_query_tooltip_gtk_widget_query_tooltip (GtkWidget* _sender, gint x, gint y, gboolean keyboard_tooltip, GtkTooltip* tooltip, gpointer self);
static gboolean gca_diagnostics_on_view_draw (GcaDiagnostics* self, cairo_t* ctx);
static gboolean _gca_diagnostics_on_view_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
GType gca_document_get_type (void) G_GNUC_CONST;
GcaDocument* gca_view_get_document (GcaView* self);
GeditDocument* gca_document_get_document (GcaDocument* self);
static void gca_diagnostics_on_buffer_mark_set (GcaDiagnostics* self, GtkTextIter* location, GtkTextMark* mark);
static void _gca_diagnostics_on_buffer_mark_set_gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self);
static void gca_diagnostics_on_cursor_moved (GcaDiagnostics* self);
static void _gca_diagnostics_on_cursor_moved_gedit_document_cursor_moved (GeditDocument* _sender, gpointer self);
void gca_source_index_clear (GcaSourceIndex* self);
GType gca_source_range_get_type (void) G_GNUC_CONST;
GType gca_source_location_get_type (void) G_GNUC_CONST;
GcaSourceLocation* gca_source_location_dup (const GcaSourceLocation* self);
void gca_source_location_free (GcaSourceLocation* self);
GcaSourceRange* gca_source_range_dup (const GcaSourceRange* self);
void gca_source_range_free (GcaSourceRange* self);
GType gca_source_range_support_get_type (void) G_GNUC_CONST;
void gca_source_index_add (GcaSourceIndex* self, GcaSourceRangeSupport* range);
static void gca_diagnostics_update_scrollbar (GcaDiagnostics* self);
static void gca_diagnostics_update_marks (GcaDiagnostics* self);
gpointer gca_scrollbar_marker_ref (gpointer instance);
void gca_scrollbar_marker_unref (gpointer instance);
GParamSpec* gca_param_spec_scrollbar_marker (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_scrollbar_marker (GValue* value, gpointer v_object);
void gca_value_take_scrollbar_marker (GValue* value, gpointer v_object);
gpointer gca_value_get_scrollbar_marker (const GValue* value);
GType gca_scrollbar_marker_get_type (void) G_GNUC_CONST;
GcaScrollbarMarker* gca_view_get_scrollbar_marker (GcaView* self);
void gca_scrollbar_marker_remove (GcaScrollbarMarker* self, guint id);
gpointer gca_diagnostic_colors_ref (gpointer instance);
void gca_diagnostic_colors_unref (gpointer instance);
GParamSpec* gca_param_spec_diagnostic_colors (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gca_value_set_diagnostic_colors (GValue* value, gpointer v_object);
void gca_value_take_diagnostic_colors (GValue* value, gpointer v_object);
gpointer gca_value_get_diagnostic_colors (const GValue* value);
GType gca_diagnostic_colors_get_type (void) G_GNUC_CONST;
GtkScrollbar* gca_scrollbar_marker_get_scrollbar (GcaScrollbarMarker* self);
GcaDiagnosticColors* gca_diagnostic_colors_new (GtkStyleContext* context);
GcaDiagnosticColors* gca_diagnostic_colors_construct (GType object_type, GtkStyleContext* context);
void gca_diagnostic_colors_mix_in_widget (GcaDiagnosticColors* self, GtkWidget* widget);
guint gca_scrollbar_marker_new_merge_id (GcaScrollbarMarker* self);
GType gca_source_index_iterator_get_type (void) G_GNUC_CONST;
GcaSourceIndexIterator* gca_source_index_iterator (GcaSourceIndex* self);
gboolean gca_source_index_iterator_next (GcaSourceIndexIterator* self);
gpointer gca_source_index_iterator_get (GcaSourceIndexIterator* self);
GType gca_diagnostic_severity_get_type (void) G_GNUC_CONST;
GdkRGBA* gca_diagnostic_colors_get (GcaDiagnosticColors* self, GcaDiagnosticSeverity severity);
GcaDiagnosticSeverity gca_diagnostic_get_severity (GcaDiagnostic* self);
GcaSourceRange* gca_source_range_support_get_ranges (GcaSourceRangeSupport* self, int* result_length1);
void gca_scrollbar_marker_add_with_id (GcaScrollbarMarker* self, guint id, GcaSourceRange* range, GdkRGBA* color);
static gboolean gca_diagnostics_diagnostic_is_at_end (GcaDiagnostics* self, GcaSourceLocation* location);
static void gca_diagnostics_add_diagnostic_at_end (GcaDiagnostics* self, GcaSourceLocation* location, GdkRGBA* color);
static void gca_diagnostics_update_diagnostic_message (GcaDiagnostics* self);
GtkTextTag* gca_diagnostic_tags_get_error_tag (GcaDiagnosticTags* self);
GtkTextTag* gca_diagnostic_tags_get_warning_tag (GcaDiagnosticTags* self);
GtkTextTag* gca_diagnostic_tags_get_info_tag (GcaDiagnosticTags* self);
GtkTextTag* gca_diagnostic_tags_get_fixit_tag (GcaDiagnosticTags* self);
static void gca_diagnostics_remove_marks (GcaDiagnostics* self);
static void gca_diagnostics_mark_diagnostic (GcaDiagnostics* self, GcaDiagnostic* diagnostic);
static GcaDiagnosticSeverity* gca_diagnostics_mark_severities (GcaDiagnostics* self, int* result_length1);
gchar* gca_diagnostics_icon_name_for_severity (GcaDiagnosticSeverity severity);
static gchar* gca_diagnostics_on_diagnostic_tooltip (GcaDiagnostics* self, GtkSourceMark* mark);
static gchar* _gca_diagnostics_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup (GtkSourceMarkAttributes* _sender, GtkSourceMark* mark, gpointer self);
gchar* gca_diagnostics_mark_category_for_severity (GcaDiagnosticSeverity severity);
static void gca_diagnostics_unregister_marks (GcaDiagnostics* self);
const gchar* gca_diagnostics_get_info_mark_category (void);
const gchar* gca_diagnostics_get_warning_mark_category (void);
const gchar* gca_diagnostics_get_error_mark_category (void);
const gchar* gca_diagnostics_get_warning_icon_name (void);
const gchar* gca_diagnostics_get_error_icon_name (void);
const gchar* gca_diagnostics_get_info_icon_name (void);
static GcaDiagnostic** gca_diagnostics_sorted_on_severity (GcaDiagnostics* self, GcaDiagnostic** diagnostics, int diagnostics_length1, int* result_length1);
static GcaDiagnostic** _vala_array_dup4 (GcaDiagnostic** self, int length);
static gint __lambda11_ (GcaDiagnostics* self, GcaDiagnostic* a, GcaDiagnostic* b);
static gint ___lambda11__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static GcaDiagnostic** gca_diagnostics_find_at (GcaDiagnostics* self, GcaSourceRange* range, int* result_length1);
gpointer* gca_source_index_find_at (GcaSourceIndex* self, GcaSourceRange* range, int* result_length1);
static GcaDiagnostic** gca_diagnostics_find_at_line (GcaDiagnostics* self, gint line, int* result_length1);
gpointer* gca_source_index_find_at_line (GcaSourceIndex* self, gint line, int* result_length1);
static void gca_diagnostics_mark_diagnostic_range (GcaDiagnostics* self, GcaDiagnostic* diagnostic, GtkTextIter* start, GtkTextIter* end);
GtkTextTag* gca_diagnostic_tags_get (GcaDiagnosticTags* self, GcaDiagnosticSeverity severity);
gboolean gca_source_range_get_iters (GcaSourceRange *self, GtkTextBuffer* buffer, GtkTextIter* start, GtkTextIter* end);
GType gca_diagnostic_fixit_get_type (void) G_GNUC_CONST;
GcaDiagnosticFixit* gca_diagnostic_fixit_dup (const GcaDiagnosticFixit* self);
void gca_diagnostic_fixit_free (GcaDiagnosticFixit* self);
void gca_diagnostic_fixit_copy (const GcaDiagnosticFixit* self, GcaDiagnosticFixit* dest);
void gca_diagnostic_fixit_destroy (GcaDiagnosticFixit* self);
GcaDiagnosticFixit* gca_diagnostic_get_fixits (GcaDiagnostic* self, int* result_length1);
static gboolean gca_diagnostics_same_diagnostics (GcaDiagnostics* self, GcaDiagnostic** first, int first_length1, GcaDiagnostic** second, int second_length1);
void gca_source_range_from_iter (GtkTextIter* iter, GcaSourceRange* result);
GcaDiagnosticMessage* gca_diagnostic_message_new (GtkSourceView* view, GcaDiagnostic** diagnostics, int diagnostics_length1);
GcaDiagnosticMessage* gca_diagnostic_message_construct (GType object_type, GtkSourceView* view, GcaDiagnostic** diagnostics, int diagnostics_length1);
static void __lambda12_ (GcaDiagnostics* self);
static void ___lambda12__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static GcaDiagnostic** _vala_array_dup5 (GcaDiagnostic** self, int length);
static gchar* gca_diagnostics_format_diagnostics (GcaDiagnostics* self, GcaDiagnostic** diagnostics, int diagnostics_length1);
gchar* gca_diagnostic_to_markup (GcaDiagnostic* self, gboolean include_severity);
static void gca_diagnostics_finalize (GObject* obj);
static void _vala_gca_diagnostics_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static GcaRemoteServices gca_diagnostic_service_real_services (GcaRemoteService* base) {
	GcaDiagnosticService * self;
	GcaRemoteServices result = 0;
	self = (GcaDiagnosticService*) base;
	result = GCA_REMOTE_SERVICES_DIAGNOSTICS;
	return result;
}


static gpointer _gca_remote_document_ref0 (gpointer self) {
	return self ? gca_remote_document_ref (self) : NULL;
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GcaDiagnosticService * self;
		self = _data4_->self;
		_gca_remote_document_unref0 (_data4_->document);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void ___lambda13_ (Block4Data* _data4_, GObject* obj, GAsyncResult* res) {
	GcaDiagnosticService * self;
	GError * _inner_error_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	{
		GcaDBusDiagnostics* _tmp0_ = NULL;
		GcaRemoteDocument* _tmp1_ = NULL;
		GAsyncResult* _tmp2_ = NULL;
		gpointer _tmp3_ = NULL;
		_tmp1_ = _data4_->document;
		_tmp2_ = res;
		_tmp3_ = gca_remote_document_get_proxy_finish (_tmp1_, _tmp2_, &_inner_error_);
		_tmp0_ = (GcaDBusDiagnostics*) _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch14_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (self->priv->d_proxy);
		self->priv->d_proxy = _tmp0_;
		gca_diagnostic_service_update_proxy (self);
	}
	goto __finally14;
	__catch14_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		gca_log_debug ("gca-diagnostics.vala:57: Failed to get diagnostics proxy: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda13__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda13_ (self, source_object, res);
	block4_data_unref (self);
}


static void gca_diagnostic_service_real_update (GcaRemoteService* base, GcaView* view, GcaRemoteDocument* document) {
	GcaDiagnosticService * self;
	Block4Data* _data4_;
	GcaRemoteDocument* _tmp0_ = NULL;
	GcaRemoteDocument* _tmp1_ = NULL;
	GcaDiagnostics* _tmp2_ = NULL;
	const char* _tmp5_ = NULL;
	GcaRemoteDocument* _tmp6_ = NULL;
	const char* _tmp7_ = NULL;
	const char* _tmp8_ = NULL;
	GcaDBusDiagnostics* _tmp9_ = NULL;
	self = (GcaDiagnosticService*) base;
	g_return_if_fail (view != NULL);
	g_return_if_fail (document != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = document;
	_tmp1_ = _gca_remote_document_ref0 (_tmp0_);
	_gca_remote_document_unref0 (_data4_->document);
	_data4_->document = _tmp1_;
	_tmp2_ = self->priv->d_diagnostics;
	if (_tmp2_ == NULL) {
		GcaView* _tmp3_ = NULL;
		GcaDiagnostics* _tmp4_ = NULL;
		_tmp3_ = view;
		_tmp4_ = gca_diagnostics_new (_tmp3_);
		_g_object_unref0 (self->priv->d_diagnostics);
		self->priv->d_diagnostics = _tmp4_;
	}
	_tmp5_ = self->priv->d_path;
	_tmp6_ = _data4_->document;
	_tmp7_ = gca_remote_document_get_path (_tmp6_);
	_tmp8_ = _tmp7_;
	if (g_strcmp0 (_tmp5_, _tmp8_) != 0) {
		_g_object_unref0 (self->priv->d_proxy);
		self->priv->d_proxy = NULL;
		_g_free0 (self->priv->d_path);
		self->priv->d_path = NULL;
	}
	_tmp9_ = self->priv->d_proxy;
	if (_tmp9_ == NULL) {
		GcaRemoteDocument* _tmp10_ = NULL;
		_tmp10_ = _data4_->document;
		gca_remote_document_get_proxy (_tmp10_, GCA_DBUS_TYPE_DIAGNOSTICS, (GBoxedCopyFunc) g_object_ref, g_object_unref, ____lambda13__gasync_ready_callback, block4_data_ref (_data4_));
	} else {
		gca_diagnostic_service_update_proxy (self);
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GcaDiagnosticService * self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->proxy);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_GcaDBusDiagnostic_array_free (GcaDBusDiagnostic* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gca_dbus_diagnostic_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void __lambda14_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res) {
	GcaDiagnosticService * self;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	{
		GcaDBusDiagnostic* ret = NULL;
		GAsyncResult* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		GcaDBusDiagnostic* _tmp2_ = NULL;
		gint ret_length1 = 0;
		gint _ret_size_ = 0;
		GcaDBusDiagnostics* _tmp3_ = NULL;
		_tmp0_ = res;
		_tmp2_ = gca_dbus_diagnostics_diagnostics_finish (_data5_->proxy, _tmp0_, &_tmp1_, &_inner_error_);
		ret = _tmp2_;
		ret_length1 = _tmp1_;
		_ret_size_ = ret_length1;
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_tmp3_ = self->priv->d_proxy;
		if (_data5_->proxy == _tmp3_) {
			GcaDiagnostics* _tmp4_ = NULL;
			gint _tmp5_ = 0;
			GcaDiagnostic** _tmp6_ = NULL;
			GcaDiagnostic** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			_tmp4_ = self->priv->d_diagnostics;
			_tmp6_ = gca_diagnostic_service_transform (self, ret, ret_length1, &_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp7__length1 = _tmp5_;
			gca_diagnostics_update (_tmp4_, _tmp7_, _tmp5_);
			_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_object_unref), NULL);
		}
		ret = (_vala_GcaDBusDiagnostic_array_free (ret, ret_length1), NULL);
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		gca_log_debug ("gca-diagnostics.vala:83: Failed to call diagnostics: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally15:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda14__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda14_ (self, source_object, res);
	block5_data_unref (self);
}


static void gca_diagnostic_service_update_proxy (GcaDiagnosticService* self) {
	Block5Data* _data5_;
	GcaDBusDiagnostics* _tmp0_ = NULL;
	GcaDBusDiagnostics* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->priv->d_proxy;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data5_->proxy = _tmp1_;
	gca_dbus_diagnostics_diagnostics (_data5_->proxy, ___lambda14__gasync_ready_callback, block5_data_ref (_data5_));
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static GcaDiagnostic** gca_diagnostic_service_transform (GcaDiagnosticService* self, GcaDBusDiagnostic* diagnostics, int diagnostics_length1, int* result_length1) {
	GcaDiagnostic** result = NULL;
	GcaDiagnostic** ret = NULL;
	GcaDBusDiagnostic* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GcaDiagnostic** _tmp1_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GcaDiagnostic** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = diagnostics;
	_tmp0__length1 = diagnostics_length1;
	_tmp1_ = g_new0 (GcaDiagnostic*, _tmp0__length1 + 1);
	ret = _tmp1_;
	ret_length1 = _tmp0__length1;
	_ret_size_ = ret_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				GcaDiagnostic** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				GcaDiagnostic** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp8_ = 0;
				GcaDBusDiagnostic* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				GcaDBusDiagnostic _tmp11_ = {0};
				GcaDiagnostic* _tmp12_ = NULL;
				GcaDiagnostic* _tmp13_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = ret;
				_tmp6__length1 = ret_length1;
				if (!(_tmp5_ < _tmp6__length1)) {
					break;
				}
				_tmp7_ = ret;
				_tmp7__length1 = ret_length1;
				_tmp8_ = i;
				_tmp9_ = diagnostics;
				_tmp9__length1 = diagnostics_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = gca_diagnostic_new_from_dbus (&_tmp11_);
				_g_object_unref0 (_tmp7_[_tmp8_]);
				_tmp7_[_tmp8_] = _tmp12_;
				_tmp13_ = _tmp7_[_tmp8_];
			}
		}
	}
	_tmp14_ = ret;
	_tmp14__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


static void gca_diagnostic_service_real_destroy (GcaRemoteService* base) {
	GcaDiagnosticService * self;
	GcaDiagnostics* _tmp0_ = NULL;
	self = (GcaDiagnosticService*) base;
	_tmp0_ = self->priv->d_diagnostics;
	if (_tmp0_ != NULL) {
		GcaDiagnostics* _tmp1_ = NULL;
		_tmp1_ = self->priv->d_diagnostics;
		gca_diagnostics_destroy (_tmp1_);
		_g_object_unref0 (self->priv->d_diagnostics);
		self->priv->d_diagnostics = NULL;
	}
}


GcaDiagnosticService* gca_diagnostic_service_construct (GType object_type) {
	GcaDiagnosticService * self = NULL;
	self = (GcaDiagnosticService*) g_object_new (object_type, NULL);
	return self;
}


GcaDiagnosticService* gca_diagnostic_service_new (void) {
	return gca_diagnostic_service_construct (GCA_TYPE_DIAGNOSTIC_SERVICE);
}


static void gca_diagnostic_service_class_init (GcaDiagnosticServiceClass * klass) {
	gca_diagnostic_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcaDiagnosticServicePrivate));
	G_OBJECT_CLASS (klass)->finalize = gca_diagnostic_service_finalize;
}


static void gca_diagnostic_service_gca_remote_service_interface_init (GcaRemoteServiceIface * iface) {
	gca_diagnostic_service_gca_remote_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->services = (GcaRemoteServices (*)(GcaRemoteService*)) gca_diagnostic_service_real_services;
	iface->update = (void (*)(GcaRemoteService*, GcaView*, GcaRemoteDocument*)) gca_diagnostic_service_real_update;
	iface->destroy = (void (*)(GcaRemoteService*)) gca_diagnostic_service_real_destroy;
}


static void gca_diagnostic_service_instance_init (GcaDiagnosticService * self) {
	self->priv = GCA_DIAGNOSTIC_SERVICE_GET_PRIVATE (self);
}


static void gca_diagnostic_service_finalize (GObject* obj) {
	GcaDiagnosticService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_DIAGNOSTIC_SERVICE, GcaDiagnosticService);
	_g_object_unref0 (self->priv->d_diagnostics);
	_g_object_unref0 (self->priv->d_proxy);
	_g_free0 (self->priv->d_path);
	G_OBJECT_CLASS (gca_diagnostic_service_parent_class)->finalize (obj);
}


GType gca_diagnostic_service_get_type (void) {
	static volatile gsize gca_diagnostic_service_type_id__volatile = 0;
	if (g_once_init_enter (&gca_diagnostic_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDiagnosticServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_diagnostic_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaDiagnosticService), 0, (GInstanceInitFunc) gca_diagnostic_service_instance_init, NULL };
		static const GInterfaceInfo gca_remote_service_info = { (GInterfaceInitFunc) gca_diagnostic_service_gca_remote_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gca_diagnostic_service_type_id;
		gca_diagnostic_service_type_id = g_type_register_static (G_TYPE_OBJECT, "GcaDiagnosticService", &g_define_type_info, 0);
		g_type_add_interface_static (gca_diagnostic_service_type_id, GCA_TYPE_REMOTE_SERVICE, &gca_remote_service_info);
		g_once_init_leave (&gca_diagnostic_service_type_id__volatile, gca_diagnostic_service_type_id);
	}
	return gca_diagnostic_service_type_id__volatile;
}


static GdkRGBA* _gdk_rgba_dup (GdkRGBA* self) {
	GdkRGBA* dup;
	dup = g_new0 (GdkRGBA, 1);
	memcpy (dup, self, sizeof (GdkRGBA));
	return dup;
}


static gboolean _gca_diagnostics_on_view_query_tooltip_gtk_widget_query_tooltip (GtkWidget* _sender, gint x, gint y, gboolean keyboard_tooltip, GtkTooltip* tooltip, gpointer self) {
	gboolean result;
	result = gca_diagnostics_on_view_query_tooltip (self, x, y, keyboard_tooltip, tooltip);
	return result;
}


static gboolean _gca_diagnostics_on_view_draw_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = gca_diagnostics_on_view_draw (self, cr);
	return result;
}


static void _gca_diagnostics_on_buffer_mark_set_gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self) {
	gca_diagnostics_on_buffer_mark_set (self, location, mark);
}


static void _gca_diagnostics_on_cursor_moved_gedit_document_cursor_moved (GeditDocument* _sender, gpointer self) {
	gca_diagnostics_on_cursor_moved (self);
}


GcaDiagnostics* gca_diagnostics_construct (GType object_type, GcaView* view) {
	GcaDiagnostics * self = NULL;
	GcaView* _tmp0_ = NULL;
	GcaView* _tmp1_ = NULL;
	GcaSourceIndex* _tmp2_ = NULL;
	GcaView* _tmp3_ = NULL;
	GeditView* _tmp4_ = NULL;
	GeditView* _tmp5_ = NULL;
	GcaDiagnosticTags* _tmp6_ = NULL;
	GeeHashMap* _tmp7_ = NULL;
	GeditView* v = NULL;
	GcaView* _tmp8_ = NULL;
	GeditView* _tmp9_ = NULL;
	GeditView* _tmp10_ = NULL;
	GeditView* _tmp11_ = NULL;
	GeditDocument* doc = NULL;
	GcaView* _tmp12_ = NULL;
	GcaDocument* _tmp13_ = NULL;
	GcaDocument* _tmp14_ = NULL;
	GeditDocument* _tmp15_ = NULL;
	GeditDocument* _tmp16_ = NULL;
	GeditDocument* _tmp17_ = NULL;
	g_return_val_if_fail (view != NULL, NULL);
	self = (GcaDiagnostics*) g_object_new (object_type, NULL);
	_tmp0_ = view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->d_view);
	self->priv->d_view = _tmp1_;
	_tmp2_ = gca_source_index_new (GCA_TYPE_DIAGNOSTIC, (GBoxedCopyFunc) g_object_ref, g_object_unref);
	_g_object_unref0 (self->priv->d_index);
	self->priv->d_index = _tmp2_;
	_tmp3_ = self->priv->d_view;
	_tmp4_ = gca_view_get_view (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gca_diagnostic_tags_new ((GtkTextView*) _tmp5_);
	_g_object_unref0 (self->priv->d_tags);
	self->priv->d_tags = _tmp6_;
	_tmp7_ = gee_hash_map_new (GTK_TYPE_TEXT_MARK, (GBoxedCopyFunc) g_object_ref, g_object_unref, gdk_rgba_get_type (), (GBoxedCopyFunc) _gdk_rgba_dup, g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_diagnostics_at_end);
	self->priv->d_diagnostics_at_end = _tmp7_;
	gca_diagnostics_register_marks (self);
	_tmp8_ = self->priv->d_view;
	_tmp9_ = gca_view_get_view (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	v = _tmp11_;
	gtk_source_view_set_show_line_marks ((GtkSourceView*) v, TRUE);
	g_signal_connect_object ((GtkWidget*) v, "query-tooltip", (GCallback) _gca_diagnostics_on_view_query_tooltip_gtk_widget_query_tooltip, self, 0);
	g_signal_connect_object ((GtkWidget*) v, "draw", (GCallback) _gca_diagnostics_on_view_draw_gtk_widget_draw, self, 0);
	_tmp12_ = self->priv->d_view;
	_tmp13_ = gca_view_get_document (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = gca_document_get_document (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	doc = _tmp17_;
	g_signal_connect_object ((GtkTextBuffer*) doc, "mark-set", (GCallback) _gca_diagnostics_on_buffer_mark_set_gtk_text_buffer_mark_set, self, 0);
	g_signal_connect_object (doc, "cursor-moved", (GCallback) _gca_diagnostics_on_cursor_moved_gedit_document_cursor_moved, self, 0);
	_g_object_unref0 (doc);
	_g_object_unref0 (v);
	return self;
}


GcaDiagnostics* gca_diagnostics_new (GcaView* view) {
	return gca_diagnostics_construct (GCA_TYPE_DIAGNOSTICS, view);
}


void gca_diagnostics_update (GcaDiagnostics* self, GcaDiagnostic** diagnostics, int diagnostics_length1) {
	GcaSourceIndex* _tmp0_ = NULL;
	GcaDiagnostic** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_index;
	gca_source_index_clear (_tmp0_);
	_tmp1_ = diagnostics;
	_tmp1__length1 = diagnostics_length1;
	{
		GcaDiagnostic** d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = _tmp1_;
		d_collection_length1 = _tmp1__length1;
		for (d_it = 0; d_it < _tmp1__length1; d_it = d_it + 1) {
			GcaDiagnostic* _tmp2_ = NULL;
			GcaDiagnostic* d = NULL;
			_tmp2_ = _g_object_ref0 (d_collection[d_it]);
			d = _tmp2_;
			{
				GcaSourceIndex* _tmp3_ = NULL;
				GcaDiagnostic* _tmp4_ = NULL;
				_tmp3_ = self->priv->d_index;
				_tmp4_ = d;
				gca_source_index_add (_tmp3_, (GcaSourceRangeSupport*) _tmp4_);
				_g_object_unref0 (d);
			}
		}
	}
	gca_diagnostics_update_scrollbar (self);
	gca_diagnostics_update_marks (self);
}


static gpointer _gca_scrollbar_marker_ref0 (gpointer self) {
	return self ? gca_scrollbar_marker_ref (self) : NULL;
}


static void gca_diagnostics_update_scrollbar (GcaDiagnostics* self) {
	GcaScrollbarMarker* sm = NULL;
	GcaView* _tmp0_ = NULL;
	GcaScrollbarMarker* _tmp1_ = NULL;
	GcaScrollbarMarker* _tmp2_ = NULL;
	GcaScrollbarMarker* _tmp3_ = NULL;
	GcaScrollbarMarker* _tmp4_ = NULL;
	GcaScrollbarMarker* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	GcaDiagnosticColors* colors = NULL;
	GcaScrollbarMarker* _tmp7_ = NULL;
	GtkScrollbar* _tmp8_ = NULL;
	GtkScrollbar* _tmp9_ = NULL;
	GtkStyleContext* _tmp10_ = NULL;
	GcaDiagnosticColors* _tmp11_ = NULL;
	GcaDiagnosticColors* mixed = NULL;
	GcaScrollbarMarker* _tmp12_ = NULL;
	GtkScrollbar* _tmp13_ = NULL;
	GtkScrollbar* _tmp14_ = NULL;
	GtkStyleContext* _tmp15_ = NULL;
	GcaDiagnosticColors* _tmp16_ = NULL;
	GcaDiagnosticColors* _tmp17_ = NULL;
	GcaView* _tmp18_ = NULL;
	GeditView* _tmp19_ = NULL;
	GeditView* _tmp20_ = NULL;
	GeeMapIterator* it = NULL;
	GeeHashMap* _tmp21_ = NULL;
	GeeMapIterator* _tmp22_ = NULL;
	GtkTextBuffer* buf = NULL;
	GcaView* _tmp23_ = NULL;
	GeditView* _tmp24_ = NULL;
	GeditView* _tmp25_ = NULL;
	GtkTextBuffer* _tmp26_ = NULL;
	GtkTextBuffer* _tmp27_ = NULL;
	GtkTextBuffer* _tmp28_ = NULL;
	GeeHashMap* _tmp35_ = NULL;
	GcaScrollbarMarker* _tmp36_ = NULL;
	guint _tmp37_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_view;
	_tmp1_ = gca_view_get_scrollbar_marker (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _gca_scrollbar_marker_ref0 (_tmp2_);
	sm = _tmp3_;
	_tmp4_ = sm;
	if (_tmp4_ == NULL) {
		_gca_scrollbar_marker_unref0 (sm);
		return;
	}
	_tmp5_ = sm;
	_tmp6_ = self->priv->d_last_marker_id;
	gca_scrollbar_marker_remove (_tmp5_, _tmp6_);
	_tmp7_ = sm;
	_tmp8_ = gca_scrollbar_marker_get_scrollbar (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	_tmp11_ = gca_diagnostic_colors_new (_tmp10_);
	colors = _tmp11_;
	_tmp12_ = sm;
	_tmp13_ = gca_scrollbar_marker_get_scrollbar (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	_tmp16_ = gca_diagnostic_colors_new (_tmp15_);
	mixed = _tmp16_;
	_tmp17_ = mixed;
	_tmp18_ = self->priv->d_view;
	_tmp19_ = gca_view_get_view (_tmp18_);
	_tmp20_ = _tmp19_;
	gca_diagnostic_colors_mix_in_widget (_tmp17_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->d_diagnostics_at_end;
	_tmp22_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp21_);
	it = _tmp22_;
	_tmp23_ = self->priv->d_view;
	_tmp24_ = gca_view_get_view (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _g_object_ref0 (_tmp27_);
	buf = _tmp28_;
	while (TRUE) {
		GeeMapIterator* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		GtkTextBuffer* _tmp31_ = NULL;
		GeeMapIterator* _tmp32_ = NULL;
		gpointer _tmp33_ = NULL;
		GtkTextMark* _tmp34_ = NULL;
		_tmp29_ = it;
		_tmp30_ = gee_map_iterator_next (_tmp29_);
		if (!_tmp30_) {
			break;
		}
		_tmp31_ = buf;
		_tmp32_ = it;
		_tmp33_ = gee_map_iterator_get_key (_tmp32_);
		_tmp34_ = (GtkTextMark*) _tmp33_;
		gtk_text_buffer_delete_mark (_tmp31_, _tmp34_);
		_g_object_unref0 (_tmp34_);
	}
	_tmp35_ = self->priv->d_diagnostics_at_end;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp35_);
	_tmp36_ = sm;
	_tmp37_ = gca_scrollbar_marker_new_merge_id (_tmp36_);
	self->priv->d_last_marker_id = _tmp37_;
	{
		GcaSourceIndexIterator* _d_it = NULL;
		GcaSourceIndex* _tmp38_ = NULL;
		GcaSourceIndexIterator* _tmp39_ = NULL;
		_tmp38_ = self->priv->d_index;
		_tmp39_ = gca_source_index_iterator (_tmp38_);
		_d_it = _tmp39_;
		while (TRUE) {
			GcaSourceIndexIterator* _tmp40_ = NULL;
			gboolean _tmp41_ = FALSE;
			GcaDiagnostic* d = NULL;
			GcaSourceIndexIterator* _tmp42_ = NULL;
			gpointer _tmp43_ = NULL;
			GdkRGBA color = {0};
			GcaDiagnosticColors* _tmp44_ = NULL;
			GcaDiagnostic* _tmp45_ = NULL;
			GcaDiagnosticSeverity _tmp46_ = 0;
			GcaDiagnosticSeverity _tmp47_ = 0;
			GdkRGBA* _tmp48_ = NULL;
			GdkRGBA* _tmp49_ = NULL;
			GdkRGBA _tmp50_ = {0};
			GdkRGBA mix = {0};
			GcaDiagnosticColors* _tmp51_ = NULL;
			GcaDiagnostic* _tmp52_ = NULL;
			GcaDiagnosticSeverity _tmp53_ = 0;
			GcaDiagnosticSeverity _tmp54_ = 0;
			GdkRGBA* _tmp55_ = NULL;
			GdkRGBA* _tmp56_ = NULL;
			GdkRGBA _tmp57_ = {0};
			GcaDiagnostic* _tmp58_ = NULL;
			GcaSourceRange* _tmp59_ = NULL;
			gint _tmp59__length1 = 0;
			GcaSourceRange* _tmp60_ = NULL;
			gint _tmp60__length1 = 0;
			_tmp40_ = _d_it;
			_tmp41_ = gca_source_index_iterator_next (_tmp40_);
			if (!_tmp41_) {
				break;
			}
			_tmp42_ = _d_it;
			_tmp43_ = gca_source_index_iterator_get (_tmp42_);
			d = (GcaDiagnostic*) _tmp43_;
			_tmp44_ = colors;
			_tmp45_ = d;
			_tmp46_ = gca_diagnostic_get_severity (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = gca_diagnostic_colors_get (_tmp44_, _tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = *_tmp49_;
			_g_free0 (_tmp49_);
			color = _tmp50_;
			_tmp51_ = mixed;
			_tmp52_ = d;
			_tmp53_ = gca_diagnostic_get_severity (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = gca_diagnostic_colors_get (_tmp51_, _tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = *_tmp56_;
			_g_free0 (_tmp56_);
			mix = _tmp57_;
			_tmp58_ = d;
			_tmp59_ = gca_source_range_support_get_ranges ((GcaSourceRangeSupport*) _tmp58_, &_tmp59__length1);
			_tmp60_ = _tmp59_;
			_tmp60__length1 = _tmp59__length1;
			{
				GcaSourceRange* range_collection = NULL;
				gint range_collection_length1 = 0;
				gint _range_collection_size_ = 0;
				gint range_it = 0;
				range_collection = _tmp60_;
				range_collection_length1 = _tmp60__length1;
				for (range_it = 0; range_it < _tmp60__length1; range_it = range_it + 1) {
					GcaSourceRange range = {0};
					range = range_collection[range_it];
					{
						GcaScrollbarMarker* _tmp61_ = NULL;
						guint _tmp62_ = 0U;
						GcaSourceRange _tmp63_ = {0};
						GdkRGBA _tmp64_ = {0};
						gboolean _tmp65_ = FALSE;
						GcaSourceRange _tmp66_ = {0};
						GcaSourceLocation _tmp67_ = {0};
						gint _tmp68_ = 0;
						GcaSourceRange _tmp69_ = {0};
						GcaSourceLocation _tmp70_ = {0};
						gint _tmp71_ = 0;
						gboolean _tmp78_ = FALSE;
						_tmp61_ = sm;
						_tmp62_ = self->priv->d_last_marker_id;
						_tmp63_ = range;
						_tmp64_ = color;
						gca_scrollbar_marker_add_with_id (_tmp61_, _tmp62_, &_tmp63_, &_tmp64_);
						_tmp66_ = range;
						_tmp67_ = _tmp66_.start;
						_tmp68_ = _tmp67_.line;
						_tmp69_ = range;
						_tmp70_ = _tmp69_.end;
						_tmp71_ = _tmp70_.line;
						if (_tmp68_ == _tmp71_) {
							GcaSourceRange _tmp72_ = {0};
							GcaSourceLocation _tmp73_ = {0};
							gint _tmp74_ = 0;
							GcaSourceRange _tmp75_ = {0};
							GcaSourceLocation _tmp76_ = {0};
							gint _tmp77_ = 0;
							_tmp72_ = range;
							_tmp73_ = _tmp72_.start;
							_tmp74_ = _tmp73_.column;
							_tmp75_ = range;
							_tmp76_ = _tmp75_.end;
							_tmp77_ = _tmp76_.column;
							_tmp65_ = _tmp74_ == _tmp77_;
						} else {
							_tmp65_ = FALSE;
						}
						_tmp78_ = _tmp65_;
						if (_tmp78_) {
							GcaSourceRange _tmp79_ = {0};
							GcaSourceLocation _tmp80_ = {0};
							gboolean _tmp81_ = FALSE;
							_tmp79_ = range;
							_tmp80_ = _tmp79_.start;
							_tmp81_ = gca_diagnostics_diagnostic_is_at_end (self, &_tmp80_);
							if (_tmp81_) {
								GcaSourceRange _tmp82_ = {0};
								GcaSourceLocation _tmp83_ = {0};
								GdkRGBA _tmp84_ = {0};
								_tmp82_ = range;
								_tmp83_ = _tmp82_.start;
								_tmp84_ = mix;
								gca_diagnostics_add_diagnostic_at_end (self, &_tmp83_, &_tmp84_);
							}
						}
					}
				}
				range_collection = (g_free (range_collection), NULL);
			}
			_g_object_unref0 (d);
		}
		_g_object_unref0 (_d_it);
	}
	gca_diagnostics_update_diagnostic_message (self);
	_g_object_unref0 (buf);
	_g_object_unref0 (it);
	_gca_diagnostic_colors_unref0 (mixed);
	_gca_diagnostic_colors_unref0 (colors);
	_gca_scrollbar_marker_unref0 (sm);
}


static void gca_diagnostics_update_marks (GcaDiagnostics* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* buf = NULL;
	GcaView* _tmp0_ = NULL;
	GeditView* _tmp1_ = NULL;
	GeditView* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextBuffer* _tmp9_ = NULL;
	GcaDiagnosticTags* _tmp10_ = NULL;
	GtkTextTag* _tmp11_ = NULL;
	GtkTextTag* _tmp12_ = NULL;
	GtkTextIter _tmp13_ = {0};
	GtkTextIter _tmp14_ = {0};
	GtkTextBuffer* _tmp15_ = NULL;
	GcaDiagnosticTags* _tmp16_ = NULL;
	GtkTextTag* _tmp17_ = NULL;
	GtkTextTag* _tmp18_ = NULL;
	GtkTextIter _tmp19_ = {0};
	GtkTextIter _tmp20_ = {0};
	GtkTextBuffer* _tmp21_ = NULL;
	GcaDiagnosticTags* _tmp22_ = NULL;
	GtkTextTag* _tmp23_ = NULL;
	GtkTextTag* _tmp24_ = NULL;
	GtkTextIter _tmp25_ = {0};
	GtkTextIter _tmp26_ = {0};
	GtkTextBuffer* _tmp27_ = NULL;
	GcaDiagnosticTags* _tmp28_ = NULL;
	GtkTextTag* _tmp29_ = NULL;
	GtkTextTag* _tmp30_ = NULL;
	GtkTextIter _tmp31_ = {0};
	GtkTextIter _tmp32_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_view;
	_tmp1_ = gca_view_get_view (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	buf = _tmp5_;
	_tmp6_ = buf;
	gtk_text_buffer_get_bounds (_tmp6_, &_tmp7_, &_tmp8_);
	start = _tmp7_;
	end = _tmp8_;
	_tmp9_ = buf;
	_tmp10_ = self->priv->d_tags;
	_tmp11_ = gca_diagnostic_tags_get_error_tag (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = start;
	_tmp14_ = end;
	gtk_text_buffer_remove_tag (_tmp9_, _tmp12_, &_tmp13_, &_tmp14_);
	_tmp15_ = buf;
	_tmp16_ = self->priv->d_tags;
	_tmp17_ = gca_diagnostic_tags_get_warning_tag (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = start;
	_tmp20_ = end;
	gtk_text_buffer_remove_tag (_tmp15_, _tmp18_, &_tmp19_, &_tmp20_);
	_tmp21_ = buf;
	_tmp22_ = self->priv->d_tags;
	_tmp23_ = gca_diagnostic_tags_get_info_tag (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = start;
	_tmp26_ = end;
	gtk_text_buffer_remove_tag (_tmp21_, _tmp24_, &_tmp25_, &_tmp26_);
	_tmp27_ = buf;
	_tmp28_ = self->priv->d_tags;
	_tmp29_ = gca_diagnostic_tags_get_fixit_tag (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = start;
	_tmp32_ = end;
	gtk_text_buffer_remove_tag (_tmp27_, _tmp30_, &_tmp31_, &_tmp32_);
	gca_diagnostics_remove_marks (self);
	{
		GcaSourceIndexIterator* _d_it = NULL;
		GcaSourceIndex* _tmp33_ = NULL;
		GcaSourceIndexIterator* _tmp34_ = NULL;
		_tmp33_ = self->priv->d_index;
		_tmp34_ = gca_source_index_iterator (_tmp33_);
		_d_it = _tmp34_;
		while (TRUE) {
			GcaSourceIndexIterator* _tmp35_ = NULL;
			gboolean _tmp36_ = FALSE;
			GcaDiagnostic* d = NULL;
			GcaSourceIndexIterator* _tmp37_ = NULL;
			gpointer _tmp38_ = NULL;
			GcaDiagnostic* _tmp39_ = NULL;
			_tmp35_ = _d_it;
			_tmp36_ = gca_source_index_iterator_next (_tmp35_);
			if (!_tmp36_) {
				break;
			}
			_tmp37_ = _d_it;
			_tmp38_ = gca_source_index_iterator_get (_tmp37_);
			d = (GcaDiagnostic*) _tmp38_;
			_tmp39_ = d;
			gca_diagnostics_mark_diagnostic (self, _tmp39_);
			_g_object_unref0 (d);
		}
		_g_object_unref0 (_d_it);
	}
	_g_object_unref0 (buf);
}


static GcaDiagnosticSeverity* gca_diagnostics_mark_severities (GcaDiagnostics* self, int* result_length1) {
	GcaDiagnosticSeverity* result = NULL;
	GcaDiagnosticSeverity* _tmp0_ = NULL;
	GcaDiagnosticSeverity* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (GcaDiagnosticSeverity, 3);
	_tmp0_[0] = GCA_DIAGNOSTIC_SEVERITY_ERROR;
	_tmp0_[1] = GCA_DIAGNOSTIC_SEVERITY_WARNING;
	_tmp0_[2] = GCA_DIAGNOSTIC_SEVERITY_INFO;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar* _gca_diagnostics_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup (GtkSourceMarkAttributes* _sender, GtkSourceMark* mark, gpointer self) {
	gchar* result;
	result = gca_diagnostics_on_diagnostic_tooltip (self, mark);
	return result;
}


static void gca_diagnostics_register_marks (GcaDiagnostics* self) {
	gint _tmp0_ = 0;
	GcaDiagnosticSeverity* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = gca_diagnostics_mark_severities (self, &_tmp0_);
	{
		GcaDiagnosticSeverity* sev_collection = NULL;
		gint sev_collection_length1 = 0;
		gint _sev_collection_size_ = 0;
		gint sev_it = 0;
		sev_collection = _tmp1_;
		sev_collection_length1 = _tmp0_;
		for (sev_it = 0; sev_it < _tmp0_; sev_it = sev_it + 1) {
			GcaDiagnosticSeverity sev = 0;
			sev = sev_collection[sev_it];
			{
				GtkSourceMarkAttributes* attr = NULL;
				GtkSourceMarkAttributes* _tmp2_ = NULL;
				GtkSourceMarkAttributes* _tmp3_ = NULL;
				GcaDiagnosticSeverity _tmp4_ = 0;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				GThemedIcon* _tmp7_ = NULL;
				GThemedIcon* _tmp8_ = NULL;
				GtkSourceMarkAttributes* _tmp9_ = NULL;
				GcaView* _tmp10_ = NULL;
				GeditView* _tmp11_ = NULL;
				GeditView* _tmp12_ = NULL;
				GcaDiagnosticSeverity _tmp13_ = 0;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				GtkSourceMarkAttributes* _tmp16_ = NULL;
				_tmp2_ = gtk_source_mark_attributes_new ();
				attr = _tmp2_;
				_tmp3_ = attr;
				_tmp4_ = sev;
				_tmp5_ = gca_diagnostics_icon_name_for_severity (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks (_tmp6_);
				_tmp8_ = _tmp7_;
				gtk_source_mark_attributes_set_gicon (_tmp3_, (GIcon*) _tmp8_);
				_g_object_unref0 (_tmp8_);
				_g_free0 (_tmp6_);
				_tmp9_ = attr;
				g_signal_connect_object (_tmp9_, "query-tooltip-markup", (GCallback) _gca_diagnostics_on_diagnostic_tooltip_gtk_source_mark_attributes_query_tooltip_markup, self, 0);
				_tmp10_ = self->priv->d_view;
				_tmp11_ = gca_view_get_view (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = sev;
				_tmp14_ = gca_diagnostics_mark_category_for_severity (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = attr;
				gtk_source_view_set_mark_attributes ((GtkSourceView*) _tmp12_, _tmp15_, _tmp16_, 0);
				_g_free0 (_tmp15_);
				_g_object_unref0 (attr);
			}
		}
		sev_collection = (g_free (sev_collection), NULL);
	}
}


static void gca_diagnostics_unregister_marks (GcaDiagnostics* self) {
	gint _tmp0_ = 0;
	GcaDiagnosticSeverity* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = gca_diagnostics_mark_severities (self, &_tmp0_);
	{
		GcaDiagnosticSeverity* sev_collection = NULL;
		gint sev_collection_length1 = 0;
		gint _sev_collection_size_ = 0;
		gint sev_it = 0;
		sev_collection = _tmp1_;
		sev_collection_length1 = _tmp0_;
		for (sev_it = 0; sev_it < _tmp0_; sev_it = sev_it + 1) {
			GcaDiagnosticSeverity sev = 0;
			sev = sev_collection[sev_it];
			{
				GtkSourceMarkAttributes* attr = NULL;
				GtkSourceMarkAttributes* _tmp2_ = NULL;
				GcaView* _tmp3_ = NULL;
				GeditView* _tmp4_ = NULL;
				GeditView* _tmp5_ = NULL;
				GcaDiagnosticSeverity _tmp6_ = 0;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				GtkSourceMarkAttributes* _tmp9_ = NULL;
				_tmp2_ = gtk_source_mark_attributes_new ();
				attr = _tmp2_;
				_tmp3_ = self->priv->d_view;
				_tmp4_ = gca_view_get_view (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = sev;
				_tmp7_ = gca_diagnostics_mark_category_for_severity (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = attr;
				gtk_source_view_set_mark_attributes ((GtkSourceView*) _tmp5_, _tmp8_, _tmp9_, 0);
				_g_free0 (_tmp8_);
				_g_object_unref0 (attr);
			}
		}
		sev_collection = (g_free (sev_collection), NULL);
	}
}


void gca_diagnostics_destroy (GcaDiagnostics* self) {
	GcaView* _tmp0_ = NULL;
	GeditView* view = NULL;
	GcaView* _tmp1_ = NULL;
	GeditView* _tmp2_ = NULL;
	GeditView* _tmp3_ = NULL;
	GeditView* _tmp4_ = NULL;
	GeditView* _tmp5_ = NULL;
	GeditView* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	GeditView* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	GeditDocument* doc = NULL;
	GcaView* _tmp10_ = NULL;
	GcaDocument* _tmp11_ = NULL;
	GcaDocument* _tmp12_ = NULL;
	GeditDocument* _tmp13_ = NULL;
	GeditDocument* _tmp14_ = NULL;
	GeditDocument* _tmp15_ = NULL;
	GeditDocument* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
	GeditDocument* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_view;
	if (_tmp0_ == NULL) {
		return;
	}
	gca_diagnostics_remove_marks (self);
	gca_diagnostics_unregister_marks (self);
	_tmp1_ = self->priv->d_view;
	_tmp2_ = gca_view_get_view (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	view = _tmp4_;
	_tmp5_ = view;
	gtk_source_view_set_show_line_marks ((GtkSourceView*) _tmp5_, FALSE);
	_tmp6_ = view;
	g_signal_parse_name ("query-tooltip", GTK_TYPE_WIDGET, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gca_diagnostics_on_view_query_tooltip_gtk_widget_query_tooltip, self);
	_tmp8_ = view;
	g_signal_parse_name ("draw", GTK_TYPE_WIDGET, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _gca_diagnostics_on_view_draw_gtk_widget_draw, self);
	_tmp10_ = self->priv->d_view;
	_tmp11_ = gca_view_get_document (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = gca_document_get_document (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	doc = _tmp15_;
	_tmp16_ = doc;
	g_signal_parse_name ("mark-set", GTK_TYPE_TEXT_BUFFER, &_tmp17_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp16_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp17_, 0, NULL, (GCallback) _gca_diagnostics_on_buffer_mark_set_gtk_text_buffer_mark_set, self);
	_tmp18_ = doc;
	g_signal_parse_name ("cursor-moved", gedit_document_get_type (), &_tmp19_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _gca_diagnostics_on_cursor_moved_gedit_document_cursor_moved, self);
	_g_object_unref0 (self->priv->d_view);
	self->priv->d_view = NULL;
	_g_object_unref0 (doc);
	_g_object_unref0 (view);
}


static void gca_diagnostics_remove_marks (GcaDiagnostics* self) {
	GcaView* _tmp0_ = NULL;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GeditDocument* buf = NULL;
	GcaView* _tmp1_ = NULL;
	GcaDocument* _tmp2_ = NULL;
	GcaDocument* _tmp3_ = NULL;
	GeditDocument* _tmp4_ = NULL;
	GeditDocument* _tmp5_ = NULL;
	GeditDocument* _tmp6_ = NULL;
	GeditDocument* _tmp7_ = NULL;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	GeditDocument* _tmp10_ = NULL;
	GtkTextIter _tmp11_ = {0};
	GtkTextIter _tmp12_ = {0};
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GeditDocument* _tmp15_ = NULL;
	GtkTextIter _tmp16_ = {0};
	GtkTextIter _tmp17_ = {0};
	GeditDocument* _tmp18_ = NULL;
	GtkTextIter _tmp19_ = {0};
	GtkTextIter _tmp20_ = {0};
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GeditDocument* _tmp23_ = NULL;
	GtkTextIter _tmp24_ = {0};
	GtkTextIter _tmp25_ = {0};
	GeditDocument* _tmp26_ = NULL;
	GtkTextIter _tmp27_ = {0};
	GtkTextIter _tmp28_ = {0};
	const gchar* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_view;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->d_view;
	_tmp2_ = gca_view_get_document (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gca_document_get_document (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	buf = _tmp6_;
	_tmp7_ = buf;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp7_, &_tmp8_, &_tmp9_);
	start = _tmp8_;
	end = _tmp9_;
	_tmp10_ = buf;
	_tmp11_ = start;
	_tmp12_ = end;
	_tmp13_ = gca_diagnostics_get_info_mark_category ();
	_tmp14_ = _tmp13_;
	gtk_source_buffer_remove_source_marks ((GtkSourceBuffer*) _tmp10_, &_tmp11_, &_tmp12_, _tmp14_);
	_tmp15_ = buf;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp15_, &_tmp16_, &_tmp17_);
	start = _tmp16_;
	end = _tmp17_;
	_tmp18_ = buf;
	_tmp19_ = start;
	_tmp20_ = end;
	_tmp21_ = gca_diagnostics_get_warning_mark_category ();
	_tmp22_ = _tmp21_;
	gtk_source_buffer_remove_source_marks ((GtkSourceBuffer*) _tmp18_, &_tmp19_, &_tmp20_, _tmp22_);
	_tmp23_ = buf;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) _tmp23_, &_tmp24_, &_tmp25_);
	start = _tmp24_;
	end = _tmp25_;
	_tmp26_ = buf;
	_tmp27_ = start;
	_tmp28_ = end;
	_tmp29_ = gca_diagnostics_get_error_mark_category ();
	_tmp30_ = _tmp29_;
	gtk_source_buffer_remove_source_marks ((GtkSourceBuffer*) _tmp26_, &_tmp27_, &_tmp28_, _tmp30_);
	_g_object_unref0 (buf);
}


gchar* gca_diagnostics_mark_category_for_severity (GcaDiagnosticSeverity severity) {
	gchar* result = NULL;
	GcaDiagnosticSeverity _tmp0_ = 0;
	_tmp0_ = severity;
	switch (_tmp0_) {
		case GCA_DIAGNOSTIC_SEVERITY_WARNING:
		case GCA_DIAGNOSTIC_SEVERITY_DEPRECATED:
		{
			const gchar* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			_tmp1_ = gca_diagnostics_get_warning_mark_category ();
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case GCA_DIAGNOSTIC_SEVERITY_ERROR:
		case GCA_DIAGNOSTIC_SEVERITY_FATAL:
		{
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp4_ = gca_diagnostics_get_error_mark_category ();
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case GCA_DIAGNOSTIC_SEVERITY_INFO:
		{
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			_tmp7_ = gca_diagnostics_get_info_mark_category ();
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}


gchar* gca_diagnostics_icon_name_for_severity (GcaDiagnosticSeverity severity) {
	gchar* result = NULL;
	GcaDiagnosticSeverity _tmp0_ = 0;
	_tmp0_ = severity;
	switch (_tmp0_) {
		case GCA_DIAGNOSTIC_SEVERITY_WARNING:
		case GCA_DIAGNOSTIC_SEVERITY_DEPRECATED:
		{
			const gchar* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			_tmp1_ = gca_diagnostics_get_warning_icon_name ();
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case GCA_DIAGNOSTIC_SEVERITY_ERROR:
		case GCA_DIAGNOSTIC_SEVERITY_FATAL:
		{
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp4_ = gca_diagnostics_get_error_icon_name ();
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case GCA_DIAGNOSTIC_SEVERITY_INFO:
		{
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			_tmp7_ = gca_diagnostics_get_info_icon_name ();
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}


static GcaDiagnostic** _vala_array_dup4 (GcaDiagnostic** self, int length) {
	GcaDiagnostic** result;
	int i;
	result = g_new0 (GcaDiagnostic*, length + 1);
	for (i = 0; i < length; i++) {
		GcaDiagnostic* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gint __lambda11_ (GcaDiagnostics* self, GcaDiagnostic* a, GcaDiagnostic* b) {
	gint result = 0;
	GcaDiagnostic* _tmp0_ = NULL;
	GcaDiagnosticSeverity _tmp1_ = 0;
	GcaDiagnosticSeverity _tmp2_ = 0;
	GcaDiagnostic* _tmp3_ = NULL;
	GcaDiagnosticSeverity _tmp4_ = 0;
	GcaDiagnosticSeverity _tmp5_ = 0;
	gint _tmp6_ = 0;
	GcaDiagnostic* _tmp7_ = NULL;
	GcaDiagnosticSeverity _tmp8_ = 0;
	GcaDiagnosticSeverity _tmp9_ = 0;
	GcaDiagnostic* _tmp10_ = NULL;
	GcaDiagnosticSeverity _tmp11_ = 0;
	GcaDiagnosticSeverity _tmp12_ = 0;
	gint _tmp13_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = gca_diagnostic_get_severity (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = b;
	_tmp4_ = gca_diagnostic_get_severity (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp2_ == _tmp5_) {
		result = 0;
		return result;
	}
	_tmp7_ = a;
	_tmp8_ = gca_diagnostic_get_severity (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = b;
	_tmp11_ = gca_diagnostic_get_severity (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp9_ < _tmp12_) {
		_tmp6_ = -1;
	} else {
		_tmp6_ = 1;
	}
	_tmp13_ = _tmp6_;
	result = _tmp13_;
	return result;
}


static gint ___lambda11__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda11_ (self, a, b);
	return result;
}


static GcaDiagnostic** gca_diagnostics_sorted_on_severity (GcaDiagnostics* self, GcaDiagnostic** diagnostics, int diagnostics_length1, int* result_length1) {
	GcaDiagnostic** result = NULL;
	GeeArrayList* lst = NULL;
	GcaDiagnostic** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GcaDiagnostic** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GeeArrayList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gpointer* _tmp4_ = NULL;
	GcaDiagnostic** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = diagnostics;
	_tmp0__length1 = diagnostics_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup4 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = gee_array_list_new_wrap (GCA_TYPE_DIAGNOSTIC, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp1_, _tmp1__length1, NULL, NULL, NULL);
	lst = _tmp2_;
	gee_list_sort ((GeeList*) lst, ___lambda11__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp4_ = gee_collection_to_array ((GeeCollection*) lst, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	_g_object_unref0 (lst);
	return result;
}


static GcaDiagnostic** gca_diagnostics_find_at (GcaDiagnostics* self, GcaSourceRange* range, int* result_length1) {
	GcaDiagnostic** result = NULL;
	GcaSourceIndex* _tmp0_ = NULL;
	GcaSourceRange _tmp1_ = {0};
	gint _tmp2_ = 0;
	gpointer* _tmp3_ = NULL;
	GcaDiagnostic** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	GcaDiagnostic** _tmp6_ = NULL;
	GcaDiagnostic** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GcaDiagnostic** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (range != NULL, NULL);
	_tmp0_ = self->priv->d_index;
	_tmp1_ = *range;
	_tmp3_ = gca_source_index_find_at (_tmp0_, &_tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp6_ = gca_diagnostics_sorted_on_severity (self, _tmp4_, _tmp2_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}


static GcaDiagnostic** gca_diagnostics_find_at_line (GcaDiagnostics* self, gint line, int* result_length1) {
	GcaDiagnostic** result = NULL;
	GcaSourceIndex* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gpointer* _tmp3_ = NULL;
	GcaDiagnostic** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	GcaDiagnostic** _tmp6_ = NULL;
	GcaDiagnostic** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GcaDiagnostic** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_index;
	_tmp1_ = line;
	_tmp3_ = gca_source_index_find_at_line (_tmp0_, _tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp6_ = gca_diagnostics_sorted_on_severity (self, _tmp4_, _tmp2_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}


static void gca_diagnostics_mark_diagnostic_range (GcaDiagnostics* self, GcaDiagnostic* diagnostic, GtkTextIter* start, GtkTextIter* end) {
	GtkTextTag* tag = NULL;
	GcaDiagnosticTags* _tmp0_ = NULL;
	GcaDiagnostic* _tmp1_ = NULL;
	GcaDiagnosticSeverity _tmp2_ = 0;
	GcaDiagnosticSeverity _tmp3_ = 0;
	GtkTextTag* _tmp4_ = NULL;
	gchar* category = NULL;
	GcaDiagnostic* _tmp5_ = NULL;
	GcaDiagnosticSeverity _tmp6_ = 0;
	GcaDiagnosticSeverity _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	GeditDocument* doc = NULL;
	GcaView* _tmp9_ = NULL;
	GcaDocument* _tmp10_ = NULL;
	GcaDocument* _tmp11_ = NULL;
	GeditDocument* _tmp12_ = NULL;
	GeditDocument* _tmp13_ = NULL;
	GeditDocument* _tmp14_ = NULL;
	GeditDocument* _tmp15_ = NULL;
	GtkTextTag* _tmp16_ = NULL;
	GtkTextIter _tmp17_ = {0};
	GtkTextIter _tmp18_ = {0};
	GtkTextIter m = {0};
	GtkTextIter _tmp19_ = {0};
	gboolean _tmp20_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (diagnostic != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = self->priv->d_tags;
	_tmp1_ = diagnostic;
	_tmp2_ = gca_diagnostic_get_severity (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gca_diagnostic_tags_get (_tmp0_, _tmp3_);
	tag = _tmp4_;
	_tmp5_ = diagnostic;
	_tmp6_ = gca_diagnostic_get_severity (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gca_diagnostics_mark_category_for_severity (_tmp7_);
	category = _tmp8_;
	_tmp9_ = self->priv->d_view;
	_tmp10_ = gca_view_get_document (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gca_document_get_document (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	doc = _tmp14_;
	_tmp15_ = doc;
	_tmp16_ = tag;
	_tmp17_ = *start;
	_tmp18_ = *end;
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) _tmp15_, _tmp16_, &_tmp17_, &_tmp18_);
	_tmp19_ = *start;
	m = _tmp19_;
	_tmp20_ = gtk_text_iter_starts_line (&m);
	if (!_tmp20_) {
		gtk_text_iter_set_line_offset (&m, 0);
	}
	while (TRUE) {
		gboolean _tmp21_ = FALSE;
		const gchar* _tmp22_ = NULL;
		gboolean _tmp25_ = FALSE;
		gboolean alreadyhas = FALSE;
		GeditDocument* _tmp26_ = NULL;
		GtkTextIter _tmp27_ = {0};
		const gchar* _tmp28_ = NULL;
		GSList* _tmp29_ = NULL;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp42_ = FALSE;
		_tmp22_ = category;
		if (_tmp22_ != NULL) {
			GtkTextIter _tmp23_ = {0};
			gint _tmp24_ = 0;
			_tmp23_ = *end;
			_tmp24_ = gtk_text_iter_compare (&m, &_tmp23_);
			_tmp21_ = _tmp24_ <= 0;
		} else {
			_tmp21_ = FALSE;
		}
		_tmp25_ = _tmp21_;
		if (!_tmp25_) {
			break;
		}
		alreadyhas = FALSE;
		_tmp26_ = doc;
		_tmp27_ = m;
		_tmp28_ = category;
		_tmp29_ = gtk_source_buffer_get_source_marks_at_iter ((GtkSourceBuffer*) _tmp26_, &_tmp27_, _tmp28_);
		{
			GSList* mark_collection = NULL;
			GSList* mark_it = NULL;
			mark_collection = _tmp29_;
			for (mark_it = mark_collection; mark_it != NULL; mark_it = mark_it->next) {
				GtkSourceMark* mark = NULL;
				mark = (GtkSourceMark*) mark_it->data;
				{
					GtkSourceMark* _tmp30_ = NULL;
					gconstpointer _tmp31_ = NULL;
					GcaDiagnostic* _tmp32_ = NULL;
					_tmp30_ = mark;
					_tmp31_ = g_object_get_data ((GObject*) _tmp30_, "Gca.Document.MarkDiagnostic");
					_tmp32_ = diagnostic;
					if (((GcaDiagnostic*) _tmp31_) == _tmp32_) {
						alreadyhas = TRUE;
						break;
					}
				}
			}
			_g_slist_free0 (mark_collection);
		}
		_tmp33_ = alreadyhas;
		if (!_tmp33_) {
			GtkSourceMark* mark = NULL;
			GeditDocument* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			GtkTextIter _tmp36_ = {0};
			GtkSourceMark* _tmp37_ = NULL;
			GtkSourceMark* _tmp38_ = NULL;
			GtkSourceMark* _tmp39_ = NULL;
			GcaDiagnostic* _tmp40_ = NULL;
			GcaDiagnostic* _tmp41_ = NULL;
			_tmp34_ = doc;
			_tmp35_ = category;
			_tmp36_ = m;
			_tmp37_ = gtk_source_buffer_create_source_mark ((GtkSourceBuffer*) _tmp34_, NULL, _tmp35_, &_tmp36_);
			_tmp38_ = _g_object_ref0 (_tmp37_);
			mark = _tmp38_;
			_tmp39_ = mark;
			_tmp40_ = diagnostic;
			_tmp41_ = _g_object_ref0 (_tmp40_);
			g_object_set_data_full ((GObject*) _tmp39_, "Gca.Document.MarkDiagnostic", _tmp41_, g_object_unref);
			_g_object_unref0 (mark);
		}
		_tmp42_ = gtk_text_iter_forward_line (&m);
		if (!_tmp42_) {
			break;
		}
	}
	_g_object_unref0 (doc);
	_g_free0 (category);
	_g_object_unref0 (tag);
}


static void gca_diagnostics_mark_diagnostic (GcaDiagnostics* self, GcaDiagnostic* diagnostic) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GeditDocument* doc = NULL;
	GcaView* _tmp0_ = NULL;
	GcaDocument* _tmp1_ = NULL;
	GcaDocument* _tmp2_ = NULL;
	GeditDocument* _tmp3_ = NULL;
	GeditDocument* _tmp4_ = NULL;
	GeditDocument* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (diagnostic != NULL);
	_tmp0_ = self->priv->d_view;
	_tmp1_ = gca_view_get_document (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gca_document_get_document (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	doc = _tmp5_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_ = FALSE;
				guint _tmp9_ = 0U;
				GcaDiagnostic* _tmp10_ = NULL;
				GcaSourceRange* _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				GcaSourceRange* _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				GcaSourceRange* _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gboolean _tmp14_ = FALSE;
				GcaDiagnostic* _tmp15_ = NULL;
				GcaSourceRange* _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				GcaSourceRange* _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				GcaSourceRange* _tmp18_ = NULL;
				gint _tmp18__length1 = 0;
				guint _tmp19_ = 0U;
				GeditDocument* _tmp20_ = NULL;
				GtkTextIter _tmp21_ = {0};
				GtkTextIter _tmp22_ = {0};
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				GcaDiagnostic* _tmp25_ = NULL;
				GtkTextIter _tmp26_ = {0};
				GtkTextIter _tmp27_ = {0};
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					guint _tmp8_ = 0U;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = diagnostic;
				_tmp11_ = gca_source_range_support_get_ranges ((GcaSourceRangeSupport*) _tmp10_, &_tmp11__length1);
				_tmp12_ = _tmp11_;
				_tmp12__length1 = _tmp11__length1;
				_tmp13_ = _tmp12_;
				_tmp13__length1 = _tmp12__length1;
				_tmp14_ = !(_tmp9_ < ((guint) _tmp12__length1));
				_tmp13_ = (g_free (_tmp13_), NULL);
				if (_tmp14_) {
					break;
				}
				_tmp15_ = diagnostic;
				_tmp16_ = gca_source_range_support_get_ranges ((GcaSourceRangeSupport*) _tmp15_, &_tmp16__length1);
				_tmp17_ = _tmp16_;
				_tmp17__length1 = _tmp16__length1;
				_tmp18_ = _tmp17_;
				_tmp18__length1 = _tmp17__length1;
				_tmp19_ = i;
				_tmp20_ = doc;
				_tmp23_ = gca_source_range_get_iters (&_tmp18_[_tmp19_], (GtkTextBuffer*) _tmp20_, &_tmp21_, &_tmp22_);
				start = _tmp21_;
				end = _tmp22_;
				_tmp24_ = !_tmp23_;
				_tmp18_ = (g_free (_tmp18_), NULL);
				if (_tmp24_) {
					continue;
				}
				_tmp25_ = diagnostic;
				_tmp26_ = start;
				_tmp27_ = end;
				gca_diagnostics_mark_diagnostic_range (self, _tmp25_, &_tmp26_, &_tmp27_);
			}
		}
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				gboolean _tmp29_ = FALSE;
				guint _tmp31_ = 0U;
				GcaDiagnostic* _tmp32_ = NULL;
				GcaDiagnosticFixit* _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				GcaDiagnosticFixit* _tmp34_ = NULL;
				gint _tmp34__length1 = 0;
				GcaSourceRange r = {0};
				GcaDiagnostic* _tmp35_ = NULL;
				GcaDiagnosticFixit* _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				GcaDiagnosticFixit* _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				guint _tmp38_ = 0U;
				GcaDiagnosticFixit _tmp39_ = {0};
				GcaSourceRange _tmp40_ = {0};
				GeditDocument* _tmp41_ = NULL;
				GtkTextIter _tmp42_ = {0};
				GtkTextIter _tmp43_ = {0};
				gboolean _tmp44_ = FALSE;
				_tmp29_ = _tmp28_;
				if (!_tmp29_) {
					guint _tmp30_ = 0U;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp28_ = FALSE;
				_tmp31_ = i;
				_tmp32_ = diagnostic;
				_tmp33_ = gca_diagnostic_get_fixits (_tmp32_, &_tmp33__length1);
				_tmp34_ = _tmp33_;
				_tmp34__length1 = _tmp33__length1;
				if (!(_tmp31_ < ((guint) _tmp34__length1))) {
					break;
				}
				_tmp35_ = diagnostic;
				_tmp36_ = gca_diagnostic_get_fixits (_tmp35_, &_tmp36__length1);
				_tmp37_ = _tmp36_;
				_tmp37__length1 = _tmp36__length1;
				_tmp38_ = i;
				_tmp39_ = _tmp37_[_tmp38_];
				_tmp40_ = _tmp39_.range;
				r = _tmp40_;
				_tmp41_ = doc;
				_tmp44_ = gca_source_range_get_iters (&r, (GtkTextBuffer*) _tmp41_, &_tmp42_, &_tmp43_);
				start = _tmp42_;
				end = _tmp43_;
				if (_tmp44_) {
					GeditDocument* _tmp45_ = NULL;
					GcaDiagnosticTags* _tmp46_ = NULL;
					GtkTextTag* _tmp47_ = NULL;
					GtkTextTag* _tmp48_ = NULL;
					GtkTextIter _tmp49_ = {0};
					GtkTextIter _tmp50_ = {0};
					_tmp45_ = doc;
					_tmp46_ = self->priv->d_tags;
					_tmp47_ = gca_diagnostic_tags_get_fixit_tag (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = start;
					_tmp50_ = end;
					gtk_text_buffer_apply_tag ((GtkTextBuffer*) _tmp45_, _tmp48_, &_tmp49_, &_tmp50_);
				}
			}
		}
	}
	_g_object_unref0 (doc);
}


static gboolean gca_diagnostics_diagnostic_is_at_end (GcaDiagnostics* self, GcaSourceLocation* location) {
	gboolean result = FALSE;
	GtkTextIter iter = {0};
	GcaView* _tmp0_ = NULL;
	GeditView* _tmp1_ = NULL;
	GeditView* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GcaSourceLocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	GtkTextIter _tmp7_ = {0};
	GcaSourceLocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GcaSourceLocation _tmp11_ = {0};
	gint _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (location != NULL, FALSE);
	_tmp0_ = self->priv->d_view;
	_tmp1_ = gca_view_get_view (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = *location;
	_tmp6_ = _tmp5_.line;
	gtk_text_buffer_get_iter_at_line (_tmp4_, &_tmp7_, _tmp6_ - 1);
	iter = _tmp7_;
	_tmp8_ = *location;
	_tmp9_ = _tmp8_.column;
	gtk_text_iter_forward_chars (&iter, _tmp9_ - 1);
	_tmp10_ = gtk_text_iter_get_line (&iter);
	_tmp11_ = *location;
	_tmp12_ = _tmp11_.line;
	if (_tmp10_ != (_tmp12_ - 1)) {
		result = FALSE;
		return result;
	}
	_tmp13_ = gtk_text_iter_ends_line (&iter);
	result = _tmp13_;
	return result;
}


static void gca_diagnostics_add_diagnostic_at_end (GcaDiagnostics* self, GcaSourceLocation* location, GdkRGBA* color) {
	GtkTextIter iter = {0};
	GcaView* _tmp0_ = NULL;
	GeditView* _tmp1_ = NULL;
	GeditView* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GcaSourceLocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	GtkTextIter _tmp7_ = {0};
	GtkTextMark* mark = NULL;
	GcaView* _tmp8_ = NULL;
	GeditView* _tmp9_ = NULL;
	GeditView* _tmp10_ = NULL;
	GtkTextBuffer* _tmp11_ = NULL;
	GtkTextBuffer* _tmp12_ = NULL;
	GtkTextIter _tmp13_ = {0};
	GtkTextMark* _tmp14_ = NULL;
	GtkTextMark* _tmp15_ = NULL;
	GeeHashMap* _tmp16_ = NULL;
	GdkRGBA _tmp17_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = self->priv->d_view;
	_tmp1_ = gca_view_get_view (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = *location;
	_tmp6_ = _tmp5_.line;
	gtk_text_buffer_get_iter_at_line (_tmp4_, &_tmp7_, _tmp6_ - 1);
	iter = _tmp7_;
	_tmp8_ = self->priv->d_view;
	_tmp9_ = gca_view_get_view (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = iter;
	_tmp14_ = gtk_text_buffer_create_mark (_tmp12_, NULL, &_tmp13_, FALSE);
	_tmp15_ = _g_object_ref0 (_tmp14_);
	mark = _tmp15_;
	_tmp16_ = self->priv->d_diagnostics_at_end;
	_tmp17_ = *color;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, mark, &_tmp17_);
	_g_object_unref0 (mark);
}


static gboolean gca_diagnostics_on_view_draw (GcaDiagnostics* self, cairo_t* ctx) {
	gboolean result = FALSE;
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GeditView* view = NULL;
	GcaView* _tmp3_ = NULL;
	GeditView* _tmp4_ = NULL;
	GeditView* _tmp5_ = NULL;
	GeditView* _tmp6_ = NULL;
	GdkWindow* window = NULL;
	GeditView* _tmp7_ = NULL;
	GdkWindow* _tmp8_ = NULL;
	GdkWindow* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	GdkWindow* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GeeMapIterator* it = NULL;
	GeeHashMap* _tmp13_ = NULL;
	GeeMapIterator* _tmp14_ = NULL;
	cairo_t* _tmp15_ = NULL;
	GeditView* _tmp16_ = NULL;
	GdkWindow* _tmp17_ = NULL;
	GdkRectangle rect = {0};
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GeditView* _tmp18_ = NULL;
	GdkRectangle _tmp19_ = {0};
	GeditView* _tmp20_ = NULL;
	GdkRectangle _tmp21_ = {0};
	gint _tmp22_ = 0;
	GtkTextIter _tmp23_ = {0};
	GeditView* _tmp24_ = NULL;
	GdkRectangle _tmp25_ = {0};
	gint _tmp26_ = 0;
	GdkRectangle _tmp27_ = {0};
	gint _tmp28_ = 0;
	GtkTextIter _tmp29_ = {0};
	gint window_width = 0;
	GdkWindow* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	GtkTextBuffer* buf = NULL;
	GeditView* _tmp32_ = NULL;
	GtkTextBuffer* _tmp33_ = NULL;
	GtkTextBuffer* _tmp34_ = NULL;
	GtkTextBuffer* _tmp35_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->priv->d_diagnostics_at_end;
	_tmp1_ = gee_abstract_map_get_size ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->d_view;
	_tmp4_ = gca_view_get_view (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	view = _tmp6_;
	_tmp7_ = view;
	_tmp8_ = gtk_text_view_get_window ((GtkTextView*) _tmp7_, GTK_TEXT_WINDOW_TEXT);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	window = _tmp9_;
	_tmp10_ = ctx;
	_tmp11_ = window;
	_tmp12_ = gtk_cairo_should_draw_window (_tmp10_, _tmp11_);
	if (!_tmp12_) {
		result = FALSE;
		_g_object_unref0 (window);
		_g_object_unref0 (view);
		return result;
	}
	_tmp13_ = self->priv->d_diagnostics_at_end;
	_tmp14_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp13_);
	it = _tmp14_;
	_tmp15_ = ctx;
	_tmp16_ = view;
	_tmp17_ = window;
	gtk_cairo_transform_to_window (_tmp15_, (GtkWidget*) _tmp16_, _tmp17_);
	_tmp18_ = view;
	gtk_text_view_get_visible_rect ((GtkTextView*) _tmp18_, &_tmp19_);
	rect = _tmp19_;
	_tmp20_ = view;
	_tmp21_ = rect;
	_tmp22_ = _tmp21_.y;
	gtk_text_view_get_line_at_y ((GtkTextView*) _tmp20_, &_tmp23_, _tmp22_, NULL);
	start = _tmp23_;
	gtk_text_iter_backward_line (&start);
	_tmp24_ = view;
	_tmp25_ = rect;
	_tmp26_ = _tmp25_.y;
	_tmp27_ = rect;
	_tmp28_ = _tmp27_.height;
	gtk_text_view_get_line_at_y ((GtkTextView*) _tmp24_, &_tmp29_, _tmp26_ + _tmp28_, NULL);
	end = _tmp29_;
	gtk_text_iter_forward_line (&end);
	_tmp30_ = window;
	_tmp31_ = gdk_window_get_width (_tmp30_);
	window_width = _tmp31_;
	_tmp32_ = view;
	_tmp33_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	buf = _tmp35_;
	while (TRUE) {
		GeeMapIterator* _tmp36_ = NULL;
		gboolean _tmp37_ = FALSE;
		GtkTextIter iter = {0};
		GtkTextBuffer* _tmp38_ = NULL;
		GeeMapIterator* _tmp39_ = NULL;
		gpointer _tmp40_ = NULL;
		GtkTextMark* _tmp41_ = NULL;
		GtkTextIter _tmp42_ = {0};
		gboolean _tmp43_ = FALSE;
		GtkTextIter _tmp44_ = {0};
		GtkTextIter _tmp45_ = {0};
		gboolean _tmp46_ = FALSE;
		gboolean _tmp49_ = FALSE;
		gboolean _tmp50_ = FALSE;
		gint y = 0;
		gint height = 0;
		gint wy = 0;
		gint wx = 0;
		GdkRectangle irect = {0};
		GeditView* _tmp52_ = NULL;
		GtkTextIter _tmp53_ = {0};
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		GeditView* _tmp56_ = NULL;
		GtkTextIter _tmp57_ = {0};
		GdkRectangle _tmp58_ = {0};
		GeditView* _tmp59_ = NULL;
		GdkRectangle _tmp60_ = {0};
		gint _tmp61_ = 0;
		GdkRectangle _tmp62_ = {0};
		gint _tmp63_ = 0;
		gint _tmp64_ = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		cairo_t* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		gint _tmp70_ = 0;
		gint _tmp71_ = 0;
		gint _tmp72_ = 0;
		cairo_t* _tmp73_ = NULL;
		GeeMapIterator* _tmp74_ = NULL;
		gpointer _tmp75_ = NULL;
		GdkRGBA* _tmp76_ = NULL;
		GdkRGBA _tmp77_ = {0};
		cairo_t* _tmp78_ = NULL;
		_tmp36_ = it;
		_tmp37_ = gee_map_iterator_next (_tmp36_);
		if (!_tmp37_) {
			break;
		}
		_tmp38_ = buf;
		_tmp39_ = it;
		_tmp40_ = gee_map_iterator_get_key (_tmp39_);
		_tmp41_ = (GtkTextMark*) _tmp40_;
		gtk_text_buffer_get_iter_at_mark (_tmp38_, &_tmp42_, _tmp41_);
		iter = _tmp42_;
		_g_object_unref0 (_tmp41_);
		_tmp44_ = start;
		_tmp45_ = end;
		_tmp46_ = gtk_text_iter_in_range (&iter, &_tmp44_, &_tmp45_);
		if (!_tmp46_) {
			GtkTextIter _tmp47_ = {0};
			gboolean _tmp48_ = FALSE;
			_tmp47_ = end;
			_tmp48_ = gtk_text_iter_equal (&iter, &_tmp47_);
			_tmp43_ = !_tmp48_;
		} else {
			_tmp43_ = FALSE;
		}
		_tmp49_ = _tmp43_;
		if (_tmp49_) {
			continue;
		}
		_tmp50_ = gtk_text_iter_ends_line (&iter);
		if (!_tmp50_) {
			gboolean _tmp51_ = FALSE;
			_tmp51_ = gtk_text_iter_forward_visible_line (&iter);
			if (_tmp51_) {
				gtk_text_iter_backward_char (&iter);
			}
		}
		_tmp52_ = view;
		_tmp53_ = iter;
		gtk_text_view_get_line_yrange ((GtkTextView*) _tmp52_, &_tmp53_, &_tmp54_, &_tmp55_);
		y = _tmp54_;
		height = _tmp55_;
		_tmp56_ = view;
		_tmp57_ = iter;
		gtk_text_view_get_iter_location ((GtkTextView*) _tmp56_, &_tmp57_, &_tmp58_);
		irect = _tmp58_;
		_tmp59_ = view;
		_tmp60_ = irect;
		_tmp61_ = _tmp60_.x;
		_tmp62_ = irect;
		_tmp63_ = _tmp62_.width;
		_tmp64_ = y;
		gtk_text_view_buffer_to_window_coords ((GtkTextView*) _tmp59_, GTK_TEXT_WINDOW_TEXT, _tmp61_ + _tmp63_, _tmp64_, &_tmp65_, &_tmp66_);
		wx = _tmp65_;
		wy = _tmp66_;
		_tmp67_ = ctx;
		_tmp68_ = wx;
		_tmp69_ = wy;
		_tmp70_ = window_width;
		_tmp71_ = wx;
		_tmp72_ = height;
		cairo_rectangle (_tmp67_, (gdouble) _tmp68_, (gdouble) _tmp69_, (gdouble) (_tmp70_ - _tmp71_), (gdouble) _tmp72_);
		_tmp73_ = ctx;
		_tmp74_ = it;
		_tmp75_ = gee_map_iterator_get_value (_tmp74_);
		_tmp76_ = (GdkRGBA*) _tmp75_;
		_tmp77_ = *_tmp76_;
		gdk_cairo_set_source_rgba (_tmp73_, &_tmp77_);
		_g_free0 (_tmp76_);
		_tmp78_ = ctx;
		cairo_fill (_tmp78_);
	}
	result = FALSE;
	_g_object_unref0 (buf);
	_g_object_unref0 (it);
	_g_object_unref0 (window);
	_g_object_unref0 (view);
	return result;
}


static void gca_diagnostics_on_buffer_mark_set (GcaDiagnostics* self, GtkTextIter* location, GtkTextMark* mark) {
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (mark != NULL);
	_tmp1_ = self->priv->d_diagnostics_at_end;
	_tmp2_ = mark;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _tmp2_);
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = gtk_text_iter_starts_line (location);
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		GcaView* _tmp6_ = NULL;
		GeditView* _tmp7_ = NULL;
		GeditView* _tmp8_ = NULL;
		GtkTextBuffer* _tmp9_ = NULL;
		GtkTextBuffer* _tmp10_ = NULL;
		GtkTextMark* _tmp11_ = NULL;
		GtkTextIter _tmp12_ = {0};
		gtk_text_iter_set_line_offset (location, 0);
		_tmp6_ = self->priv->d_view;
		_tmp7_ = gca_view_get_view (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = mark;
		_tmp12_ = *location;
		gtk_text_buffer_move_mark (_tmp10_, _tmp11_, &_tmp12_);
	}
}


static gboolean gca_diagnostics_same_diagnostics (GcaDiagnostics* self, GcaDiagnostic** first, int first_length1, GcaDiagnostic** second, int second_length1) {
	gboolean result = FALSE;
	GcaDiagnostic** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GcaDiagnostic** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean _tmp2_ = FALSE;
	GcaDiagnostic** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gboolean _tmp5_ = FALSE;
	GcaDiagnostic** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GcaDiagnostic** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = first;
	_tmp0__length1 = first_length1;
	_tmp1_ = second;
	_tmp1__length1 = second_length1;
	if (_tmp0_ == _tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = first;
	_tmp3__length1 = first_length1;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GcaDiagnostic** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = second;
		_tmp4__length1 = second_length1;
		_tmp2_ = _tmp4_ == NULL;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = first;
	_tmp6__length1 = first_length1;
	_tmp7_ = second;
	_tmp7__length1 = second_length1;
	if (_tmp6__length1 != _tmp7__length1) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_ = FALSE;
				gint _tmp11_ = 0;
				GcaDiagnostic** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				GcaDiagnostic** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				GcaDiagnostic* _tmp15_ = NULL;
				GcaDiagnostic** _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				GcaDiagnostic* _tmp18_ = NULL;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = first;
				_tmp12__length1 = first_length1;
				if (!(_tmp11_ < _tmp12__length1)) {
					break;
				}
				_tmp13_ = first;
				_tmp13__length1 = first_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				_tmp16_ = second;
				_tmp16__length1 = second_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_];
				if (_tmp15_ != _tmp18_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void __lambda12_ (GcaDiagnostics* self) {
	_g_object_unref0 (self->priv->d_cursor_diagnostic_message);
	self->priv->d_cursor_diagnostic_message = NULL;
}


static void ___lambda12__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda12_ (self);
}


static GcaDiagnostic** _vala_array_dup5 (GcaDiagnostic** self, int length) {
	GcaDiagnostic** result;
	int i;
	result = g_new0 (GcaDiagnostic*, length + 1);
	for (i = 0; i < length; i++) {
		GcaDiagnostic* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void gca_diagnostics_update_diagnostic_message (GcaDiagnostics* self) {
	GtkTextIter iter = {0};
	GtkTextBuffer* buf = NULL;
	GcaView* _tmp0_ = NULL;
	GeditView* _tmp1_ = NULL;
	GeditView* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextBuffer* _tmp7_ = NULL;
	GtkTextMark* _tmp8_ = NULL;
	GtkTextIter _tmp9_ = {0};
	GcaSourceRange range = {0};
	GtkTextIter _tmp10_ = {0};
	GcaSourceRange _tmp11_ = {0};
	GcaDiagnostic** diagnostics = NULL;
	GcaSourceRange _tmp12_ = {0};
	gint _tmp13_ = 0;
	GcaDiagnostic** _tmp14_ = NULL;
	gint diagnostics_length1 = 0;
	gint _diagnostics_size_ = 0;
	GcaDiagnostic** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	GcaDiagnostic** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gboolean _tmp17_ = FALSE;
	GcaDiagnosticMessage* _tmp18_ = NULL;
	GcaView* _tmp20_ = NULL;
	GeditView* _tmp21_ = NULL;
	GeditView* _tmp22_ = NULL;
	GcaDiagnostic** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	GcaDiagnosticMessage* _tmp24_ = NULL;
	GcaDiagnosticMessage* _tmp25_ = NULL;
	GcaDiagnosticMessage* _tmp26_ = NULL;
	GcaDiagnostic** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	GcaDiagnostic** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_view;
	_tmp1_ = gca_view_get_view (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	buf = _tmp5_;
	_tmp6_ = buf;
	_tmp7_ = buf;
	_tmp8_ = gtk_text_buffer_get_insert (_tmp7_);
	gtk_text_buffer_get_iter_at_mark (_tmp6_, &_tmp9_, _tmp8_);
	iter = _tmp9_;
	_tmp10_ = iter;
	gca_source_range_from_iter (&_tmp10_, &_tmp11_);
	range = _tmp11_;
	_tmp12_ = range;
	_tmp14_ = gca_diagnostics_find_at (self, &_tmp12_, &_tmp13_);
	diagnostics = _tmp14_;
	diagnostics_length1 = _tmp13_;
	_diagnostics_size_ = diagnostics_length1;
	_tmp15_ = diagnostics;
	_tmp15__length1 = diagnostics_length1;
	_tmp16_ = self->priv->d_cursor_diagnostics;
	_tmp16__length1 = self->priv->d_cursor_diagnostics_length1;
	_tmp17_ = gca_diagnostics_same_diagnostics (self, _tmp15_, _tmp15__length1, _tmp16_, _tmp16__length1);
	if (_tmp17_) {
		diagnostics = (_vala_array_free (diagnostics, diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (buf);
		return;
	}
	_tmp18_ = self->priv->d_cursor_diagnostic_message;
	if (_tmp18_ != NULL) {
		GcaDiagnosticMessage* _tmp19_ = NULL;
		_tmp19_ = self->priv->d_cursor_diagnostic_message;
		gtk_widget_destroy ((GtkWidget*) _tmp19_);
	}
	_tmp20_ = self->priv->d_view;
	_tmp21_ = gca_view_get_view (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = diagnostics;
	_tmp23__length1 = diagnostics_length1;
	_tmp24_ = gca_diagnostic_message_new ((GtkSourceView*) _tmp22_, _tmp23_, _tmp23__length1);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->d_cursor_diagnostic_message);
	self->priv->d_cursor_diagnostic_message = _tmp24_;
	_tmp25_ = self->priv->d_cursor_diagnostic_message;
	g_signal_connect_object ((GtkWidget*) _tmp25_, "destroy", (GCallback) ___lambda12__gtk_widget_destroy, self, 0);
	_tmp26_ = self->priv->d_cursor_diagnostic_message;
	gtk_widget_show ((GtkWidget*) _tmp26_);
	_tmp27_ = diagnostics;
	_tmp27__length1 = diagnostics_length1;
	_tmp28_ = (_tmp27_ != NULL) ? _vala_array_dup5 (_tmp27_, _tmp27__length1) : ((gpointer) _tmp27_);
	_tmp28__length1 = _tmp27__length1;
	self->priv->d_cursor_diagnostics = (_vala_array_free (self->priv->d_cursor_diagnostics, self->priv->d_cursor_diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->d_cursor_diagnostics = _tmp28_;
	self->priv->d_cursor_diagnostics_length1 = _tmp28__length1;
	self->priv->_d_cursor_diagnostics_size_ = self->priv->d_cursor_diagnostics_length1;
	diagnostics = (_vala_array_free (diagnostics, diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (buf);
}


static void gca_diagnostics_on_cursor_moved (GcaDiagnostics* self) {
	g_return_if_fail (self != NULL);
	gca_diagnostics_update_diagnostic_message (self);
}


static gchar* gca_diagnostics_format_diagnostics (GcaDiagnostics* self, GcaDiagnostic** diagnostics, int diagnostics_length1) {
	gchar* result = NULL;
	GcaDiagnostic** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** markup = NULL;
	GcaDiagnostic** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint markup_length1 = 0;
	gint _markup_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gchar* _tmp16_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = diagnostics;
	_tmp0__length1 = diagnostics_length1;
	if (_tmp0__length1 == 0) {
		result = NULL;
		return result;
	}
	_tmp1_ = diagnostics;
	_tmp1__length1 = diagnostics_length1;
	_tmp2_ = g_new0 (gchar*, _tmp1__length1 + 1);
	markup = _tmp2_;
	markup_length1 = _tmp1__length1;
	_markup_size_ = markup_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				gint _tmp6_ = 0;
				GcaDiagnostic** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				GcaDiagnostic** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				GcaDiagnostic* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = diagnostics;
				_tmp7__length1 = diagnostics_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = markup;
				_tmp8__length1 = markup_length1;
				_tmp9_ = i;
				_tmp10_ = diagnostics;
				_tmp10__length1 = diagnostics_length1;
				_tmp11_ = i;
				_tmp12_ = _tmp10_[_tmp11_];
				_tmp13_ = gca_diagnostic_to_markup (_tmp12_, FALSE);
				_g_free0 (_tmp8_[_tmp9_]);
				_tmp8_[_tmp9_] = _tmp13_;
				_tmp14_ = _tmp8_[_tmp9_];
			}
		}
	}
	_tmp15_ = markup;
	_tmp15__length1 = markup_length1;
	_tmp16_ = g_strjoinv ("\n", _tmp15_);
	result = _tmp16_;
	markup = (_vala_array_free (markup, markup_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* gca_diagnostics_on_diagnostic_tooltip (GcaDiagnostics* self, GtkSourceMark* mark) {
	gchar* result = NULL;
	GtkTextIter iter = {0};
	GcaDiagnostic* diagnostic = NULL;
	GtkSourceMark* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GcaDiagnostic* _tmp2_ = NULL;
	GcaDiagnostic* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mark != NULL, NULL);
	_tmp0_ = mark;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "Gca.Document.MarkDiagnostic");
	_tmp2_ = _g_object_ref0 ((GcaDiagnostic*) _tmp1_);
	diagnostic = _tmp2_;
	_tmp3_ = diagnostic;
	if (_tmp3_ == NULL) {
		GcaView* _tmp4_ = NULL;
		GcaDocument* _tmp5_ = NULL;
		GcaDocument* _tmp6_ = NULL;
		GeditDocument* _tmp7_ = NULL;
		GeditDocument* _tmp8_ = NULL;
		GtkSourceMark* _tmp9_ = NULL;
		GtkTextIter _tmp10_ = {0};
		gint line = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		GcaDiagnostic** _tmp14_ = NULL;
		GcaDiagnostic** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp4_ = self->priv->d_view;
		_tmp5_ = gca_view_get_document (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gca_document_get_document (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp8_, &_tmp10_, (GtkTextMark*) _tmp9_);
		iter = _tmp10_;
		_tmp11_ = gtk_text_iter_get_line (&iter);
		line = _tmp11_ + 1;
		_tmp12_ = line;
		_tmp14_ = gca_diagnostics_find_at_line (self, _tmp12_, &_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp15__length1 = _tmp13_;
		_tmp16_ = gca_diagnostics_format_diagnostics (self, _tmp15_, _tmp13_);
		_tmp17_ = _tmp16_;
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_object_unref), NULL);
		result = _tmp17_;
		_g_object_unref0 (diagnostic);
		return result;
	} else {
		GcaDiagnostic* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp18_ = diagnostic;
		_tmp19_ = gca_diagnostic_to_markup (_tmp18_, FALSE);
		result = _tmp19_;
		_g_object_unref0 (diagnostic);
		return result;
	}
	_g_object_unref0 (diagnostic);
}


static gboolean gca_diagnostics_on_view_query_tooltip (GcaDiagnostics* self, gint x, gint y, gboolean keyboard_mode, GtkTooltip* tooltip) {
	gboolean result = FALSE;
	gint bx = 0;
	gint by = 0;
	GcaView* _tmp0_ = NULL;
	GeditView* _tmp1_ = NULL;
	GeditView* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GtkTextIter iter = {0};
	GcaView* _tmp7_ = NULL;
	GeditView* _tmp8_ = NULL;
	GeditView* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GtkTextIter _tmp12_ = {0};
	GcaSourceRange range = {0};
	GtkTextIter _tmp13_ = {0};
	GcaSourceRange _tmp14_ = {0};
	gchar* s = NULL;
	GcaSourceRange _tmp15_ = {0};
	gint _tmp16_ = 0;
	GcaDiagnostic** _tmp17_ = NULL;
	GcaDiagnostic** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GtkTooltip* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp0_ = self->priv->d_view;
	_tmp1_ = gca_view_get_view (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = x;
	_tmp4_ = y;
	gtk_text_view_window_to_buffer_coords ((GtkTextView*) _tmp2_, GTK_TEXT_WINDOW_WIDGET, _tmp3_, _tmp4_, &_tmp5_, &_tmp6_);
	bx = _tmp5_;
	by = _tmp6_;
	_tmp7_ = self->priv->d_view;
	_tmp8_ = gca_view_get_view (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = bx;
	_tmp11_ = by;
	gtk_text_view_get_iter_at_location ((GtkTextView*) _tmp9_, &_tmp12_, _tmp10_, _tmp11_);
	iter = _tmp12_;
	_tmp13_ = iter;
	gca_source_range_from_iter (&_tmp13_, &_tmp14_);
	range = _tmp14_;
	_tmp15_ = range;
	_tmp17_ = gca_diagnostics_find_at (self, &_tmp15_, &_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp18__length1 = _tmp16_;
	_tmp19_ = gca_diagnostics_format_diagnostics (self, _tmp18_, _tmp16_);
	_tmp20_ = _tmp19_;
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_object_unref), NULL);
	s = _tmp20_;
	_tmp21_ = s;
	if (_tmp21_ == NULL) {
		result = FALSE;
		_g_free0 (s);
		return result;
	}
	_tmp22_ = tooltip;
	_tmp23_ = s;
	gtk_tooltip_set_markup (_tmp22_, _tmp23_);
	result = TRUE;
	_g_free0 (s);
	return result;
}


const gchar* gca_diagnostics_get_error_mark_category (void) {
	const gchar* result;
	result = "Gca.Document.ErrorCategory";
	return result;
}


const gchar* gca_diagnostics_get_error_icon_name (void) {
	const gchar* result;
	result = "dialog-error-symbolic";
	return result;
}


const gchar* gca_diagnostics_get_warning_mark_category (void) {
	const gchar* result;
	result = "Gca.Document.WarningCategory";
	return result;
}


const gchar* gca_diagnostics_get_warning_icon_name (void) {
	const gchar* result;
	result = "dialog-warning-symbolic";
	return result;
}


const gchar* gca_diagnostics_get_info_mark_category (void) {
	const gchar* result;
	result = "Gca.Document.InfoCategory";
	return result;
}


const gchar* gca_diagnostics_get_info_icon_name (void) {
	const gchar* result;
	result = "dialog-information-symbolic";
	return result;
}


static void gca_diagnostics_class_init (GcaDiagnosticsClass * klass) {
	gca_diagnostics_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GcaDiagnosticsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gca_diagnostics_get_property;
	G_OBJECT_CLASS (klass)->finalize = gca_diagnostics_finalize;
}


static void gca_diagnostics_instance_init (GcaDiagnostics * self) {
	self->priv = GCA_DIAGNOSTICS_GET_PRIVATE (self);
}


static void gca_diagnostics_finalize (GObject* obj) {
	GcaDiagnostics * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GCA_TYPE_DIAGNOSTICS, GcaDiagnostics);
	_g_object_unref0 (self->priv->d_view);
	_g_object_unref0 (self->priv->d_index);
	_g_object_unref0 (self->priv->d_tags);
	_g_object_unref0 (self->priv->d_diagnostics_at_end);
	self->priv->d_cursor_diagnostics = (_vala_array_free (self->priv->d_cursor_diagnostics, self->priv->d_cursor_diagnostics_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->d_cursor_diagnostic_message);
	G_OBJECT_CLASS (gca_diagnostics_parent_class)->finalize (obj);
}


GType gca_diagnostics_get_type (void) {
	static volatile gsize gca_diagnostics_type_id__volatile = 0;
	if (g_once_init_enter (&gca_diagnostics_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GcaDiagnosticsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gca_diagnostics_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GcaDiagnostics), 0, (GInstanceInitFunc) gca_diagnostics_instance_init, NULL };
		GType gca_diagnostics_type_id;
		gca_diagnostics_type_id = g_type_register_static (G_TYPE_OBJECT, "GcaDiagnostics", &g_define_type_info, 0);
		g_once_init_leave (&gca_diagnostics_type_id__volatile, gca_diagnostics_type_id);
	}
	return gca_diagnostics_type_id__volatile;
}


static void _vala_gca_diagnostics_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GcaDiagnostics * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GCA_TYPE_DIAGNOSTICS, GcaDiagnostics);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



