/* gca-source-location.c generated by valac 0.28.0.11-bbdd, the Vala compiler
 * generated from gca-source-location.vala, do not modify */

/*
 * This file is part of gedit-code-assistant.
 *
 * Copyright (C) 2011 - Jesse van den Kieboom
 *
 * gedit-code-assistant is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gedit-code-assistant is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gedit-code-assistant.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <string.h>
#include <gdk/gdk.h>
#include <stdlib.h>


#define GCA_TYPE_SOURCE_LOCATION (gca_source_location_get_type ())
typedef struct _GcaSourceLocation GcaSourceLocation;

#define GCA_DBUS_TYPE_SOURCE_LOCATION (gca_dbus_source_location_get_type ())
typedef struct _GcaDBusSourceLocation GcaDBusSourceLocation;

#define GCA_TYPE_SOURCE_RANGE (gca_source_range_get_type ())
typedef struct _GcaSourceRange GcaSourceRange;

struct _GcaSourceLocation {
	gint line;
	gint column;
};

struct _GcaDBusSourceLocation {
	gint64 line;
	gint64 column;
};

struct _GcaSourceRange {
	GcaSourceLocation start;
	GcaSourceLocation end;
};



GType gca_source_location_get_type (void) G_GNUC_CONST;
GcaSourceLocation* gca_source_location_dup (const GcaSourceLocation* self);
void gca_source_location_free (GcaSourceLocation* self);
void gca_source_location_from_iter (GtkTextIter* iter, GcaSourceLocation* result);
GType gca_dbus_source_location_get_type (void) G_GNUC_CONST;
GcaDBusSourceLocation* gca_dbus_source_location_dup (const GcaDBusSourceLocation* self);
void gca_dbus_source_location_free (GcaDBusSourceLocation* self);
void gca_source_location_from_dbus (GcaDBusSourceLocation* location, GcaSourceLocation* result);
GType gca_source_range_get_type (void) G_GNUC_CONST;
GcaSourceRange* gca_source_range_dup (const GcaSourceRange* self);
void gca_source_range_free (GcaSourceRange* self);
void gca_source_location_to_range (GcaSourceLocation *self, GcaSourceRange* result);
static gint gca_source_location_compare_int (GcaSourceLocation *self, gint a, gint b);
gint gca_source_location_compare_to (GcaSourceLocation *self, GcaSourceLocation* other);
gboolean gca_source_location_get_iter (GcaSourceLocation *self, GtkTextBuffer* buffer, GtkTextIter* iter);
gboolean gca_source_location_buffer_coordinates (GcaSourceLocation *self, GtkTextView* view, GdkRectangle* rect);
gchar* gca_source_location_to_string (GcaSourceLocation *self);


void gca_source_location_from_iter (GtkTextIter* iter, GcaSourceLocation* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GcaSourceLocation _tmp2_ = {0};
	g_return_if_fail (iter != NULL);
	_tmp0_ = gtk_text_iter_get_line (iter);
	_tmp1_ = gtk_text_iter_get_line_offset (iter);
	memset (&_tmp2_, 0, sizeof (GcaSourceLocation));
	_tmp2_.line = _tmp0_ + 1;
	_tmp2_.column = _tmp1_ + 1;
	*result = _tmp2_;
	return;
}


void gca_source_location_from_dbus (GcaDBusSourceLocation* location, GcaSourceLocation* result) {
	GcaDBusSourceLocation _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	GcaDBusSourceLocation _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	GcaSourceLocation _tmp4_ = {0};
	g_return_if_fail (location != NULL);
	_tmp0_ = *location;
	_tmp1_ = _tmp0_.line;
	_tmp2_ = *location;
	_tmp3_ = _tmp2_.column;
	memset (&_tmp4_, 0, sizeof (GcaSourceLocation));
	_tmp4_.line = (gint) _tmp1_;
	_tmp4_.column = (gint) _tmp3_;
	*result = _tmp4_;
	return;
}


void gca_source_location_to_range (GcaSourceLocation *self, GcaSourceRange* result) {
	GcaSourceRange _tmp0_ = {0};
	memset (&_tmp0_, 0, sizeof (GcaSourceRange));
	_tmp0_.start = (*self);
	_tmp0_.end = (*self);
	*result = _tmp0_;
	return;
}


static gint gca_source_location_compare_int (GcaSourceLocation *self, gint a, gint b) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	_tmp1_ = a;
	_tmp2_ = b;
	if (_tmp1_ < _tmp2_) {
		_tmp0_ = -1;
	} else {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp4_ = a;
		_tmp5_ = b;
		if (_tmp4_ == _tmp5_) {
			_tmp3_ = 0;
		} else {
			_tmp3_ = 1;
		}
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}


gint gca_source_location_compare_to (GcaSourceLocation *self, GcaSourceLocation* other) {
	gint result = 0;
	gint _tmp0_ = 0;
	GcaSourceLocation _tmp1_ = {0};
	gint _tmp2_ = 0;
	g_return_val_if_fail (other != NULL, 0);
	_tmp0_ = (*self).line;
	_tmp1_ = *other;
	_tmp2_ = _tmp1_.line;
	if (_tmp0_ == _tmp2_) {
		gint _tmp3_ = 0;
		GcaSourceLocation _tmp4_ = {0};
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp3_ = (*self).column;
		_tmp4_ = *other;
		_tmp5_ = _tmp4_.column;
		_tmp6_ = gca_source_location_compare_int (&(*self), _tmp3_, _tmp5_);
		result = _tmp6_;
		return result;
	} else {
		gint _tmp7_ = 0;
		GcaSourceLocation _tmp8_ = {0};
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp7_ = (*self).line;
		_tmp8_ = *other;
		_tmp9_ = _tmp8_.line;
		_tmp10_ = gca_source_location_compare_int (&(*self), _tmp7_, _tmp9_);
		result = _tmp10_;
		return result;
	}
}


gboolean gca_source_location_get_iter (GcaSourceLocation *self, GtkTextBuffer* buffer, GtkTextIter* iter) {
	GtkTextIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTextBuffer* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkTextIter _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp6_ = 0;
	gboolean ret = FALSE;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (buffer != NULL, FALSE);
	_tmp0_ = buffer;
	_tmp1_ = (*self).line;
	gtk_text_buffer_get_iter_at_line (_tmp0_, &_tmp2_, _tmp1_ - 1);
	_vala_iter = _tmp2_;
	_tmp3_ = gtk_text_iter_get_line (&_vala_iter);
	_tmp4_ = (*self).line;
	if (_tmp3_ != (_tmp4_ - 1)) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = gtk_text_iter_is_end (&_vala_iter);
		if (_tmp5_) {
			result = TRUE;
			if (iter) {
				*iter = _vala_iter;
			}
			return result;
		}
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp6_ = (*self).column;
	if (_tmp6_ <= 1) {
		result = TRUE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp7_ = (*self).column;
	_tmp8_ = gtk_text_iter_forward_chars (&_vala_iter, _tmp7_ - 1);
	ret = _tmp8_;
	_tmp10_ = ret;
	if (!_tmp10_) {
		gboolean _tmp11_ = FALSE;
		_tmp11_ = gtk_text_iter_is_end (&_vala_iter);
		_tmp9_ = _tmp11_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ret = TRUE;
	}
	result = ret;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


gboolean gca_source_location_buffer_coordinates (GcaSourceLocation *self, GtkTextView* view, GdkRectangle* rect) {
	GdkRectangle _vala_rect = {0};
	gboolean result = FALSE;
	GtkTextIter iter = {0};
	GtkTextView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	GtkTextView* _tmp5_ = NULL;
	GtkTextIter _tmp6_ = {0};
	GdkRectangle _tmp7_ = {0};
	GtkTextView* _tmp8_ = NULL;
	GtkTextIter _tmp9_ = {0};
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	g_return_val_if_fail (view != NULL, FALSE);
	memset (&_vala_rect, 0, sizeof (GdkRectangle));
	_tmp0_ = view;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = gca_source_location_get_iter (&(*self), _tmp2_, &_tmp3_);
	iter = _tmp3_;
	if (!_tmp4_) {
		result = FALSE;
		if (rect) {
			*rect = _vala_rect;
		}
		return result;
	}
	_tmp5_ = view;
	_tmp6_ = iter;
	gtk_text_view_get_iter_location (_tmp5_, &_tmp6_, &_tmp7_);
	_vala_rect = _tmp7_;
	_tmp8_ = view;
	_tmp9_ = iter;
	gtk_text_view_get_line_yrange (_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
	_vala_rect.y = _tmp10_;
	_vala_rect.height = _tmp11_;
	result = TRUE;
	if (rect) {
		*rect = _vala_rect;
	}
	return result;
}


gchar* gca_source_location_to_string (GcaSourceLocation *self) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	_tmp0_ = (*self).line;
	_tmp1_ = (*self).column;
	_tmp2_ = g_strdup_printf ("(%d.%d)", _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


GcaSourceLocation* gca_source_location_dup (const GcaSourceLocation* self) {
	GcaSourceLocation* dup;
	dup = g_new0 (GcaSourceLocation, 1);
	memcpy (dup, self, sizeof (GcaSourceLocation));
	return dup;
}


void gca_source_location_free (GcaSourceLocation* self) {
	g_free (self);
}


GType gca_source_location_get_type (void) {
	static volatile gsize gca_source_location_type_id__volatile = 0;
	if (g_once_init_enter (&gca_source_location_type_id__volatile)) {
		GType gca_source_location_type_id;
		gca_source_location_type_id = g_boxed_type_register_static ("GcaSourceLocation", (GBoxedCopyFunc) gca_source_location_dup, (GBoxedFreeFunc) gca_source_location_free);
		g_once_init_leave (&gca_source_location_type_id__volatile, gca_source_location_type_id);
	}
	return gca_source_location_type_id__volatile;
}



