
#line 3 "lexer.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,int len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 87
#define YY_END_OF_BUFFER 88
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_acclist[359] =
    {   0,
       88,   86,   87,   72,   86,   87,   71,   87,   72,   86,
       87,   82,   86,   87,   86,   87,   86,   87,   83,   86,
       87,   82,   86,   87,   54,   86,   87,   56,   86,   87,
       83,   84,   86,   87,   69,   83,   86,   87,   69,   83,
       86,   87,   69,   83,   86,   87,   83,   86,   87,   11,
       83,   86,   87,   19,   83,   86,   87,   21,   83,   86,
       87,   20,   83,   86,   87,   83,   86,   87,   57,   83,
       86,   87,   52,   83,   86,   87,   83,   86,   87,   53,
       83,   86,   87,   57,   86,   87,   57,   86,   87,   57,
       86,   87,   57,   86,   87,   57,   86,   87,   57,   86,

       87,   57,   86,   87,   57,   86,   87,   57,   86,   87,
       57,   86,   87,   57,   86,   87,   57,   86,   87,   57,
       86,   87,   57,   86,   87,   57,   86,   87,   57,   86,
       87,   57,   86,   87,   57,   86,   87,   57,   86,   87,
       85,   86,   87,   56,   86,   87,   72,   86,   87,   57,
       86,   87,   57,   86,   87,   57,   86,   87,   57,   86,
       87,   72,   71,   72,   53,   81,   14,   12,    1,   55,
       78,   80,   75,   73,   74,   76,   65,   77,   79,   68,
       69,   69,   59,   69,   59,   69,   22,   17,   15,   13,
       18,   50,   57,   52,   70,   57,   57,   57,   34,   57,

       57,   57,   32,   57,   57,   57,   57,   57,   36,   57,
       35,   57,   57,   57,   57,   57,   26,   57,   57,   57,
       57,   57,   57,   33,   57,   57,   57,   57,   72,   57,
       57,   57,   57,   57,   57,   12,   51,   62,   64,   67,
       66,   16,   24,   57,   57,   57,   57,   57,   57,   57,
       29,   57,   57,   57,   47,   57,   23,   57,   57,   57,
       57,   57,   30,   57,   57,   57,   57,   25,   57,   57,
       57,    8,   57,   57,   63,   61,   57,   57,   41,   57,
       57,   38,   57,   57,   57,   57,   48,   57,   57,   31,
       57,   57,   37,   57,   57,   57,   57,   57,    8,   57,

        6,   60,   58,   57,   46,   57,   57,   57,   57,   49,
       57,   57,   57,   28,   57,   27,   57,    4,   10,    7,
       57,   58,   58,   57,   57,   57,   57,   57,   42,   57,
       10,   57,   43,   57,   57,   57,   57,   57,    9,    3,
        3,   45,   57,   57,   39,   57,   57,    2,    3,   44,
       57,   40,   57,    2,    2,    3,    5,    2
    } ;

static yyconst flex_int16_t yy_accept[289] =
    {   0,
        1,    1,    1,    2,    4,    7,    9,   12,   15,   17,
       19,   22,   25,   28,   31,   35,   39,   43,   47,   50,
       54,   58,   62,   66,   69,   73,   77,   80,   84,   87,
       90,   93,   96,   99,  102,  105,  108,  111,  114,  117,
      120,  123,  126,  129,  132,  135,  138,  141,  144,  147,
      150,  153,  156,  159,  162,  163,  164,  165,  166,  167,
      168,  168,  169,  169,  169,  170,  170,  171,  172,  173,
      174,  175,  176,  176,  177,  178,  179,  180,  180,  182,
      183,  183,  184,  184,  184,  185,  185,  186,  187,  188,
      189,  190,  191,  192,  193,  194,  195,  196,  197,  198,

      199,  201,  202,  203,  205,  206,  207,  208,  209,  211,
      213,  214,  215,  216,  217,  219,  220,  221,  222,  223,
      224,  226,  227,  228,  229,  230,  230,  230,  230,  230,
      231,  232,  233,  234,  235,  236,  237,  238,  238,  239,
      239,  240,  241,  241,  242,  243,  245,  246,  247,  248,
      249,  250,  251,  253,  254,  255,  257,  259,  260,  261,
      262,  263,  265,  266,  267,  268,  270,  270,  270,  270,
      270,  270,  270,  270,  271,  272,  272,  273,  274,  275,
      275,  276,  277,  277,  277,  277,  278,  279,  281,  282,
      284,  285,  286,  287,  289,  290,  292,  293,  295,  296,

      297,  297,  297,  297,  297,  297,  298,  299,  299,  300,
      301,  301,  302,  303,  304,  305,  307,  308,  309,  310,
      312,  313,  314,  316,  318,  318,  318,  318,  318,  319,
      319,  320,  320,  320,  321,  322,  323,  324,  325,  326,
      327,  328,  329,  331,  331,  331,  332,  332,  332,  333,
      335,  336,  337,  338,  339,  339,  339,  340,  340,  341,
      341,  342,  342,  342,  342,  344,  345,  347,  348,  348,
      348,  348,  348,  350,  350,  350,  352,  354,  354,  355,
      355,  355,  357,  357,  358,  358,  359,  359
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    6,    7,    8,    1,    9,    1,   10,   11,
       12,   13,   14,   15,   16,   17,   18,   19,   20,   20,
       20,   21,   21,   21,   21,   22,   22,   23,   24,   25,
       26,   27,   15,   28,   29,   29,   29,   29,   30,   29,
       31,   31,   31,   31,   31,   31,   31,   31,   31,   31,
       31,   31,   31,   31,   31,   31,   31,   31,   31,   31,
       32,   33,   34,   35,   36,   15,   37,   38,   39,   40,

       41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
       51,   52,   46,   53,   54,   55,   56,   46,   57,   58,
       59,   46,   60,   61,   62,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[63] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    2,
        2,    2,    1,    1,    1,    1,    1,    1,    2,    2,
        3,    1,    1,    1,    1,    4,    2,    2,    2,    2,
        2,    2,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    1,
        1,    1
    } ;

static yyconst flex_int16_t yy_base[305] =
    {   0,
        0,   61,  559,  560,   65,  560,   69,   58,   58,  555,
      560,  560,  560,   70,  107,  126,  180,   57,  531,  560,
       54,  530,  529,  543,    0,   80,  550,  560,  502,   49,
       46,  500,   40,   36,    0,   51,  499,  498,   38,  495,
       53,  506,  490,   52,  495,  500,  492,  560,  560,  129,
       67,  501,   60,   82,  148,  560,  153,  560,  560,  560,
      103,  560,  105,  538,  560,  159,  560,  560,  560,  560,
      560,  560,  523,  560,  196,  560,  560,  167,  210,  226,
      243,  560,    0,  154,    0,    0,  534,  505,  560,  510,
      560,  560,  560,  560,    0,  139,  560,  496,  490,  493,

        0,  485,  482,    0,  477,  491,  476,  478,    0,    0,
      488,  486,  470,  476,    0,  470,  471,  466,  471,  478,
        0,  463,  472,  463,  270,  475,  473,  108,  112,  178,
      465,  133,  188,  456,  471,  159,  560,  262,  560,  214,
      266,    0,  271,    0,  560,    0,  462,  472,  460,  452,
      465,  464,    0,  465,  466,    0,    0,  454,  464,  460,
      443,    0,  448,  452,  448,    0,  193,  447,  457,  204,
      437,  452,  209,  439,  450,  217,  560,  446,  247,  275,
      279,  560,  248,  307,  470,  436,  439,    0,  378,    0,
      370,  366,  371,    0,  368,    0,  362,    0,  365,  371,

      359,  369,  364,  300,  403,  305,  237,  402,  401,  358,
      310,  560,  560,  311,  345,    0,  350,  344,  353,    0,
      356,  345,    0,    0,  318,  256,  346,  384,  560,  332,
      560,  334,  380,  560,  308,  321,  560,  264,  261,  261,
      228,  198,    0,  194,  225,  220,  209,  335,  275,    0,
      164,  152,  146,  153,  342,  176,  560,  175,  560,  342,
      233,  346,  343,  348,    0,  115,    0,   96,  327,  362,
      328,  369,  560,  375,  134,    0,    0,  379,  560,  383,
      387,  330,  119,  560,  391,  346,  560,  424,  428,  431,
       93,  434,  437,  441,  445,  449,  453,  457,  461,  465,

      469,  473,  477,  481
    } ;

static yyconst flex_int16_t yy_def[305] =
    {   0,
      287,    1,  287,  287,  287,  287,  287,  287,  288,  289,
      287,  287,  287,  287,  287,  287,  287,   17,  287,  287,
      287,  287,  287,  287,  290,  287,  287,  287,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  287,  287,  287,
      290,  290,  290,  290,  287,  287,  287,  287,  287,  287,
      288,  287,  288,  289,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  291,  287,   18,  292,  287,   18,  287,  287,
      287,  287,  287,  287,  290,  287,  287,  290,  290,  290,

      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  287,  287,  287,  287,  287,  290,
      290,  290,  290,  290,  290,  288,  287,  287,  287,  287,
      287,  291,  287,  292,  287,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  287,  287,  287,  287,
      287,  287,  293,  290,  290,  294,  287,  290,  290,  287,
      287,  287,  287,  287,  287,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  290,  290,  290,  290,  290,  290,

      287,  287,  287,  287,  295,  290,  290,  296,  296,  290,
      287,  287,  287,  287,  290,  290,  290,  290,  290,  290,
      290,  290,  290,  290,  287,  287,  287,  295,  287,  297,
      287,  298,  296,  287,  290,  287,  287,  290,  290,  290,
      290,  290,  290,  287,  299,  299,  300,  301,  290,  290,
      290,  290,  290,  290,  287,  299,  287,  300,  287,  301,
      302,  300,  301,  303,  290,  290,  290,  290,  302,  287,
      302,  300,  287,  301,  304,  290,  290,  287,  287,  302,
      301,  302,  304,  287,  302,  302,    0,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,

      287,  287,  287,  287
    } ;

static yyconst flex_int16_t yy_nxt[623] =
    {   0,
        4,    5,    6,    7,    5,    8,    9,   10,   11,   12,
       13,   14,   11,   11,   11,   11,   15,   11,   16,   17,
       18,   18,   19,   20,   21,   22,   23,   24,   25,   25,
       25,   26,   27,   28,   11,   25,   29,   30,   31,   32,
       33,   34,   35,   35,   36,   35,   35,   37,   38,   39,
       40,   41,   42,   43,   44,   45,   46,   47,   35,   13,
       48,   49,   50,   59,   62,   50,   55,   56,   57,   55,
       57,   66,   57,   57,   66,   88,   88,   88,   88,   90,
       91,   96,  102,   60,   96,   99,  107,  105,  113,  116,
       63,  108,  109,  114,  142,  120,  103,  106,   58,   51,

      110,  100,  121,  102,   52,  117,  130,  101,   53,   62,
      132,  136,   54,  133,   67,   68,   69,  103,  116,   70,
       71,  284,   72,   73,   74,   75,   75,   75,   75,  134,
      125,   56,   57,  125,  117,   63,  284,   63,  135,   76,
       96,   77,   78,   96,   79,   79,   79,   80,  277,   55,
       56,   57,   55,   81,   57,   81,   57,   57,  169,  171,
       66,  170,   58,   66,  276,   62,   81,  126,  172,  175,
       82,  155,  127,  143,  143,  143,  128,  259,  257,  173,
      129,   58,  173,   83,   84,   75,   75,   75,   75,  176,
      177,   63,  176,  268,  173,  267,   78,  173,   85,   85,

       85,   85,  266,   67,  265,  176,  177,   81,  176,   81,
      173,  259,   86,  173,   75,   75,   75,   75,  176,  209,
       81,  176,  257,  138,   87,  138,   78,  257,   79,   79,
       79,   80,  141,  141,  141,  141,  138,   81,  232,   81,
      139,  232,   78,  255,   80,   80,   80,   80,  211,  212,
       81,  211,  254,   81,   82,   81,  140,  232,  140,  270,
      232,  141,  141,  141,  141,  271,   81,  214,  214,  214,
       82,  125,   56,   57,  125,  180,  264,  180,  253,  264,
      181,  181,  181,  181,  141,  141,  141,  141,  183,  184,
      184,  184,  184,  181,  181,  181,  181,  181,  181,  181,

      181,  211,  212,   58,  211,  252,  230,  231,  126,  230,
      182,  211,  212,  127,  211,  185,  251,  128,  250,  230,
      231,  129,  230,  213,  183,  184,  184,  184,  184,  236,
      236,  236,  236,  230,  246,  232,  230,  261,  232,  236,
      236,  236,  236,  264,  261,  261,  264,  272,  273,  264,
      272,  185,  264,  270,  280,  237,  270,  249,  248,  271,
      271,  262,  271,  278,  279,  237,  278,  263,  262,  274,
      272,  273,  270,  272,  263,  263,  281,  282,  271,  281,
      278,  279,  234,  278,  285,  286,  229,  285,  281,  282,
      244,  281,  285,  286,  243,  285,  242,  241,  240,  239,

      238,  262,  235,  234,  234,  229,  227,  263,  226,  270,
      225,  224,  223,  262,  222,  271,  221,  270,  220,  263,
      219,  218,  217,  271,   61,   61,   61,   61,   64,   64,
       64,   64,   95,   95,   95,  144,  144,  205,  205,  205,
      205,  208,  208,  208,  208,  228,  228,  228,  228,  233,
      233,  233,  233,  245,  245,  245,  245,  247,  247,  247,
      247,  256,  256,  256,  256,  258,  258,  258,  258,  260,
      260,  260,  260,  269,  269,  269,  269,  275,  275,  275,
      275,  283,  283,  283,  283,  216,  215,  183,  210,  207,
      206,  204,  203,  202,  201,  200,  199,  198,  197,  196,

      195,  194,  193,  192,  191,  190,  189,  188,  187,  186,
      179,  178,  174,  168,  167,  166,  165,  164,  163,  162,
      161,  160,  159,  158,  157,  156,  155,  154,  153,  152,
      151,  150,  149,  148,  147,  146,  145,  287,   84,  137,
       65,  131,  124,  123,  122,  119,  118,  115,  112,  111,
      104,   98,   97,   94,   93,   92,   89,   65,  287,    3,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,

      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287
    } ;

static yyconst flex_int16_t yy_chk[623] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    2,    8,    9,    2,    5,    5,    5,    5,
        7,   14,    7,    7,   14,   18,   18,   18,   18,   21,
       21,   26,   31,    8,   26,   30,   34,   33,   39,   41,
        9,   34,   36,   39,  291,   44,   31,   33,    5,    2,

       36,   30,   44,   51,    2,   41,   51,   30,    2,   61,
       53,   63,    2,   53,   14,   15,   15,   51,   54,   15,
       15,  283,   15,   15,   15,   15,   15,   15,   15,   54,
       50,   50,   50,   50,   54,   61,  275,   63,   54,   15,
       96,   15,   16,   96,   16,   16,   16,   16,  268,   55,
       55,   55,   55,   16,   57,   16,   57,   57,  128,  129,
       66,  128,   50,   66,  266,  136,   16,   50,  129,  132,
       16,  132,   50,   84,   84,   84,   50,  258,  256,  130,
       50,   55,  130,   16,   17,   78,   78,   78,   78,  133,
      133,  136,  133,  254,  167,  253,   17,  167,   17,   17,

       17,   17,  252,   66,  251,  170,  170,   17,  170,   17,
      173,  247,   17,  173,   75,   75,   75,   75,  176,  176,
       17,  176,  246,   75,   17,   75,   79,  245,   79,   79,
       79,   79,  140,  140,  140,  140,   75,   79,  207,   79,
       75,  207,   80,  244,   80,   80,   80,   80,  179,  179,
       79,  179,  242,   80,   79,   80,   81,  226,   81,  261,
      226,   81,   81,   81,   81,  261,   80,  183,  183,  183,
       80,  125,  125,  125,  125,  138,  249,  138,  241,  249,
      138,  138,  138,  138,  141,  141,  141,  141,  143,  143,
      143,  143,  143,  180,  180,  180,  180,  181,  181,  181,

      181,  204,  204,  125,  204,  240,  206,  206,  125,  206,
      141,  211,  211,  125,  211,  143,  239,  125,  238,  225,
      225,  125,  225,  181,  184,  184,  184,  184,  184,  214,
      214,  214,  214,  230,  230,  232,  230,  248,  232,  236,
      236,  236,  236,  255,  260,  263,  255,  262,  262,  264,
      262,  184,  264,  269,  271,  214,  282,  235,  232,  269,
      271,  248,  282,  270,  270,  236,  270,  248,  260,  263,
      272,  272,  286,  272,  260,  263,  274,  274,  286,  274,
      278,  278,  233,  278,  280,  280,  228,  280,  281,  281,
      227,  281,  285,  285,  222,  285,  221,  219,  218,  217,

      215,  274,  210,  209,  208,  205,  203,  274,  202,  280,
      201,  200,  199,  281,  197,  280,  195,  285,  193,  281,
      192,  191,  189,  285,  288,  288,  288,  288,  289,  289,
      289,  289,  290,  290,  290,  292,  292,  293,  293,  293,
      293,  294,  294,  294,  294,  295,  295,  295,  295,  296,
      296,  296,  296,  297,  297,  297,  297,  298,  298,  298,
      298,  299,  299,  299,  299,  300,  300,  300,  300,  301,
      301,  301,  301,  302,  302,  302,  302,  303,  303,  303,
      303,  304,  304,  304,  304,  187,  186,  185,  178,  175,
      174,  172,  171,  169,  168,  165,  164,  163,  161,  160,

      159,  158,  155,  154,  152,  151,  150,  149,  148,  147,
      135,  134,  131,  127,  126,  124,  123,  122,  120,  119,
      118,  117,  116,  114,  113,  112,  111,  108,  107,  106,
      105,  103,  102,  100,   99,   98,   90,   88,   87,   73,
       64,   52,   47,   46,   45,   43,   42,   40,   38,   37,
       32,   29,   27,   24,   23,   22,   19,   10,    3,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,

      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287
    } ;

extern int yy_flex_debug;
int yy_flex_debug = 0;

static yy_state_type *yy_state_buf=0, *yy_state_ptr=0;
static char *yy_full_match;
static int yy_lp;
#define REJECT \
{ \
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */ \
yy_cp = (yy_full_match); /* restore poss. backed-over text */ \
++(yy_lp); \
goto find_rule; \
}

#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lexer.l"
/* GENIUS Calculator
 * Copyright (C) 1997-2009 Jiri (George) Lebl
 *
 * Author: Jiri (George) Lebl
 *
 * This file is part of Genius.
 *
 * Genius is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#line 22 "lexer.l"
#include "config.h"

#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "mpwrap.h"
#include "eval.h"
#include "dict.h"
#include "calc.h"
#include "parse.h"
#include "util.h"
#include "binreloc.h"

int gel_lex_fd[2];
int gel_first_tok = STARTTOK;
gboolean gel_return_ret = FALSE;
int gel_parenth_depth = 0;
gboolean gel_lex_init = TRUE;
extern GSList *gel_parsestack;
static int matrix_entry = 0;
static GSList *matrix_entry_stack = NULL;

/* Ugly warning avoiding */
#define yywrap() 1
#define YY_SKIP_YYWRAP
#ifdef FLEX_SCANNER
int yylex(void);
#endif

#define NO_RET {gel_return_ret = FALSE;}
#define DO_RET { \
	if(!gel_parenth_depth) \
		gel_return_ret = TRUE; \
	else \
		gel_return_ret = FALSE; \
}

static GHashTable *fp_hash = NULL;

void gel_lexer_open(FILE *fp);
void gel_lexer_parse(FILE *fp);
void gel_lexer_close(FILE *fp);

void
gel_lexer_open(FILE *fp)
{
	YY_BUFFER_STATE buf;
	if(!fp_hash)
		fp_hash = g_hash_table_new(NULL, NULL);

	buf = g_hash_table_lookup(fp_hash, fp);
	if(buf)
		return;

	buf = yy_create_buffer(fp,YY_BUF_SIZE);
	g_hash_table_insert(fp_hash, fp, buf);
}

void
gel_lexer_parse(FILE *fp)
{
	YY_BUFFER_STATE buf;

	g_assert(fp_hash);

	buf = g_hash_table_lookup(fp_hash, fp);

	yy_switch_to_buffer(buf);
	yyparse();
}

void
gel_lexer_close(FILE *fp)
{
	YY_BUFFER_STATE buf;

	/* don't close the stdin */
	if(fp == stdin)
		return;

	g_assert(fp_hash);

	buf = g_hash_table_lookup(fp_hash, fp);

	yy_delete_buffer(buf);

	 g_hash_table_remove(fp_hash, fp);
}

#line 846 "lexer.c"

#define INITIAL 0

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy (void );

int yyget_debug (void );

void yyset_debug (int debug_flag  );

YY_EXTRA_TYPE yyget_extra (void );

void yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *yyget_in (void );

void yyset_in  (FILE * in_str  );

FILE *yyget_out (void );

void yyset_out  (FILE * out_str  );

int yyget_leng (void );

char *yyget_text (void );

int yyget_lineno (void );

void yyset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

    static void yyunput (int c,char *buf_ptr  );
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		unsigned n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		YY_CURRENT_BUFFER_LVALUE->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 115 "lexer.l"



	if(gel_lex_init) {
		gel_return_ret = FALSE;
		gel_parenth_depth = 0;
		matrix_entry = 0;
		matrix_entry_stack = NULL;
		gel_lex_init = FALSE;
	}
	
	if(gel_first_tok!=INT_MAX) {
		int i = gel_first_tok;
		gel_first_tok = INT_MAX;
		return i;
	}



#line 1051 "lexer.c"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

        /* Create the reject buffer large enough to save one state per allowed character. */
        if ( ! (yy_state_buf) )
            (yy_state_buf) = (yy_state_type *)yyalloc(YY_STATE_BUF_SIZE  );
            if ( ! (yy_state_buf) )
                YY_FATAL_ERROR( "out of dynamic memory in yylex()" );

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		yy_current_state += YY_AT_BOL();

		(yy_state_ptr) = (yy_state_buf);
		*(yy_state_ptr)++ = yy_current_state;

yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 288 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			*(yy_state_ptr)++ = yy_current_state;
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 560 );

yy_find_action:
		yy_current_state = *--(yy_state_ptr);
		(yy_lp) = yy_accept[yy_current_state];
find_rule: /* we branch to this label when backing up */
		for ( ; ; ) /* until we find what rule we matched */
			{
			if ( (yy_lp) && (yy_lp) < yy_accept[yy_current_state + 1] )
				{
				yy_act = yy_acclist[(yy_lp)];
					{
					(yy_full_match) = yy_cp;
					break;
					}
				}
			--yy_cp;
			yy_current_state = *--(yy_state_ptr);
			(yy_lp) = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 134 "lexer.l"
; /*comment, ignore*/
	YY_BREAK
case 2:
/* rule 2 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 136 "lexer.l"
{
			char *s;
			char *end;
			char *dir;
			if(gel_parsestack || gel_parenth_depth) {REJECT;}
			s=strchr(yytext,'<')+1; /*find the beginning*/
			end=strrchr(yytext,'>'); /*find the end*/
			s = gel_unescape_string(s,end,NULL);
			dir = gbr_find_data_dir (DATADIR);
			yylval.id = g_build_filename (dir,
						      "genius",
						      s,
						      NULL);
			g_free (dir);
			g_free(s);
			DO_RET;
			return LOADFILE;
		}
	YY_BREAK
case 3:
/* rule 3 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 155 "lexer.l"
{
			char *s;
			if(gel_parsestack || gel_parenth_depth) {REJECT;}
			s=strchr(yytext,'d')+1; /*move after the load*/
			/*btw from the above RE we know this will work*/
			while(*s==' ' || *s=='\t')
				s++;
			yylval.id = g_strdup(s);
			DO_RET;
			return LOADFILE_GLOB;
		}
	YY_BREAK
case 4:
/* rule 4 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 167 "lexer.l"
{
			char *s;
			if(gel_parsestack || gel_parenth_depth) {REJECT;}
			s=strchr(yytext,'d')+1; /*move after the cd*/
			/*btw from the above RE we know this will work*/
			while(*s==' ' || *s=='\t')
				s++;
			yylval.id = g_strdup(s);
			DO_RET;
			return CHANGEDIR;
		}
	YY_BREAK
case 5:
/* rule 5 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 179 "lexer.l"
{
			char *s;
			if(gel_parsestack || gel_parenth_depth) {REJECT;}
			s=strchr(yytext,'n')+1; /*move after the plugin*/
			/*btw from the above RE we know this will work*/
			while(*s==' ' || *s=='\t')
				s++;
			yylval.id = g_strdup(s);
			DO_RET;
			return LOAD_PLUGIN;
		}
	YY_BREAK
case 6:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 191 "lexer.l"
{
			if(gel_parsestack || gel_parenth_depth) {REJECT;}
			DO_RET;
			return PWD;
		}
	YY_BREAK
case 7:
/* rule 7 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 197 "lexer.l"
{
			char *s;
			if(gel_parsestack || gel_parenth_depth) {REJECT;}
			s=strchr(yytext,'s')+1; /*move after the ls*/
			/*btw from the above RE we know this will work*/
			while(*s==' ' || *s=='\t')
				s++;
			yylval.id = g_strdup(s);
			DO_RET;
			return LS_ARG;
		}
	YY_BREAK
case 8:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 209 "lexer.l"
{
			if(gel_parsestack || gel_parenth_depth) {REJECT;}
			DO_RET;
			return LS;
		}
	YY_BREAK
case 9:
/* rule 9 can match eol */
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 215 "lexer.l"
{
			char *s;
			if(gel_parsestack || gel_parenth_depth) {REJECT;}
			s=strchr(yytext,'p')+1; /*move after the help*/
			/*btw from the above RE we know this will work*/
			while(*s==' ' || *s=='\t')
				s++;
			yylval.id = g_strdup(s);
			DO_RET;
			return HELP_ARG;
		}
	YY_BREAK
case 10:
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */
(yy_c_buf_p) = yy_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_RULE_SETUP
#line 227 "lexer.l"
{
			if(gel_parsestack || gel_parenth_depth) {REJECT;}
			DO_RET;
			return HELP;
		}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 234 "lexer.l"
{
			if (matrix_entry &&
			    GPOINTER_TO_INT(matrix_entry_stack->data) == 0) {
				return NEXTROW;
			}
			DO_RET;
			return SEPAR;
		}
	YY_BREAK
case 12:
/* rule 12 can match eol */
YY_RULE_SETUP
#line 243 "lexer.l"
{ 
			DO_RET;
			yylval.id = gel_unescape_string(&yytext[1],NULL,NULL);
			/*kill the trailing "*/
			yylval.id[strlen(yylval.id)-1]='\0';
			return STRING;
		}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 251 "lexer.l"
{ NO_RET; return EQ_CMP; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 252 "lexer.l"
{ NO_RET; return NE_CMP; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 253 "lexer.l"
{ NO_RET; return NE_CMP; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 254 "lexer.l"
{ NO_RET; return CMP_CMP; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 256 "lexer.l"
{ NO_RET; return LE_CMP; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 257 "lexer.l"
{ NO_RET; return GE_CMP; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 259 "lexer.l"
{ NO_RET; return LT_CMP; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 260 "lexer.l"
{ NO_RET; return GT_CMP; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 262 "lexer.l"
{ NO_RET; return EQUALS; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 263 "lexer.l"
{ NO_RET; return DEFEQUALS; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 265 "lexer.l"
{ NO_RET; return LOGICAL_NOT; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 266 "lexer.l"
{ NO_RET; return LOGICAL_AND; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 267 "lexer.l"
{ NO_RET; return LOGICAL_XOR; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 268 "lexer.l"
{ NO_RET; return LOGICAL_OR; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 270 "lexer.l"
{ NO_RET; return WHILE; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 271 "lexer.l"
{ NO_RET; return UNTIL; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 272 "lexer.l"
{ NO_RET; return FOR; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 273 "lexer.l"
{ NO_RET; return SUM; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 274 "lexer.l"
{ NO_RET; return PROD; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 275 "lexer.l"
{ NO_RET; return DO; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 276 "lexer.l"
{ NO_RET; return TO; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 277 "lexer.l"
{ NO_RET; return BY; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 278 "lexer.l"
{ NO_RET; return IN; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 279 "lexer.l"
{ NO_RET; return IF; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 280 "lexer.l"
{ NO_RET; return THEN; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 281 "lexer.l"
{ NO_RET; return ELSE; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 283 "lexer.l"
{ NO_RET; return FUNCTION; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 284 "lexer.l"
{ NO_RET; return PARAMETER; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 285 "lexer.l"
{ NO_RET; return CALL; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 287 "lexer.l"
{ NO_RET; return RETURNTOK; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 288 "lexer.l"
{ DO_RET; return BAILOUT; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 289 "lexer.l"
{ DO_RET; return EXCEPTION; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 290 "lexer.l"
{ DO_RET; return CONTINUE; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 291 "lexer.l"
{ DO_RET; return BREAK; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 293 "lexer.l"
{ NO_RET; return MOD; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 295 "lexer.l"
{ DO_RET; return '.'; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 297 "lexer.l"
{ DO_RET; return LOCAL; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 299 "lexer.l"
{
			gel_parenth_depth++;
			if (matrix_entry_stack != NULL)
				matrix_entry_stack->data =
					GINT_TO_POINTER
					  (GPOINTER_TO_INT(matrix_entry_stack->data) + 1);
			NO_RET;
			return AT;
		}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 308 "lexer.l"
{
			NO_RET;
			return THREEDOTS;
		}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 313 "lexer.l"
{
			matrix_entry++;
			gel_parenth_depth++;
			matrix_entry_stack =
				g_slist_prepend (matrix_entry_stack,
						 GINT_TO_POINTER (0));
			NO_RET;
			return '[';
		}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 323 "lexer.l"
{
			GSList *li;
			matrix_entry--;
			gel_parenth_depth--;
			li = matrix_entry_stack;
			matrix_entry_stack = g_slist_remove_link (matrix_entry_stack, li);
			g_slist_free_1 (li);
			DO_RET;
			return ']';
		}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 335 "lexer.l"
{
			gel_parenth_depth++;
			if (matrix_entry_stack != NULL)
				matrix_entry_stack->data =
					GINT_TO_POINTER
					  (GPOINTER_TO_INT(matrix_entry_stack->data) + 1);
			NO_RET;
			return yytext[0];
		}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 345 "lexer.l"
{
			gel_parenth_depth--;
			if (matrix_entry_stack != NULL)
				matrix_entry_stack->data =
					GINT_TO_POINTER
					  (GPOINTER_TO_INT(matrix_entry_stack->data) - 1);
			DO_RET;
			return MAKEIMAGPARENTH;
		}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 355 "lexer.l"
{
			gel_parenth_depth--;
			if (matrix_entry_stack != NULL)
				matrix_entry_stack->data =
					GINT_TO_POINTER
					  (GPOINTER_TO_INT(matrix_entry_stack->data) - 1);
			DO_RET;
			return yytext[0];
		}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 365 "lexer.l"
{
				/* identifier*/
				yylval.id = g_strdup(yytext);
				DO_RET;
				return FUNCID;
			}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 372 "lexer.l"
{
			mpw_init(yylval.val);
			mpw_set_str(yylval.val,yytext,10);
			DO_RET;
			return NUMBER;
		}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 379 "lexer.l"
{
			mpw_init(yylval.val);
			mpw_set_str_complex_int(yylval.val,yytext,10);
			DO_RET;
			return NUMBER;
		}
	YY_BREAK
case 60:
#line 388 "lexer.l"
case 61:
#line 389 "lexer.l"
case 62:
YY_RULE_SETUP
#line 389 "lexer.l"
{
			char *s;
			if(yytext[0] == '.')
				s = g_strconcat("0",&yytext[0],NULL);
			else
				s = g_strdup(yytext);
			mpw_init(yylval.val);
			mpw_set_str_complex(yylval.val,s,10);
			g_free(s);
			DO_RET;
			return NUMBER;
		}
	YY_BREAK
case 63:
#line 404 "lexer.l"
case 64:
#line 405 "lexer.l"
case 65:
YY_RULE_SETUP
#line 405 "lexer.l"
{
			char *s;
			if(yytext[0] == '.')
				s = g_strconcat("0",&yytext[0],NULL);
			else
				s = g_strdup(yytext);
			mpw_init(yylval.val);
			mpw_set_str_float(yylval.val,s,10);
			g_free(s);
			DO_RET;
			return NUMBER;
		}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 419 "lexer.l"
{
			char *s;
			int base;

			s=g_malloc(strlen(yytext)-2); /*minus 3 and plus 1*/
			sscanf(yytext,"%d\\%[0-9a-zA-Z]s",&base,s);
			if(base>36) { g_free(s); REJECT; }
			mpw_init(yylval.val);
			mpw_set_str_int(yylval.val,s,base);
			g_free(s);
			DO_RET;
			return NUMBER;
		}
	YY_BREAK
case 67:
#line 434 "lexer.l"
case 68:
#line 435 "lexer.l"
case 69:
YY_RULE_SETUP
#line 435 "lexer.l"
{
			mpw_init(yylval.val);
			mpw_set_str_int(yylval.val,yytext,0);
			DO_RET;
			return NUMBER;
		}
	YY_BREAK
case 70:
/* rule 70 can match eol */
YY_RULE_SETUP
#line 442 "lexer.l"
{ gel_incr_file_info(); }
	YY_BREAK
case 71:
/* rule 71 can match eol */
YY_RULE_SETUP
#line 444 "lexer.l"
{ 
			gel_incr_file_info();
			if(matrix_entry) {
				return NEXTROW;
			} else if(gel_return_ret) {
				gel_first_tok = 0;
				return '\n';
			}
		}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 454 "lexer.l"
; /*ignore whitespace*/
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 456 "lexer.l"
{ DO_RET; return ELTELTPLUS; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 457 "lexer.l"
{ DO_RET; return ELTELTMINUS; }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 458 "lexer.l"
{ DO_RET; return ELTELTMUL; }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 459 "lexer.l"
{ DO_RET; return ELTELTDIV; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 460 "lexer.l"
{ DO_RET; return ELTELTBACKDIV; }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 461 "lexer.l"
{ DO_RET; return ELTELTMOD; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 462 "lexer.l"
{ DO_RET; return ELTELTEXP; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 463 "lexer.l"
{ DO_RET; return TRANSPOSE; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 465 "lexer.l"
{ DO_RET; return DOUBLEFACT; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 467 "lexer.l"
{
			DO_RET;
			return yytext[0];
		}
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 472 "lexer.l"
{ NO_RET; return yytext[0]; }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 474 "lexer.l"
{ DO_RET; return '.'; }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 476 "lexer.l"
{ DO_RET; return '|'; }
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 478 "lexer.l"
{
			gel_got_eof = TRUE;
			return '\n';
		}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 483 "lexer.l"
{ NO_RET; return yytext[0]; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 485 "lexer.l"
ECHO;
	YY_BREAK
#line 1816 "lexer.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);
	yy_current_state += YY_AT_BOL();

	(yy_state_ptr) = (yy_state_buf);
	*(yy_state_ptr)++ = yy_current_state;

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 288 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		*(yy_state_ptr)++ = yy_current_state;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    
	register YY_CHAR yy_c = 1;
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 288 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 287);
	if ( ! yy_is_jam )
		*(yy_state_ptr)++ = yy_current_state;

	return yy_is_jam ? 0 : yy_current_state;
}

    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = (c == '\n');

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void yyset_lineno (int  line_number )
{
    
    yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  in_str )
{
        yyin = in_str ;
}

void yyset_out (FILE *  out_str )
{
        yyout = out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  bdebug )
{
        yy_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

    (yy_state_buf) = 0;
    (yy_state_ptr) = 0;
    (yy_full_match) = 0;
    (yy_lp) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    yyfree ( (yy_state_buf) );
    (yy_state_buf)  = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 485 "lexer.l"



int my_yyinput(void);
int my_yyinput(void) { return input(); }

/* avoid unused warnings, kind of bogus */
/* Apparently this no worky, so don't do it */
#if 0
#ifdef FLEX_SCANNER
void fake_fake_fake (void);
void fake_fake_fake (void) {
	 yy_flex_realloc (NULL, 0);
	 yyunput (0, NULL);
}
#endif
#endif

/* Dropping support for tabs as separators in matrix entry as of 1.0.1
   if we want to readd it, just add the following after "ignore whitespace"
   line above
^[\t ][\t ]*	;

[\t ]*,[\t ]*	{ return ','; }

[\t][\t ]*	{
			if(matrix_entry)
				return ',';
		}
		*/


