/* gfloppy.c
 *
 * Copyright (C) 1999 Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <gnome.h>
#include "gfloppy.h"


static gchar *
make_mformat_cmd (GFloppy *floppy)
{
	gchar *retval = NULL;

	switch (floppy->size) {
	case 0:
		/* 1.44 m */
		retval = g_strconcat (floppy->mformat_cmd, " -c 80 -h 2 -s 18 ", floppy->mdevice, NULL);
		break;
	case 1:
		/* 1.2 m */
		retval = g_strconcat (floppy->mformat_cmd, " -c 80 -h 2 -s 15 ", floppy->mdevice, NULL);
		break;
	case 2:
		/* 720 k */
		retval = g_strconcat (floppy->mformat_cmd, " -c 80 -h 2 -s 9 ", floppy->mdevice, NULL);
		break;
	case 3:
		/* 360 k */
		retval = g_strconcat (floppy->mformat_cmd, " -c 40 -h 2 -s 9 ", floppy->mdevice, NULL);
		break;
	default:
		g_assert_not_reached ();
	}
	return retval;
}

static gchar *
make_mke2fs_cmd (GFloppy *floppy)
{
	gchar *retval = NULL;
	gchar *bad_block_flag;

	if (floppy->quick_format)
		bad_block_flag = "";
	else
		bad_block_flag = "-c ";

	switch (floppy->size) {
	case 0:
		/* 1.44 m */
		retval = g_strconcat (floppy->mke2fs_cmd, " -b 2880 ", bad_block_flag, floppy->device, NULL);
		break;
	case 1:
		/* 1.2 m */
		retval = g_strconcat (floppy->mke2fs_cmd, " -b 2160 ", bad_block_flag, floppy->device, NULL);
		break;
	case 2:
		/* 720 k */
		retval = g_strconcat (floppy->mke2fs_cmd, " -b 1440 ", bad_block_flag, floppy->device, NULL);
		break;
	case 3:
		/* 360 k */
		retval = g_strconcat (floppy->mke2fs_cmd, " -b 720 ", bad_block_flag, floppy->device, NULL);
		break;
	default:
		g_assert_not_reached ();
	}
	return retval;
}

static void
fdformat_disk (GFloppy *floppy)
{
	gchar *cmd;

	cmd = g_strdup_printf (floppy->fdformat_cmd, " ", floppy->device, NULL);
	system (cmd);
	g_free (cmd);
}

static void
format_ext2fs (GFloppy *floppy)
{
	gchar *cmd;

	if (!floppy->quick_format) {
		fdformat_disk (floppy);
	}

	cmd = make_mke2fs_cmd (floppy);
	g_print ("executing: %s\n", cmd);
	system (cmd);
}

static void
format_fat (GFloppy *floppy)
{
	gchar *cmd;

	if (!floppy->quick_format) {
		fdformat_disk (floppy);
	}

	cmd = make_mformat_cmd (floppy);
	g_print ("executing: %s\n", cmd);
	system (cmd);

	if (!floppy->quick_format) {
		g_print ("executing: %s\n", cmd);
		system (g_strconcat (floppy->badblocks_cmd, " ", floppy->mdevice, NULL));
	}
}

void
format_floppy (GFloppy *floppy)
{

	if (floppy->type == GFLOPPY_E2FS)
		format_ext2fs (floppy);
	else
		format_fat (floppy);

	_exit (0);
}
