/* gfloppy.h
 *
 * Copyright (C) 1999 Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GFLOPPY_H__
#define __GFLOPPY_H__

#include <glib.h>

typedef enum {
	GFLOPPY_E2FS = 0,
	GFLOPPY_FAT = 1
} GFloppyType;

typedef enum {
	GFLOPPY_144M = 0,
	GFLOPPY_12M = 1,
	GFLOPPY_720K = 2,
	GFLOPPY_360K = 3
} GFloppySize;

typedef struct _GFloppy GFloppy;
struct _GFloppy {
	GFloppyType type;
	GFloppySize size;
	gboolean quick_format; /* If true, don't do a low level format */
	gchar *device;         /* ie. /dev/fd0  can also be /dev/fd0H1440 */
	gchar *extended_device;/* ie. /dev/fd0H1440 */
	gchar *mdevice;        /* ie. a: or b: */
	gint pid;
	gint filedes[2];

	/* Our commands */
	gchar *badblocks_cmd;
	gchar *fdformat_cmd;
	gchar *mformat_cmd;
	gchar *mke2fs_cmd;
};

void format_floppy (GFloppy *floppy);

#endif
