/*
 * Text manipulation plugin
 *
 * Author:
 *   JP Rosevear (jpr@arcavia.com)
 */
#include <gnome.h>
#include <glib.h>

#include "../../src/gI_plugin.h"
#include "../../src/gide.h"
#include "../../src/gI_tools.h"
#include "plugin_text_insert.h"

void
plugin_text_insert_date( Tool *tool, ToolState *state )
{
	time_t t;
	struct tm *st;
	gchar *timestr;

	time(&t);

	st = localtime(&t);

	timestr = asctime( st );

	gI_document_insert_text_at_point( state->document, timestr );
}

void
plugin_text_insert_gpl_c( Tool *tool, ToolState *state )
{
	gchar *GPL_Notice =
	    "/* Program Name\n"
	    " * Copyright (C) 1999 Author Name\n"
	    " *\n"
	    " * This program is free software; you can redistribute it and/or modify\n"
	    " * it under the terms of the GNU General Public License as published by\n"
	    " * the Free Software Foundation; either version 2 of the License, or\n"
	    " * (at your option) any later version.\n"
	    " *\n"
	    " * This program is distributed in the hope that it will be useful,\n"
	    " * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
	    " * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
	    " * GNU General Public License for more details.\n"
	    " *\n"
	    " * You should have received a copy of the GNU General Public License\n"
	    " * along with this program; if not, write to the Free Software\n"
	    " * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n"
	    " */\n"
	    "\n";

	gI_document_insert_text_at_point( state->document, GPL_Notice );
}


void
plugin_text_insert_gpl_cpp( Tool *tool, ToolState *state )
{
	gchar *GPL_Notice =
	    "// Program Name\n"
	    "// Copyright (C) 1999 Author Name\n"
	    "//\n"
	    "// This program is free software; you can redistribute it and/or modify\n"
	    "// it under the terms of the GNU General Public License as published by\n"
	    "// the Free Software Foundation; either version 2 of the License, or\n"
	    "// (at your option) any later version.\n"
	    "//\n"
	    "// This program is distributed in the hope that it will be useful,\n"
	    "// but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
	    "// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
	    "// GNU General Public License for more details.\n"
	    "//\n"
	    "// You should have received a copy of the GNU General Public License\n"
	    "// along with this program; if not, write to the Free Software\n"
	    "// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n"
	    "\n";

	gI_document_insert_text_at_point( state->document, GPL_Notice );
}




