/* GtkEditor - a source editor widget for GTK
 * Copyright (C) 1998 Thomas Mailund.
 *
 * The editor widget was written by Thomas Mailund, so bugs should be
 * reported to <mailund@daimi.au.dk>, not the gtk ppl.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef SYNTAX_TABLE_H
#define SYNTAX_TABLE_H

#include <glib.h>
#include "gtkeditor.h"
#include "gtkeditor-regex.h"

/* --<types>-------------------------------------------------------- */
  /* The syntax table contains a regex of all start patterns, and an
   * array with the entries.  When a pattern is matched in regex, it is
   * the start pattern with index corresponding to the matched register.
   */
  struct _GtkEditorSyntaxTable {
    /* the number of entries */
    guint size;

    /* the entries...the order is as described above */
    GtkEditorSTEntry **entries;
    
    /* the regex of all start patterns */
    Regex regex;
  };

/* All pointes in this structure (if not NULL) must be dynamically
 * allocated, since they will be g_freed under stable destruction.
 * The application programmer should use the constructor function. */
struct _GtkEditorSTEntry {
  /* The name of the syntax block.  This is a unique key for use in
   * update and remove.  The editor does not enforce uniqueness of
   * names, so it is the responsibility of the application
   * programmer to ensure this.  This is only a problem when
   * creating new syntax tables, so it should be manageable. */
  gchar *name;
  
  /* the start and end of the syntax block. */
  gchar *start;
  gchar *end;

  /* The regex from end.  This is used to find the end of a block. */
  Regex start_regex;
  Regex end_regex;
  
  /* Escape characters.  This string contains chars to escape the end
   * regex.  If NULL, no escaping is used. */
  gchar *esc;

  /* can the syntax block be nested? */
  gint nest : 1;
  
  /* the text properties associated with the syntax block */
  GdkFont *font;
  GdkColor *fore;
  GdkColor *back;

  /* reference count...it is possible to share stentries between
   * tables, e.g. C comments can be shared between C, C++, and Java
   * syntax tables.  The reference count ensures that we don't
   * accidentially frees an entry in use.  Changes to one entry
   * reflects on the others however, so the application programmer
   * should be carefull about this. */
  int refcount;
};



/* --<prototypes>--------------------------------------------------- */
/* These should only be visible in gtkeditor.c...the application
 * programmer shouldn't worry about this.  The prefix _gtk_editor_ is
 * to prevent name collisions in the linker. */
GtkEditorSyntaxTable  *_gtk_editor_new_stable      (GList       *entries);
void           _gtk_editor_destroy_stable (GtkEditorSyntaxTable *stable);
void           _gtk_editor_sthilite_interval       (GtkEditor   *editor,
						    guint        from,
						    guint        to);




#endif /* SYNTAX_TABLE_H */
