/* gIDE
 * Copyright (C) 1999-2000 Jody Goldberg <jgoldberg@home.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#ifndef GIDE_COMMAND_H
#define GIDE_COMMAND_H

#include "gI_document.h"

typedef struct {
	GtkObject parent;
} CommandContext;

void command_undo (CommandContext *context, GideDocument *doc);
void command_redo (CommandContext *context, GideDocument *doc);
void command_undo_redo_menu_labels (GideDocument *doc);

void command_list_pop_top_undo (GideDocument *doc);
void command_list_release      (GSList *cmds);

gboolean cmd_insert_text (GideDocument *doc, const gchar *text,
			  gint to, gint from);

gboolean cmd_delete_text (GideDocument *doc, const gchar *text,
			  gint to, gint from);

#endif /* GIDE_COMMAND_H */


