/* $Header: /cvs/gnome/gIDE/src/gI_edit.c,v 1.16 2000/04/09 16:37:35 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gide.h"
#include <stdio.h> 
#include <string.h>
#include <time.h>
#include "gI_edit.h"
#include "gI_menus.h"
#include "gI_common.h"
#include "gI_commands.h"

static glong get_end_of_line( GtkWidget *text, glong point );

/*
 ---------------------------------------------------------------------
     Function: edit_undo()
     Desc: Callback-Function /Edit/Undo
 ---------------------------------------------------------------------
*/

void edit_undo( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;

	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW( data );
	document = gI_window_get_current_doc( window );

	g_return_if_fail(document);

	document = gI_window_get_current_doc( window );
	command_undo( NULL, document );
}


/*
 ---------------------------------------------------------------------
     Function: edit_redo()
     Desc: Callback-Function /Edit/Redo
 ---------------------------------------------------------------------
*/

void edit_redo( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;

	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW( data );
	document = gI_window_get_current_doc( window );

	g_return_if_fail(document);
	
	document = gI_window_get_current_doc( window );
	command_redo( NULL, document );
}


/*
 ---------------------------------------------------------------------
     Function: edit_cut()
     Desc: Callback-Function /Edit/Cut
 ---------------------------------------------------------------------
*/
void edit_cut( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;

	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW( data );
	document = gI_window_get_current_doc( window );

	g_return_if_fail(document);

	gtk_editable_cut_clipboard( GTK_EDITABLE( document ) );
}


/*
 ---------------------------------------------------------------------
     Function: edit_copy()
     Desc: Callback-Function /Edit/Copy
 ---------------------------------------------------------------------
*/
void edit_copy( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;

	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW( data );
	document = gI_window_get_current_doc( window );

	g_return_if_fail(document);

	gtk_editable_copy_clipboard( GTK_EDITABLE( document ) );
}


/*
 ---------------------------------------------------------------------
     Function: edit_paste()
     Desc: Callback-Function /Edit/Paste
 ---------------------------------------------------------------------
*/
void edit_paste( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;

	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW( data );
	document = gI_window_get_current_doc( window );

	g_return_if_fail(document);

	gtk_editable_paste_clipboard( GTK_EDITABLE( document ) );
}


/*
 ---------------------------------------------------------------------
     Function: edit_select_all()
     Desc: Callback-Function /Edit/Select All
 ---------------------------------------------------------------------
*/
void edit_select_all( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;

	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW( data );
	document = gI_window_get_current_doc( window );

	g_return_if_fail(document);
	
	gtk_editable_select_region( GTK_EDITABLE( document ), 0,
				    gI_text_get_length( document ) );
}


static glong
get_end_of_line( GtkWidget *text, glong point )
{
	static glong eol;

	g_return_val_if_fail( text != NULL, 0 );

	for(eol=point;eol<gI_text_get_length( text );eol++)
	{
		if( gtk_editable_get_chars( GTK_EDITABLE( text ), eol, eol+1 )[0] == '\n' )
			break;
	}

	if( eol < 0 )
		eol = 0;
	if( eol > gI_text_get_length( text ) )
		eol = gI_text_get_length( text );

	return( eol );
}

void edit_select_line( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;
	gint oldpoint;
	
	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW( data );
	document = gI_window_get_current_doc( window );

	g_return_if_fail(document);
	
	document = gI_window_get_current_doc( window );

	oldpoint = gI_text_get_point( document );

	gtk_editable_select_region( GTK_EDITABLE( document ), oldpoint,
	                            get_end_of_line( GTK_WIDGET( document ),
						     oldpoint ) );
}

/*
 ---------------------------------------------------------------------
     Function: edit_read_only()
     Desc: Callback-Function /Edit/Read Only
 ---------------------------------------------------------------------
*/

void edit_read_only( GtkWidget *widget, gpointer data )
{
	GideWindow *window;
	GideDocument *document;
	GtkWidget *item;
	
	g_assert(IS_GIDE_WINDOW(data));

	window = GIDE_WINDOW(data);
	document = gI_window_get_current_doc( window );

	g_return_if_fail(document);

	item = gI_menus_get_item_widget(window, "/Edit/Read Only");
	gI_document_set_readonly_state( document,
					GTK_CHECK_MENU_ITEM(item)->active );
}













