/* $Header: /cvs/gnome/gIDE/src/gI_project.h,v 1.8 2000/04/22 17:23:01 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_PROJECT_H
#define GI_PROJECT_H

#include "gide.h"
#include "gI_todo.h"

typedef struct _gI_target
{
	gchar*								name;

	gint								sources_no;
	gchar*								sources[MAX_PROJECT_FILES];
	gint								build[MAX_PROJECT_FILES];
} gI_target;

typedef struct _gI_project
{
	gchar*								filename;

	gchar*								name;
	gchar*								version;
	gchar*								changelog;
	gchar*								mtarget;
	gchar*								prjroot;
	gchar*								prjfdir;

	gint								targets_no;
	gI_target*							targets[MAX_PROJECT_TARGETS];

	gint								libs_no;
	gchar*								libs[MAX_PROJECT_FILES];

	gchar*								cpar;
	gchar*								cinc;

	gchar*								lpar;
	gchar*								llib;

	gI_TodoList*						todoList;
	gI_TodoPane*						todoPane;
} gI_project;

/*
 * Prototypes for 'gI_project.c'
 */
gI_project* gI_project_get_current(void);
void gI_project_new(GtkWidget* widget, gpointer data);
void gI_project_open(GtkWidget* widget, gpointer data);
void gI_project_delete(GtkWidget* widget, gpointer data);
void gI_project_close(GtkWidget* widget, gpointer data);
void gI_project_edit(GtkWidget* widget, gpointer data);
void gI_project_create_makefile(GtkWidget* widget, gpointer data);
void gI_project_files_tree(GtkWidget* container, gI_project* project);
void gI_project_build(GtkWidget* widget, gpointer data);
void gI_project_update_menu(GideWindow* window);

#endif
